/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.MulticallException;
import com.gridnine.xtrip.common.model.Xeption;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;

public final class XeptionHelper {
    public static boolean isForUser(Xeption xeption) {
        return xeption.getEndUserMessage() != null && StringUtils.isNotBlank((String)xeption.getEndUserMessage().toString());
    }

    public static boolean isForAdmin(Xeption xeption) {
        return xeption.getAdminMessage() != null && StringUtils.isNotBlank((String)xeption.getAdminMessage().toString());
    }

    public static boolean isForDeveloper(Xeption xeption) {
        return StringUtils.isNotBlank((String)xeption.getMessage());
    }

    public static Xeption findXeption(Throwable throwable) {
        Xeption result = null;
        if (throwable instanceof Xeption) {
            result = (Xeption)throwable;
        } else if (throwable instanceof MulticallException) {
            for (Throwable multicall : ((MulticallException)throwable).getSubrouteExceptions().values()) {
                result = XeptionHelper.findXeption(multicall);
            }
        } else {
            result = throwable.getCause() != null ? XeptionHelper.findXeption(throwable.getCause()) : null;
        }
        return result;
    }

    public static <T> T requireNonNullForDeveloper(T obj, String message, Object ... parameters) {
        if (null == obj) {
            throw Xeption.forDeveloper(message, parameters);
        }
        return obj;
    }

    public static <T> T requireNonNullForEndUser(T obj, String message, Object ... parameters) {
        if (null == obj) {
            throw Xeption.forEndUser(message, parameters);
        }
        return obj;
    }

    @FunctionalInterface
    public static interface Rethrower<A, B> {
        public B apply(A var1) throws Exception;

        public static <A, B> Function<A, B> propagate(Rethrower<A, B> rethrower) {
            return value -> {
                try {
                    return rethrower.apply(value);
                }
                catch (Throwable io) {
                    throw new RuntimeException(io);
                }
            };
        }
    }
}

