/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.advanced;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.cache.AssetsCacheManager;
import com.gridnine.xtrip.common.model.cache.common.GroupsBuilder;
import com.gridnine.xtrip.common.model.cache.common.GroupsHandler;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.search.StorageQuery;
import java.util.Collection;

public class GroupsHandlerManager {
    public static <T> boolean isCachedByGroups(Class<T> clazz) {
        GroupsHandler<T> handler = GroupsHandlerManager.getGroupsHandler(clazz);
        return handler != null;
    }

    public static <T> Collection<String> getQueryGroups(StorageQuery query) {
        return GroupsBuilder.builder().groups(query).build();
    }

    public static <T> Collection<String> getGroups(T obj) {
        GroupsHandler<?> handler = GroupsHandlerManager.getGroupsHandler(obj.getClass());
        return handler != null ? handler.getGroups(obj) : null;
    }

    private static <T> GroupsHandler<T> getGroupsHandler(Class<T> clazz) {
        if (BaseAsset.class.isAssignableFrom(clazz)) {
            GroupsHandler<T> handler = AssetsCacheManager.get().getGroupsHandler(clazz);
            return handler;
        }
        return EntityCacheManager.get().getGroupsHandler(clazz);
    }
}

