/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.asset;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheConfigurationResolveHandler;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheConfigurationSimpleSearchHandler;
import com.gridnine.xtrip.common.model.cache.common.GroupsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetsCacheConfiguration {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Class<?>, AssetsCacheConfigurationResolveHandler<?>> resolveHandlers = new HashMap();
    private final Map<Class<?>, Map<String, AssetsCacheConfigurationSimpleSearchHandler<?>>> simpleSearchHandlers = new HashMap();
    private static final ConcurrentMap<Class<?>, GroupsHandler<?>> groupsHandlers = new ConcurrentHashMap();
    private final Set<Class<?>> cachedClasses = new HashSet();
    private final Set<String> cachedClassesNames = new HashSet<String>();
    private int updatePeriodInSeconds;

    public boolean isCached(Class<?> cls) {
        return this.cachedClasses.contains(cls);
    }

    <A extends BaseAsset> boolean isPropertyCached(Class<A> cls, String propertyName) {
        Map<String, AssetsCacheConfigurationSimpleSearchHandler<?>> handlers = this.simpleSearchHandlers.get(cls);
        if (handlers == null) {
            return false;
        }
        return handlers.containsKey(propertyName);
    }

    <A extends BaseAsset> boolean isSearchQueryCached(Class<A> cls) {
        return groupsHandlers.containsKey(cls);
    }

    public <A extends BaseAsset> GroupsHandler<A> getGroupsHandler(Class<A> clazz) {
        return (GroupsHandler)groupsHandlers.get(clazz);
    }

    public Collection<String> getCachedClassesNames() {
        return Collections.unmodifiableCollection(this.cachedClassesNames);
    }

    public <A extends BaseAsset> void register(AssetsCacheConfigurationResolveHandler<A> handler) {
        this.cachedClasses.add(handler.getType());
        this.cachedClassesNames.add(handler.getType().getName());
        AssetsCacheConfigurationResolveHandler<?> existingHandler = this.resolveHandlers.get(handler.getType());
        if (existingHandler != null) {
            this.log.info(String.format("asset resolve handler %s for type %s is automatically unregistered", existingHandler, handler.getType()));
        }
        this.resolveHandlers.put(handler.getType(), handler);
        this.log.info(String.format("asset resolve handler %s for type %s is registered", handler, handler.getType()));
    }

    public <A extends BaseAsset> void register(AssetsCacheConfigurationSimpleSearchHandler<A> handler) {
        AssetsCacheConfigurationSimpleSearchHandler<?> existingHandler;
        this.cachedClasses.add(handler.getType());
        this.cachedClassesNames.add(handler.getType().getName());
        Map<String, AssetsCacheConfigurationSimpleSearchHandler<?>> handlers = this.simpleSearchHandlers.get(handler.getType());
        if (handlers == null) {
            handlers = new HashMap();
            this.simpleSearchHandlers.put(handler.getType(), handlers);
        }
        if ((existingHandler = handlers.get(handler.getPropertyName())) != null) {
            this.log.info(String.format("simple search handler %s for asset %s for property %s is automatically unregistered", existingHandler, handler.getType(), handler.getPropertyName()));
        }
        handlers.put(handler.getPropertyName(), handler);
        this.log.info(String.format("simple search handler %s for index %s for property %s is registered", handler, handler.getType(), handler.getPropertyName()));
    }

    public <A extends BaseAsset> void register(GroupsHandler<A> handler) {
        this.cachedClasses.add(handler.getType());
        this.cachedClassesNames.add(handler.getType().getName());
        GroupsHandler existingHandler = (GroupsHandler)groupsHandlers.get(handler.getType());
        if (existingHandler != null) {
            this.log.info(String.format("groups handler %s for type %s is automatically unregistered", existingHandler, handler.getType()));
        }
        groupsHandlers.put(handler.getType(), handler);
        this.log.info(String.format("groups handler %s for type %s is registered", handler, handler.getType()));
    }

    public int getUpdatePeriodInSeconds() {
        return this.updatePeriodInSeconds;
    }

    public void setUpdatePeriodInSeconds(int updatePeriodInSecondsValue) {
        this.updatePeriodInSeconds = updatePeriodInSecondsValue;
    }
}

