/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.asset;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheActualStorage;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheConfiguration;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheData;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.cache.common.CacheHelper;
import com.gridnine.xtrip.common.model.cache.common.CacheState;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.utils.SearchQueryOptimizer;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedAssetsStorage
extends AssetsStorage
implements Disposable {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected Logger writelog = LoggerFactory.getLogger((String)(this.getClass().getName() + ".write"));
    boolean disposed;
    final AssetsCacheActualStorage as;
    final AssetsCacheConfiguration config;
    final AssetsCacheData cache;
    final CacheState state;

    public CachedAssetsStorage(AssetsCacheActualStorage actualStorage, AssetsCacheConfiguration configuration, AssetsCacheData cacheData, CacheState cacheState) {
        this.as = actualStorage;
        this.config = configuration;
        this.cache = cacheData;
        this.state = cacheState;
    }

    @Override
    public <A extends BaseAsset> SearchResult<A> search(Class<A> cls, SearchQuery query) throws StorageException {
        return this.search(cls, query, false);
    }

    @Override
    public <A extends BaseAsset> A save(A asset) throws StorageException {
        return this.save(asset, false);
    }

    @Override
    public <A extends BaseAsset> A save(final A asset, final boolean ignoreInterceptors) throws StorageException {
        if (asset == null) {
            return null;
        }
        return (A)((BaseAsset)CacheHelper.doAction(new DefaultActualStorageOperationCallback<A>(){

            @Override
            public A doWithActualStorage() throws Throwable {
                return CachedAssetsStorage.this.as.save(asset, ignoreInterceptors);
            }
        }, ignoreInterceptors, String.format("save.%s", MiscUtil.getSimpleClassName(asset.getClass()))));
    }

    @Override
    public <A extends BaseAsset> List<A> save(Iterable<A> assets) throws StorageException {
        return this.save(assets, false);
    }

    @Override
    public <A extends BaseAsset> A load(Class<A> cls, String uid) throws StorageException {
        return this.load(cls, uid, false);
    }

    @Override
    public <A extends BaseAsset> List<A> save(final Iterable<A> assets, final boolean ignoreInterceptors) throws StorageException {
        if (!assets.iterator().hasNext()) {
            return Collections.emptyList();
        }
        return (List)CacheHelper.doAction(new DefaultActualStorageOperationCallback<List<A>>(){

            @Override
            public List<A> doWithActualStorage() throws Throwable {
                return CachedAssetsStorage.this.as.save(assets, ignoreInterceptors);
            }
        }, ignoreInterceptors, String.format("save-batch.%s", MiscUtil.getSimpleClassName(((BaseAsset)assets.iterator().next()).getClass())));
    }

    @Override
    public <A extends BaseAsset> void delete(A asset) throws StorageException {
        this.delete(asset, false);
    }

    @Override
    public <A extends BaseAsset> void delete(final A asset, final boolean ignoreInterceptors) throws StorageException {
        if (asset == null) {
            return;
        }
        CacheHelper.doAction(new DefaultActualStorageOperationCallback<Void>(){

            @Override
            public Void doWithActualStorage() throws Throwable {
                CachedAssetsStorage.this.as.delete(asset, ignoreInterceptors);
                return null;
            }
        }, false, String.format("delete.%s", MiscUtil.getSimpleClassName(asset.getClass())));
    }

    @Override
    public <A extends BaseAsset> SearchResult<A> search(final Class<A> cls, final SearchQuery query, boolean noCache) throws StorageException {
        if (cls == null || query == null) {
            return null;
        }
        if (!SearchQueryOptimizer.optimize(query)) {
            this.log.warn("no row will match query " + query);
            return new SearchResult();
        }
        return (SearchResult)CacheHelper.doAction(new DefaultActualStorageOperationCallback<SearchResult<A>>(){

            @Override
            public SearchResult<A> doWithActualStorage() throws Throwable {
                return CachedAssetsStorage.this.as.search(cls, query);
            }

            @Override
            public SearchResult<A> doWithLocalStorage() {
                return CachedAssetsStorage.this.cache.getSearchQueryCache().get(cls, query);
            }

            @Override
            public void updateLocalStorage(SearchResult<A> result) throws Throwable {
                CachedAssetsStorage.this.cache.getSearchQueryCache().put(cls, query, result);
                if (CachedAssetsStorage.this.writelog.isDebugEnabled()) {
                    CachedAssetsStorage.this.writelog.debug(String.format("SearchCache is updated: class = %s, query = %s", MiscUtil.getSimpleClassName(cls), XSUtil.toString(query)));
                }
            }

            @Override
            public boolean isCached() {
                return CachedAssetsStorage.this.config.isSearchQueryCached(cls);
            }
        }, noCache, String.format("search.%s", MiscUtil.getSimpleClassName(cls)));
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @Override
    public <A extends BaseAsset> ProjectionResult search(final Class<A> cls, final ProjectionQuery query, boolean noCache) throws StorageException {
        return CacheHelper.doAction(new DefaultActualStorageOperationCallback<ProjectionResult>(){

            @Override
            public ProjectionResult doWithActualStorage() throws Throwable {
                return CachedAssetsStorage.this.as.search(cls, query);
            }

            @Override
            public ProjectionResult doWithLocalStorage() {
                return CachedAssetsStorage.this.cache.getSearchQueryCache().get(cls, query);
            }

            @Override
            public void updateLocalStorage(ProjectionResult result) throws Throwable {
                CachedAssetsStorage.this.cache.getSearchQueryCache().put(cls, query, result);
                if (CachedAssetsStorage.this.writelog.isDebugEnabled()) {
                    CachedAssetsStorage.this.writelog.debug(String.format("SearchCache is updated: class = %s, query = %s", MiscUtil.getSimpleClassName(cls), XSUtil.toString(query)));
                }
            }

            @Override
            public boolean isCached() {
                return CachedAssetsStorage.this.config.isSearchQueryCached(cls);
            }
        }, noCache, String.format("projection-search.%s", MiscUtil.getSimpleClassName(cls)));
    }

    @Override
    public <A extends BaseAsset> ProjectionResult search(Class<A> cls, ProjectionQuery query) throws StorageException {
        return this.search(cls, query, false);
    }

    @Override
    public <A extends BaseAsset> A load(final Class<A> cls, final String uid, boolean noCache) throws StorageException {
        if (cls == null || uid == null) {
            return null;
        }
        BaseAsset res = (BaseAsset)CacheHelper.doAction(new AssetsDoActionCallback<A>(){

            @Override
            public A doWithActualStorage() throws Throwable {
                return CachedAssetsStorage.this.as.load(cls, uid);
            }

            @Override
            public A doWithLocalStorage() {
                return CachedAssetsStorage.this.cache.getAssetsCache().get(cls, uid);
            }

            @Override
            public void updateLocalStorage(A result) {
                CachedAssetsStorage.this.cache.getAssetsCache().put(cls, uid, result == null ? CacheHelper.NULL_ASSET : result);
            }

            @Override
            public boolean isCached() {
                return CachedAssetsStorage.this.config.isCached(cls);
            }
        }, noCache, String.format("load.%s", MiscUtil.getSimpleClassName(cls)));
        return (A)(CacheHelper.NULL_ASSET.equals(res) ? null : res);
    }

    @Override
    public <A extends BaseAsset> A find(final Class<A> cls, final String fieldName, final Object value, boolean noCache) throws StorageException {
        if (cls == null || fieldName == null) {
            return null;
        }
        final ValueHolder asset = new ValueHolder();
        AssetReference result = (AssetReference)CacheHelper.doAction(new AssetsDoActionCallback<AssetReference<A>>(){

            @Override
            public AssetReference<A> doWithActualStorage() throws Throwable {
                SearchResult res = CachedAssetsStorage.this.as.find(cls, fieldName, value);
                int totalCount = res.getData().size();
                if (totalCount > 1) {
                    throw new IllegalStateException(String.format("find returns more than one item: type = %s, propertyName = %s, propertyValue = %s", cls, fieldName, value));
                }
                if (totalCount == 0) {
                    return CacheHelper.NULL_ASSET_REFERENCE;
                }
                asset.setValue(res.getData().get(0));
                return new AssetReference<BaseAsset>((BaseAsset)res.getData().get(0));
            }

            @Override
            public AssetReference<A> doWithLocalStorage() {
                return CachedAssetsStorage.this.cache.getSimpleSearchCache().get(cls, fieldName, value);
            }

            @Override
            public void updateLocalStorage(AssetReference<A> res) {
                CachedAssetsStorage.this.cache.getSimpleSearchCache().put(cls, fieldName, value, res == null ? CacheHelper.NULL_ASSET_REFERENCE : res);
            }

            @Override
            public boolean isCached() {
                return CachedAssetsStorage.this.config.isCached(cls);
            }
        }, noCache, String.format("find.%s.%s", MiscUtil.getSimpleClassName(cls), fieldName));
        if (CacheHelper.NULL_ASSET_REFERENCE.equals(result)) {
            return null;
        }
        if (asset.getValue() != null) {
            this.cache.getAssetsCache().put(cls, ((BaseAsset)asset.getValue()).getUid(), (BaseAsset)asset.getValue());
            return (A)((BaseAsset)asset.getValue());
        }
        return this.load(cls, result.getUid());
    }

    @Override
    public <A extends BaseAsset> A find(Class<A> cls, String fieldName, Object value) throws StorageException {
        return this.find(cls, fieldName, value, false);
    }

    abstract class AssetsDoActionCallback<T>
    implements CacheHelper.DoActionCallback<T> {
        AssetsDoActionCallback() {
        }

        @Override
        public boolean isCached() {
            return false;
        }

        @Override
        public T doWithLocalStorage() {
            return null;
        }

        @Override
        public void updateLocalStorage(T result) throws Throwable {
        }

        @Override
        public Logger getLog() {
            return CachedAssetsStorage.this.log;
        }

        @Override
        public String getProfilingPrefix() {
            return "assets-cache";
        }

        @Override
        public boolean isDisposed() {
            return CachedAssetsStorage.this.disposed;
        }

        @Override
        public Logger getWriteLog() {
            return CachedAssetsStorage.this.writelog;
        }

        @Override
        public void updateTimeStamp(Date date) {
            CachedAssetsStorage.this.state.initializeTimeStamp(date);
        }
    }

    abstract class DefaultActualStorageOperationCallback<T>
    extends AssetsDoActionCallback<T> {
        DefaultActualStorageOperationCallback() {
        }

        @Override
        public boolean isCached() {
            return false;
        }

        @Override
        public T doWithLocalStorage() {
            return null;
        }

        @Override
        public void updateLocalStorage(T result) throws Throwable {
        }
    }
}

