/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.asset;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.cache.common.ContentType;
import com.gridnine.xtrip.common.model.cache.common.OperationType;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class ModifiedObjectReference
extends BaseAsset {
    private static final long serialVersionUID = -8558746862336339978L;
    private String refUid;
    private Class<?> refType;
    private String refCaption;
    private Date refModified = new Date();
    private Collection<String> groups;
    private ContentType contentType;
    private OperationType operationType;

    public ModifiedObjectReference() {
    }

    public ModifiedObjectReference(String aUid) {
        super(aUid);
    }

    public ModifiedObjectReference(BaseAsset asset, Collection<String> groups, OperationType operationType) {
        this.refUid = asset.getUid();
        this.refType = asset.getClass();
        this.refCaption = asset.toString();
        this.groups = groups;
        this.contentType = ContentType.ASSET;
        this.operationType = operationType;
    }

    public ModifiedObjectReference(EntityContainer<?> etc, Collection<String> groups, OperationType operationType) {
        this.refUid = etc.getUid();
        this.refType = etc.getEntityType();
        this.refCaption = ((BaseEntity)etc.getEntity()).toString();
        this.groups = groups;
        this.contentType = ContentType.ENTITY;
        this.operationType = operationType;
    }

    public String getRefUid() {
        return this.refUid;
    }

    public void setRefUid(String refUid) {
        this.refUid = refUid;
    }

    public Class<?> getRefType() {
        return this.refType;
    }

    public void setRefType(Class<?> refType) {
        this.refType = refType;
    }

    public String getRefCaption() {
        return this.refCaption;
    }

    public void setRefCaption(String refCaption) {
        this.refCaption = refCaption;
    }

    public Date getRefModified() {
        return this.refModified;
    }

    public void setRefModified(Date refModified) {
        this.refModified = refModified;
    }

    public Collection<String> getGroups() {
        return this.groups != null ? Collections.unmodifiableCollection(this.groups) : null;
    }

    public void setGroups(Collection<String> groups) {
        this.groups = groups != null ? new ArrayList<String>(groups) : null;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeString(elm, "refuid", this.getRefUid());
        XHelper.writeString(elm, "reftype", this.getRefType().getName());
        XHelper.writeString(elm, "refcaption", this.getRefCaption(), true);
        XHelper.writeDate(elm, "refmodified", this.getRefModified());
        XHelper.writeEnum(elm, "contentType", this.getContentType());
        XHelper.writeEnum(elm, "operationType", this.getOperationType());
        if (this.groups != null) {
            for (String group : this.groups) {
                XHelper.writeString(elm, "groups/item", group);
            }
        }
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "refuid", this.getRefUid());
        XSHelper.writeString(writer, "reftype", this.getRefType().getName());
        XSHelper.writeString(writer, "refcaption", this.getRefCaption(), true);
        XSHelper.writeDate(writer, "refmodified", this.getRefModified());
        XSHelper.writeEnum(writer, "contentType", this.getContentType());
        XSHelper.writeEnum(writer, "operationType", this.getOperationType());
        if (this.groups != null && !this.groups.isEmpty()) {
            writer.writeStartElement("groups");
            for (String group : this.groups) {
                XSHelper.writeString(writer, "item", group);
            }
            writer.writeEndElement();
        }
    }

    @Override
    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        ModifiedObjectReference source = (ModifiedObjectReference)sourceAsset;
        this.setRefUid(source.getRefUid());
        this.setRefType(source.getRefType());
        this.setRefCaption(source.getRefCaption());
        this.setRefModified(XCloneHelper.cloneDate(source.getRefModified()));
        this.setContentType(source.getContentType());
        this.setOperationType(source.getOperationType());
        this.groups.clear();
        this.groups.addAll(XCloneHelper.cloneCollection(source.groups, newUids, uids));
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.setRefUid(XHelper.readString(elm, "refuid"));
        this.setRefType(XHelper.getClass(XHelper.readString(elm, "reftype")));
        this.setRefCaption(XHelper.readString(elm, "refcaption"));
        this.setRefModified(XHelper.readDate(elm, "refmodified"));
        this.setContentType(XHelper.readEnum(elm, "contentType", ContentType.class));
        this.setOperationType(XHelper.readEnum(elm, "operationType", OperationType.class));
        Element[] groupElements = XmlUtil.getElements(elm, "groups/item");
        if (groupElements.length == 0) {
            this.groups = null;
        } else {
            if (this.groups != null) {
                this.groups.clear();
            } else {
                this.groups = new ArrayList<String>(groupElements.length);
            }
            for (Element itemElm : groupElements) {
                String group = XHelper.readString(itemElm, ".");
                this.groups.add(group);
            }
        }
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("refuid".equals(tagName)) {
            this.setRefUid(XSHelper.readString(reader));
            return true;
        }
        if ("reftype".equals(tagName)) {
            this.setRefType(XSHelper.getClass(XSHelper.readString(reader)));
            return true;
        }
        if ("refcaption".equals(tagName)) {
            this.setRefCaption(XSHelper.readString(reader));
            return true;
        }
        if ("refmodified".equals(tagName)) {
            this.setRefModified(XSHelper.readDate(reader));
            return true;
        }
        if ("contentType".equals(tagName)) {
            this.setContentType(XSHelper.readEnum(reader, ContentType.class));
            return true;
        }
        if ("operationType".equals(tagName)) {
            this.setOperationType(XSHelper.readEnum(reader, OperationType.class));
            return true;
        }
        if ("groups".equals(tagName)) {
            if (this.groups != null) {
                this.groups.clear();
            } else {
                this.groups = new ArrayList<String>();
            }
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    String group = XSHelper.readString(reader);
                    this.groups.add(group);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
            return true;
        }
        return false;
    }

    public static enum Property {
        refUid,
        refType,
        refCaption,
        refModified,
        groups,
        contentType,
        operationType;

    }
}

