/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.common;

import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class ModificationData<A extends XSerializable & XSSerializable>
implements Serializable,
XSerializable,
XSSerializable,
Identity {
    private static final long serialVersionUID = 3703042502182075599L;
    private A item;
    private String[] groups;

    public ModificationData() {
    }

    public ModificationData(A item, String[] groups) {
        this.item = item;
        this.groups = groups;
    }

    public ModificationData(A item, Collection<String> groups) {
        this.item = item;
        this.groups = groups != null ? groups.toArray(new String[groups.size()]) : null;
    }

    public A getItem() {
        return this.item;
    }

    public void setItem(A item) {
        this.item = item;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public String toString() {
        return "ref " + this.item + ", groups " + Arrays.toString(this.groups);
    }

    @Override
    public String getUid() {
        return ((Identity)this.item).getUid();
    }

    @Override
    public void setUid(String uid) {
        ((Identity)this.item).setUid(uid);
    }

    @Override
    public void toXML(Element elm) throws Exception {
        XHelper.writeObject(elm, "item", this.item);
        if (this.groups != null) {
            XHelper.writeInt(elm, "groups/count", this.groups.length);
            for (String group : this.groups) {
                XHelper.writeString(elm, "groups/item", group);
            }
        }
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        this.item = (XSerializable)XHelper.readObject(elm, "item");
        if (XHelper.readInt(elm, "groups/count") == null) {
            this.groups = null;
        } else {
            Element[] ge = XmlUtil.getElements(elm, "groups/item");
            this.groups = new String[ge.length];
            for (int i = 0; i < ge.length; ++i) {
                this.groups[i] = XHelper.readString(ge[i], ".");
            }
        }
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeObject(writer, "item", this.item);
        if (this.groups != null) {
            writer.writeStartElement("groups");
            XSHelper.writeInt(writer, "count", this.groups.length);
            for (String group : this.groups) {
                XSHelper.writeString(writer, "item", group);
            }
            writer.writeEndElement();
        }
    }
}

