/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleSearchCache<I, T> {
    private final Object nullItem;
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, SimpleSearchCacheEntry<T>>> data = new ConcurrentHashMap();

    protected SimpleSearchCache(Object fakeNullItem) {
        this.nullItem = fakeNullItem;
    }

    public T getReference(Class<I> cls, String fieldName, Object value) {
        ConcurrentHashMap<String, SimpleSearchCacheEntry<T>> indexCache = this.data.get(cls);
        if (indexCache == null) {
            return null;
        }
        SimpleSearchCacheEntry<T> fieldCache = indexCache.get(fieldName);
        if (fieldCache == null) {
            return null;
        }
        return fieldCache.get(value);
    }

    public boolean containsValue(Class<I> cls, String fieldName, Object value) {
        ConcurrentHashMap<String, SimpleSearchCacheEntry<T>> indexCache = this.data.get(cls);
        if (indexCache == null) {
            return false;
        }
        SimpleSearchCacheEntry<T> fieldCache = indexCache.get(fieldName);
        if (fieldCache == null) {
            return false;
        }
        return fieldCache.contains(value);
    }

    public void putReference(Class<I> cls, String fieldName, Object value, T reference) {
        SimpleSearchCacheEntry<T> fieldCache;
        ConcurrentHashMap<String, SimpleSearchCacheEntry<T>> indexCache = this.data.get(cls);
        if (indexCache == null) {
            this.data.putIfAbsent(cls, new ConcurrentHashMap());
            indexCache = this.data.get(cls);
        }
        if ((fieldCache = indexCache.get(fieldName)) == null) {
            indexCache.putIfAbsent(fieldName, new SimpleSearchCacheEntry(this.nullItem));
            fieldCache = indexCache.get(fieldName);
        }
        fieldCache.put(value, reference);
    }

    public void invalidateByValue(Class<I> cls, String fieldName, Object value) {
        ConcurrentHashMap<String, SimpleSearchCacheEntry<T>> indexCache = this.data.get(cls);
        if (indexCache == null) {
            return;
        }
        SimpleSearchCacheEntry<T> fieldCache = indexCache.get(fieldName);
        if (fieldCache == null) {
            return;
        }
        fieldCache.invalidate(value);
    }

    public void invalidateByReference(Class<I> cls, T ref) {
        ConcurrentHashMap<String, SimpleSearchCacheEntry<T>> indexCache = this.data.get(cls);
        if (indexCache == null) {
            return;
        }
        for (SimpleSearchCacheEntry<T> fieldCache : indexCache.values()) {
            fieldCache.invalidateByReference(ref);
        }
    }

    public void invalidate(Class<?> ... indexClasses) {
        for (Class<?> cacheName : indexClasses) {
            this.data.remove(cacheName);
        }
    }

    public void invalidateByFieldNames(Class<I> cls, String ... fieldNames) {
        ConcurrentHashMap<String, SimpleSearchCacheEntry<T>> indexCache = this.data.get(cls);
        if (indexCache == null) {
            return;
        }
        for (String fieldName : fieldNames) {
            indexCache.remove(fieldName);
        }
    }

    public void invalidateAll() {
        this.data.clear();
    }

    static class SimpleSearchCacheEntry<T> {
        private final Object nullItem;
        private final ConcurrentHashMap<Object, T> data = new ConcurrentHashMap();
        private final Map<T, Object> inverseData = new HashMap<T, Object>();
        private final Set<T> emptyResults = new HashSet<T>();

        SimpleSearchCacheEntry(Object fakeNullItem) {
            this.nullItem = fakeNullItem;
        }

        T get(Object value) {
            Object correctedValue = this.getNotNullValue(value);
            return (T)(this.emptyResults.contains(correctedValue) ? this.nullItem : this.data.get(correctedValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(Object value, T ref) {
            SimpleSearchCacheEntry simpleSearchCacheEntry = this;
            synchronized (simpleSearchCacheEntry) {
                Object correctedValue = this.getNotNullValue(value);
                if (ref == null || this.nullItem.equals(ref)) {
                    this.emptyResults.add(correctedValue);
                    return;
                }
                this.emptyResults.remove(correctedValue);
                T oldRef = this.data.put(correctedValue, ref);
                if (oldRef != null) {
                    this.inverseData.remove(oldRef);
                }
                this.inverseData.put(ref, correctedValue);
            }
        }

        boolean contains(Object value) {
            return this.data.containsKey(this.getNotNullValue(value));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidate(Object value) {
            SimpleSearchCacheEntry simpleSearchCacheEntry = this;
            synchronized (simpleSearchCacheEntry) {
                Object correctedValue = this.getNotNullValue(value);
                this.emptyResults.remove(correctedValue);
                T reference = this.data.remove(correctedValue);
                if (reference != null) {
                    this.inverseData.remove(reference);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidateByReference(T ref) {
            SimpleSearchCacheEntry simpleSearchCacheEntry = this;
            synchronized (simpleSearchCacheEntry) {
                for (T correctedValue : this.emptyResults) {
                    T reference = this.data.remove(correctedValue);
                    if (reference == null) continue;
                    this.inverseData.remove(reference);
                }
                this.emptyResults.clear();
                if (ref == null || this.nullItem.equals(ref)) {
                    return;
                }
                Object obj = this.inverseData.remove(ref);
                if (obj != null) {
                    this.data.remove(obj);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidateAll() {
            SimpleSearchCacheEntry simpleSearchCacheEntry = this;
            synchronized (simpleSearchCacheEntry) {
                this.data.clear();
                this.inverseData.clear();
                this.emptyResults.clear();
            }
        }

        private Object getNotNullValue(Object value) {
            return value == null ? this.nullItem : value;
        }
    }
}

