/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.entity.advanced;

import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECCaptionHandler;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECConfiguration;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECEntityHandler;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECSearchHandler;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECSimpleSearchHandler;
import com.gridnine.xtrip.common.xml.XHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AECConfigurationHelper {
    private static final Logger log = LoggerFactory.getLogger(AECConfigurationHelper.class);

    public static void registerContainersHandlers(AECConfiguration config) {
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (EntityType et : metaRegistry.getEntities().values()) {
            if (et.isAbstract() || !MetaRegistryHelper.isRoot(et)) continue;
            try {
                Class<?> cls = XHelper.getClass(et.getId());
                if (cls == null) {
                    log.error("unable to load class " + et.getId());
                    continue;
                }
                if (!MetaRegistryHelper.isCachedEntity(et)) continue;
                config.register(new StandardAdvancedEntityCacheEntityHandler(cls));
            }
            catch (Exception e) {
                log.error("unable to load class " + et.getId(), (Throwable)e);
            }
        }
    }

    public static void registerSimpleSearchHandlers(AECConfiguration config) {
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (IndexType it : metaRegistry.getIndexes().values()) {
            for (IndexProperty property : it.getProperties().values()) {
                if (!property.isCached()) continue;
                try {
                    Class<?> cls = XHelper.getClass(it.getId());
                    if (cls == null) {
                        log.error("unable to load class " + it.getId());
                        continue;
                    }
                    config.register(new StandardAdvancedEntityCacheSimpleSearchHandler(cls, property.getId()));
                }
                catch (Exception e) {
                    log.error("unable to load class " + it.getId(), (Throwable)e);
                }
            }
        }
    }

    public static void registerSearchHandlers(AECConfiguration config) {
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (IndexType it : metaRegistry.getIndexes().values()) {
            if (!MetaRegistryHelper.isCachedEntity(metaRegistry.getEntities().get(it.getEntityId()))) continue;
            try {
                Class<?> cls = XHelper.getClass(it.getId());
                if (cls == null) {
                    log.error("unable to load class " + it.getId());
                    continue;
                }
                config.register(new StandardAdvancedEntityCacheSearchHandler(cls));
            }
            catch (Exception e) {
                log.error("unable to load class " + it.getId(), (Throwable)e);
            }
        }
    }

    public static void registerCaptionHandlers(AECConfiguration config) {
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (EntityType et : metaRegistry.getEntities().values()) {
            if (et.isAbstract() || !MetaRegistryHelper.isRoot(et) && !MetaRegistryHelper.isCachedReference(et)) continue;
            try {
                Class<?> cls = XHelper.getClass(et.getId());
                if (cls == null) {
                    log.error("unable to load class " + et.getId());
                    continue;
                }
                if (!MetaRegistryHelper.isCachedEntity(et) && !MetaRegistryHelper.isCachedReference(et)) continue;
                config.register(new StandardAdvancedEntityCacheCaptionHandler(cls));
            }
            catch (Exception e) {
                log.error("unable to load class " + et.getId(), (Throwable)e);
            }
        }
    }

    static class StandardAdvancedEntityCacheSearchHandler<E extends BaseEntity, I extends EntityIndex<E>>
    implements AECSearchHandler<E, I> {
        private final Class<I> cls;

        public StandardAdvancedEntityCacheSearchHandler(Class<I> indexClass) {
            this.cls = indexClass;
        }

        @Override
        public Class<I> getIndexClass() {
            return this.cls;
        }
    }

    static class StandardAdvancedEntityCacheSimpleSearchHandler<E extends BaseEntity, I extends EntityIndex<E>>
    implements AECSimpleSearchHandler<E, I> {
        private final Class<I> cls;
        private final String property;

        public StandardAdvancedEntityCacheSimpleSearchHandler(Class<I> indexClass, String propertyName) {
            this.cls = indexClass;
            this.property = propertyName;
        }

        @Override
        public Class<I> getIndexClass() {
            return this.cls;
        }

        @Override
        public String getPropertyName() {
            return this.property;
        }
    }

    static class StandardAdvancedEntityCacheCaptionHandler<E extends BaseEntity>
    implements AECCaptionHandler<E> {
        private final Class<E> cls;

        public StandardAdvancedEntityCacheCaptionHandler(Class<E> entityType) {
            this.cls = entityType;
        }

        @Override
        public Class<E> getEntityType() {
            return this.cls;
        }
    }

    static class StandardAdvancedEntityCacheEntityHandler<E extends BaseEntity>
    implements AECEntityHandler<E> {
        private final Class<E> cls;

        public StandardAdvancedEntityCacheEntityHandler(Class<E> entityType) {
            this.cls = entityType;
        }

        @Override
        public Class<E> getEntityType() {
            return this.cls;
        }

        @Override
        public boolean accept(E item) {
            return this.cls.equals(item.getClass());
        }
    }
}

