/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cache.entity.advanced;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleData;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.cache.common.CacheHelper;
import com.gridnine.xtrip.common.model.cache.common.CacheState;
import com.gridnine.xtrip.common.model.cache.common.ReferenceActualizationResult;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECActualStorage;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECConfiguration;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECData;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageDeleteParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageIsAvailableParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageRollbackParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.utils.SearchQueryOptimizer;
import com.gridnine.xtrip.common.search.utils.SearchQueryValidator;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedCachedEntityStorage
extends EntityStorage {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected Logger writelog = LoggerFactory.getLogger((String)(this.getClass().getName() + ".write"));
    protected Logger bugLog = LoggerFactory.getLogger((String)(this.getClass().getName() + ".bug"));
    final AECData data;
    final CacheState state;
    final AECActualStorage dataSource;
    final AECConfiguration config;
    volatile boolean disposed;
    private final boolean useLock = !"false".equals(System.getProperty("midoffice.entity-cache.useLock"));
    public static final String DONT_CHECK_OLD_FINBLOCK = "dont-check-old-finblock";
    private final ConcurrentMap<Class<?>, String> resolveOperationKeyCache = new ConcurrentHashMap();

    public AdvancedCachedEntityStorage(AECData cacheData, AECActualStorage ds, CacheState cacheState, AECConfiguration configuration) {
        this.data = cacheData;
        this.dataSource = ds;
        this.state = cacheState;
        this.config = configuration;
    }

    @Override
    public <E extends BaseEntity> EntityReference<E> actualize(EntityReference<E> ref) throws StorageException {
        return this.actualize(ref, new EntityStorageActualizeParameters());
    }

    @Override
    public <E extends BaseEntity> EntityReference<E> actualize(final EntityReference<E> ref, final EntityStorageActualizeParameters parameters) throws StorageException {
        if (ref == null || ref.getUid() == null || ref.getType() == null) {
            return ref;
        }
        final boolean entityCached = this.config.isCaptionCached(ref.getType());
        if (!entityCached && !parameters.isProcessedUncachedEntity()) {
            return ref;
        }
        CacheHelper.doAction(new EntityDoActionCallback<ReferenceActualizationResult<E>>(){
            private final ReferenceActualizationResult<E> fakeResult = new ReferenceActualizationResult();

            @Override
            public ReferenceActualizationResult<E> doWithActualStorage() throws Throwable {
                boolean process;
                boolean bl = process = parameters.isUseRemoteCallIfNecessary() || !entityCached && parameters.isProcessedUncachedEntity();
                if (!process) {
                    return null;
                }
                long startTime = System.currentTimeMillis();
                ReferenceActualizationResult referenceActualizationResult = AdvancedCachedEntityStorage.this.dataSource.actualizeReference(ref, parameters);
                if (referenceActualizationResult.getReference() != null) {
                    ref.setCaption(referenceActualizationResult.getReference().getCaption());
                } else if (ref.getCaption() == null) {
                    ref.setCaption(L10n.get(Messages.AdvancedCachedEntityStorage_deleted));
                } else if (!AdvancedCachedEntityStorage.this.isEndsWithAdvancedCachedEntityStorage_deleted2(ref)) {
                    ref.setCaption(String.format(L10n.get(Messages.AdvancedCachedEntityStorage_deleted2), ref.getCaption()));
                }
                CacheHelper.profileCacheOperation(String.format("%s.actualize.%s.db", this.getProfilingPrefix(), MiscUtil.getSimpleClassName(ref.getType())), startTime);
                return referenceActualizationResult;
            }

            @Override
            public ReferenceActualizationResult<E> doWithLocalStorage() {
                if (!entityCached) {
                    return null;
                }
                String result = AdvancedCachedEntityStorage.this.data.getCaptionsCache().get(ref.getType(), ref.getUid());
                if (result == null) {
                    return null;
                }
                if (!"7821111802610283508L".equals(result)) {
                    ref.setCaption(result);
                } else if (ref.getCaption() == null) {
                    ref.setCaption(L10n.get(Messages.AdvancedCachedEntityStorage_deleted));
                } else if (!AdvancedCachedEntityStorage.this.isEndsWithAdvancedCachedEntityStorage_deleted2(ref)) {
                    ref.setCaption(String.format(L10n.get(Messages.AdvancedCachedEntityStorage_deleted2), ref.getCaption()));
                }
                return this.fakeResult;
            }

            @Override
            public void updateLocalStorage(ReferenceActualizationResult<E> res) {
                if (res == null || !entityCached) {
                    return;
                }
                AdvancedCachedEntityStorage.this.data.getCaptionsCache().put(ref.getType(), ref.getUid(), res.getReference() == null ? "7821111802610283508L" : res.getReference().getCaption());
            }

            @Override
            public boolean isCached() {
                return true;
            }
        }, parameters.isNoCache(), String.format("actualize.%s", MiscUtil.getSimpleClassName(ref.getType())));
        return ref;
    }

    @Override
    public <E extends BaseEntity, T extends BaseEntity> EntityReference<E> actualize(final NestedEntityReference<E, T> ref, final EntityStorageActualizeParameters parameters) throws StorageException {
        if (ref == null || ref.getUid() == null || ref.getType() == null || ref.getNestedEntityType() == null || ref.getNestedEntityUid() == null) {
            return ref;
        }
        if (!this.config.isCaptionCached(ref.getNestedEntityType())) {
            return ref;
        }
        CacheHelper.doAction(new EntityDoActionCallback<ReferenceActualizationResult<T>>(){
            private final ReferenceActualizationResult<T> fakeResult = new ReferenceActualizationResult();

            @Override
            public ReferenceActualizationResult<T> doWithActualStorage() throws Throwable {
                if (!parameters.isUseRemoteCallIfNecessary()) {
                    return null;
                }
                long startTime = System.currentTimeMillis();
                ReferenceActualizationResult referenceActualizationResult = AdvancedCachedEntityStorage.this.dataSource.actualizeNestedReference(ref, parameters);
                if (referenceActualizationResult.getReference() != null) {
                    ref.setCaption(referenceActualizationResult.getReference().getCaption());
                } else if (ref.getCaption() == null) {
                    ref.setCaption(L10n.get(Messages.AdvancedCachedEntityStorage_deleted));
                } else if (!AdvancedCachedEntityStorage.this.isEndsWithAdvancedCachedEntityStorage_deleted2(ref)) {
                    ref.setCaption(String.format(L10n.get(Messages.AdvancedCachedEntityStorage_deleted2), ref.getCaption()));
                }
                CacheHelper.profileCacheOperation(String.format("%s.actualize.%s.db", this.getProfilingPrefix(), MiscUtil.getSimpleClassName(ref.getType())), startTime);
                return referenceActualizationResult;
            }

            @Override
            public ReferenceActualizationResult<T> doWithLocalStorage() {
                String result = AdvancedCachedEntityStorage.this.data.getCaptionsCache().get(ref.getNestedEntityType(), ref.getNestedEntityUid());
                if (result == null) {
                    return null;
                }
                if (!"7821111802610283508L".equals(result)) {
                    ref.setCaption(result);
                } else if (ref.getCaption() == null) {
                    ref.setCaption(L10n.get(Messages.AdvancedCachedEntityStorage_deleted));
                } else if (!AdvancedCachedEntityStorage.this.isEndsWithAdvancedCachedEntityStorage_deleted2(ref)) {
                    ref.setCaption(String.format(L10n.get(Messages.AdvancedCachedEntityStorage_deleted2), ref.getCaption()));
                }
                return this.fakeResult;
            }

            @Override
            public void updateLocalStorage(ReferenceActualizationResult<T> res) {
                if (res == null) {
                    return;
                }
                AdvancedCachedEntityStorage.this.data.getCaptionsCache().put(ref.getNestedEntityType(), ref.getNestedEntityUid(), res.getReference() == null ? "7821111802610283508L" : res.getReference().getCaption());
            }

            @Override
            public boolean isCached() {
                return true;
            }
        }, parameters.isNoCache(), String.format("actualize.%s", MiscUtil.getSimpleClassName(ref.getType())));
        return ref;
    }

    @Override
    public <E extends BaseEntity, T extends BaseEntity> EntityReference<E> actualize(NestedEntityReference<E, T> ref) throws StorageException {
        return this.actualize(ref, new EntityStorageActualizeParameters());
    }

    @Override
    public <E extends BaseEntity> void delete(EntityReference<E> ref) throws StorageException {
        this.delete(ref, new EntityStorageDeleteParameters());
    }

    @Override
    public <E extends BaseEntity> void delete(final EntityReference<E> ref, final EntityStorageDeleteParameters parameters) throws StorageException {
        if (ref == null) {
            return;
        }
        CacheHelper.doAction(new DefaultActualStorageOperationCallback<Void>(){

            @Override
            public Void doWithActualStorage() throws Throwable {
                AdvancedCachedEntityStorage.this.dataSource.delete(ref, parameters);
                return null;
            }
        }, true, "delete");
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> EntityReference<E> findReference(Class<I> cls, String propertyName, Object propertyValue) throws StorageException {
        return this.findReference(cls, propertyName, propertyValue, new EntityStorageSearchParameters());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> EntityReference<E> findReference(final Class<I> cls, final String propertyName, final Object propertyValue, final EntityStorageSearchParameters parameters) throws StorageException {
        if (cls == null || propertyName == null) {
            return null;
        }
        EntityReference reference = (EntityReference)CacheHelper.doAction(new EntityDoActionCallback<EntityReference<E>>(){

            @Override
            public EntityReference<E> doWithActualStorage() throws Throwable {
                SearchQuery query = new SearchQuery();
                query.getPreferredProperties().add(propertyName);
                query.getCriteria().getCriterions().add(SearchCriterion.eq(propertyName, propertyValue));
                SearchResult result = null;
                int totalCount = 0;
                int tryCount = !Environment.isTest() && !Boolean.TRUE.equals(EntityStorageThreadContext.isIgnoreReadTryCount()) ? 3 : 1;
                for (int i = 0; i < tryCount && (totalCount = (result = AdvancedCachedEntityStorage.this.dataSource.search(cls, query, parameters)).getData().size()) == 0; ++i) {
                    if (i == tryCount - 1) continue;
                    Thread.sleep(100L);
                }
                if (totalCount > 1) {
                    throw new IllegalStateException(String.format(L10n.get(Messages.AdvancedCachedEntityStorage_fieldIsNotUnique), MiscUtil.getSimpleClassName(cls), propertyValue, propertyName, this.getDuplicatesListStr(result, 10)));
                }
                return totalCount == 0 ? CacheHelper.NULL_REFERENCE : ((EntityIndex)result.getData().get(0)).getSource();
            }

            private String getDuplicatesListStr(SearchResult<I> result, int maxCount) {
                StringJoiner res = new StringJoiner(",", "[", "]");
                int count = 0;
                for (EntityIndex index : result.getData()) {
                    if (count++ >= maxCount) break;
                    EntityReference source = index.getSource();
                    res.add(String.format("{source:'%s', caption:'%s', uid:'%s'}", source.getUid(), source.getCaption(), index.getUid()));
                }
                if (result.getTotalCount() > maxCount) {
                    res.add(" and more... ");
                }
                return res.toString();
            }

            @Override
            public EntityReference<E> doWithLocalStorage() {
                return AdvancedCachedEntityStorage.this.data.getSimpleSearchCache().get(cls, propertyName, propertyValue);
            }

            @Override
            public void updateLocalStorage(EntityReference<E> result) {
                AdvancedCachedEntityStorage.this.data.getSimpleSearchCache().put(cls, propertyName, propertyValue, result);
                if (AdvancedCachedEntityStorage.this.writelog.isDebugEnabled()) {
                    AdvancedCachedEntityStorage.this.writelog.debug(String.format("SimpleSearchCache is updated: class = %s, propertyName = %s, propertyValue = %s, result = %s", MiscUtil.getSimpleClassName(cls), propertyName, propertyValue, result));
                }
            }

            @Override
            public boolean isCached() {
                return AdvancedCachedEntityStorage.this.config.isPropertyCached(cls, propertyName);
            }
        }, false, String.format("find.%s.%s", MiscUtil.getSimpleClassName(cls), propertyName));
        return CacheHelper.NULL_REFERENCE.equals(reference) ? null : reference;
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> EntityContainer<E> find(Class<I> cls, String propertyName, Object propertyValue) throws StorageException {
        return this.find(cls, propertyName, propertyValue, new EntityStorageSearchParameters());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> EntityContainer<E> find(Class<I> cls, String propertyName, Object propertyValue, EntityStorageSearchParameters parameters) throws StorageException {
        return this.resolve(this.findReference(cls, propertyName, propertyValue, parameters));
    }

    @Override
    public <E extends BaseEntity> boolean isAvailable(Class<E> cls, String uid) throws StorageException {
        return this.isAvailable(cls, uid, new EntityStorageIsAvailableParameters());
    }

    @Override
    public <E extends BaseEntity> boolean isAvailable(final Class<E> cls, final String uid, final EntityStorageIsAvailableParameters parameters) throws StorageException {
        Boolean result = CacheHelper.doAction(new EntityDoActionCallback<Boolean>(){

            @Override
            public Boolean doWithActualStorage() throws Throwable {
                return AdvancedCachedEntityStorage.this.dataSource.isAvailable(cls, uid, parameters);
            }
        }, parameters.isNoCache(), String.format("isAvailable.%s", MiscUtil.getSimpleClassName(cls)));
        return result;
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> resolve(EntityReference<E> ref) throws StorageException {
        return this.resolve(ref, new EntityStorageLoadParameters());
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> rollback(EntityContainer<E> etc, int versionNumber) throws StorageException {
        return this.rollback(etc, versionNumber, new EntityStorageRollbackParameters());
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> rollback(final EntityContainer<E> etc, final int versionNumber, final EntityStorageRollbackParameters parameters) throws StorageException {
        return (EntityContainer)CacheHelper.doAction(new DefaultActualStorageOperationCallback<EntityContainer<E>>(){

            @Override
            public EntityContainer<E> doWithActualStorage() throws Throwable {
                return AdvancedCachedEntityStorage.this.dataSource.rollback(etc, versionNumber, parameters);
            }
        }, true, String.format("rollback.%s", MiscUtil.getSimpleClassName(etc.getEntityType())));
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> save(EntityContainer<E> etc, boolean withCheckPoint) throws StorageException {
        return this.save(etc, withCheckPoint, new EntityStorageSaveParameters());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult search(Class<I> cls, ProjectionQuery query) throws StorageException {
        return this.search(cls, query, new EntityStorageSearchParameters());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult search(final Class<I> cls, final ProjectionQuery query, final EntityStorageSearchParameters parameters) throws StorageException {
        if (query.isForceEmptyResponse()) {
            return new ProjectionResult();
        }
        boolean checkOldFinBlock = "true".equals(System.getProperty("entity-storage.check-old-finblock"));
        if (checkOldFinBlock && !EntityStorageThreadContext.isDontCheckFinblockRequests() && !parameters.getContext().containsKey(DONT_CHECK_OLD_FINBLOCK) && cls.getName().equals("com.gridnine.xtrip.common.model.system.BillingTransactionIndex")) {
            Date firstTransactionDate = null;
            for (SearchCriterion cr : query.getCriteria().getCriterions()) {
                Date date;
                SearchCriterion.SimpleCriterion sc;
                if (!(cr instanceof SearchCriterion.SimpleCriterion) || !"transactionDate".equals((sc = (SearchCriterion.SimpleCriterion)cr).getProperty()) || (date = (Date)sc.getValue()) == null || firstTransactionDate != null && !date.before(firstTransactionDate)) continue;
                firstTransactionDate = date;
            }
            if (firstTransactionDate == null || firstTransactionDate.after(MiscUtil.clearTime(new Date()))) {
                StringBuilder sb = new StringBuilder();
                sb.append("old fin block projection");
                sb.append("\n\tuser: ");
                sb.append(UserData.get().getCurrentUser());
                sb.append("\n\tquery: ");
                try {
                    sb.append(XSUtil.toString(query));
                }
                catch (Exception ex) {
                    sb.append("failed ");
                    sb.append(TextUtil.getExceptionStackTrace(ex));
                }
                IncidentsLog.reportStackTrace(sb.toString());
            }
        }
        SearchQueryValidator.validate(cls, query);
        return CacheHelper.doAction(new EntityDoActionCallback<ProjectionResult>(){

            @Override
            public ProjectionResult doWithActualStorage() throws Throwable {
                return AdvancedCachedEntityStorage.this.dataSource.search(cls, query, parameters);
            }

            @Override
            public ProjectionResult doWithLocalStorage() {
                return AdvancedCachedEntityStorage.this.data.getSearchQueryCache().get(cls, query);
            }

            @Override
            public void updateLocalStorage(ProjectionResult result) throws Throwable {
                AdvancedCachedEntityStorage.this.data.getSearchQueryCache().put(cls, query, result);
                if (AdvancedCachedEntityStorage.this.writelog.isDebugEnabled()) {
                    AdvancedCachedEntityStorage.this.writelog.debug(String.format("SearchCache is updated: class = %s, query = %s", MiscUtil.getSimpleClassName(cls), XSUtil.toString(query)));
                }
            }

            @Override
            public boolean isCached() {
                return AdvancedCachedEntityStorage.this.config.isSearchQueryCached(cls);
            }
        }, parameters.isNoCache(), String.format("projection-search.%s", MiscUtil.getSimpleClassName(cls)));
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> I get(Class<I> cls, SearchQuery query) throws StorageException {
        return this.get(cls, query, new EntityStorageSearchParameters(), false);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> I get(Class<I> cls, SearchQuery query, EntityStorageSearchParameters parameters) throws StorageException {
        return this.get(cls, query, parameters, false);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> I getMandatory(Class<I> cls, SearchQuery query) throws StorageException {
        return this.get(cls, query, new EntityStorageSearchParameters(), true);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> I getMandatory(Class<I> cls, SearchQuery query, EntityStorageSearchParameters parameters) throws StorageException {
        return this.get(cls, query, parameters, true);
    }

    private <E extends BaseEntity, I extends EntityIndex<E>> I get(Class<I> cls, SearchQuery query, EntityStorageSearchParameters parameters, boolean mandatory) throws StorageException {
        query.setLimit(2);
        SearchResult<I> searchResult = this.search(cls, query, parameters);
        List<I> resultData = searchResult.getData();
        if (resultData.size() == 1) {
            return (I)((EntityIndex)resultData.get(0));
        }
        if (resultData.size() > 1) {
            throw Xeption.forDeveloper("ambiguous result", new Object[0]);
        }
        if (mandatory) {
            throw Xeption.forDeveloper("no result", new Object[0]);
        }
        return null;
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> search(Class<I> cls, SearchQuery query) throws StorageException {
        return this.search(cls, query, new EntityStorageSearchParameters());
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> resolve(final EntityReference<E> ref, final EntityStorageLoadParameters parameters) throws StorageException {
        if (ref == null || ref.getUid() == null || ref.getType() == null) {
            return null;
        }
        String operationKey = this.resolveOperationKeyCache.computeIfAbsent(ref.getType(), type -> TextUtil.concat("resolve.", MiscUtil.getSimpleClassName(type)));
        String lockKey = this.useLock ? ref.toLockKey() : null;
        EntityContainer result = (EntityContainer)CacheHelper.doActionWithLock(new EntityDoActionCallback<EntityContainer<E>>(){

            @Override
            public EntityContainer<E> doWithActualStorage() throws Throwable {
                int tryCount = !Environment.isTest() && !Boolean.TRUE.equals(EntityStorageThreadContext.isIgnoreReadTryCount()) ? 3 : 1;
                for (int i = 0; i < tryCount; ++i) {
                    EntityContainer ctr = AdvancedCachedEntityStorage.this.dataSource.load(ref, parameters);
                    if (this.isCached() && ctr == null && AdvancedCachedEntityStorage.this.bugLog.isDebugEnabled()) {
                        AdvancedCachedEntityStorage.this.bugLog.debug(String.format("unable to find container in DB for uid=%s, class=%s, i=%d", ref.getUid(), ref.getType(), i));
                    }
                    if (ctr != null) {
                        return ctr;
                    }
                    if (i == tryCount - 1) continue;
                    Thread.sleep(100L);
                }
                return null;
            }

            @Override
            public EntityContainer<E> doWithLocalStorage() {
                EntityContainer ctr = AdvancedCachedEntityStorage.this.data.getEntitiesCache().get(ref.getType(), ref.getUid());
                if (CacheHelper.NULL_CONTAINER.equals(ctr) && AdvancedCachedEntityStorage.this.bugLog.isDebugEnabled()) {
                    AdvancedCachedEntityStorage.this.bugLog.debug(String.format("requested container is null in cache for uid=%s, class=%s", ref.getUid(), ref.getType()));
                }
                return ctr;
            }

            @Override
            public void updateLocalStorage(EntityContainer<E> res) {
                if (res != null && !AdvancedCachedEntityStorage.this.config.isContainerCached(res)) {
                    AdvancedCachedEntityStorage.this.data.getEntitiesCache().invalidate(ref.getType(), ref.getUid());
                    return;
                }
                AdvancedCachedEntityStorage.this.data.getEntitiesCache().put(ref.getType(), ref.getUid(), res == null ? CacheHelper.NULL_CONTAINER : res);
                AdvancedCachedEntityStorage.this.data.getCaptionsCache().put(ref.getType(), ref.getUid(), res == null ? "7821111802610283508L" : ((BaseEntity)res.getEntity()).toString());
                if (AdvancedCachedEntityStorage.this.writelog.isDebugEnabled()) {
                    AdvancedCachedEntityStorage.this.writelog.debug(String.format("ContainersCache is updated: ref = %s", ref));
                }
            }

            @Override
            public boolean isCached() {
                return AdvancedCachedEntityStorage.this.config.isContainerCached(ref.getType());
            }
        }, parameters.isNoCache(), operationKey, lockKey);
        return CacheHelper.NULL_CONTAINER.equals(result) ? null : result;
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> load(final Class<E> cls, final String uid, final Integer versionNumber) throws StorageException {
        if (cls == null || TextUtil.isBlank(uid)) {
            return null;
        }
        if (versionNumber == null) {
            return this.load(cls, uid);
        }
        return (EntityContainer)CacheHelper.doAction(new DefaultActualStorageOperationCallback<EntityContainer<E>>(){

            @Override
            public EntityContainer<E> doWithActualStorage() throws Throwable {
                return AdvancedCachedEntityStorage.this.dataSource.load(cls, uid, versionNumber);
            }
        }, true, String.format("load-version.%s", MiscUtil.getSimpleClassName(cls)));
    }

    @Override
    public <E extends BaseEntity> void delete(EntityContainer<E> etc) throws StorageException {
        this.delete(etc, new EntityStorageDeleteParameters());
    }

    @Override
    public <E extends BaseEntity> void delete(final EntityContainer<E> etc, final EntityStorageDeleteParameters parameters) throws StorageException {
        if (etc == null) {
            return;
        }
        CacheHelper.doAction(new DefaultActualStorageOperationCallback<Void>(){

            @Override
            public Void doWithActualStorage() throws Throwable {
                AdvancedCachedEntityStorage.this.dataSource.delete(etc, parameters);
                return null;
            }
        }, true, String.format("delete.%s", MiscUtil.getSimpleClassName(etc.getEntityType())));
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> load(Class<E> cls, String uid) throws StorageException {
        return this.load(cls, uid, new EntityStorageLoadParameters());
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> load(Class<E> cls, String uid, EntityStorageLoadParameters parameters) throws StorageException {
        return this.resolve(new EntityReference<E>(uid, cls, null), parameters);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> search(final Class<I> cls, final SearchQuery query, final EntityStorageSearchParameters parameters) throws StorageException {
        if (query.isForceEmptyResponse()) {
            return new SearchResult();
        }
        if (!SearchQueryOptimizer.optimize(query)) {
            this.log.warn("no row will match query " + query);
            return new SearchResult();
        }
        SearchQueryValidator.validate(cls, query);
        return (SearchResult)CacheHelper.doAction(new EntityDoActionCallback<SearchResult<I>>(){

            @Override
            public SearchResult<I> doWithActualStorage() throws Throwable {
                return AdvancedCachedEntityStorage.this.dataSource.search(cls, query, parameters);
            }

            @Override
            public SearchResult<I> doWithLocalStorage() {
                return AdvancedCachedEntityStorage.this.data.getSearchQueryCache().get(cls, query);
            }

            @Override
            public void updateLocalStorage(SearchResult<I> result) throws Throwable {
                AdvancedCachedEntityStorage.this.data.getSearchQueryCache().put(cls, query, result);
                if (AdvancedCachedEntityStorage.this.writelog.isDebugEnabled()) {
                    AdvancedCachedEntityStorage.this.writelog.debug(String.format("SearchCache is updated: class = %s, query = %s", MiscUtil.getSimpleClassName(cls), XSUtil.toString(query)));
                }
            }

            @Override
            public boolean isCached() {
                return AdvancedCachedEntityStorage.this.config.isSearchQueryCached(cls);
            }
        }, parameters.isNoCache(), String.format("search.%s", MiscUtil.getSimpleClassName(cls)));
    }

    void setDisposed(boolean disposedValue) {
        this.disposed = disposedValue;
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> save(final EntityContainer<E> etc, final boolean withCheckPoint, final EntityStorageSaveParameters parameters) throws StorageException {
        return (EntityContainer)CacheHelper.doAction(new DefaultActualStorageOperationCallback<EntityContainer<E>>(){

            @Override
            public EntityContainer<E> doWithActualStorage() throws Throwable {
                return AdvancedCachedEntityStorage.this.dataSource.save(etc, withCheckPoint, parameters);
            }
        }, true, String.format("save.%s", MiscUtil.getSimpleClassName(etc.getEntityType())));
    }

    private boolean isEndsWithAdvancedCachedEntityStorage_deleted2(EntityReference ref) {
        HashSet<String> messages = new HashSet<String>();
        for (LocaleData localeData : LocaleManager.get().getSupportedLocales()) {
            Locale locale = localeData.getLocale();
            String advancedCachedEntityStorage_deleted2 = L10n.get(Messages.class, locale, "AdvancedCachedEntityStorage_deleted2", new Object[0]);
            messages.add(advancedCachedEntityStorage_deleted2.substring(advancedCachedEntityStorage_deleted2.length() - 3));
        }
        return messages.stream().anyMatch(ref.getCaption()::endsWith);
    }

    abstract class DefaultActualStorageOperationCallback<T>
    extends EntityDoActionCallback<T> {
        DefaultActualStorageOperationCallback() {
        }

        @Override
        public boolean isCached() {
            return false;
        }

        @Override
        public T doWithLocalStorage() {
            return null;
        }

        @Override
        public void updateLocalStorage(T result) {
        }
    }

    abstract class EntityDoActionCallback<T>
    implements CacheHelper.DoActionCallback<T> {
        EntityDoActionCallback() {
        }

        @Override
        public boolean isCached() {
            return false;
        }

        @Override
        public T doWithLocalStorage() {
            return null;
        }

        @Override
        public void updateLocalStorage(T result) throws Throwable {
        }

        @Override
        public Logger getLog() {
            return AdvancedCachedEntityStorage.this.log;
        }

        @Override
        public String getProfilingPrefix() {
            return "advanced-cache.entity";
        }

        @Override
        public boolean isDisposed() {
            return AdvancedCachedEntityStorage.this.disposed;
        }

        @Override
        public Logger getWriteLog() {
            return AdvancedCachedEntityStorage.this.writelog;
        }

        @Override
        public void updateTimeStamp(Date date) {
            AdvancedCachedEntityStorage.this.state.initializeTimeStamp(date);
        }
    }
}

