/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.dict;

import com.gridnine.xtrip.common.meta.DictionaryCollection;
import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TrieMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Index<D extends BaseDictionary>
implements Serializable {
    private static final long serialVersionUID = 1641947524956035008L;
    private static final Logger log = LoggerFactory.getLogger(Index.class);
    private final HashMap<String, D> all = new HashMap();
    private volatile Map<String, D> snapshot;
    private final HashMap<String, Set<D>> varCode2items = new HashMap();
    private final HashMap<String, Set<D>> varCodeCodesystem2items = new HashMap();
    private final Map<String, D> remoteUid2items = new HashMap<String, D>();
    private final TrieMap<Set<D>> text2items = new TrieMap();
    private final HashMap<String, Map<Object, Set<D>>> indexableItems = new HashMap();
    private final HashMap<String, Map<D, Object>> indexableItemsReverse = new HashMap();
    private transient Date modified;

    private static String[] split(String text) {
        return text.toLowerCase().split("(?m)[\\s\\p{Punct}]");
    }

    void dump(StringBuilder buf) {
        buf.append("\t\tItems: ").append(this.all.size()).append("\r\n").append("\t\tVariation codes: ").append(this.varCode2items.size()).append("\r\n").append("\t\tCode + variation codes: ").append(this.varCodeCodesystem2items.size()).append("\r\n").append("\t\tRemote uids: ").append(this.remoteUid2items.size()).append("\r\n").append("\t\tText items: ").append(this.text2items.size()).append("\r\n");
    }

    Date getModified() {
        return this.modified;
    }

    void setModified(Date modifiedValue) {
        this.modified = modifiedValue;
    }

    int size() {
        return this.all.size();
    }

    public Map<String, D> getSnapshot() {
        return this.snapshot;
    }

    public Map<String, D> createNGetSnapshot() {
        return this.snapshot != null ? this.snapshot : (this.snapshot = Collections.unmodifiableMap(new HashMap<String, D>(this.all)));
    }

    void updateSnapshot() {
        this.snapshot = null;
    }

    void add(D item, boolean update) {
        Map map;
        Object val;
        this.modified = new Date();
        Map<String, Object> oldReverseMap = Index.getIndexedProperties(item.getClass().getName()).stream().map(propertyName -> new MiscUtil.Pair<String, Object>((String)propertyName, Optional.ofNullable(this.indexableItemsReverse.get(propertyName)).map(reverseMap -> reverseMap.get(item)).orElse(null))).filter(p -> p.getSecond() != null).collect(Collectors.toMap(MiscUtil.Pair::getFirst, MiscUtil.Pair::getSecond));
        this.remove(((BaseDictionary)item).getCode(), false);
        this.all.put(((BaseDictionary)item).getCode(), item);
        if (update) {
            this.updateSnapshot();
        }
        if (!TextUtil.isBlank(((BaseDictionary)item).getRemoteUid(), true)) {
            this.remoteUid2items.put(((BaseDictionary)item).getRemoteUid(), item);
        }
        for (Map.Entry<String, String> entry : ((BaseDictionary)item).getCodeVariants().entrySet()) {
            Set<D> set = this.varCode2items.get(entry.getValue());
            if (set == null) {
                set = new HashSet<D>();
                this.varCode2items.put(entry.getValue(), set);
            }
            set.add(item);
            String key = entry.getValue() + '|' + entry.getKey();
            Set<D> set2 = this.varCodeCodesystem2items.get(key);
            if (set2 == null) {
                set2 = new HashSet<D>();
                this.varCodeCodesystem2items.put(key, set2);
            }
            set2.add(item);
        }
        for (String propertyName2 : Index.getIndexedProperties(item.getClass().getName())) {
            HashSet<D> set;
            block26: {
                try {
                    val = PropertyUtils.getProperty(item, (String)propertyName2);
                    if (val == null) {
                    }
                    break block26;
                }
                catch (Exception e) {
                    log.error(String.format("unable to get value of field \"%s\" of dictionary \"%s\"", propertyName2, item.getClass().getName()), (Throwable)e);
                }
                continue;
            }
            map = this.indexableItems.get(propertyName2);
            if (map == null) {
                map = new HashMap<Object, Set<D>>();
                this.indexableItems.put(propertyName2, map);
            }
            if ((set = map.get(oldReverseMap.get(propertyName2))) != null) {
                set.remove(item);
            }
            if ((set = (HashSet<D>)map.get(val)) == null) {
                set = new HashSet<D>();
                map.put(val, set);
            }
            set.add(item);
            Map<D, Object> mapReverse = this.indexableItemsReverse.get(propertyName2);
            if (mapReverse == null) {
                mapReverse = new HashMap<D, Object>();
                this.indexableItemsReverse.put(propertyName2, mapReverse);
            }
            mapReverse.put(item, val);
        }
        for (String propertyName2 : Index.getIndexedCollections(item.getClass().getName())) {
            Collection valCol;
            Map mapReverse;
            block27: {
                try {
                    val = PropertyUtils.getProperty(item, (String)propertyName2);
                    if (val == null) {
                    }
                    break block27;
                }
                catch (Exception e) {
                    log.error(String.format("unable to get value of field \"%s\" of dictionary \"%s\"", propertyName2, item.getClass().getName()), (Throwable)e);
                }
                continue;
            }
            map = this.indexableItems.computeIfAbsent(propertyName2, prop -> new HashMap());
            Set set = (Set)map.get((mapReverse = this.indexableItemsReverse.computeIfAbsent(propertyName2, prop -> new HashMap())).get(item));
            if (set != null) {
                set.remove(item);
            }
            if (val instanceof Collection) {
                valCol = (Collection)val;
            } else if (val instanceof Map) {
                valCol = ((Map)val).values();
            } else {
                log.warn(String.format("unable to convert to collection value of field \"%s\" of dictionary \"%s\"", propertyName2, item.getClass().getName()));
                continue;
            }
            for (Object obj : valCol) {
                Set set3 = map.computeIfAbsent(obj, v -> new HashSet());
                set3.add(item);
            }
            mapReverse.put(item, val);
        }
        for (String str : ((BaseDictionary)item).getTranslations().values()) {
            this.addToTextIndex(item, str);
        }
        for (String str : ((BaseDictionary)item).getSpellVariants()) {
            this.addToTextIndex(item, str);
        }
        for (String str : ((BaseDictionary)item).getCodeVariants().values()) {
            this.addToTextIndex(item, str);
        }
    }

    private static Set<String> getIndexedProperties(String clsName) {
        DictionaryType dtype = MetaRegistry.get().getDictionaries().get(clsName);
        if (dtype == null) {
            log.error(String.format("dictionary \"%s\" is absent in MetaRegistry", clsName));
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (DictionaryProperty prop : dtype.getProperties().values()) {
            if (!prop.isIndexed()) continue;
            result.add(prop.getId());
        }
        return result;
    }

    private static Set<String> getIndexedCollections(String clsName) {
        DictionaryType dtype = MetaRegistry.get().getDictionaries().get(clsName);
        if (dtype == null) {
            log.error(String.format("dictionary \"%s\" is absent in MetaRegistry", clsName));
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (DictionaryCollection coll : dtype.getCollections().values()) {
            if (!coll.isIndexed()) continue;
            result.add(coll.getId());
        }
        return result;
    }

    private void addToTextIndex(D item, String text) {
        if (TextUtil.isBlank(text)) {
            return;
        }
        for (String key : Index.split(text)) {
            if (TextUtil.isBlank(key)) continue;
            Set<D> set = this.text2items.get(key);
            if (set == null) {
                set = new HashSet<D>();
                this.text2items.put(key, set);
            }
            set.add(item);
        }
    }

    void remove(String code, boolean update) {
        Set<D> set;
        Map<Object, Set<D>> map;
        Object val;
        this.modified = new Date();
        BaseDictionary item = (BaseDictionary)this.all.remove(code);
        if (update) {
            this.updateSnapshot();
        }
        if (item == null) {
            return;
        }
        if (!TextUtil.isBlank(item.getRemoteUid(), true)) {
            this.remoteUid2items.remove(item.getRemoteUid());
        }
        for (Map.Entry<String, String> entry : item.getCodeVariants().entrySet()) {
            String key;
            Set<D> set2;
            Set<D> set3 = this.varCode2items.get(entry.getValue());
            if (set3 != null) {
                set3.remove(item);
                if (set3.isEmpty()) {
                    this.varCode2items.remove(entry.getValue());
                }
            }
            if ((set2 = this.varCodeCodesystem2items.get(key = entry.getValue() + '|' + entry.getKey())) == null) continue;
            set2.remove(item);
            if (!set2.isEmpty()) continue;
            this.varCodeCodesystem2items.remove(key);
        }
        for (String propertyName : Index.getIndexedProperties(item.getClass().getName())) {
            Map<D, Object> mapReverse;
            block18: {
                try {
                    val = PropertyUtils.getProperty((Object)item, (String)propertyName);
                    if (val == null) {
                    }
                    break block18;
                }
                catch (Exception e) {
                    log.error(String.format("unable to get value of field \"%s\" of dictionary \"%s\"", propertyName, item.getClass().getName()), (Throwable)e);
                }
                continue;
            }
            map = this.indexableItems.get(propertyName);
            if (map != null && (set = map.get(val)) != null) {
                set.remove(item);
            }
            if ((mapReverse = this.indexableItemsReverse.get(propertyName)) == null) continue;
            mapReverse.remove(item);
        }
        for (String propertyName : Index.getIndexedCollections(item.getClass().getName())) {
            block19: {
                try {
                    val = PropertyUtils.getProperty((Object)item, (String)propertyName);
                    if (val == null) {
                    }
                    break block19;
                }
                catch (Exception e) {
                    log.error(String.format("unable to get value of field \"%s\" of dictionary \"%s\"", propertyName, item.getClass().getName()), (Throwable)e);
                }
                continue;
            }
            map = this.indexableItems.get(propertyName);
            if (map == null || (set = map.get(val)) == null) continue;
            set.remove(item);
        }
        for (String str : item.getTranslations().values()) {
            this.removeFromTextIndex(item, str);
        }
        for (String str : item.getSpellVariants()) {
            this.removeFromTextIndex(item, str);
        }
        for (String str : item.getCodeVariants().values()) {
            this.removeFromTextIndex(item, str);
        }
    }

    private void removeFromTextIndex(D item, String text) {
        if (TextUtil.isBlank(text)) {
            return;
        }
        for (String key : Index.split(text)) {
            Set<D> set;
            if (TextUtil.isBlank(key) || (set = this.text2items.get(key)) == null) continue;
            set.remove(item);
            if (!set.isEmpty()) continue;
            this.text2items.remove(key);
        }
    }

    D findByCode(String code) {
        return (D)((BaseDictionary)this.all.get(code));
    }

    D findByRemoteUid(String remoteUid) {
        return (D)((BaseDictionary)this.remoteUid2items.get(remoteUid));
    }

    Set<D> lookup(String code, String ... codeSystems) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        if (codeSystems != null && codeSystems.length > 0) {
            for (String codeSystem : codeSystems) {
                Set<D> set = this.varCodeCodesystem2items.get(code + '|' + codeSystem);
                if (set == null) continue;
                result.addAll(set);
            }
        } else {
            Set<D> set;
            BaseDictionary item = (BaseDictionary)this.all.get(code);
            if (item != null) {
                result.add(item);
            }
            if ((set = this.varCode2items.get(code)) != null) {
                result.addAll(set);
            }
        }
        return result;
    }

    Set<D> search(String pattern) {
        HashSet result = null;
        for (String str : Index.split(pattern)) {
            if (TextUtil.isBlank(str)) continue;
            HashSet set = new HashSet();
            Iterator<Map.Entry<String, Set<D>>> it = this.text2items.search(str);
            while (it.hasNext()) {
                set.addAll(it.next().getValue());
            }
            if (result == null) {
                result = set;
                continue;
            }
            result.retainAll(set);
        }
        return result == null ? new HashSet() : result;
    }

    Set<D> search(DictSearchCriterion criterion) {
        if (TextUtil.isBlank(criterion.getPropertyName()) || criterion.getOperation() == null) {
            return Collections.emptySet();
        }
        switch (criterion.getOperation()) {
            case EQUALS: 
            case CONTAINS: {
                if (criterion.getValue() == null) {
                    return Collections.emptySet();
                }
                Map<Object, Set<D>> map = this.indexableItems.get(criterion.getPropertyName());
                if (map == null) {
                    return Collections.emptySet();
                }
                Set<D> set = map.get(criterion.getValue());
                if (set == null) {
                    return Collections.emptySet();
                }
                return Collections.unmodifiableSet(new HashSet<D>(set));
            }
        }
        return Collections.emptySet();
    }
}

