/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.entity;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityActualizer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityStorageHelper {
    private static final Logger logLoad = LoggerFactory.getLogger((String)String.format("%s.LOAD", EntityStorageHelper.class.getName()));
    static EntityContainer<BaseEntity> NULL_CTR = new EntityContainer<BaseEntity>(BaseEntity.class, "null-container");

    public static EntityStorageContext createContext() {
        EntityStorageContext result = new EntityStorageContext();
        return result;
    }

    public static <Root extends BaseEntity> EntityStorageContext createContext(EntityContainer<Root> ctr) {
        EntityStorageContext result = new EntityStorageContext();
        result.putContainer(ctr.toReference(), ctr);
        result.putOriginalContainer(ctr.toReference(), EntityStorageHelper.cloneCtr(ctr));
        return result;
    }

    public static <Root extends BaseEntity> void registerContainer(EntityContainer<Root> ctr, EntityStorageContext ctx) {
        ctx.putContainer(ctr.toReference(), ctr);
        ctx.putOriginalContainer(ctr.toReference(), EntityStorageHelper.cloneCtr(ctr));
    }

    public static <E extends BaseEntity> EntityContainer<E> resolve(EntityReference<E> ref, EntityStorageContext ctx) {
        if (ref == null) {
            return null;
        }
        EntityContainer<E> ctr = ctx.getContainer(ref);
        if (ctr != null) {
            if (ctx.getDeletedContainers().contains(ctr)) {
                if (logLoad.isDebugEnabled()) {
                    logLoad.debug(String.format("%s : entity reference load failed (deleted): %s (type -> %s, uid -> %s)", String.valueOf(ctx.hashCode()), ref.getCaption(), ref.getType(), ref.getUid()));
                }
                return null;
            }
            if (NULL_CTR.equals(ctr)) {
                if (logLoad.isDebugEnabled()) {
                    logLoad.debug(String.format("%s : entity reference load failed (cache): %s (type -> %s, uid -> %s)", String.valueOf(ctx.hashCode()), ref.getCaption(), ref.getType(), ref.getUid()));
                }
                return null;
            }
            if (logLoad.isDebugEnabled()) {
                logLoad.debug(String.format("%s : entity reference load success (cache): %s (type -> %s, uid -> %s)", String.valueOf(ctx.hashCode()), ref.getCaption(), ref.getType(), ref.getUid()));
            }
            return ctr;
        }
        ctr = EntityStorage.get().resolve(ref);
        if (ctr != null) {
            if (logLoad.isDebugEnabled()) {
                logLoad.debug(String.format("%s : entity reference load success (storage): %s (type -> %s, uid -> %s)", String.valueOf(ctx.hashCode()), ref.getCaption(), ref.getType(), ref.getUid()));
            }
        } else if (logLoad.isDebugEnabled()) {
            logLoad.debug(String.format("%s : entity reference load failed (storage): %s (type -> %s, uid -> %s)", String.valueOf(ctx.hashCode()), ref.getCaption(), ref.getType(), ref.getUid()));
        }
        ctx.putContainer(ref, ctr == null ? NULL_CTR : ctr);
        ctx.putOriginalContainer(ref, EntityStorageHelper.cloneCtr(ctr));
        return ctr;
    }

    public static List<EntityContainer<?>> getChangedContainers(EntityStorageContext ctx) {
        ArrayList result = new ArrayList();
        for (EntityContainer<?> ctr : ctx.getAllContainers()) {
            if (NULL_CTR == ctr || ctx.getDeletedContainers().contains(ctr)) continue;
            EntityContainer<?> originalContainer = ctx.getOriginalContainer(ctr.toReference());
            if (originalContainer != null) {
                try {
                    HashSet processedUids = new HashSet();
                    if (EntityStorageHelper.isEquals(ctr, originalContainer)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper("unable to serialize container {0}", e, ctr.toReference());
                }
            }
            result.add(ctr);
        }
        return result;
    }

    private static boolean isEquals(EntityContainer<?> o1, EntityContainer<?> o2) throws Exception {
        if (!(EntityStorageHelper.isEquals(o1.getCreated(), o1.getCreated()) && EntityStorageHelper.isEquals(o1.getCreatedBy(), o2.getCreatedBy()) && EntityStorageHelper.isEquals(o1.getModified(), o2.getModified()) && EntityStorageHelper.isEquals(o1.getModifiedBy(), o2.getModifiedBy()) && EntityStorageHelper.isEquals((Object)o1.getStatus(), (Object)o2.getStatus()) && EntityStorageHelper.isEquals(o1.getUid(), o2.getUid()) && EntityStorageHelper.isEquals((Object)o1.getUpdatePolicy(), (Object)o2.getUpdatePolicy()) && EntityStorageHelper.isEquals(o1.getVersionInfo(), o2.getVersionInfo()) && o1.getVersionsCount() == o2.getVersionsCount())) {
            return false;
        }
        HashSet<Object> processedUids = new HashSet<Object>();
        return EntityStorageHelper.isEquals(o1.getEntity(), o2.getEntity(), processedUids);
    }

    public static boolean isEqualsWithAllProperties(BaseEntity o1, BaseEntity o2) throws Exception {
        Object value2;
        Object value1;
        if (null == o1) {
            return null == o2;
        }
        if (null == o2) {
            return false;
        }
        MetaRegistry metaRegistry = MetaRegistry.get();
        EntityType entityType = metaRegistry.getEntities().get(o1.getClass().getName());
        if (null == entityType) {
            return TextUtil.isSame(XSUtil.toString(o1), XSUtil.toString(o2));
        }
        for (Property prop : MetaRegistryHelper.getAllProperties(entityType).values()) {
            value1 = o1.getValue(prop.getId());
            value2 = o2.getValue(prop.getId());
            if (!(value1 instanceof BaseEntity ? !EntityStorageHelper.isEqualsWithAllProperties((BaseEntity)value1, (BaseEntity)value2) : !EntityStorageHelper.isEquals(value1, value2))) continue;
            return false;
        }
        for (EntityCollection col : MetaRegistryHelper.getAllCollections(entityType).values()) {
            value1 = o1.getValue(col.getId());
            value2 = o2.getValue(col.getId());
            if (!(value1 instanceof Set ? !EntityStorageHelper.isEquals(value1, value2) : (value1 instanceof Collection ? !EntityStorageHelper.isEquals(value1, value2) : value1 instanceof Map && !EntityStorageHelper.isEquals(value1, value2)))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEquals(BaseEntity o1, BaseEntity o2, Set<Object> processed) throws Exception {
        Object value2;
        Object value1;
        if (null == o1) {
            return null == o2;
        }
        if (null == o2) {
            return false;
        }
        if (processed.contains(o1)) {
            return true;
        }
        processed.add(o1);
        MetaRegistry metaRegistry = MetaRegistry.get();
        EntityType entityType = metaRegistry.getEntities().get(o1.getClass().getName());
        if (null == entityType) {
            return TextUtil.isSame(XSUtil.toString(o1), XSUtil.toString(o2));
        }
        for (Property prop : MetaRegistryHelper.getAllProperties(entityType).values()) {
            value1 = o1.getValue(prop.getId());
            value2 = o2.getValue(prop.getId());
            if (!(value1 instanceof BaseEntity ? !EntityStorageHelper.isEquals((BaseEntity)value1, (BaseEntity)value2, processed) : !EntityStorageHelper.isEquals(value1, value2))) continue;
            return false;
        }
        for (EntityCollection col : MetaRegistryHelper.getAllCollections(entityType).values()) {
            value1 = o1.getValue(col.getId());
            value2 = o2.getValue(col.getId());
            if (!(value1 instanceof Set ? !EntityStorageHelper.isEquals((Set)value1, (Set)value2, processed) : (value1 instanceof Collection ? !EntityStorageHelper.isEquals((Collection)value1, (Collection)value2, processed) : value1 instanceof Map && !EntityStorageHelper.isEquals((Map)value1, (Map)value2, processed)))) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean isEquals(Set<T> o1, Set<T> o2, Set<Object> processed) throws Exception {
        if (o1.size() != o2.size()) {
            return false;
        }
        if (o1.size() == 0) {
            return true;
        }
        HashSet<T> moneybox = new HashSet<T>(o2);
        block0: for (T value1 : o1) {
            for (Object value2 : moneybox) {
                if (value1 instanceof BaseEntity && value2 instanceof BaseEntity) {
                    if (!EntityStorageHelper.isEquals((BaseEntity)value1, (BaseEntity)value2, processed)) continue;
                    moneybox.remove(value2);
                    continue block0;
                }
                if (!EntityStorageHelper.isEquals(value1, value2)) continue;
                moneybox.remove(value2);
                continue block0;
            }
            return false;
        }
        return true;
    }

    private static <T> boolean isEquals(Collection<T> o1, Collection<T> o2, Set<Object> processed) throws Exception {
        if (o1.size() != o2.size()) {
            return false;
        }
        Iterator<T> iter2 = o2.iterator();
        for (T value1 : o1) {
            T value2 = iter2.next();
            if (!(value1 instanceof BaseEntity && value2 instanceof BaseEntity ? !EntityStorageHelper.isEquals((BaseEntity)value1, (BaseEntity)value2, processed) : !EntityStorageHelper.isEquals(value1, value2))) continue;
            return false;
        }
        return true;
    }

    private static <K, V> boolean isEquals(Map<K, V> o1, Map<K, V> o2, Set<Object> processed) throws Exception {
        if (o1.size() != o2.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry1 : o1.entrySet()) {
            V value1 = entry1.getValue();
            V value2 = o2.get(entry1.getKey());
            if (!(value1 instanceof BaseEntity && value2 instanceof BaseEntity ? !EntityStorageHelper.isEquals((BaseEntity)value1, (BaseEntity)value2, processed) : !EntityStorageHelper.isEquals(value1, value2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEquals(Object o1, Object o2) {
        return MiscUtil.equals(o1, o2);
    }

    public static List<EntityContainer<?>> getDeletedContainers(EntityStorageContext ctx) {
        return new ArrayList(ctx.getDeletedContainers());
    }

    public static <Root extends BaseEntity, Nested extends BaseEntity> List<Nested> resolve(List<NestedEntityReference<Root, Nested>> references, EntityStorageContext context) {
        ArrayList<Nested> entities = new ArrayList<Nested>();
        for (NestedEntityReference<Root, Nested> reference : references) {
            Nested entity = EntityStorageHelper.resolve(reference, context);
            if (entity == null) continue;
            entities.add(entity);
        }
        return entities;
    }

    public static <Root extends BaseEntity, Nested extends BaseEntity> MiscUtil.Pair<EntityContainer<Root>, Nested> resolveDetailed(NestedEntityReference<Root, Nested> reference) {
        return EntityStorageHelper.resolveDetailed(reference, new EntityStorageContext());
    }

    public static <Root extends BaseEntity, Nested extends BaseEntity> MiscUtil.Pair<EntityContainer<Root>, Nested> resolveDetailed(NestedEntityReference<Root, Nested> reference, EntityStorageContext context) {
        if (null == reference) {
            return null;
        }
        EntityContainer container = context.getContainer(reference);
        if (container != null) {
            if (context.getDeletedContainers().contains(container)) {
                if (logLoad.isDebugEnabled()) {
                    logLoad.debug(String.format("%s : nested entity reference load failed (deleted): %s (type -> %s, uid -> %s, nestedType -> %s, nestedUid -> %s)", String.valueOf(context.hashCode()), reference.getCaption(), reference.getType(), reference.getUid(), reference.getNestedEntityType(), reference.getNestedEntityUid()));
                }
                return null;
            }
            if (NULL_CTR.equals(container)) {
                if (logLoad.isDebugEnabled()) {
                    logLoad.debug(String.format("%s : nested entity reference load failed (cache): %s (type -> %s, uid -> %s, nestedType -> %s, nestedUid -> %s)", String.valueOf(context.hashCode()), reference.getCaption(), reference.getType(), reference.getUid(), reference.getNestedEntityType(), reference.getNestedEntityUid()));
                }
                return null;
            }
            if (logLoad.isDebugEnabled()) {
                logLoad.debug(String.format("%s : nested entity reference load success (cache): %s (type -> %s, uid -> %s, nestedType -> %s, nestedUid -> %s)", String.valueOf(context.hashCode()), reference.getCaption(), reference.getType(), reference.getUid(), reference.getNestedEntityType(), reference.getNestedEntityUid()));
            }
        }
        if (container == null) {
            container = EntityStorage.get().resolve(reference);
            if (container != null) {
                if (logLoad.isDebugEnabled()) {
                    logLoad.debug(String.format("%s : nested entity reference load success (storage): %s (type -> %s, uid -> %s, nestedType -> %s, nestedUid -> %s)", String.valueOf(context.hashCode()), reference.getCaption(), reference.getType(), reference.getUid(), reference.getNestedEntityType(), reference.getNestedEntityUid()));
                }
                context.putContainer(container.toReference(), container);
                context.putOriginalContainer(container.toReference(), EntityStorageHelper.cloneCtr(container));
            } else {
                if (logLoad.isDebugEnabled()) {
                    logLoad.debug(String.format("%s : nested entity reference load failed (storage): %s (type -> %s, uid -> %s, nestedType -> %s, nestedUid -> %s)", String.valueOf(context.hashCode()), reference.getCaption(), reference.getType(), reference.getUid(), reference.getNestedEntityType(), reference.getNestedEntityUid()));
                }
                context.putContainer(reference, NULL_CTR);
                context.putOriginalContainer(reference, NULL_CTR);
                return null;
            }
        }
        HashSet<BaseEntity> processedEntities = new HashSet<BaseEntity>();
        Nested entity = EntityStorageHelper.findNestedEntity(container.getEntity(), reference.getNestedEntityUid(), reference.getNestedEntityType(), processedEntities);
        if (entity == null) {
            if (logLoad.isDebugEnabled()) {
                logLoad.debug(String.format("%s : nested entity reference find failed: %s (type -> %s, uid -> %s, nestedType -> %s, nestedUid -> %s)", String.valueOf(context.hashCode()), reference.getCaption(), reference.getType(), reference.getUid(), reference.getNestedEntityType(), reference.getNestedEntityUid()));
            }
            return null;
        }
        if (logLoad.isDebugEnabled()) {
            logLoad.debug(String.format("%s : nested entity reference find success: %s (type -> %s, uid -> %s, nestedType -> %s, nestedUid -> %s)", String.valueOf(context.hashCode()), reference.getCaption(), reference.getType(), reference.getUid(), reference.getNestedEntityType(), reference.getNestedEntityUid()));
        }
        return new MiscUtil.Pair(container, entity);
    }

    public static <Root extends BaseEntity, Nested extends BaseEntity> Nested resolve(NestedEntityReference<Root, Nested> ref) {
        return EntityStorageHelper.resolve(ref, new EntityStorageContext());
    }

    public static <Root extends BaseEntity, Nested extends BaseEntity> Nested resolve(NestedEntityReference<Root, Nested> ref, EntityStorageContext ctx) {
        MiscUtil.Pair<EntityContainer<Root>, Nested> result = EntityStorageHelper.resolveDetailed(ref, ctx);
        return (Nested)(result != null ? (BaseEntity)result.getSecond() : null);
    }

    public static <P extends BaseEntity, T extends BaseEntity> P findParentEntity(T entity, Class<P> cls, EntityStorageContext ctx) {
        if (null == entity) {
            return null;
        }
        for (EntityContainer<?> item : ctx.getAllContainers()) {
            if (item.equals(NULL_CTR)) continue;
            HashSet<BaseEntity> processedEntities = new HashSet<BaseEntity>();
            ArrayList<BaseEntity> objects = new ArrayList<BaseEntity>();
            objects.add(item);
            if (!EntityStorageHelper.findLeaf(entity, item.getEntity(), processedEntities, objects)) continue;
            for (BaseEntity object : objects) {
                if (!cls.isAssignableFrom(object.getClass())) continue;
                return (P)object;
            }
            throw new IllegalStateException(String.format("leaf %s found but parent of type %s is absent", entity, cls.getName()));
        }
        return null;
    }

    private static <T extends BaseEntity> boolean findLeaf(T leaf, BaseEntity ett, Set<BaseEntity> processedEntities, List<BaseEntity> objects) {
        int i;
        if (processedEntities.contains(ett)) {
            return false;
        }
        processedEntities.add(ett);
        if (leaf.getClass().isAssignableFrom(ett.getClass()) && ett.getUid().equals(leaf.getUid())) {
            return true;
        }
        MetaRegistry mr = MetaRegistry.get();
        EntityType et = mr.getEntities().get(ett.getClass().getName());
        if (et == null) {
            return false;
        }
        List<String> properties = MetaRegistryHelper.getAllProperties(et).keyList();
        for (i = 0; i < properties.size(); ++i) {
            BaseEntity be;
            String prop = properties.get(i);
            Object value = ett.getValue(prop);
            if (!(value instanceof BaseEntity) || !EntityStorageHelper.findLeaf(leaf, be = (BaseEntity)value, processedEntities, objects)) continue;
            objects.add(ett);
            return true;
        }
        List<String> collections = MetaRegistryHelper.getAllCollections(et).keyList();
        for (i = 0; i < collections.size(); ++i) {
            String coll = collections.get(i);
            Object object = ett.getValue(coll);
            Collection collectionValues = object instanceof Map ? ((Map)object).values() : (Collection)object;
            if (collectionValues instanceof List) {
                if (!(collectionValues instanceof RandomAccess)) {
                    IncidentsLog.reportStackTrace("List and not RandomAccess");
                }
                List listValues = (List)collectionValues;
                for (int n = 0; n < listValues.size(); ++n) {
                    BaseEntity be;
                    Object val = listValues.get(n);
                    if (!(val instanceof BaseEntity) || !EntityStorageHelper.findLeaf(leaf, be = (BaseEntity)val, processedEntities, objects)) continue;
                    objects.add(ett);
                    return true;
                }
                continue;
            }
            if (collectionValues.isEmpty()) continue;
            for (Object val : collectionValues) {
                BaseEntity be;
                if (!(val instanceof BaseEntity) || !EntityStorageHelper.findLeaf(leaf, be = (BaseEntity)val, processedEntities, objects)) continue;
                objects.add(ett);
                return true;
            }
        }
        return false;
    }

    public static <E extends BaseEntity, T extends BaseEntity> T findNestedEntity(E ett, NestedEntityReference<E, T> ref) {
        return EntityStorageHelper.findNestedEntity(ett, ref.getNestedEntityUid(), ref.getNestedEntityType(), new HashSet<BaseEntity>());
    }

    public static <E extends BaseEntity, T extends BaseEntity> T findNestedEntity(E ett, NestedEntityReference<E, T> ref, Set<BaseEntity> processedEntities) {
        return EntityStorageHelper.findNestedEntity(ett, ref.getNestedEntityUid(), ref.getNestedEntityType(), processedEntities);
    }

    public static <T extends BaseEntity> T findNestedEntity(BaseEntity ett, String uid, Class<T> cls, Set<BaseEntity> processedEntities) {
        int k;
        if (processedEntities.contains(ett)) {
            return null;
        }
        processedEntities.add(ett);
        if (cls.isInstance(ett) && ett.getUid().equals(uid)) {
            return (T)ett;
        }
        MetaRegistry mr = MetaRegistry.get();
        EntityType et = mr.getEntities().get(ett.getClass().getName());
        if (et == null) {
            return null;
        }
        List<String> properties = MetaRegistryHelper.getAllProperties(et).keyList();
        for (k = 0; k < properties.size(); ++k) {
            BaseEntity be;
            T res;
            String prop = properties.get(k);
            Object value = ett.getValue(prop);
            if (!(value instanceof BaseEntity) || (res = EntityStorageHelper.findNestedEntity(be = (BaseEntity)value, uid, cls, processedEntities)) == null) continue;
            return res;
        }
        List<String> collections = MetaRegistryHelper.getAllCollections(et).keyList();
        for (k = 0; k < collections.size(); ++k) {
            String coll = collections.get(k);
            Object value = ett.getValue(coll);
            Collection collectionValues = value instanceof Map ? ((Map)value).values() : (Collection)value;
            if (collectionValues instanceof List) {
                if (!(collectionValues instanceof RandomAccess)) {
                    IncidentsLog.reportStackTrace("List and not RandomAccess");
                }
                List listValues = (List)collectionValues;
                for (int n = 0; n < listValues.size(); ++n) {
                    Object val = listValues.get(n);
                    T res = EntityStorageHelper.processVal(val, uid, cls, processedEntities);
                    if (res == null) continue;
                    return res;
                }
                continue;
            }
            if (collectionValues.isEmpty()) continue;
            for (Object val : collectionValues) {
                T res = EntityStorageHelper.processVal(val, uid, cls, processedEntities);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private static <E extends BaseEntity, T extends BaseEntity> T processVal(Object val, String uid, Class<T> cls, Set<BaseEntity> processedEntities) {
        BaseEntity be;
        T res;
        if (val instanceof BaseEntity && (res = EntityStorageHelper.findNestedEntity(be = (BaseEntity)val, uid, cls, processedEntities)) != null) {
            return res;
        }
        return null;
    }

    public static <Root extends BaseEntity> EntityContainer<Root> createContainer(Class<Root> cls, String uid, EntityStorageContext ctx) {
        EntityContainer<Root> ctr = uid == null ? new EntityContainer<Root>(cls) : new EntityContainer<Root>(cls, uid);
        ctx.putContainer(ctr.toReference(), ctr);
        return ctr;
    }

    public static <E extends BaseEntity> EntityContainer<E> createContainer(E entity, EntityStorageContext ctx) {
        EntityContainer<E> ctr = EntityContainer.create(entity);
        ctx.putContainer(ctr.toReference(), ctr);
        return ctr;
    }

    public static <Root extends BaseEntity> EntityContainer<Root> deleteContainer(EntityContainer<Root> ctr, EntityStorageContext ctx) {
        if (ctr == null) {
            return null;
        }
        ctx.getDeletedContainers().add(ctr);
        return ctr;
    }

    public static <Root extends BaseEntity> void forget(EntityContainer<Root> ctr, EntityStorageContext ctx) {
        ctx.getContainers().remove(ctr.getUid());
        ctx.getOriginalContainers().remove(ctr.getUid());
        ctx.getDeletedContainers().remove(ctr);
    }

    public static <Root extends BaseEntity> void forget(EntityReference<Root> ref, EntityStorageContext ctx) {
        ctx.getContainers().remove(ref.getUid());
        ctx.getOriginalContainers().remove(ref.getUid());
        EntityContainer<?> ctr = CollectionUtil.find(ctx.getDeletedContainers(), ref.getUid());
        if (ctr != null) {
            ctx.getDeletedContainers().remove(ctr);
        }
    }

    private static <E extends BaseEntity> EntityContainer<E> cloneCtr(EntityContainer<E> ctr) {
        if (ctr == null) {
            return NULL_CTR;
        }
        try {
            return XCloneHelper.clone(ctr);
        }
        catch (Exception e) {
            throw Xeption.forDeveloper("unable to clone {0}", e, ctr.toReference());
        }
    }

    public static <E extends BaseEntity> EntityContainer<E> resolve(EntityReference<E> ref) {
        if (Objects.isNull(ref)) {
            return null;
        }
        EntityContainer<E> ctr = EntityStorage.get().resolve(ref);
        if (ctr != null) {
            if (logLoad.isDebugEnabled()) {
                logLoad.debug(String.format("no context : entity reference load success (storage): %s (type -> %s, uid -> %s)", ref.getCaption(), ref.getType(), ref.getUid()));
            }
        } else if (logLoad.isDebugEnabled()) {
            logLoad.debug(String.format("no context : entity reference load failed (storage): context -> no context: %s (type -> %s, uid -> %s)", ref.getCaption(), ref.getType(), ref.getUid()));
        }
        return EntityStorageHelper.isEmpty(ctr) ? null : ctr;
    }

    public static <E extends BaseEntity> boolean isEmpty(EntityContainer<E> container) {
        return container == null || container.getEntity() == null;
    }

    public static <E extends BaseEntity> boolean nonEmpty(EntityContainer<E> container) {
        return !EntityStorageHelper.isEmpty(container);
    }

    public static <E extends BaseEntity> EntityContainer<E> requireNonNull(EntityContainer<E> container) {
        if (EntityStorageHelper.isEmpty(container)) {
            throw new IllegalArgumentException("empty container");
        }
        return container;
    }

    public static <T> boolean isEmpty(SearchResult<T> result) {
        return result == null || CollectionUtil.isEmpty(result.getData());
    }

    public static <T> boolean nonEmpty(SearchResult<T> result) {
        return !EntityStorageHelper.isEmpty(result);
    }

    public static <E extends BaseEntity> String getUid(EntityContainer<E> container) {
        return EntityStorageHelper.isEmpty(container) ? null : container.getUid();
    }

    public static <E extends BaseEntity> String getUid(EntityReference<E> reference) {
        return reference == null ? null : reference.getUid();
    }

    public static <E extends BaseEntity> EntityContainer<E> save(EntityContainer<E> container, boolean withCheckPoint, EntityStorageSaveParameters parameters) {
        EntityActualizer.newInstance().actualize(container.getEntity());
        return EntityStorage.get().save(container, withCheckPoint, parameters);
    }

    public static List<EntityContainer<?>> getAllContainers(EntityStorageContext ctx) {
        ArrayList result = new ArrayList();
        for (EntityContainer<?> ctr : ctx.getAllContainers()) {
            if (NULL_CTR == ctr || ctx.getDeletedContainers().contains(ctr)) continue;
            result.add(ctr);
        }
        return result;
    }

    public static EntityContainer<?> getContainer(EntityStorageContext ctx, EntityReference<?> reference) {
        EntityContainer<?> container = ctx.getContainer(reference);
        return NULL_CTR != container && !ctx.getDeletedContainers().contains(container) ? container : null;
    }

    public static <T extends BaseEntity> T entity(EntityContainer<? extends T> container) {
        return EntityStorageHelper.isEmpty(container) ? null : (T)container.getEntity();
    }

    private EntityStorageHelper() {
    }

    public static class NestedEntity<Root extends BaseEntity, Nested extends BaseEntity> {
        private static final NestedEntity NULL = new NestedEntity(null, null);
        private final EntityContainer<Root> ctr;
        private final Nested ett;

        public static <Root extends BaseEntity, Nested extends BaseEntity> NestedEntity<Root, Nested> forRef(NestedEntityReference<Root, Nested> ref, EntityStorageContext ctx) {
            if (ref == null) {
                return NULL;
            }
            Nested ett = EntityStorageHelper.resolve(ref, ctx);
            EntityContainer ctr = ctx.getContainer(ref);
            if (ctr == null || NULL_CTR.equals(ctr)) {
                return NULL;
            }
            return new NestedEntity(ctr, ett);
        }

        public static <Root extends BaseEntity, Nested extends BaseEntity> NestedEntity<Root, Nested> nullEntity() {
            return NULL;
        }

        public NestedEntity(EntityContainer<Root> c, Nested e) {
            this.ctr = c;
            this.ett = e;
        }

        public EntityContainer<Root> getContainer() {
            return this.ctr;
        }

        public Nested getEntity() {
            return this.ett;
        }

        public NestedEntityReference<Root, Nested> toReference() {
            return new NestedEntityReference<Root, Nested>(this.ctr, this.ett);
        }
    }
}

