/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.entity.misc;

import java.util.concurrent.Callable;

public class EntityStorageThreadContext {
    private static ThreadLocal<EntityStorageThreadContext> ctx = new ThreadLocal();
    private boolean dontCheckFinblockRequests;
    private String defaultDataSource;
    private ActionSource actionSource;
    private boolean ignoreReadTryCount;

    public static void setDontCheckFinblockRequests(boolean value) {
        EntityStorageThreadContext.ctx.get().dontCheckFinblockRequests = value;
    }

    public static boolean isDontCheckFinblockRequests() {
        EntityStorageThreadContext sc = ctx.get();
        if (sc == null) {
            return false;
        }
        return sc.dontCheckFinblockRequests;
    }

    public static String getDefaultDataSource() {
        EntityStorageThreadContext sc = ctx.get();
        if (sc == null) {
            return null;
        }
        return sc.defaultDataSource;
    }

    public static ActionSource getActionSource() {
        EntityStorageThreadContext sc = ctx.get();
        if (sc == null) {
            return null;
        }
        return sc.actionSource;
    }

    public static boolean isIgnoreReadTryCount() {
        EntityStorageThreadContext sc = ctx.get();
        if (sc == null) {
            return false;
        }
        return sc.ignoreReadTryCount;
    }

    public static void setIgnoreReadTryCount(boolean value) {
        EntityStorageThreadContext.ctx.get().ignoreReadTryCount = value;
    }

    public static void setDefaultDataSource(String value) {
        EntityStorageThreadContext.ctx.get().defaultDataSource = value;
    }

    public static void setActionSource(ActionSource value) {
        EntityStorageThreadContext.ctx.get().actionSource = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(Callable<T> callable) throws Exception {
        EntityStorageThreadContext oldCtx = ctx.get();
        EntityStorageThreadContext newCtx = new EntityStorageThreadContext();
        if (oldCtx != null) {
            oldCtx.copyTo(newCtx);
        }
        ctx.set(newCtx);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            ctx.set(oldCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T callWithThrowable(CallableWithThrowable<T> callable) throws Throwable {
        EntityStorageThreadContext oldCtx = ctx.get();
        EntityStorageThreadContext newCtx = new EntityStorageThreadContext();
        if (oldCtx != null) {
            oldCtx.copyTo(newCtx);
        }
        ctx.set(newCtx);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            ctx.set(oldCtx);
        }
    }

    public static void execute(RunnableWithException<?> runnable) throws Exception {
        EntityStorageThreadContext oldCtx = ctx.get();
        EntityStorageThreadContext newCtx = new EntityStorageThreadContext();
        if (oldCtx != null) {
            oldCtx.copyTo(newCtx);
        }
        ctx.set(newCtx);
        try {
            runnable.run();
        }
        finally {
            ctx.set(oldCtx);
        }
    }

    public static void executeWithoutException(Runnable runnable) {
        EntityStorageThreadContext oldCtx = ctx.get();
        EntityStorageThreadContext newCtx = new EntityStorageThreadContext();
        if (oldCtx != null) {
            oldCtx.copyTo(newCtx);
        }
        ctx.set(newCtx);
        try {
            runnable.run();
        }
        finally {
            ctx.set(oldCtx);
        }
    }

    private void copyTo(EntityStorageThreadContext newCtx) {
        newCtx.dontCheckFinblockRequests = this.dontCheckFinblockRequests;
        newCtx.defaultDataSource = this.defaultDataSource;
        newCtx.actionSource = this.actionSource;
        newCtx.ignoreReadTryCount = this.ignoreReadTryCount;
    }

    public static enum ActionSource {
        PARSER,
        MIDOFFICE_CLIENT_FX,
        ONLINE;

    }

    @FunctionalInterface
    public static interface CallableWithThrowable<T> {
        public T call() throws Throwable;
    }

    @FunctionalInterface
    public static interface RunnableWithException<E extends Exception> {
        public void run() throws E;
    }
}

