/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.entity.misc;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.BaseEntityStorageParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageDeleteParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageIsAvailableParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageRollbackParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;

public class IrrelevanceTolerantEntityStorage
extends EntityStorage {
    private final ThreadLocal<Boolean> tolerant = new ThreadLocal();
    private final EntityStorage storage;
    public static final String IRRELEVANCE_TOLERANT_QUERY = "irrelevance-tolerant-query";
    public static final EntityStorageSearchParameters IRRELEVANCE_TOLERANT_PARAMS = (EntityStorageSearchParameters)new EntityStorageSearchParameters().context("irrelevance-tolerant-query", Boolean.TRUE);

    public void setTolerant(boolean value) {
        this.tolerant.set(value);
    }

    public Boolean getTolerant() {
        return this.tolerant.get();
    }

    public IrrelevanceTolerantEntityStorage(EntityStorage storage) {
        this.storage = storage;
    }

    private <P extends BaseEntityStorageParameters<P>> P applyTolerant(P parameters) {
        if (!parameters.getContext().containsKey(IRRELEVANCE_TOLERANT_QUERY)) {
            parameters.getContext().put(IRRELEVANCE_TOLERANT_QUERY, this.tolerant.get());
        }
        return parameters;
    }

    private <P extends BaseEntityStorageParameters<P>> P forceTolerant(P parameters) {
        parameters.getContext().put(IRRELEVANCE_TOLERANT_QUERY, Boolean.TRUE);
        return parameters;
    }

    @Override
    public <E extends BaseEntity> EntityReference<E> actualize(EntityReference<E> ref) throws StorageException {
        return this.actualize(ref, new EntityStorageActualizeParameters());
    }

    @Override
    public <E extends BaseEntity> EntityReference<E> actualize(EntityReference<E> ref, EntityStorageActualizeParameters parameters) throws StorageException {
        return this.storage.actualize(ref, this.forceTolerant(parameters));
    }

    @Override
    public <E extends BaseEntity, T extends BaseEntity> EntityReference<E> actualize(NestedEntityReference<E, T> ref, EntityStorageActualizeParameters parameters) throws StorageException {
        return this.storage.actualize(ref, this.forceTolerant(parameters));
    }

    @Override
    public <E extends BaseEntity, T extends BaseEntity> EntityReference<E> actualize(NestedEntityReference<E, T> ref) throws StorageException {
        return this.actualize(ref, new EntityStorageActualizeParameters());
    }

    @Override
    public <E extends BaseEntity> void delete(EntityContainer<E> etc) throws StorageException {
        this.storage.delete(etc);
    }

    @Override
    public <E extends BaseEntity> void delete(EntityContainer<E> etc, EntityStorageDeleteParameters parameters) throws StorageException {
        this.storage.delete(etc, parameters);
    }

    @Override
    public <E extends BaseEntity> void delete(EntityReference<E> ref) throws StorageException {
        this.storage.delete(ref);
    }

    @Override
    public <E extends BaseEntity> void delete(EntityReference<E> ref, EntityStorageDeleteParameters parameters) throws StorageException {
        this.storage.delete(ref, parameters);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> EntityContainer<E> find(Class<I> cls, String propertyName, Object propertyValue) throws StorageException {
        return this.find(cls, propertyName, propertyValue, new EntityStorageSearchParameters());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> EntityContainer<E> find(Class<I> cls, String propertyName, Object propertyValue, EntityStorageSearchParameters parameters) throws StorageException {
        return this.storage.find(cls, propertyName, propertyValue, this.applyTolerant(parameters));
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> EntityReference<E> findReference(Class<I> cls, String propertyName, Object propertyValue) throws StorageException {
        return this.findReference(cls, propertyName, propertyValue, new EntityStorageSearchParameters());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> EntityReference<E> findReference(Class<I> cls, String propertyName, Object propertyValue, EntityStorageSearchParameters parameters) throws StorageException {
        return this.storage.findReference(cls, propertyName, propertyValue, this.applyTolerant(parameters));
    }

    @Override
    public <E extends BaseEntity> boolean isAvailable(Class<E> cls, String uid) throws StorageException {
        return this.isAvailable(cls, uid, new EntityStorageIsAvailableParameters());
    }

    @Override
    public <E extends BaseEntity> boolean isAvailable(Class<E> cls, String uid, EntityStorageIsAvailableParameters parameters) throws StorageException {
        return this.storage.isAvailable(cls, uid, this.applyTolerant(parameters));
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> load(Class<E> cls, String uid) throws StorageException {
        return this.load(cls, uid, new EntityStorageLoadParameters());
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> load(Class<E> cls, String uid, EntityStorageLoadParameters parameters) throws StorageException {
        return this.storage.load(cls, uid, this.applyTolerant(parameters));
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> load(Class<E> cls, String uid, Integer versionNumber) throws StorageException {
        return this.storage.load(cls, uid, versionNumber);
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> resolve(EntityReference<E> ref) throws StorageException {
        return this.resolve(ref, new EntityStorageLoadParameters());
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> resolve(EntityReference<E> ref, EntityStorageLoadParameters parameters) throws StorageException {
        return this.storage.resolve(ref, this.applyTolerant(parameters));
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> rollback(EntityContainer<E> etc, int versionNumber) throws StorageException {
        return this.storage.rollback(etc, versionNumber);
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> rollback(EntityContainer<E> etc, int versionNumber, EntityStorageRollbackParameters parameters) throws StorageException {
        return this.storage.rollback(etc, versionNumber, parameters);
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> save(EntityContainer<E> etc, boolean withCheckPoint) throws StorageException {
        return this.storage.save(etc, withCheckPoint);
    }

    @Override
    public <E extends BaseEntity> EntityContainer<E> save(EntityContainer<E> etc, boolean withCheckPoint, EntityStorageSaveParameters parameters) throws StorageException {
        return this.storage.save(etc, withCheckPoint, parameters);
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult search(Class<I> cls, ProjectionQuery query) throws StorageException {
        return this.search(cls, query, new EntityStorageSearchParameters());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult search(Class<I> cls, ProjectionQuery query, EntityStorageSearchParameters parameters) throws StorageException {
        return this.storage.search(cls, query, this.applyTolerant(parameters));
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> search(Class<I> cls, SearchQuery query) throws StorageException {
        return this.search(cls, query, new EntityStorageSearchParameters());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> search(Class<I> cls, SearchQuery query, EntityStorageSearchParameters parameters) throws StorageException {
        return this.storage.search(cls, query, this.applyTolerant(parameters));
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> I get(Class<I> cls, SearchQuery query) throws StorageException {
        return this.get(cls, query, new EntityStorageSearchParameters());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> I get(Class<I> cls, SearchQuery query, EntityStorageSearchParameters parameters) throws StorageException {
        return this.storage.get(cls, query, this.applyTolerant(parameters));
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> I getMandatory(Class<I> cls, SearchQuery query) throws StorageException {
        return this.getMandatory(cls, query, new EntityStorageSearchParameters());
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> I getMandatory(Class<I> cls, SearchQuery query, EntityStorageSearchParameters parameters) throws StorageException {
        return this.storage.getMandatory(cls, query, this.applyTolerant(parameters));
    }

    public EntityStorage getDelegateStorage() {
        return this.storage;
    }
}

