/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.entity.misc;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;

public class StorageUtil {
    public static <T extends BaseEntity> T getEntity(EntityReference<T> ref) {
        EntityContainer<T> ctr = ref != null ? EntityStorage.get().resolve(ref) : null;
        return ctr == null ? null : (T)ctr.getEntity();
    }

    public static <T extends BaseEntity> EntityContainer<T> save(EntityContainer<T> ctr, String dataSource, boolean withCheckPoint) {
        ctr.getVersionInfo().setDataSource(dataSource);
        return EntityStorage.get().save(ctr, withCheckPoint);
    }

    public static <T extends BaseEntity> EntityContainer<T> restore(EntityReference<T> ref, int version) throws Exception {
        EntityContainer<T> ctr = EntityStorage.get().load(ref.getType(), ref.getUid(), version);
        if (ctr == null) {
            throw new RuntimeException(String.format("failed loading version %s of entity %s", version + 1, ref));
        }
        EntityContainer<T> newCtr = new EntityContainer<T>(ctr.getEntityType());
        XCloneModelHelper.copy(ctr, newCtr);
        newCtr.setUid(ctr.getUid());
        newCtr.getVersionInfo().setCreated(null);
        newCtr.getVersionInfo().setCreatedBy(null);
        newCtr.getVersionInfo().setModified(null);
        newCtr.getVersionInfo().setCreatedBy(null);
        newCtr.getVersionInfo().setUid(null);
        newCtr.getVersionInfo().setVersionNotes("restored from version " + (ctr.getVersionInfo().getVersionNumber() + 1));
        newCtr.getVersionInfo().setDataSource("forced-completing");
        newCtr = EntityStorage.get().save(newCtr, true);
        return newCtr;
    }

    public static <E extends BaseEntity> Object captionOf(EntityReference<E> entRef) {
        return entRef == null ? null : entRef.getCaption();
    }
}

