/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.profiling;

import com.gridnine.xtrip.common.model.profiling.ProfiledEntryRecord;
import com.gridnine.xtrip.common.model.profiling.ProfiledEntryRecordType;
import com.gridnine.xtrip.common.model.profiling.ProfiledOperation;
import com.gridnine.xtrip.common.model.profiling.ProfilingConfiguration;
import com.gridnine.xtrip.common.model.profiling.ProfilingUtils;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ProfiledEntry
implements Serializable,
XSerializable {
    private static final long serialVersionUID = -5538049352028711381L;
    private volatile String id;
    private LinkedList<ProfiledOperation> slowestOperations = new LinkedList();
    private LinkedList<ProfiledOperation> fastestOperations = new LinkedList();
    private transient ProfiledOperation fastestSlowestOperation;
    private transient ProfiledOperation slowestFastestOperation;
    private final Map<ProfiledEntryRecordType, LinkedList<ProfiledEntryRecord>> allRecords = new HashMap<ProfiledEntryRecordType, LinkedList<ProfiledEntryRecord>>();
    private final transient Map<ProfiledEntryRecordType, ProfiledEntryRecord> currentRecords = new HashMap<ProfiledEntryRecordType, ProfiledEntryRecord>();

    public ProfiledEntry() {
        for (ProfiledEntryRecordType item : ProfiledEntryRecordType.values()) {
            this.allRecords.put(item, new LinkedList());
        }
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        ProfiledOperation item;
        this.id = XHelper.readString(elm, "id");
        this.slowestOperations.clear();
        for (Element itemElm : XmlUtil.getElements(elm, "slowestOperations/item")) {
            item = (ProfiledOperation)XHelper.readObject(itemElm, ".");
            if (item == null) continue;
            this.slowestOperations.add(item);
        }
        this.fastestOperations.clear();
        for (Element itemElm : XmlUtil.getElements(elm, "fastestOperations/item")) {
            item = (ProfiledOperation)XHelper.readObject(itemElm, ".");
            if (item == null) continue;
            this.fastestOperations.add(item);
        }
        Collections.sort(this.slowestOperations, ProfilingUtils.slowestOperationComparator);
        if (!this.slowestOperations.isEmpty()) {
            this.fastestSlowestOperation = this.slowestOperations.getLast();
        }
        Collections.sort(this.fastestOperations, ProfilingUtils.fastestOperationComparator);
        if (!this.fastestOperations.isEmpty()) {
            this.slowestFastestOperation = this.fastestOperations.getLast();
        }
        this.allRecords.clear();
        for (Element itemElm : XmlUtil.getElements(elm, "records/entry")) {
            ProfiledEntryRecordType type = ProfiledEntryRecordType.valueOf(itemElm.getAttribute("recordType"));
            LinkedList<ProfiledEntryRecord> list = new LinkedList<ProfiledEntryRecord>();
            for (Element listElm : XmlUtil.getElements(itemElm, "item")) {
                list.add((ProfiledEntryRecord)XHelper.readObject(listElm, "."));
            }
            this.allRecords.put(type, list);
        }
        for (Map.Entry entry : this.allRecords.entrySet()) {
            ProfiledEntryRecordType recordType = (ProfiledEntryRecordType)((Object)entry.getKey());
            LinkedList value = (LinkedList)entry.getValue();
            if (value.isEmpty()) continue;
            this.currentRecords.put(recordType, (ProfiledEntryRecord)value.getLast());
        }
    }

    @Override
    public void toXML(Element elm) throws Exception {
        XHelper.writeString(elm, "id", this.id);
        for (ProfiledOperation profiledOperation : this.slowestOperations) {
            XHelper.writeObject(elm, "slowestOperations/item", profiledOperation);
        }
        for (ProfiledOperation profiledOperation : this.fastestOperations) {
            XHelper.writeObject(elm, "fastestOperations/item", profiledOperation);
        }
        for (Map.Entry entry : this.allRecords.entrySet()) {
            Element itemElm = XmlUtil.addElement(elm, "records/entry");
            itemElm.setAttribute("recordType", ((ProfiledEntryRecordType)((Object)entry.getKey())).name());
            for (ProfiledEntryRecord item : (LinkedList)entry.getValue()) {
                XHelper.writeObject(itemElm, "item", item);
            }
        }
    }

    private void addRecord(long timing, ProfiledEntryRecordType type, long currentTime, long profilingStartTime) {
        long operationStartDate = ProfilingUtils.getRecordStartDate(currentTime, type);
        long delta = ProfilingUtils.getDelta(type);
        long operationEndDate = operationStartDate + delta;
        ProfiledEntryRecord currentRecord = this.currentRecords.get((Object)type);
        if (currentRecord == null) {
            this.addZeroValuesAndUpdateCurrentRecord(ProfilingUtils.getRecordStartDate(profilingStartTime, type), operationEndDate, currentTime, delta, timing, profilingStartTime, type);
            return;
        }
        long currentRecordStartDate = currentRecord.getStartDate();
        if (currentRecordStartDate == operationStartDate) {
            if (currentRecord.getLastUpdateTime() < profilingStartTime) {
                currentRecord.setLastUpdateTime(profilingStartTime);
            }
            this.updateRecord(currentRecord, timing, currentTime);
            return;
        }
        currentRecord.setTotalRegistrationTime(currentRecord.getTotalRegistrationTime() + currentRecordStartDate + delta - currentRecord.getLastUpdateTime());
        this.addZeroValuesAndUpdateCurrentRecord(currentRecordStartDate + delta, operationEndDate, currentTime, delta, timing, profilingStartTime, type);
    }

    private void addZeroValuesAndUpdateCurrentRecord(long firstDate, long lastDate, long currentTime, long delta, long timing, long profilingStartTime, ProfiledEntryRecordType type) {
        for (long time = firstDate; time < lastDate - delta; time += delta) {
            ProfiledEntryRecord record = new ProfiledEntryRecord();
            record.setLastUpdateTime(time + delta);
            record.setStartDate(time);
            record.setTotalRegistrationTime(delta);
            this.allRecords.get((Object)type).add(record);
        }
        ProfiledEntryRecord lastRecord = new ProfiledEntryRecord();
        lastRecord.setStartDate(lastDate - delta);
        lastRecord.setLastUpdateTime(profilingStartTime > lastRecord.getStartDate() ? profilingStartTime : lastRecord.getStartDate());
        this.updateRecord(lastRecord, timing, currentTime);
        this.allRecords.get((Object)type).add(lastRecord);
        this.currentRecords.put(type, lastRecord);
        long cleanupTime = lastDate - ProfilingConfiguration.get().getHistoryLength().get((Object)type).longValue() * delta;
        Iterator it = this.allRecords.get((Object)type).iterator();
        while (it.hasNext()) {
            if (((ProfiledEntryRecord)it.next()).getStartDate() >= cleanupTime) continue;
            it.remove();
        }
    }

    private void cleanupFastestOperations() {
        Collections.sort(this.fastestOperations, ProfilingUtils.fastestOperationComparator);
        if (this.fastestOperations.size() > ProfilingConfiguration.get().getMaxExtremeRecordsCount()) {
            this.fastestOperations = new LinkedList(this.fastestOperations.subList(0, ProfilingConfiguration.get().getMaxExtremeRecordsCount()));
        }
        if (!this.fastestOperations.isEmpty()) {
            this.slowestFastestOperation = this.fastestOperations.getLast();
        }
    }

    private void cleanupSlowestOperations() {
        Collections.sort(this.slowestOperations, ProfilingUtils.slowestOperationComparator);
        if (this.slowestOperations.size() > ProfilingConfiguration.get().getMaxExtremeRecordsCount()) {
            this.slowestOperations = new LinkedList(this.slowestOperations.subList(0, ProfilingConfiguration.get().getMaxExtremeRecordsCount()));
        }
        if (!this.slowestOperations.isEmpty()) {
            this.fastestSlowestOperation = this.slowestOperations.getLast();
        }
    }

    private ProfiledOperation createOperation(long timing, long currentTime, String details) {
        ProfiledOperation result = new ProfiledOperation();
        result.setTiming(timing);
        result.setDetails(details);
        result.setDate(currentTime);
        return result;
    }

    private long getTotalValue(ValueProvider provider, Date startDate, Date endDate) {
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        long delta = endTime - startTime;
        ProfiledEntryRecordType usedType = ProfiledEntryRecordType.MINUTE;
        if (delta >= 86400000L) {
            usedType = ProfiledEntryRecordType.DAY;
        } else if (delta >= 3600000L) {
            usedType = ProfiledEntryRecordType.HOUR;
        }
        List lst = this.allRecords.get((Object)usedType);
        if (lst == null || lst.isEmpty()) {
            return 0L;
        }
        long result = 0L;
        for (ProfiledEntryRecord item : lst) {
            if (item.getStartDate() < startTime || item.getStartDate() >= endTime) continue;
            result += provider.getValue(item);
        }
        return result;
    }

    private void updateFastestOperations(long timing, long currentTime, String details) {
        if (ProfilingConfiguration.get().getMaxExtremeRecordsCount() == 0) {
            return;
        }
        if (this.fastestOperations.size() >= ProfilingConfiguration.get().getMaxExtremeRecordsCount() && this.slowestFastestOperation.getTiming() < timing) {
            return;
        }
        this.fastestOperations.add(this.createOperation(timing, currentTime, details));
        this.cleanupFastestOperations();
    }

    private void updateRecord(ProfiledEntryRecord record, long timing, long currentTime) {
        record.setTotalRegistrationTime(record.getTotalRegistrationTime() + currentTime - record.getLastUpdateTime());
        if (timing >= 0L) {
            record.setTotalRequestCount(record.getTotalRequestCount() + 1L);
            record.setTotalTiming(record.getTotalTiming() + timing);
            record.setTotalSquaredTiming(record.getTotalSquaredTiming() + timing * timing);
        }
        record.setLastUpdateTime(currentTime);
    }

    private void updateSlowestOperations(long timing, long currentTime, String details) {
        if (ProfilingConfiguration.get().getMaxExtremeRecordsCount() == 0) {
            return;
        }
        if (this.slowestOperations.size() >= ProfilingConfiguration.get().getMaxExtremeRecordsCount() && this.fastestSlowestOperation.getTiming() > timing) {
            return;
        }
        this.slowestOperations.add(this.createOperation(timing, currentTime, details));
        this.cleanupSlowestOperations();
    }

    Map<ProfiledEntryRecordType, LinkedList<ProfiledEntryRecord>> getAllRecords() {
        return this.allRecords;
    }

    List<ProfiledOperation> getFastestOperations() {
        return this.fastestOperations;
    }

    String getId() {
        return this.id;
    }

    List<ProfiledOperation> getSlowestOperations() {
        return this.slowestOperations;
    }

    long getTotalRegistrationTime(Date startDate, Date endDate) {
        return this.getTotalValue(new ValueProvider(){

            @Override
            public long getValue(ProfiledEntryRecord item) {
                return item.getTotalRegistrationTime();
            }
        }, startDate, endDate);
    }

    double getTotalRequestCount(Date startDate, Date endDate) {
        return this.getTotalValue(new ValueProvider(){

            @Override
            public long getValue(ProfiledEntryRecord item) {
                return item.getTotalRequestCount();
            }
        }, startDate, endDate);
    }

    double getTotalSquaredTiming(Date startDate, Date endDate) {
        return this.getTotalValue(new ValueProvider(){

            @Override
            public long getValue(ProfiledEntryRecord item) {
                return item.getTotalSquaredTiming();
            }
        }, startDate, endDate);
    }

    long getTotalTiming(Date startDate, Date endDate) {
        return this.getTotalValue(new ValueProvider(){

            @Override
            public long getValue(ProfiledEntryRecord item) {
                return item.getTotalTiming();
            }
        }, startDate, endDate);
    }

    void prepareDataForRetrieval(long currentTime, long profilingStartTime) {
        for (ProfiledEntryRecordType type : ProfiledEntryRecordType.values()) {
            this.addRecord(-1L, type, currentTime, profilingStartTime);
        }
    }

    void setId(String value) {
        this.id = value;
    }

    void update(long timing, long currentTime, long profilingStartTime, String details) {
        this.updateSlowestOperations(timing, currentTime, details);
        this.updateFastestOperations(timing, currentTime, details);
        for (ProfiledEntryRecordType type : ProfiledEntryRecordType.values()) {
            this.addRecord(timing, type, currentTime, profilingStartTime);
        }
    }

    static interface ValueProvider {
        public long getValue(ProfiledEntryRecord var1);
    }
}

