/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.profiling;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.model.profiling.ApplicationProfilingData;
import com.gridnine.xtrip.common.model.profiling.EntryProfilingStatistics;
import com.gridnine.xtrip.common.model.profiling.ProfiledEntryRecordType;
import com.gridnine.xtrip.common.model.profiling.ProfilerState;
import com.gridnine.xtrip.common.model.profiling.ProfilingConfiguration;
import com.gridnine.xtrip.common.model.profiling.ProfilingData;
import com.gridnine.xtrip.common.model.profiling.ProfilingStaticsticsDistributionItem;
import com.gridnine.xtrip.common.model.profiling.ProfilingStatistics;
import com.gridnine.xtrip.common.model.profiling.ProfilingUtils;
import com.gridnine.xtrip.common.model.profiling.RunningProcessDescription;
import com.gridnine.xtrip.common.model.profiling.RunningProcessesData;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MultiString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Profiler
implements Disposable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    ProfilingData profilingData;
    ProfilingStatistics profilingStatistics;
    RunningProcessesData tasksData;
    private volatile boolean started = false;
    private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();
    private WorkerThread thread;
    private TimeService timeService;

    public static Profiler get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(Profiler.class);
    }

    @Deprecated
    public Profiler() {
    }

    public Profiler(ProfilerState initData, Properties configuration) {
        this.timeService = new TimeService(){

            @Override
            public Date currentDate() {
                return new Date();
            }

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        ProfilingConfiguration.initialize(configuration);
        this.profilingData = initData.getProfilingData();
        this.tasksData = initData.getRunningProcessesData();
        this.profilingStatistics = new ProfilingStatistics(this.profilingData);
        this.thread = new WorkerThread(this.queue);
    }

    public void setTimeService(TimeService timeServiceValue) {
        this.timeService = timeServiceValue;
        this.profilingData.setTimeService(this.timeService);
    }

    @Override
    public void dispose() {
        if (this.isProfilingEnabled()) {
            this.stop();
            try {
                ApplicationProfilingData performanceData = ProfilingUtils.getSelfPerformanceData(Environment.getApplicationId());
                ProfilingUtils.saveApplicationProfilingData(performanceData);
            }
            catch (Throwable e) {
                this.log.error("unable to save profiling data", e);
            }
        }
    }

    public void stop() {
        this.thread.setBeingInterrupted(true);
        this.profilingData.dispose();
        while (this.thread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("error", (Throwable)e);
            }
        }
    }

    public Collection<RunningProcessDescription> getAllTasks() {
        if (!ProfilingConfiguration.get().isProfilingEnabled()) {
            return Collections.emptyList();
        }
        return this.tasksData.getAllTasks();
    }

    public List<ProfilingStaticsticsDistributionItem> getDistribution(String key, ProfiledEntryRecordType type) {
        return this.profilingStatistics.getDistribution(key, type);
    }

    public ProfilingStaticsticsDistributionItem getItem(long date, String key, ProfiledEntryRecordType type) {
        return this.profilingStatistics.getItem(date, key, type);
    }

    public Collection<String> getRelatedKeys(String key) {
        return this.profilingStatistics.getRelatedKeys(key);
    }

    public Collection<String> getRelatedSubKeys(String key) {
        return this.profilingStatistics.getRelatedSubKeys(key);
    }

    public ProfilerState getState() {
        ProfilerState state = new ProfilerState();
        state.setProfilingData(this.profilingData);
        state.setRunningProcessesData(this.tasksData);
        return state;
    }

    public EntryProfilingStatistics getStatistics(String key, DateInterval dateInterval) {
        return this.profilingStatistics.getStatistics(key, dateInterval);
    }

    public boolean isProfilingEnabled() {
        return this.started && ProfilingConfiguration.get().isProfilingEnabled();
    }

    public boolean isProfilingEnabled(String key) {
        return this.started && ProfilingConfiguration.get().isProfilingEnabled(key);
    }

    public boolean isProfilingEnabled(MultiString key) {
        return this.started && ProfilingConfiguration.get().isProfilingEnabled() && ProfilingConfiguration.get().isProfilingEnabled(key.join());
    }

    public void prepareDataForRetrieval() {
        this.profilingData.prepareDataForRetrieval();
    }

    public void processCompleted(final String processUid) {
        if (!ProfilingConfiguration.get().isProfilingEnabled()) {
            return;
        }
        this.queue.add(new Runnable(){

            @Override
            public void run() {
                Profiler.this.tasksData.removeTask(processUid);
            }
        });
    }

    public void processStarted(final RunningProcessDescription process) {
        if (!ProfilingConfiguration.get().isProfilingEnabled()) {
            return;
        }
        this.queue.add(new Runnable(){

            @Override
            public void run() {
                Profiler.this.tasksData.addTask(process);
            }
        });
    }

    public void reset() {
        this.stop();
        this.profilingData = new ProfilingData();
        this.profilingData.setTimeService(this.timeService);
        this.profilingStatistics = new ProfilingStatistics(this.profilingData);
        this.thread = new WorkerThread(this.queue);
        this.start();
    }

    public void start() {
        this.started = true;
        ArrayList<RunningProcessDescription> list = new ArrayList<RunningProcessDescription>();
        for (RunningProcessDescription item : this.tasksData.getAllTasks()) {
            if (item.getServerId() != null && item.getServerId().equals(Environment.getApplicationId())) continue;
            list.add(item);
        }
        for (RunningProcessDescription item : list) {
            this.tasksData.removeTask(item.getUid());
        }
        if (!ProfilingConfiguration.get().isProfilingEnabled()) {
            return;
        }
        this.thread = new WorkerThread(this.queue);
        this.thread.start();
        this.profilingData.start();
    }

    public void updateConfiguration(Properties props) {
        ProfilingConfiguration.initialize(props);
        this.stop();
        this.profilingData.setTimeService(this.timeService);
        this.thread = new WorkerThread(this.queue);
        this.start();
    }

    public void updateTaskProgress(final String taskUid, final byte progress) {
        if (!ProfilingConfiguration.get().isProfilingEnabled()) {
            return;
        }
        this.queue.add(new Runnable(){

            @Override
            public void run() {
                Profiler.this.tasksData.updateTaskProgress(taskUid, progress);
            }
        });
    }

    public void updateTiming(final String key, long startTime, final String details) {
        if (!this.started) {
            return;
        }
        if (!ProfilingConfiguration.get().isProfilingEnabled(key)) {
            return;
        }
        final long currentTime = this.timeService.currentTimeMillis();
        final long timing = currentTime - startTime;
        this.queue.add(new Runnable(){

            @Override
            public void run() {
                Profiler.this.profilingData.updateTiming(key, timing, currentTime, details);
            }
        });
    }

    public void resetData(String key) {
        this.profilingData.resetData(key);
    }

    static final class WorkerThread
    extends Thread {
        private volatile boolean beingInterrupted;
        private final ConcurrentLinkedQueue<Runnable> queue;

        WorkerThread(ConcurrentLinkedQueue<Runnable> queueValue) {
            super("profiling data worker");
            this.queue = queueValue;
        }

        @Override
        public void run() {
            while (!this.beingInterrupted) {
                this.processQueue();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LoggerFactory.getLogger(Profiler.class).error("unable to process queue", (Throwable)e);
                }
            }
            this.processQueue();
            this.interrupt();
        }

        private void processQueue() {
            try {
                Runnable task;
                while ((task = this.queue.poll()) != null) {
                    task.run();
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(Profiler.class).error("unable to process queue", (Throwable)e);
            }
        }

        void setBeingInterrupted(boolean beingInterruptedValue) {
            this.beingInterrupted = beingInterruptedValue;
        }
    }

    private static class Holder {
        public static final Profiler INSTANCE = Environment.getPublished(Profiler.class);

        private Holder() {
        }
    }
}

