/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.profiling;

import com.gridnine.xtrip.common.model.profiling.ProfiledEntryRecordType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProfilingConfiguration {
    private static volatile ProfilingConfiguration instance;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Boolean> enabledKeys = new HashMap<String, Boolean>();
    private int maxExtremeRecordsCount = 0;
    private final Map<ProfiledEntryRecordType, Integer> historyLength = new HashMap<ProfiledEntryRecordType, Integer>();
    private boolean hasEnabledKeys = false;

    static ProfilingConfiguration get() {
        if (instance == null) {
            throw new IllegalStateException("configuration is not initialized");
        }
        return instance;
    }

    static ProfilingConfiguration initialize(Properties props) {
        ProfilingConfiguration config;
        instance = config = new ProfilingConfiguration(props);
        return instance;
    }

    private ProfilingConfiguration(Properties props) {
        if (props != null) {
            if (props.containsKey("enabled")) {
                if ("true".equals(props.getProperty("enabled"))) {
                    this.enabledKeys.put(null, Boolean.TRUE);
                    this.hasEnabledKeys = true;
                }
            } else {
                for (Object item : props.keySet()) {
                    String key;
                    if (!(item instanceof String) || !(key = (String)item).endsWith(".enabled")) continue;
                    boolean enabled = "true".equalsIgnoreCase(props.getProperty(key));
                    this.hasEnabledKeys = this.hasEnabledKeys || enabled;
                    this.enabledKeys.put(key.substring(0, key.length() - 8), enabled);
                }
            }
        }
        this.maxExtremeRecordsCount = this.readInt(props, "maxExtremeRecordsCount", this.maxExtremeRecordsCount);
        this.historyLength.put(ProfiledEntryRecordType.MINUTE, this.readInt(props, "historyLength.MINUTE", 60));
        this.historyLength.put(ProfiledEntryRecordType.HOUR, this.readInt(props, "historyLength.HOUR", 24));
        this.historyLength.put(ProfiledEntryRecordType.DAY, this.readInt(props, "historyLength.DAY", 30));
    }

    private int readInt(Properties props, String key, int def) {
        if (props == null) {
            return def;
        }
        String str = props.getProperty(key);
        if (!TextUtil.isBlank(str)) {
            try {
                return Integer.parseInt(str.trim());
            }
            catch (Throwable e) {
                this.log.error("unable to read config param " + key, e);
                return def;
            }
        }
        return def;
    }

    int getMaxExtremeRecordsCount() {
        return this.maxExtremeRecordsCount;
    }

    boolean isProfilingEnabled(String key) {
        Boolean val;
        if (TextUtil.isBlank(key)) {
            return false;
        }
        if (this.enabledKeys.isEmpty()) {
            return false;
        }
        if (this.enabledKeys.containsKey(null)) {
            return this.enabledKeys.get(null);
        }
        String currentKey = key;
        while ((val = this.enabledKeys.get(currentKey)) == null) {
            int index = currentKey.lastIndexOf(".");
            if (index == -1) {
                return false;
            }
            currentKey = currentKey.substring(0, index);
        }
        return val;
    }

    Map<ProfiledEntryRecordType, Integer> getHistoryLength() {
        return this.historyLength;
    }

    boolean isProfilingEnabled() {
        return this.hasEnabledKeys;
    }
}

