/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.profiling;

import com.gridnine.xtrip.common.model.profiling.EntryProfilingStatistics;
import com.gridnine.xtrip.common.model.profiling.OperationProfilingStatistics;
import com.gridnine.xtrip.common.model.profiling.ProfiledEntry;
import com.gridnine.xtrip.common.model.profiling.ProfiledEntryRecord;
import com.gridnine.xtrip.common.model.profiling.ProfiledEntryRecordType;
import com.gridnine.xtrip.common.model.profiling.ProfiledOperation;
import com.gridnine.xtrip.common.model.profiling.ProfilingData;
import com.gridnine.xtrip.common.model.profiling.ProfilingStaticsticsDistributionItem;
import com.gridnine.xtrip.common.model.profiling.ProfilingUtils;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ProfilingStatistics {
    private final ProfilingData profilingData;

    public Collection<String> getRelatedKeys(String key) {
        HashSet<String> result = new HashSet<String>();
        Collection<String> keys = this.profilingData.getAllEntriesKeys();
        if (TextUtil.isBlank(key)) {
            result.addAll(keys);
            return result;
        }
        for (String entryKey : keys) {
            if (!entryKey.startsWith(key + ".")) continue;
            result.add(entryKey);
        }
        return result;
    }

    public Collection<String> getRelatedSubKeys(String key) {
        HashSet<String> result = new HashSet<String>();
        for (String entryKey : this.profilingData.getAllEntriesKeys()) {
            String subKey = null;
            if (TextUtil.isBlank(key)) {
                subKey = entryKey;
            } else {
                if (!entryKey.startsWith(key + ".")) continue;
                subKey = entryKey.substring(key.length() + 1);
            }
            int index = subKey.indexOf(".");
            result.add(index != -1 ? subKey.substring(0, index) : subKey);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryProfilingStatistics getStatistics(String key, DateInterval interval) {
        Collection<ProfiledEntry> allEntries = this.getAllEntries(key);
        long totalTiming = 0L;
        long totalSquaredTiming = 0L;
        long totalRequestCount = 0L;
        long totalObservationTime = 0L;
        ArrayList<ProfiledOperation> slowestOperations = new ArrayList<ProfiledOperation>();
        ArrayList<ProfiledOperation> fastestOperations = new ArrayList<ProfiledOperation>();
        HashMap<ProfiledOperation, String> operationsMap = new HashMap<ProfiledOperation, String>();
        Iterator<ProfiledEntry> iterator = allEntries.iterator();
        while (iterator.hasNext()) {
            ProfiledEntry item;
            ProfiledEntry profiledEntry = item = iterator.next();
            synchronized (profiledEntry) {
                long totalRegistrationTime = item.getTotalRegistrationTime(interval.getBeginDate(), interval.getEndDate());
                if (totalRegistrationTime == 0L) {
                    continue;
                }
                double coeff = totalObservationTime == 0L ? 1.0 : (double)(totalObservationTime / totalRegistrationTime);
                totalTiming += (long)(coeff * (double)item.getTotalTiming(interval.getBeginDate(), interval.getEndDate()));
                totalSquaredTiming += (long)(coeff * item.getTotalSquaredTiming(interval.getBeginDate(), interval.getEndDate()));
                totalRequestCount += (long)(coeff * item.getTotalRequestCount(interval.getBeginDate(), interval.getEndDate()));
                if (totalObservationTime == 0L) {
                    totalObservationTime = totalRegistrationTime;
                }
                for (ProfiledOperation op : item.getSlowestOperations()) {
                    slowestOperations.add(op);
                    operationsMap.put(op, item.getId());
                }
                for (ProfiledOperation op : item.getFastestOperations()) {
                    fastestOperations.add(op);
                    operationsMap.put(op, item.getId());
                }
            }
        }
        EntryProfilingStatistics result = new EntryProfilingStatistics();
        Collections.sort(slowestOperations, ProfilingUtils.slowestOperationComparator);
        Collections.sort(fastestOperations, ProfilingUtils.fastestOperationComparator);
        result.getSlowestOperations().addAll(this.getOperations(slowestOperations, operationsMap));
        result.getFastestOperations().addAll(this.getOperations(fastestOperations, operationsMap));
        if (totalRequestCount > 0L) {
            result.setAverageTiming((double)totalTiming / (double)totalRequestCount);
            result.setTimingDeviation(Math.sqrt(totalSquaredTiming * totalRequestCount - totalTiming * totalTiming) / (double)totalRequestCount);
            result.setRate((double)(totalRequestCount * 60L) * 1000.0 / (double)totalObservationTime);
            result.setTimingPerMinute(result.getRate() * result.getAverageTiming());
        }
        result.setEntryId(key);
        return result;
    }

    private List<OperationProfilingStatistics> getOperations(List<ProfiledOperation> slowestOperations, Map<ProfiledOperation, String> operationsMap) {
        ArrayList<OperationProfilingStatistics> result = new ArrayList<OperationProfilingStatistics>();
        for (ProfiledOperation item : slowestOperations) {
            result.add(new OperationProfilingStatistics(item, operationsMap.get(item)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProfilingStaticsticsDistributionItem> getDistribution(String key, ProfiledEntryRecordType type) {
        Collection<ProfiledEntry> allEntries = this.getAllEntries(key);
        if (allEntries.isEmpty()) {
            return Collections.emptyList();
        }
        DateInterval interval = this.getRelevantDateInterval(allEntries, type);
        if (interval == null) {
            return Collections.emptyList();
        }
        long startDate = interval.getBeginDate().getTime();
        long endDate = interval.getEndDate().getTime();
        ArrayList<ProfilingStaticsticsDistributionItem> result = new ArrayList<ProfilingStaticsticsDistributionItem>();
        long delta = ProfilingUtils.getDelta(type);
        for (long date = startDate; date <= endDate; date += delta) {
            long dateMin = date == startDate ? date : date - delta / 2L + 1L;
            long dateMax = date == endDate ? date : date + delta / 2L - 1L;
            long totalTiming = 0L;
            long totalSquaredTiming = 0L;
            long totalRequestCount = 0L;
            long totalRegistrationTime = 0L;
            Iterator<ProfiledEntry> iterator = allEntries.iterator();
            while (iterator.hasNext()) {
                ProfiledEntry item;
                ProfiledEntry profiledEntry = item = iterator.next();
                synchronized (profiledEntry) {
                    if (!item.getAllRecords().containsKey((Object)type)) {
                        continue;
                    }
                    for (ProfiledEntryRecord record : item.getAllRecords().get((Object)type)) {
                        double coeff;
                        if (record.getStartDate() < dateMin || record.getStartDate() > dateMax) continue;
                        double d = coeff = totalRegistrationTime == 0L ? 1.0 : (double)totalRegistrationTime / (double)record.getTotalRegistrationTime();
                        if (totalRegistrationTime == 0L) {
                            totalRegistrationTime = record.getTotalRegistrationTime();
                        }
                        totalTiming += (long)(coeff * (double)record.getTotalTiming());
                        totalSquaredTiming += (long)(coeff * (double)record.getTotalSquaredTiming());
                        totalRequestCount += (long)(coeff * (double)record.getTotalRequestCount());
                    }
                }
            }
            ProfilingStaticsticsDistributionItem item = new ProfilingStaticsticsDistributionItem();
            item.setStartDate(new Date(date));
            item.setEndDate(new Date(date + delta));
            if (totalRequestCount > 0L) {
                item.setAverageTiming((double)totalTiming / (double)totalRequestCount);
                item.setTimingDeviation(Math.sqrt(totalSquaredTiming * totalRequestCount - totalTiming * totalTiming) / (double)totalRequestCount);
                item.setRate((double)totalRequestCount * 1000.0 * 60.0 / (double)totalRegistrationTime);
            }
            result.add(item);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateInterval getRelevantDateInterval(Collection<ProfiledEntry> allEntries, ProfiledEntryRecordType type) {
        long startDate = 0L;
        long endDate = 0L;
        Iterator<ProfiledEntry> iterator = allEntries.iterator();
        while (iterator.hasNext()) {
            ProfiledEntry item;
            ProfiledEntry profiledEntry = item = iterator.next();
            synchronized (profiledEntry) {
                if (!item.getAllRecords().containsKey((Object)type)) {
                    continue;
                }
                LinkedList<ProfiledEntryRecord> list = item.getAllRecords().get((Object)type);
                if (list.isEmpty()) {
                    continue;
                }
                if (startDate == 0L || startDate > list.getFirst().getStartDate()) {
                    startDate = list.getFirst().getStartDate();
                }
                if (endDate == 0L || endDate < list.getLast().getStartDate()) {
                    endDate = list.getLast().getStartDate();
                }
            }
        }
        return startDate == 0L || endDate == 0L ? null : new DateInterval(new Date(startDate), new Date(endDate));
    }

    private Collection<ProfiledEntry> getAllEntries(String key) {
        HashSet<ProfiledEntry> allEntries = new HashSet<ProfiledEntry>();
        ProfiledEntry entry = this.profilingData.findEntry(key);
        if (entry != null) {
            allEntries.add(entry);
        }
        if (entry == null) {
            allEntries.addAll(this.getSubentries(key));
        }
        return allEntries;
    }

    private Collection<ProfiledEntry> getSubentries(String key) {
        HashSet<ProfiledEntry> result = new HashSet<ProfiledEntry>();
        for (String entryId : this.getRelatedSubKeys(key)) {
            String fullKey = TextUtil.isBlank(key) ? entryId : String.format("%s.%s", key, entryId);
            ProfiledEntry entry = this.profilingData.findEntry(fullKey);
            if (entry != null) {
                result.add(entry);
                continue;
            }
            result.addAll(this.getSubentries(fullKey));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfilingStaticsticsDistributionItem getItem(long date, String key, ProfiledEntryRecordType type) {
        ProfiledEntry entry = this.profilingData.findEntry(key);
        if (entry == null) {
            return null;
        }
        if (!entry.getAllRecords().containsKey((Object)type)) {
            return null;
        }
        long delta = ProfilingUtils.getDelta(type);
        ProfiledEntry profiledEntry = entry;
        synchronized (profiledEntry) {
            for (ProfiledEntryRecord value : entry.getAllRecords().get((Object)type)) {
                if (value.getStartDate() > date || value.getStartDate() + delta <= date) continue;
                ProfilingStaticsticsDistributionItem result = new ProfilingStaticsticsDistributionItem();
                result.setStartDate(new Date(value.getStartDate()));
                result.setEndDate(new Date(value.getStartDate() + delta));
                long totalRequestCount = value.getTotalRequestCount();
                if (totalRequestCount > 0L) {
                    result.setAverageTiming((double)value.getTotalTiming() / (double)totalRequestCount);
                    result.setRate(60000.0 * (double)totalRequestCount / (double)value.getTotalRegistrationTime());
                    result.setTimingDeviation(Math.sqrt(value.getTotalSquaredTiming() * totalRequestCount - value.getTotalTiming() * value.getTotalTiming()) / (double)totalRequestCount);
                }
                return result;
            }
        }
        return null;
    }

    public Date getStatisticsLastDate() {
        DateInterval result = this.getRelevantDateInterval(this.getAllEntries(""), ProfiledEntryRecordType.MINUTE);
        return result == null ? null : new Date(result.getEndDate().getTime() + 60000L);
    }

    public ProfilingStatistics(ProfilingData data) {
        this.profilingData = data;
    }
}

