/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.tasks.standard;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.cache.common.ContentType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class DeletedObjectReference
extends BaseAsset {
    private static final long serialVersionUID = 802121169485001604L;
    private String refUid;
    private Class<?> refType;
    private String refCaption;
    private Date refDeleted = new Date();
    private ContentType contentType;

    public DeletedObjectReference() {
    }

    public DeletedObjectReference(String aUid) {
        super(aUid);
    }

    public DeletedObjectReference(BaseAsset asset) {
        this.refUid = asset.getUid();
        this.refType = asset.getClass();
        this.refCaption = asset.toString();
        this.contentType = ContentType.ASSET;
    }

    public DeletedObjectReference(EntityContainer<?> etc) {
        this.refUid = etc.getUid();
        this.refType = etc.getEntityType();
        this.refCaption = ((BaseEntity)etc.getEntity()).toString();
        this.contentType = ContentType.ENTITY;
    }

    public DeletedObjectReference(BaseDictionary dictionary) {
        this.refUid = dictionary.getUid();
        this.refType = dictionary.getClass();
        this.refCaption = dictionary.toString();
        this.contentType = ContentType.DICTIONARY;
    }

    public String getRefUid() {
        return this.refUid;
    }

    public void setRefUid(String refUid) {
        this.refUid = refUid;
    }

    public Class<?> getRefType() {
        return this.refType;
    }

    public void setRefType(Class<?> refType) {
        this.refType = refType;
    }

    public String getRefCaption() {
        return this.refCaption;
    }

    public void setRefCaption(String refCaption) {
        this.refCaption = refCaption;
    }

    public Date getRefDeleted() {
        return this.refDeleted;
    }

    public void setRefDeleted(Date refModified) {
        this.refDeleted = refModified;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeString(elm, "refuid", this.getRefUid());
        XHelper.writeString(elm, "reftype", this.getRefType().getName());
        XHelper.writeString(elm, "refcaption", this.getRefCaption(), true);
        XHelper.writeDate(elm, "refdeleted", this.getRefDeleted());
        XHelper.writeEnum(elm, "contentType", this.getContentType());
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "refuid", this.getRefUid());
        XSHelper.writeString(writer, "reftype", this.getRefType().getName());
        XSHelper.writeString(writer, "refcaption", this.getRefCaption(), true);
        XSHelper.writeDate(writer, "refdeleted", this.getRefDeleted());
        XSHelper.writeEnum(writer, "contentType", this.getContentType());
    }

    @Override
    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        DeletedObjectReference source = (DeletedObjectReference)sourceAsset;
        this.setRefUid(source.getRefUid());
        this.setRefType(source.getRefType());
        this.setRefCaption(source.getRefCaption());
        this.setRefDeleted(XCloneHelper.cloneDate(source.getRefDeleted()));
        this.setContentType(source.getContentType());
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.setRefUid(XHelper.readString(elm, "refuid"));
        this.setRefType(XHelper.getClass(XHelper.readString(elm, "reftype")));
        this.setRefCaption(XHelper.readString(elm, "refcaption"));
        this.setRefDeleted(XHelper.readDate(elm, "refdeleted"));
        this.setContentType(XHelper.readEnum(elm, "contentType", ContentType.class));
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("refuid".equals(tagName)) {
            this.setRefUid(XSHelper.readString(reader));
            return true;
        }
        if ("reftype".equals(tagName)) {
            this.setRefType(XSHelper.getClass(XSHelper.readString(reader)));
            return true;
        }
        if ("refcaption".equals(tagName)) {
            this.setRefCaption(XSHelper.readString(reader));
            return true;
        }
        if ("refdeleted".equals(tagName)) {
            this.setRefDeleted(XSHelper.readDate(reader));
            return true;
        }
        if ("contentType".equals(tagName)) {
            this.setContentType(XSHelper.readEnum(reader, ContentType.class));
            return true;
        }
        return false;
    }

    public static enum Property {
        refUid,
        refType,
        refCaption,
        refDeleted,
        contentType;

    }
}

