/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.validation;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.ValidationMessageItem;
import com.gridnine.xtrip.common.meta.ValidationMessagesType;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.rest.RestValidationMessageItem;
import com.gridnine.xtrip.common.meta.rest.RestValidationMessagesType;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ValidationMessagesFactory {
    private static final ConcurrentMap<String, ValidationMessage> CACHE = new ConcurrentHashMap<String, ValidationMessage>();

    protected static ValidationMessage getMessage(final String messagesId, final String messageId, final Object ... params) {
        ValidationMessage prev;
        final String key = messagesId + '.' + messageId;
        ValidationMessage message = (ValidationMessage)CACHE.get(key);
        if (message == null && (prev = CACHE.putIfAbsent(key, message = new ValidationMessage(){
            private static final long serialVersionUID = -903284183417143624L;

            @Override
            public String getCode() {
                return messageId;
            }

            @Override
            public String getText() {
                ValidationMessagesType vmt = MetaRegistry.get().getValidationMessages().get(messagesId);
                if (vmt == null) {
                    RestValidationMessagesType rvmt = RestMetaRegistry.get().getValidationMessages().get(messagesId);
                    RestValidationMessageItem vmi = rvmt == null ? null : rvmt.getMessages().get(messageId);
                    return vmi == null ? messageId : vmi.getDisplayName();
                }
                ValidationMessageItem vmi = vmt.getMessages().get(messageId);
                return vmi == null ? messageId : vmi.getDisplayName();
            }
        })) != null) {
            message = prev;
        }
        if (params == null || params.length == 0) {
            return message;
        }
        final ValidationMessage result = message;
        return new ValidationMessage(){
            private static final long serialVersionUID = 8392398038379511254L;

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getCode() {
                return messageId;
            }

            @Override
            public String getText() {
                return L10n.replace(result.getText(), params);
            }

            public int hashCode() {
                String key1 = this.getKey();
                return key1 != null ? key1.hashCode() : 0;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof ValidationMessage)) {
                    return false;
                }
                ValidationMessage other = (ValidationMessage)obj;
                return TextUtil.equals(this.getKey(), other.getKey(), false);
            }
        };
    }
}

