/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.plugin;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.update.UpdateIndexFile;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.ApplicationPlugin;
import org.java.plugin.boot.ErrorDialog;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.util.ExtendedProperties;

public abstract class BaseApplicationPlugin
extends ApplicationPlugin
implements Application {
    private FileLock lock;

    protected Application initApplication(ExtendedProperties config, String[] args) throws Exception {
        long timing = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("system info\r\n" + ErrorDialog.getErrorDetails(null)));
        }
        File rootFolder = new File(config.getProperty("rootFolder", "."));
        if (!(rootFolder = rootFolder.getCanonicalFile()).isDirectory()) {
            throw new Exception(String.format("root folder %s not found", rootFolder));
        }
        File dataFolder = new File(config.getProperty("dataFolder", "." + File.separator + "data"));
        if (!(dataFolder = dataFolder.getCanonicalFile()).isDirectory() && !dataFolder.mkdirs()) {
            throw new Exception(String.format("data folder %s not found", dataFolder));
        }
        this.acquireLock(dataFolder);
        File configFolder = new File(config.getProperty("configFolder", "." + File.separator + "config"));
        configFolder = configFolder.getCanonicalFile();
        if (!configFolder.isDirectory() && !configFolder.mkdirs()) {
            throw new Exception(String.format("config folder %s not found", configFolder));
        }
        File tempFolder = new File(config.getProperty("tempFolder", "." + File.separator + "temp"));
        if (!(tempFolder = tempFolder.getCanonicalFile()).isDirectory() && !tempFolder.mkdirs()) {
            throw new Exception(String.format("temporary folder %s not found", tempFolder));
        }
        UpdateIndexFile updateIndexFile = new UpdateIndexFile();
        updateIndexFile.readFromXml(IoUtil.file2url(new File(dataFolder, "update-repository/index.xml")));
        Environment.configure(config.getProperty("appId", ""), rootFolder, configFolder, dataFolder, tempFolder);
        Environment.publish(updateIndexFile);
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.preactivatePlugins();
        this.configure(config, args);
        MiscUtil.logTiming(timing, "application initialized");
        return this;
    }

    private void preactivatePlugins() {
        PluginManager pm = PluginManager.lookup(((Object)((Object)this)).getClass());
        if (pm == null) {
            return;
        }
        long timing = System.currentTimeMillis();
        int count = 0;
        for (PluginDescriptor descr : pm.getRegistry().getPluginDescriptors()) {
            if (pm.isPluginActivated(descr) || !pm.isPluginEnabled(descr) || pm.isBadPlugin(descr)) continue;
            try {
                pm.activatePlugin(descr.getId());
                ++count;
            }
            catch (PluginLifecycleException ple) {
                this.log.error((Object)("failed activating plug-in " + descr), (Throwable)ple);
            }
        }
        MiscUtil.logTiming(timing, count + " plug-ins pre-activated");
    }

    protected abstract void configure(ExtendedProperties var1, String[] var2) throws Exception;

    private void acquireLock(File dataFolder) throws Exception {
        try {
            File file = new File(dataFolder, ".lock");
            this.log.debug((Object)String.format("file checked: %s, exists: %s", file.getAbsolutePath(), String.valueOf(file.exists())));
            file.createNewFile();
            file.deleteOnExit();
            this.log.debug((Object)String.format("file created: %s, exists: %s", file.getAbsolutePath(), String.valueOf(file.exists())));
            this.lock = new RandomAccessFile(file, "rwd").getChannel().tryLock();
            if (this.lock != null) {
                this.log.debug((Object)String.format("file lock acquired: %s", String.valueOf(this.lock.isShared())));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.lock == null) {
            throw new Exception("Another instance of the application is running. Please terminate and try again.");
        }
    }

    private void releaseLock() {
        if (this.lock == null) {
            return;
        }
        try {
            this.lock.release();
            this.lock.channel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        this.releaseLock();
    }
}

