/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rest;

import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.EnumItem;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.rest.BaseRestType;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestEnumItem;
import com.gridnine.xtrip.common.meta.rest.RestEnumType;
import com.gridnine.xtrip.common.meta.rest.RestMap;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistryHelper;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.rest.DocGenerator;
import com.gridnine.xtrip.common.rest.RestDocType;
import com.gridnine.xtrip.common.rest.RestDocTypeItem;
import com.gridnine.xtrip.common.rest.l10n.Messages;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class RestDocsHelper {
    public static String getCollectionFormat(String typeId, Locale locale) {
        if (TextUtil.isBlank(typeId)) {
            return L10n.get("REST_DOCS_COLLECTION_OF_UNKNOWN_TYPE_ELEMENTS", locale);
        }
        if ("string".equals(typeId)) {
            return L10n.get("REST_DOCS_STRING_COLLECTION", locale);
        }
        if ("int".equals(typeId) || "byte".equals(typeId) || "big-int".equals(typeId) || "long".equals(typeId)) {
            return L10n.get("REST_DOCS_INTEGER_COLLECTION", locale);
        }
        if ("boolean".equals(typeId)) {
            return L10n.get("REST_DOCS_BOOLEAN_COLLECTION", locale);
        }
        if ("double".equals(typeId) || "float".equals(typeId) || "big-decimal".equals(typeId)) {
            return L10n.get("REST_DOCS_DECIMAL_COLLECTION", locale);
        }
        MetaRegistry reg = MetaRegistry.get();
        RestMetaRegistry restReg = RestMetaRegistry.get();
        if (restReg.getEntities().containsKey(typeId)) {
            return L10n.getWithParams(Messages.REST_DOCS_COLLECTION_OF_TYPE, locale, RestDocsHelper.getLink(RestDocsHelper.getLinkTypeId(typeId)));
        }
        if (reg.getEnums().containsKey(typeId) || restReg.getEnums().containsKey(typeId)) {
            return L10n.getWithParams("REST_DOCS_ENUM_COLLECTION", locale, RestDocsHelper.getLink(RestDocsHelper.getLinkTypeId(typeId)));
        }
        if (reg.getEntities().containsKey(typeId)) {
            return L10n.getWithParams("REST_DOCS_ENTITY_REFERENCE_COLLECTION", locale, RestDocsHelper.getLink(RestDocsHelper.getLinkTypeId(typeId)));
        }
        if (reg.getDictionaries().containsKey(typeId)) {
            return L10n.getWithParams("REST_DOCS_DICTIONARY_REFERENCE_COLLECTION", locale, RestDocsHelper.getLink(RestDocsHelper.getLinkTypeId(typeId)));
        }
        return L10n.get("REST_DOCS_COLLECTION_OF_UNKNOWN_TYPE_ELEMENTS", locale);
    }

    public static String getMapFormat(String keyType, String valueType, Locale locale) {
        return L10n.getWithParams("REST_DOCS_KEY_VALUE_COLLECTION", locale, RestDocsHelper.getPropertyFormat(keyType, locale), RestDocsHelper.getPropertyFormat(valueType, locale));
    }

    public static String getPropertyFormat(String typeId, Locale locale) {
        if (TextUtil.isBlank(typeId)) {
            return L10n.get("REST_DOCS_UNKNOWN_TYPE", locale);
        }
        if ("string".equals(typeId)) {
            return L10n.get(Messages.REST_DOCS_STRING, locale);
        }
        if ("int".equals(typeId) || "byte".equals(typeId) || "big-int".equals(typeId) || "long".equals(typeId)) {
            return L10n.get("REST_DOCS_INTEGER", locale);
        }
        if ("boolean".equals(typeId)) {
            return L10n.get("REST_DOCS_BOOLEAN", locale);
        }
        if ("double".equals(typeId) || "float".equals(typeId) || "big-decimal".equals(typeId)) {
            return L10n.get("REST_DOCS_DECIMAL", locale);
        }
        if ("bytes".equals(typeId) || "byte[]".equals(typeId)) {
            return L10n.get("REST_DOCS_BINARY_DATA", locale);
        }
        if ("char".equals(typeId)) {
            return L10n.get("REST_DOCS_CHARACTER", locale);
        }
        if ("timestamp".equals(typeId)) {
            return L10n.get(Messages.REST_DOCS_STRING, locale) + ", (yyyy-MM-dd'T'HH:mm:ss.SSSZZ)";
        }
        if ("date-local".equals(typeId)) {
            return L10n.get(Messages.REST_DOCS_STRING, locale) + ", (yyyy-MM-dd)";
        }
        if ("date-local-java".equals(typeId)) {
            return L10n.get(Messages.REST_DOCS_STRING, locale) + ", (yyyy-MM-dd)";
        }
        if ("time-local".equals(typeId)) {
            return L10n.get(Messages.REST_DOCS_STRING, locale) + ", (HH:mm:ss)";
        }
        if ("time-local-java".equals(typeId)) {
            return L10n.get(Messages.REST_DOCS_STRING, locale) + ", (HH:mm:ss)";
        }
        if ("date-time-local".equals(typeId)) {
            return L10n.get(Messages.REST_DOCS_STRING, locale) + ", (yyyy-MM-dd'T'HH:mm:ss)";
        }
        if ("date-time-local-java".equals(typeId)) {
            return L10n.get(Messages.REST_DOCS_STRING, locale) + ", (yyyy-MM-dd'T'HH:mm:ss)";
        }
        if ("date-time".equals(typeId)) {
            return L10n.get(Messages.REST_DOCS_STRING, locale) + ", (yyyy-MM-dd'T'HH:mm:ss.SSSZZ)";
        }
        MetaRegistry reg = MetaRegistry.get();
        RestMetaRegistry restReg = RestMetaRegistry.get();
        if (restReg.getEntities().containsKey(typeId)) {
            return L10n.getWithParams(Messages.REST_DOCS_OBJECT_AND_TYPE, locale, RestDocsHelper.getLink(RestDocsHelper.getLinkTypeId(typeId)));
        }
        if (reg.getEnums().containsKey(typeId) || restReg.getEnums().containsKey(typeId)) {
            return L10n.getWithParams("REST_DOCS_ENUM", locale, RestDocsHelper.getLink(RestDocsHelper.getLinkTypeId(typeId)));
        }
        if (reg.getEntities().containsKey(typeId)) {
            return L10n.getWithParams("REST_DOCS_ENTITY_REFERENCE_OF_TYPE", locale, RestDocsHelper.getLink(RestDocsHelper.getLinkTypeId(typeId)));
        }
        if (reg.getDictionaries().containsKey(typeId)) {
            return L10n.getWithParams("REST_DOCS_DICTIONARY_REFERENCE_OF_TYPE", locale, RestDocsHelper.getLink(RestDocsHelper.getLinkTypeId(typeId)));
        }
        return L10n.get("REST_DOCS_UNKNOWN_TYPE", locale);
    }

    public static String getLink(String typeId) {
        return RestDocsHelper.getLink(typeId, GenUtil.getSimpleClassName(typeId));
    }

    public static String getLink(String typeId, String caption) {
        return String.format("<a href=\"#%s\">%s</a>", typeId, caption);
    }

    public static String getDescription(BaseMetaElement type, Locale locale) {
        String fullId = type instanceof EnumItem ? ((EnumItem)type).getOwner() + "." + type.getId() : type.getId();
        String description = type.getDescription();
        if (!TextUtil.isBlank(description) && !(fullId + ".description").equals(description)) {
            return description;
        }
        description = type.getDisplayName(locale);
        if (!TextUtil.isBlank(description) && !(fullId + ".name").equals(description)) {
            return description;
        }
        return null;
    }

    public static void collectTypes(Set<String> types, String typeId) {
        if (types.contains(typeId)) {
            return;
        }
        MetaRegistry meta = MetaRegistry.get();
        if (meta.getEntities().containsKey(typeId) || meta.getEnums().containsKey(typeId) || meta.getDictionaries().containsKey(typeId)) {
            types.add(typeId);
            return;
        }
        RestMetaRegistry restMeta = RestMetaRegistry.get();
        if (restMeta.getEnums().containsKey(typeId)) {
            types.add(typeId);
            return;
        }
        RestEntityType ett = restMeta.getEntities().get(typeId);
        if (ett == null) {
            return;
        }
        types.add(typeId);
        for (RestProperty prop : ett.getProperties().values()) {
            RestDocsHelper.collectTypes(types, prop.getType());
        }
        for (RestCollection coll : ett.getCollections().values()) {
            RestDocsHelper.collectTypes(types, coll.getElementType());
        }
        for (RestMap map : ett.getMaps().values()) {
            RestDocsHelper.collectTypes(types, map.getKeyType());
            RestDocsHelper.collectTypes(types, map.getValueType());
        }
        if (ett.getExtendsId() != null) {
            RestDocsHelper.collectTypes(types, ett.getExtendsId());
        }
        RestDocsHelper.collectSubclasses(types, typeId);
    }

    private static void collectSubclasses(Set<String> types, String typeId) {
        RestMetaRegistry restMeta = RestMetaRegistry.get();
        for (RestEntityType type : restMeta.getEntities().values()) {
            if (!typeId.equals(type.getExtendsId())) continue;
            String subtypeId = type.getId();
            if (!type.isAbstract()) {
                RestDocsHelper.collectTypes(types, subtypeId);
            }
            RestDocsHelper.collectSubclasses(types, subtypeId);
        }
    }

    private static BaseRestType getType(String typeId) {
        RestMetaRegistry restMeta = RestMetaRegistry.get();
        BaseRestType type = restMeta.getEntities().get(typeId);
        if (type == null) {
            type = restMeta.getEnums().get(typeId);
        }
        return type;
    }

    public static BaseType getMetaType(String typeId) {
        MetaRegistry meta = MetaRegistry.get();
        BaseType type = meta.getEntities().get(typeId);
        if (type == null) {
            type = meta.getEnums().get(typeId);
        }
        if (type == null) {
            type = meta.getDictionaries().get(typeId);
        }
        return type;
    }

    private static void processDocTypeItem(RestDocTypeItem item, String typeId, Map<String, DocGenerator.JsonTypeDescriptor> handlerTypes) {
        if (null == handlerTypes) {
            return;
        }
        DocGenerator.JsonTypeDescriptor descriptor = handlerTypes.get(typeId);
        if (null == descriptor) {
            return;
        }
        String newTypeName = descriptor.getTypeName();
        if (null != newTypeName) {
            item.setTypeName(newTypeName);
        }
    }

    public static String getLinkTypeId(String typeId) {
        BaseType type2 = RestDocsHelper.getMetaType(typeId);
        return type2 != null ? RestDocsHelper.getLinkId(type2) : typeId;
    }

    private static String getLinkId(BaseType type2) {
        if (type2 instanceof EntityType || type2 instanceof DictionaryType) {
            return type2.getId() + "Reference";
        }
        return type2.getId();
    }

    public static RestDocType getDocType(String typeId, Map<String, DocGenerator.JsonTypeDescriptor> docGenTypes, Locale locale) {
        RestDocType result;
        block18: {
            BaseType modelType;
            block16: {
                String lang;
                BaseRestType restType;
                block17: {
                    RestDocTypeItem item;
                    if (null == typeId) {
                        return null;
                    }
                    restType = RestDocsHelper.getType(typeId);
                    modelType = RestDocsHelper.getMetaType(typeId);
                    if (null == restType && null == modelType) {
                        return null;
                    }
                    result = new RestDocType();
                    String string = lang = locale != null ? locale.getLanguage() : null;
                    if (restType == null) break block16;
                    result.setDeprecated(restType.isDeprecated());
                    result.setEnum(restType instanceof RestEnumType);
                    result.setId(restType.getId());
                    result.setName(GenUtil.getSimpleClassName(restType.getId()));
                    result.setDocumentation(RestMetaRegistryHelper.joinStrings(" ", restType.getDocumentation(), lang));
                    if (!(restType instanceof RestEntityType)) break block17;
                    if (((RestEntityType)restType).isWithMessages()) {
                        RestDocTypeItem item2 = new RestDocTypeItem();
                        item2.setName("messages");
                        item2.setDocumentation(L10n.get("REST_DOCS_INFORMATION_MESSAGES", locale));
                        item2.setTypeName(L10n.get("REST_DOCS_OBJECT_ARRAY", locale));
                        item2.setRequired("0/1");
                        result.getItems().add(item2);
                    }
                    ArrayList<RestProperty> props = new ArrayList<RestProperty>();
                    ArrayList<RestCollection> collections = new ArrayList<RestCollection>();
                    ArrayList<RestMap> maps = new ArrayList<RestMap>();
                    RestDocsHelper.collectMembers((RestEntityType)restType, props, collections, maps);
                    for (RestProperty property : props) {
                        item = new RestDocTypeItem();
                        item.setDeprecated(property.isDeprecated());
                        item.setName(property.getId());
                        item.setDocumentation(RestMetaRegistryHelper.joinStrings(" ", property.getDocumentation(), lang));
                        item.setTypeName(RestDocsHelper.getPropertyFormat(property.getType(), locale));
                        item.setRequired(!property.isOptional() ? "1" : "0/1");
                        RestDocsHelper.processDocTypeItem(item, property.getType(), docGenTypes);
                        result.getItems().add(item);
                    }
                    for (RestCollection collection : collections) {
                        item = new RestDocTypeItem();
                        item.setDeprecated(collection.isDeprecated());
                        item.setName(collection.getId());
                        item.setDocumentation(RestMetaRegistryHelper.joinStrings(" ", collection.getDocumentation(), lang));
                        item.setTypeName(RestDocsHelper.getCollectionFormat(collection.getElementType(), locale));
                        item.setRequired("0/1");
                        result.getItems().add(item);
                    }
                    for (RestMap map : maps) {
                        item = new RestDocTypeItem();
                        item.setDeprecated(map.isDeprecated());
                        item.setName(map.getId());
                        item.setDocumentation(RestMetaRegistryHelper.joinStrings(" ", map.getDocumentation(), lang));
                        item.setTypeName(RestDocsHelper.getMapFormat(map.getKeyType(), map.getValueType(), locale));
                        item.setRequired("0/1");
                        result.getItems().add(item);
                    }
                    break block18;
                }
                if (!(restType instanceof RestEnumType)) break block18;
                for (RestEnumItem element : ((RestEnumType)restType).getItems().values()) {
                    RestDocTypeItem item = new RestDocTypeItem();
                    item.setDeprecated(element.isDeprecated());
                    item.setName(element.getId());
                    item.setDocumentation(RestMetaRegistryHelper.joinStrings(" ", element.getDocumentation(), lang));
                    result.getItems().add(item);
                }
                break block18;
            }
            result.setDeprecated(modelType.isDeprecated());
            result.setEnum(modelType instanceof EnumType);
            String id = RestDocsHelper.getLinkId(modelType);
            result.setId(id);
            result.setName(GenUtil.getSimpleClassName(id));
            String description = RestDocsHelper.getDescription(modelType, locale);
            if (modelType instanceof EntityType) {
                description = L10n.getWithParams("REST_DOCS_ENTITY_REFERENCE_OF_TYPE", locale, description);
            } else if (modelType instanceof DictionaryType) {
                description = L10n.getWithParams("REST_DOCS_DICTIONARY_REFERENCE_OF_TYPE", locale, description);
            }
            result.setDocumentation(description);
            if (modelType instanceof EntityType) {
                RestDocTypeItem item = new RestDocTypeItem();
                item.setDeprecated(false);
                item.setName("uid");
                item.setDocumentation(L10n.get("REST_DOCS_IDENTIFIER", locale));
                item.setTypeName(L10n.get(Messages.REST_DOCS_STRING, locale));
                item.setRequired("1");
                result.getItems().add(item);
                item = new RestDocTypeItem();
                item.setDeprecated(false);
                item.setName("type");
                item.setDocumentation(L10n.get("REST_DOCS_REFERENCED_TYPE", locale));
                item.setTypeName(L10n.get(Messages.REST_DOCS_STRING, locale));
                item.setRequired("1");
                result.getItems().add(item);
                item = new RestDocTypeItem();
                item.setDeprecated(false);
                item.setName("caption");
                item.setDocumentation(L10n.get("REST_DOCS_TITLE", locale));
                item.setTypeName(L10n.get(Messages.REST_DOCS_STRING, locale));
                item.setRequired("0/1");
                result.getItems().add(item);
            } else if (modelType instanceof DictionaryType) {
                RestDocTypeItem item = new RestDocTypeItem();
                item.setDeprecated(false);
                item.setName("code");
                item.setDocumentation(L10n.get("REST_DOCS_DICTIONARY_CODE", locale));
                item.setTypeName(L10n.get(Messages.REST_DOCS_STRING, locale));
                item.setRequired("1");
                result.getItems().add(item);
                item = new RestDocTypeItem();
                item.setDeprecated(false);
                item.setName("type");
                item.setDocumentation(L10n.get("REST_DOCS_REFERENCED_TYPE", locale));
                item.setTypeName(L10n.get(Messages.REST_DOCS_STRING, locale));
                item.setRequired("1");
                result.getItems().add(item);
                item = new RestDocTypeItem();
                item.setDeprecated(false);
                item.setName("caption");
                item.setDocumentation(L10n.get("REST_DOCS_TITLE", locale));
                item.setTypeName(L10n.get(Messages.REST_DOCS_STRING, locale));
                item.setRequired("0/1");
                result.getItems().add(item);
            } else if (modelType instanceof EnumType) {
                for (EnumItem element : ((EnumType)modelType).getItems().values()) {
                    RestDocTypeItem item = new RestDocTypeItem();
                    item.setDeprecated(element.isDeprecated());
                    item.setName(element.getId());
                    item.setDocumentation(RestDocsHelper.getDescription(element, locale));
                    result.getItems().add(item);
                }
            }
        }
        return result;
    }

    private static void collectMembers(RestEntityType type, List<RestProperty> props, List<RestCollection> collections, List<RestMap> maps) {
        props.addAll(type.getProperties().values());
        collections.addAll(type.getCollections().values());
        maps.addAll(type.getMaps().values());
        if (type.getExtendsId() == null) {
            return;
        }
        RestEntityType superType = RestMetaRegistry.get().getEntities().get(type.getExtendsId());
        if (superType != null) {
            RestDocsHelper.collectMembers(superType, props, collections, maps);
        }
    }

    public static List<RestDocType> getDocTypes(Set<String> types, String docGenClass, Locale locale) throws Exception {
        HashMap<String, RestDocType> docTypes = new HashMap<String, RestDocType>();
        TreeSet nativeTypes = new TreeSet();
        HashMap<String, DocGenerator.JsonTypeDescriptor> handlers = new HashMap<String, DocGenerator.JsonTypeDescriptor>();
        DocGenerator docGen = (DocGenerator)XHelper.getClass(docGenClass).newInstance();
        for (String typeId : types) {
            DocGenerator.JsonTypeDescriptor descriptor;
            BaseMetaElement type = RestDocsHelper.getMetaElement(typeId);
            if (null == type || (descriptor = docGen.getFieldDescriptors(type, locale)) == null) continue;
            Collection<RestDocType> handlerDocTypes = descriptor.getTypes();
            if (handlerDocTypes != null) {
                for (RestDocType docType : handlerDocTypes) {
                    docTypes.put(docType.getId(), docType);
                }
            }
            handlers.put(typeId, descriptor);
        }
        for (String typeId : nativeTypes) {
            RestDocType docType = RestDocsHelper.getDocType(typeId, handlers, locale);
            if (docType == null) continue;
            docTypes.put(docType.getId(), docType);
        }
        for (RestDocType restDocType : docTypes.values()) {
            RestDocsHelper.collectSubclasses(restDocType, docTypes);
        }
        for (RestDocType restDocType : docTypes.values()) {
            RestDocsHelper.collectInterfaces(restDocType, docTypes);
        }
        block5: for (RestDocType restDocType : docTypes.values()) {
            String typeId = restDocType.getId();
            String superId = RestDocsHelper.getSuperId(typeId);
            while (superId != null) {
                if (docTypes.containsKey(superId)) {
                    restDocType.setSupertype(superId);
                    continue block5;
                }
                superId = RestDocsHelper.getSuperId(superId);
            }
        }
        ArrayList<RestDocType> result = new ArrayList<RestDocType>(docTypes.values());
        Collections.sort(result, new Comparator<RestDocType>(){

            @Override
            public int compare(RestDocType o1, RestDocType o2) {
                return TextUtil.compare(o1.getName(), o2.getName(), true, true);
            }
        });
        return result;
    }

    private static String getSuperId(String typeId) {
        BaseMetaElement type = RestDocsHelper.getMetaElement(typeId);
        if (null == type) {
            return null;
        }
        String superId = null;
        if (type instanceof BaseClassType) {
            superId = ((BaseClassType)type).getExtendsId();
        } else if (type instanceof RestEntityType) {
            superId = ((RestEntityType)type).getExtendsId();
        }
        return superId;
    }

    private static void collectSubclasses(RestDocType restDocType, final Map<String, RestDocType> docTypes) {
        String typeId = restDocType.getId();
        RestMetaRegistry restMeta = RestMetaRegistry.get();
        for (RestEntityType type : restMeta.getEntities().values()) {
            if (!typeId.equals(type.getExtendsId()) || !docTypes.containsKey(type.getId())) continue;
            String subtypeId = type.getId();
            if (!restDocType.getAllKnownSubtypes().contains(subtypeId)) {
                restDocType.getAllKnownSubtypes().add(subtypeId);
            }
            RestDocType subRestDocType = docTypes.get(subtypeId);
            RestDocsHelper.collectSubclasses(subRestDocType, docTypes);
        }
        Collections.sort(restDocType.getAllKnownSubtypes(), new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                RestDocType docType1 = (RestDocType)docTypes.get(o1);
                RestDocType docType2 = (RestDocType)docTypes.get(o2);
                return TextUtil.compare(docType1 != null ? docType1.getName() : null, docType2 != null ? docType2.getName() : null, true, true);
            }
        });
    }

    private static void collectInterfaces(RestDocType restDocType, final Map<String, RestDocType> docTypes) {
        RestMetaRegistry restMeta = RestMetaRegistry.get();
        for (RestEntityType type : restMeta.getEntities().values()) {
            if (!type.getId().equals(restDocType.getId()) || type.getInterfaces().isEmpty() || !docTypes.containsKey(type.getId())) continue;
            Set<String> interfaces = type.getInterfaces();
            for (String interfaceId : interfaces) {
                if (restDocType.getInterfaces().contains(interfaceId)) continue;
                restDocType.getInterfaces().add(interfaceId);
            }
        }
        Collections.sort(restDocType.getInterfaces(), new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                RestDocType docType1 = (RestDocType)docTypes.get(o1);
                RestDocType docType2 = (RestDocType)docTypes.get(o2);
                return TextUtil.compare(docType1 != null ? docType1.getName() : null, docType2 != null ? docType2.getName() : null, true, true);
            }
        });
    }

    private static BaseMetaElement getMetaElement(String typeId) {
        BaseMetaElement type = RestDocsHelper.getType(typeId);
        if (null == type) {
            type = RestDocsHelper.getMetaType(typeId);
        }
        return type;
    }
}

