/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.restriction.helper;

import com.gridnine.xtrip.common.restriction.model.DateCorrection;
import com.gridnine.xtrip.common.restriction.model.DateCorrectionUnit;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class RestrictionRulesHelper {
    public static final Pair<?> VOID_NUMBER_INTERVAL = new Pair<Object>(null, null);
    public static final DateInterval VOID_DATE_INTERVAL = new DateInterval(null, null);
    public static final SearchCriterion EMPTY_RESULT_CRITERION = SearchCriterion.eq("containerUid", null);

    public static <E> boolean isEquals(E data, Collection<E> values) {
        return values.stream().anyMatch(value -> MiscUtil.equals(data, value));
    }

    public static boolean isContains(String data, Collection<String> values) {
        return values.stream().anyMatch(value -> TextUtil.contains(data, value));
    }

    public static <E> boolean isContainsCollection(Collection<E> data, Collection<E> values) {
        return values.stream().map(value -> data.stream().anyMatch(item -> MiscUtil.equals(item, value))).anyMatch(item -> item);
    }

    public static boolean isBegins(String data, Collection<String> values) {
        return values.stream().anyMatch(value -> TextUtil.startsWith(data, value));
    }

    public static <E> boolean isBeginsCollection(Collection<E> data, Collection<E> values) {
        List list = data.stream().collect(Collectors.toList());
        return list.size() > 0 && values.stream().anyMatch(value -> MiscUtil.equals(list.get(0), value));
    }

    public static boolean isEnds(String data, Collection<String> values) {
        return values.stream().anyMatch(value -> TextUtil.endsWith(data, value));
    }

    public static <E> boolean isEndsCollection(Collection<E> data, Collection<E> values) {
        List list = data.stream().collect(Collectors.toList());
        return list.size() > 0 && values.stream().anyMatch(value -> MiscUtil.equals(list.get(list.size() - 1), value));
    }

    public static boolean isEmpty(String data) {
        return TextUtil.isBlank(data, false);
    }

    public static <E> boolean isEmptyCollection(Collection<E> data) {
        return CollectionUtil.isEmpty(data);
    }

    public static boolean isBoolean(Boolean data, Boolean value, BooleanCondition condition) {
        if (condition == BooleanCondition.EQUALS) {
            return MiscUtil.compare(data, value) == 0;
        }
        if (condition == BooleanCondition.NOT_EQUALS) {
            return MiscUtil.compare(data, value) != 0;
        }
        return true;
    }

    public static <E extends Number> boolean isNumber(E data, E value, NumberCondition condition) {
        if (condition == NumberCondition.EQUALS) {
            return MiscUtil.compare((Comparable)((Object)data), (Comparable)((Object)value)) == 0;
        }
        if (condition == NumberCondition.NOT_EQUALS) {
            return MiscUtil.compare((Comparable)((Object)data), (Comparable)((Object)value)) != 0;
        }
        if (condition == NumberCondition.GREATER) {
            return MiscUtil.compare((Comparable)((Object)data), (Comparable)((Object)value)) > 0;
        }
        if (condition == NumberCondition.GREATER_OR_EQUALS) {
            return MiscUtil.compare((Comparable)((Object)data), (Comparable)((Object)value)) >= 0;
        }
        if (condition == NumberCondition.LOWER) {
            return MiscUtil.compare((Comparable)((Object)data), (Comparable)((Object)value)) < 0;
        }
        if (condition == NumberCondition.LOWER_OR_EQUALS) {
            return MiscUtil.compare((Comparable)((Object)data), (Comparable)((Object)value)) <= 0;
        }
        return true;
    }

    public static <E extends Number> boolean isNumberInterval(E data, Pair<E> value, NumberIntervalCondition condition) {
        if (condition == NumberIntervalCondition.WITHIN) {
            if (value == VOID_NUMBER_INTERVAL) {
                return false;
            }
            return MiscUtil.isBetween((Number)value.getFirst(), (Number)value.getLast(), data);
        }
        if (condition == NumberIntervalCondition.BEYOND) {
            if (value == VOID_NUMBER_INTERVAL) {
                return true;
            }
            return !MiscUtil.isBetween((Number)value.getFirst(), (Number)value.getLast(), data);
        }
        if (condition == NumberIntervalCondition.GREATER) {
            if (value == VOID_NUMBER_INTERVAL) {
                return true;
            }
            if (value.getLast() != null) {
                return MiscUtil.compare((Comparable)((Object)data), (Comparable)value.getLast()) > 0;
            }
            return false;
        }
        if (condition == NumberIntervalCondition.GREATER_OR_EQUALS) {
            if (value == VOID_NUMBER_INTERVAL) {
                return true;
            }
            if (value.getFirst() != null) {
                return MiscUtil.compare((Comparable)((Object)data), (Comparable)value.getFirst()) >= 0;
            }
            return true;
        }
        if (condition == NumberIntervalCondition.LOWER) {
            if (value == VOID_NUMBER_INTERVAL) {
                return true;
            }
            if (value.getFirst() != null) {
                return MiscUtil.compare((Comparable)((Object)data), (Comparable)value.getFirst()) < 0;
            }
            return false;
        }
        if (condition == NumberIntervalCondition.LOWER_OR_EQUALS) {
            if (value == VOID_NUMBER_INTERVAL) {
                return true;
            }
            if (value.getLast() != null) {
                return MiscUtil.compare((Comparable)((Object)data), (Comparable)value.getLast()) <= 0;
            }
            return true;
        }
        return true;
    }

    public static boolean isDate(Date data, Date value, DateCondition condition) {
        if (condition == DateCondition.EQUALS) {
            return MiscUtil.compare(data, value) == 0;
        }
        if (condition == DateCondition.NOT_EQUALS) {
            return MiscUtil.compare(data, value) != 0;
        }
        if (condition == DateCondition.GREATER) {
            return MiscUtil.compare(data, value) > 0;
        }
        if (condition == DateCondition.GREATER_OR_EQUALS) {
            return MiscUtil.compare(data, value) >= 0;
        }
        if (condition == DateCondition.LOWER) {
            return MiscUtil.compare(data, value) < 0;
        }
        if (condition == DateCondition.LOWER_OR_EQUALS) {
            return MiscUtil.compare(data, value) <= 0;
        }
        return true;
    }

    public static boolean isDateInterval(Date data, DateInterval value, DateIntervalCondition condition) {
        if (condition == DateIntervalCondition.WITHIN) {
            if (value == VOID_DATE_INTERVAL) {
                return false;
            }
            return MiscUtil.isBetween(value.getBeginDate(), value.getEndDate(), data);
        }
        if (condition == DateIntervalCondition.BEYOND) {
            if (value == VOID_DATE_INTERVAL) {
                return true;
            }
            return !MiscUtil.isBetween(value.getBeginDate(), value.getEndDate(), data);
        }
        if (condition == DateIntervalCondition.GREATER) {
            if (value == VOID_DATE_INTERVAL) {
                return true;
            }
            if (value.getEndDate() != null) {
                return MiscUtil.compare(data, value.getEndDate()) > 0;
            }
            return false;
        }
        if (condition == DateIntervalCondition.GREATER_OR_EQUALS) {
            if (value == VOID_DATE_INTERVAL) {
                return true;
            }
            if (value.getBeginDate() != null) {
                return MiscUtil.compare(data, value.getBeginDate()) >= 0;
            }
            return true;
        }
        if (condition == DateIntervalCondition.LOWER) {
            if (value == VOID_DATE_INTERVAL) {
                return true;
            }
            if (value.getBeginDate() != null) {
                return MiscUtil.compare(data, value.getBeginDate()) < 0;
            }
            return false;
        }
        if (condition == DateIntervalCondition.LOWER_OR_EQUALS) {
            if (value == VOID_DATE_INTERVAL) {
                return true;
            }
            if (value.getEndDate() != null) {
                return MiscUtil.compare(data, value.getEndDate()) <= 0;
            }
            return true;
        }
        return true;
    }

    public static boolean isYes(Boolean data) {
        return RestrictionRulesHelper.isBoolean(data, Boolean.TRUE, BooleanCondition.EQUALS);
    }

    public static boolean isNo(Boolean data) {
        return RestrictionRulesHelper.isBoolean(data, Boolean.FALSE, BooleanCondition.EQUALS);
    }

    public static boolean isNow(Date date, DateCorrection correction, DateCondition condition) {
        Calendar calendar = Calendar.getInstance();
        if (correction != null) {
            int value = correction.getValue();
            DateCorrectionUnit unit = correction.getUnit();
            if (unit == DateCorrectionUnit.DAY) {
                calendar.add(value, 5);
            } else if (unit == DateCorrectionUnit.HOUR) {
                calendar.add(value, 11);
            }
        }
        return RestrictionRulesHelper.isDate(date, calendar.getTime(), condition);
    }

    public static boolean isToday(Date date, DateIntervalCondition condition) {
        Calendar calendar = Calendar.getInstance();
        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime(calendar.getTime()), MiscUtil.setDayEndTime(calendar.getTime()));
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static boolean isYesterday(Date date, DateIntervalCondition condition) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime(calendar.getTime()), MiscUtil.setDayEndTime(calendar.getTime()));
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static boolean isCurrentWeekBsp(Date date, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(3), MiscUtil.getEndDecade(3));
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static boolean isPreviousWeekBsp(Date date, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(4), MiscUtil.getEndDecade(4));
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static boolean isCurrentDecade(Date date, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(1), MiscUtil.getEndDecade(1));
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static boolean isPreviousDecade(Date date, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(2), MiscUtil.getEndDecade(2));
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static boolean isCurrentMonth(Date date, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(5), MiscUtil.getEndDecade(5));
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static boolean isPreviousMonth(Date date, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(6), MiscUtil.getEndDecade(6));
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static boolean isLast7Days(Date date, DateIntervalCondition condition) {
        DateInterval dateInterval = MiscUtil.getLastDays(7);
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static boolean isLast30Days(Date date, DateIntervalCondition condition) {
        DateInterval dateInterval = MiscUtil.getLastDays(30);
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static boolean isLast6Months(Date date, DateIntervalCondition condition) {
        DateInterval dateInterval = MiscUtil.getLastHalfYear();
        return RestrictionRulesHelper.isDateInterval(date, dateInterval, condition);
    }

    public static <E> boolean isNull(E data) {
        return data == null;
    }

    public static SearchCriterion createEqualsCriterion(String propertyId, Collection<?> values) {
        if (values.size() == 0) {
            return EMPTY_RESULT_CRITERION;
        }
        if (values.size() == 1) {
            return SearchCriterion.eq(propertyId, values.iterator().next());
        }
        List<SearchCriterion> criterions = values.stream().map(value -> SearchCriterion.eq(propertyId, value)).collect(Collectors.toList());
        return SearchCriterion.or(criterions.toArray(new SearchCriterion[criterions.size()]));
    }

    public static SearchCriterion createNotEqualsCriterion(String propertyId, Collection<?> values) {
        if (values.size() == 0) {
            return EMPTY_RESULT_CRITERION;
        }
        if (values.size() == 1) {
            return SearchCriterion.ne(propertyId, values.iterator().next());
        }
        List<SearchCriterion> criterions = values.stream().map(value -> SearchCriterion.ne(propertyId, value)).collect(Collectors.toList());
        return SearchCriterion.and(criterions.toArray(new SearchCriterion[criterions.size()]));
    }

    public static SearchCriterion createContainsCriterion(String propertyId, Collection<?> values, boolean collection) {
        if (values.size() == 0) {
            return EMPTY_RESULT_CRITERION;
        }
        if (values.size() == 1) {
            return collection ? SearchCriterion.contains(propertyId, values.iterator().next()) : SearchCriterion.like(propertyId, "%" + (String)values.iterator().next() + "%");
        }
        List<SearchCriterion> criterions = values.stream().map(value -> collection ? SearchCriterion.contains(propertyId, value) : SearchCriterion.like(propertyId, "%" + (String)value + "%")).collect(Collectors.toList());
        return SearchCriterion.or(criterions.toArray(new SearchCriterion[criterions.size()]));
    }

    public static SearchCriterion createNotContainsCriterion(String propertyId, Collection<?> values, boolean collection) {
        if (values.size() == 0) {
            return EMPTY_RESULT_CRITERION;
        }
        if (values.size() == 1) {
            return collection ? SearchCriterion.not(SearchCriterion.contains(propertyId, values.iterator().next())) : SearchCriterion.not(SearchCriterion.like(propertyId, "%" + (String)values.iterator().next() + "%"));
        }
        List<SearchCriterion> criterions = values.stream().map(value -> collection ? SearchCriterion.not(SearchCriterion.contains(propertyId, value)) : SearchCriterion.not(SearchCriterion.like(propertyId, "%" + (String)value + "%"))).collect(Collectors.toList());
        return SearchCriterion.and(criterions.toArray(new SearchCriterion[criterions.size()]));
    }

    public static SearchCriterion createBeginsCriterion(String propertyId, Collection<?> values, boolean collection) {
        if (values.size() == 0) {
            return EMPTY_RESULT_CRITERION;
        }
        if (values.size() == 1) {
            return collection ? SearchCriterion.begins(propertyId, values.iterator().next()) : SearchCriterion.like(propertyId, (String)values.iterator().next() + "%");
        }
        List<SearchCriterion> criterions = values.stream().map(value -> collection ? SearchCriterion.begins(propertyId, value) : SearchCriterion.like(propertyId, (String)value + "%")).collect(Collectors.toList());
        return SearchCriterion.or(criterions.toArray(new SearchCriterion[criterions.size()]));
    }

    public static SearchCriterion createNotBeginsCriterion(String propertyId, Collection<?> values, boolean collection) {
        if (values.size() == 0) {
            return EMPTY_RESULT_CRITERION;
        }
        if (values.size() == 1) {
            return collection ? SearchCriterion.not(SearchCriterion.begins(propertyId, values.iterator().next())) : SearchCriterion.not(SearchCriterion.like(propertyId, (String)values.iterator().next() + "%"));
        }
        List<SearchCriterion> criterions = values.stream().map(value -> collection ? SearchCriterion.not(SearchCriterion.begins(propertyId, value)) : SearchCriterion.not(SearchCriterion.like(propertyId, (String)value + "%"))).collect(Collectors.toList());
        return SearchCriterion.and(criterions.toArray(new SearchCriterion[criterions.size()]));
    }

    public static SearchCriterion createEndsCriterion(String propertyId, Collection<?> values, boolean collection) {
        if (values.size() == 0) {
            return EMPTY_RESULT_CRITERION;
        }
        if (values.size() == 1) {
            return collection ? SearchCriterion.ends(propertyId, values.iterator().next()) : SearchCriterion.like(propertyId, "%" + values.iterator().next().toString());
        }
        List<SearchCriterion> criterions = values.stream().map(value -> collection ? SearchCriterion.ends(propertyId, value) : SearchCriterion.like(propertyId, "%" + value.toString())).collect(Collectors.toList());
        return SearchCriterion.or(criterions.toArray(new SearchCriterion[criterions.size()]));
    }

    public static SearchCriterion createNotEndsCriterion(String propertyId, Collection<?> values, boolean collection) {
        if (values.size() == 0) {
            return EMPTY_RESULT_CRITERION;
        }
        if (values.size() == 1) {
            return collection ? SearchCriterion.not(SearchCriterion.ends(propertyId, values.iterator().next())) : SearchCriterion.not(SearchCriterion.like(propertyId, "%" + values.iterator().next().toString()));
        }
        List<SearchCriterion> criterions = values.stream().map(value -> collection ? SearchCriterion.not(SearchCriterion.ends(propertyId, value)) : SearchCriterion.not(SearchCriterion.like(propertyId, "%" + value.toString()))).collect(Collectors.toList());
        return SearchCriterion.and(criterions.toArray(new SearchCriterion[criterions.size()]));
    }

    public static SearchCriterion createEmptyCriterion(String propertyId, boolean collection) {
        return SearchCriterion.isEmpty(propertyId);
    }

    public static SearchCriterion createNotEmptyCriterion(String propertyId, boolean collection) {
        return SearchCriterion.isNotEmpty(propertyId);
    }

    public static SearchCriterion createBooleanCriterion(String propertyId, Boolean value, BooleanCondition condition) {
        if (condition == BooleanCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion(propertyId, Collections.singleton(value));
        }
        if (condition == BooleanCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion(propertyId, Collections.singleton(value));
        }
        return null;
    }

    public static SearchCriterion createNumberCriterion(String propertyId, Number number, NumberCondition condition) {
        if (condition == NumberCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion(propertyId, Collections.singleton(number));
        }
        if (condition == NumberCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion(propertyId, Collections.singleton(number));
        }
        if (condition == NumberCondition.GREATER) {
            return RestrictionRulesHelper.createGreaterCriterion(propertyId, number);
        }
        if (condition == NumberCondition.GREATER_OR_EQUALS) {
            return RestrictionRulesHelper.createGreaterOrEqualsCriterion(propertyId, number);
        }
        if (condition == NumberCondition.LOWER) {
            return RestrictionRulesHelper.createLowerCriterion(propertyId, number);
        }
        if (condition == NumberCondition.LOWER_OR_EQUALS) {
            return RestrictionRulesHelper.createLowerOrEqualsCriterion(propertyId, number);
        }
        return null;
    }

    public static SearchCriterion createNumberIntervalCriterion(String propertyId, Pair<Number> numberInterval, NumberIntervalCondition condition) {
        if (condition == NumberIntervalCondition.WITHIN) {
            if (numberInterval == VOID_NUMBER_INTERVAL) {
                return EMPTY_RESULT_CRITERION;
            }
            if (numberInterval.getFirst() == null && numberInterval.getLast() == null) {
                return null;
            }
            if (numberInterval.getFirst() == null) {
                return RestrictionRulesHelper.createLowerOrEqualsCriterion(propertyId, numberInterval.getLast());
            }
            if (numberInterval.getLast() == null) {
                return RestrictionRulesHelper.createGreaterOrEqualsCriterion(propertyId, numberInterval.getFirst());
            }
            return RestrictionRulesHelper.createBetweenCriterion(propertyId, numberInterval.getFirst(), numberInterval.getLast());
        }
        if (condition == NumberIntervalCondition.BEYOND) {
            if (numberInterval == VOID_NUMBER_INTERVAL) {
                return null;
            }
            if (numberInterval.getFirst() == null && numberInterval.getLast() == null) {
                return EMPTY_RESULT_CRITERION;
            }
            if (numberInterval.getFirst() == null) {
                return RestrictionRulesHelper.createGreaterCriterion(propertyId, numberInterval.getLast());
            }
            if (numberInterval.getLast() == null) {
                return RestrictionRulesHelper.createLowerCriterion(propertyId, numberInterval.getFirst());
            }
            return RestrictionRulesHelper.createNotBetweenCriterion(propertyId, numberInterval.getFirst(), numberInterval.getLast());
        }
        if (condition == NumberIntervalCondition.GREATER) {
            if (numberInterval == VOID_NUMBER_INTERVAL) {
                return null;
            }
            if (numberInterval.getLast() != null) {
                return RestrictionRulesHelper.createGreaterCriterion(propertyId, numberInterval.getLast());
            }
            return EMPTY_RESULT_CRITERION;
        }
        if (condition == NumberIntervalCondition.GREATER_OR_EQUALS) {
            if (numberInterval == VOID_NUMBER_INTERVAL) {
                return null;
            }
            if (numberInterval.getFirst() != null) {
                return RestrictionRulesHelper.createGreaterOrEqualsCriterion(propertyId, numberInterval.getFirst());
            }
            return null;
        }
        if (condition == NumberIntervalCondition.LOWER) {
            if (numberInterval == VOID_NUMBER_INTERVAL) {
                return null;
            }
            if (numberInterval.getFirst() != null) {
                return RestrictionRulesHelper.createLowerCriterion(propertyId, numberInterval.getFirst());
            }
            return EMPTY_RESULT_CRITERION;
        }
        if (condition == NumberIntervalCondition.LOWER_OR_EQUALS) {
            if (numberInterval == VOID_NUMBER_INTERVAL) {
                return null;
            }
            if (numberInterval.getLast() != null) {
                return RestrictionRulesHelper.createLowerOrEqualsCriterion(propertyId, numberInterval.getLast());
            }
            return null;
        }
        return null;
    }

    public static SearchCriterion createDateCriterion(String propertyId, Date date, DateCondition condition) {
        if (condition == DateCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion(propertyId, Collections.singleton(date));
        }
        if (condition == DateCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion(propertyId, Collections.singleton(date));
        }
        if (condition == DateCondition.GREATER) {
            return RestrictionRulesHelper.createGreaterCriterion(propertyId, date);
        }
        if (condition == DateCondition.GREATER_OR_EQUALS) {
            return RestrictionRulesHelper.createGreaterOrEqualsCriterion(propertyId, date);
        }
        if (condition == DateCondition.LOWER) {
            return RestrictionRulesHelper.createLowerCriterion(propertyId, date);
        }
        if (condition == DateCondition.LOWER_OR_EQUALS) {
            return RestrictionRulesHelper.createLowerOrEqualsCriterion(propertyId, date);
        }
        return null;
    }

    public static SearchCriterion createDateIntervalCriterion(String propertyId, DateInterval dateInterval, DateIntervalCondition condition) {
        if (condition == DateIntervalCondition.WITHIN) {
            if (dateInterval == VOID_DATE_INTERVAL) {
                return EMPTY_RESULT_CRITERION;
            }
            if (dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return null;
            }
            if (dateInterval.getBeginDate() == null) {
                return RestrictionRulesHelper.createLowerOrEqualsCriterion(propertyId, dateInterval.getEndDate());
            }
            if (dateInterval.getEndDate() == null) {
                return RestrictionRulesHelper.createGreaterOrEqualsCriterion(propertyId, dateInterval.getBeginDate());
            }
            return RestrictionRulesHelper.createBetweenCriterion(propertyId, dateInterval.getBeginDate(), dateInterval.getEndDate());
        }
        if (condition == DateIntervalCondition.BEYOND) {
            if (dateInterval == VOID_DATE_INTERVAL) {
                return null;
            }
            if (dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return EMPTY_RESULT_CRITERION;
            }
            if (dateInterval.getBeginDate() == null) {
                return RestrictionRulesHelper.createGreaterCriterion(propertyId, dateInterval.getEndDate());
            }
            if (dateInterval.getEndDate() == null) {
                return RestrictionRulesHelper.createLowerCriterion(propertyId, dateInterval.getBeginDate());
            }
            return RestrictionRulesHelper.createNotBetweenCriterion(propertyId, dateInterval.getBeginDate(), dateInterval.getEndDate());
        }
        if (condition == DateIntervalCondition.GREATER) {
            if (dateInterval == VOID_DATE_INTERVAL) {
                return null;
            }
            if (dateInterval.getEndDate() != null) {
                return RestrictionRulesHelper.createGreaterCriterion(propertyId, dateInterval.getEndDate());
            }
            return EMPTY_RESULT_CRITERION;
        }
        if (condition == DateIntervalCondition.GREATER_OR_EQUALS) {
            if (dateInterval == VOID_DATE_INTERVAL) {
                return null;
            }
            if (dateInterval.getBeginDate() != null) {
                return RestrictionRulesHelper.createGreaterOrEqualsCriterion(propertyId, dateInterval.getBeginDate());
            }
            return null;
        }
        if (condition == DateIntervalCondition.LOWER) {
            if (dateInterval == VOID_DATE_INTERVAL) {
                return null;
            }
            if (dateInterval.getBeginDate() != null) {
                return RestrictionRulesHelper.createLowerCriterion(propertyId, dateInterval.getBeginDate());
            }
            return EMPTY_RESULT_CRITERION;
        }
        if (condition == DateIntervalCondition.LOWER_OR_EQUALS) {
            if (dateInterval == VOID_DATE_INTERVAL) {
                return null;
            }
            if (dateInterval.getEndDate() != null) {
                return RestrictionRulesHelper.createLowerOrEqualsCriterion(propertyId, dateInterval.getEndDate());
            }
            return null;
        }
        return null;
    }

    public static SearchCriterion createYesCriterion(String propertyId, BooleanCondition condition) {
        return RestrictionRulesHelper.createBooleanCriterion(propertyId, Boolean.TRUE, condition);
    }

    public static SearchCriterion createNoCriterion(String propertyId, BooleanCondition condition) {
        return RestrictionRulesHelper.createBooleanCriterion(propertyId, Boolean.FALSE, condition);
    }

    public static SearchCriterion createGreaterCriterion(String propertyId, Object value) {
        return SearchCriterion.gt(propertyId, value);
    }

    public static SearchCriterion createGreaterOrEqualsCriterion(String propertyId, Object value) {
        return SearchCriterion.ge(propertyId, value);
    }

    public static SearchCriterion createLowerCriterion(String propertyId, Object value) {
        return SearchCriterion.lt(propertyId, value);
    }

    public static SearchCriterion createLowerOrEqualsCriterion(String propertyId, Object value) {
        return SearchCriterion.le(propertyId, value);
    }

    public static SearchCriterion createBetweenCriterion(String propertyId, Object value1, Object value2) {
        return SearchCriterion.between(propertyId, value1, value2);
    }

    public static SearchCriterion createNotBetweenCriterion(String propertyId, Object value1, Object value2) {
        return SearchCriterion.notbetween(propertyId, value1, value2);
    }

    public static SearchCriterion createNowCriterion(String propertyId, DateCorrection correction, DateCondition condition) {
        Calendar calendar = Calendar.getInstance();
        if (correction != null) {
            int value = correction.getValue();
            DateCorrectionUnit unit = correction.getUnit();
            if (unit == DateCorrectionUnit.DAY) {
                calendar.add(5, value);
            } else if (unit == DateCorrectionUnit.HOUR) {
                calendar.add(11, value);
            }
        }
        return RestrictionRulesHelper.createDateCriterion(propertyId, calendar.getTime(), condition);
    }

    public static SearchCriterion createTodayCriterion(String propertyId, DateIntervalCondition condition) {
        Calendar calendar = Calendar.getInstance();
        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime(calendar.getTime()), MiscUtil.setDayEndTime(calendar.getTime()));
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createYesterdayCriterion(String propertyId, DateIntervalCondition condition) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        DateInterval dateInterval = new DateInterval(MiscUtil.clearTime(calendar.getTime()), MiscUtil.setDayEndTime(calendar.getTime()));
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createCurrentWeekBspCriterion(String propertyId, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(3), MiscUtil.getEndDecade(3));
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createPreviousWeekBspCriterion(String propertyId, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(4), MiscUtil.getEndDecade(4));
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createCurrentDecadeCriterion(String propertyId, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(1), MiscUtil.getEndDecade(1));
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createPreviousDecadeCriterion(String propertyId, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(2), MiscUtil.getEndDecade(2));
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createCurrentMonthCriterion(String propertyId, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(5), MiscUtil.getEndDecade(5));
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createPreviousMonthCriterion(String propertyId, DateIntervalCondition condition) {
        DateInterval dateInterval = new DateInterval(MiscUtil.getStartDecade(6), MiscUtil.getEndDecade(6));
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createLast7DaysCriterion(String propertyId, DateIntervalCondition condition) {
        DateInterval dateInterval = MiscUtil.getLastDays(7);
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createLast30DaysCriterion(String propertyId, DateIntervalCondition condition) {
        DateInterval dateInterval = MiscUtil.getLastDays(30);
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createLast6MonthsCriterion(String propertyId, DateIntervalCondition condition) {
        DateInterval dateInterval = MiscUtil.getLastHalfYear();
        return RestrictionRulesHelper.createDateIntervalCriterion(propertyId, dateInterval, condition);
    }

    public static SearchCriterion createNullCriterion(String propertyId) {
        return SearchCriterion.eq(propertyId, null);
    }

    public static SearchCriterion createNotNullCriterion(String propertyId) {
        return SearchCriterion.ne(propertyId, null);
    }

    public static String getInfo(String name, String condition, Object object, boolean timeIncluded) {
        if (object == null) {
            return String.format("%s %s", name, condition);
        }
        if (object instanceof String) {
            return RestrictionRulesHelper.getInfo(name, condition, (String)object);
        }
        if (object instanceof Iterable) {
            return RestrictionRulesHelper.getInfo(name, condition, (Iterable)object);
        }
        if (object instanceof Date) {
            return RestrictionRulesHelper.getInfo(name, condition, (Date)object, timeIncluded);
        }
        if (object instanceof DateInterval) {
            return RestrictionRulesHelper.getInfo(name, condition, (DateInterval)object, timeIncluded);
        }
        return String.format("%s %s %s", name, condition, object.toString());
    }

    public static String getInfo(String name, String condition, String value) {
        return String.format("%s %s %s", name, condition, value);
    }

    public static String getInfo(String name, String condition, Iterable<?> values) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object value : values) {
            if (value == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(value);
        }
        return String.format("%s %s %s", name, condition, stringBuilder.toString());
    }

    public static String getInfo(String name, String condition, Date value, boolean timeIncluded) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(timeIncluded ? "yyyy.MM.dd HH:mm" : "yyyy.MM.dd");
        return String.format("%s %s %s", name, condition, dateFormat.format(value));
    }

    public static String getInfo(String name, String condition, DateInterval value, boolean timeIncluded) {
        if (value != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(timeIncluded ? "yyyy.MM.dd HH:mm" : "yyyy.MM.dd");
            if (value.getBeginDate() != null && value.getEndDate() == null) {
                return String.format("%s %s %s %s", name, condition, "c", dateFormat.format(value.getBeginDate()));
            }
            if (value.getBeginDate() == null && value.getEndDate() != null) {
                return String.format("%s %s %s %s", name, condition, "\u043f\u043e", dateFormat.format(value.getEndDate()));
            }
            if (value.getBeginDate() != null && value.getEndDate() != null) {
                return String.format("%s %s %s %s %s %s", name, condition, "c", dateFormat.format(value.getBeginDate()), "\u043f\u043e", dateFormat.format(value.getEndDate()));
            }
        }
        return null;
    }

    public static enum DateIntervalCondition {
        WITHIN,
        BEYOND,
        GREATER,
        GREATER_OR_EQUALS,
        LOWER,
        LOWER_OR_EQUALS;

    }

    public static enum DateCondition {
        EQUALS,
        NOT_EQUALS,
        GREATER,
        GREATER_OR_EQUALS,
        LOWER,
        LOWER_OR_EQUALS;

    }

    public static enum BooleanCondition {
        EQUALS,
        NOT_EQUALS;

    }

    public static enum NumberIntervalCondition {
        WITHIN,
        BEYOND,
        GREATER,
        GREATER_OR_EQUALS,
        LOWER,
        LOWER_OR_EQUALS;

    }

    public static enum NumberCondition {
        EQUALS,
        NOT_EQUALS,
        GREATER,
        GREATER_OR_EQUALS,
        LOWER,
        LOWER_OR_EQUALS;

    }
}

