/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.restriction.util;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.RestrictionGroupType;
import com.gridnine.xtrip.common.restriction.RestrictionValue;
import com.gridnine.xtrip.common.restriction.model.DateCorrection;
import com.gridnine.xtrip.common.restriction.model.DateCorrectionUnit;
import com.gridnine.xtrip.common.restriction.resource.RestrictionQueryable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyCondition;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyDynamicValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyDynamicValueHandlers;
import com.gridnine.xtrip.common.search.DynamicFieldDateCorrection;
import com.gridnine.xtrip.common.search.DynamicFieldValue;
import com.gridnine.xtrip.common.search.PredefinedKeyWords;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.resource.AclPropertyRestrictionGroupType;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestriction;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestrictionGroup;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictionsUtil {
    private static final Logger log = LoggerFactory.getLogger(RestrictionsUtil.class);

    public static Collection<RestrictionGroup> toRestrictionGroupsFromAclRestrictionsGroups(Collection<AclPropertyRestrictionGroup> groups) {
        return groups.stream().map(item -> RestrictionsUtil.toRestrictionGroupFromAclRestrictionsGroup(item)).collect(Collectors.toList());
    }

    public static RestrictionGroup toRestrictionGroupFromAclRestrictionsGroup(AclPropertyRestrictionGroup group) {
        if (group.getType() == AclPropertyRestrictionGroupType.SIMPLE) {
            return RestrictionsUtil.handleSimpleGroup(group);
        }
        if (group.getType() == AclPropertyRestrictionGroupType.NOT) {
            RestrictionGroup restrictionGroup = new RestrictionGroup();
            restrictionGroup.setType(RestrictionGroupType.NOT);
            restrictionGroup.setValue(Collections.singletonList(RestrictionsUtil.handleSimpleGroup(group)));
            return restrictionGroup;
        }
        if (group.getType() == AclPropertyRestrictionGroupType.AND) {
            RestrictionGroup restrictionGroup = new RestrictionGroup();
            restrictionGroup.setType(RestrictionGroupType.AND);
            restrictionGroup.setValue(((List)group.getValue()).stream().map(item -> RestrictionsUtil.toRestrictionGroupFromAclRestrictionsGroup(item)).collect(Collectors.toList()));
            return restrictionGroup;
        }
        if (group.getType() == AclPropertyRestrictionGroupType.OR) {
            RestrictionGroup restrictionGroup = new RestrictionGroup();
            restrictionGroup.setType(RestrictionGroupType.OR);
            restrictionGroup.setValue(((List)group.getValue()).stream().map(item -> RestrictionsUtil.toRestrictionGroupFromAclRestrictionsGroup(item)).collect(Collectors.toList()));
            return restrictionGroup;
        }
        throw new RuntimeException(String.format("unsupported group %s", new Object[]{group.getType()}));
    }

    private static RestrictionGroup handleSimpleGroup(AclPropertyRestrictionGroup group) {
        AclPropertyRestriction value = (AclPropertyRestriction)group.getValue();
        RestrictionValue restrictionValue = new RestrictionValue();
        RestrictionResourceProperty property = RestrictionResourcesRegistry.get().getProperty(value.getPropertyId());
        if (property == null) {
            throw new RuntimeException(String.format("unsupported property %s", value.getPropertyId()));
        }
        restrictionValue.setPropertyId(value.getPropertyId());
        RestrictionsUtil.handleCondition(restrictionValue, value, property);
        RestrictionsUtil.handleValue(restrictionValue, value, property);
        RestrictionGroup restrictionGroup = new RestrictionGroup();
        restrictionGroup.setType(RestrictionGroupType.SIMPLE);
        restrictionGroup.setValue(restrictionValue);
        return restrictionGroup;
    }

    private static void handleCondition(RestrictionValue restrictionValue, AclPropertyRestriction value, RestrictionResourceProperty property) {
        RestrictionResourcePropertyCondition condition = RestrictionResourcesRegistry.get().getCondition(value.getConditionId());
        if (condition == null) {
            throw new RuntimeException(String.format("unsupported condition %s", value.getPropertyId()));
        }
        restrictionValue.setConditionId(value.getConditionId());
        if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(value.getConditionId())) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.WITHIN.getId());
        } else if (StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(value.getConditionId())) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.BEYOND.getId());
        } else if (StandardAclResourcePropertyConditions.LAST_DECADE.getId().equals(value.getConditionId())) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.PREVIOUS_DECADE.getId());
        }
        if (property.isCollection()) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(value.getConditionId()) || StandardAclResourcePropertyConditions.INCLUDES.getId().equals(value.getConditionId())) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.CONTAINS.getId());
            } else if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(value.getConditionId()) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(value.getConditionId())) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.NOT_CONTAINS.getId());
            } else if (StandardAclResourcePropertyConditions.NULL.getId().equals(value.getConditionId())) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.EMPTY.getId());
            } else if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(value.getConditionId())) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId());
            }
        } else if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(value.getConditionId())) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.EQUALS.getId());
        } else if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(value.getConditionId())) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId());
        }
    }

    private static void handleValue(RestrictionValue restrictionValue, AclPropertyRestriction value, RestrictionResourceProperty property) {
        if (value.getValue() instanceof DateInterval) {
            DateInterval dateInteval = (DateInterval)value.getValue();
            if (dateInteval != null) {
                restrictionValue.setValue(property.isTimeIncluded() ? new Pair<LocalDateTime>(MiscUtil.toLocalDateTime(dateInteval.getBeginDate()), MiscUtil.toLocalDateTime(dateInteval.getEndDate())) : new Pair<LocalDate>(MiscUtil.toLocalDate(dateInteval.getBeginDate()), MiscUtil.toLocalDate(dateInteval.getEndDate())));
            }
        } else if (value.getValue() instanceof Date) {
            Date date = (Date)value.getValue();
            restrictionValue.setValue(property.isTimeIncluded() ? MiscUtil.toLocalDateTime(date) : MiscUtil.toLocalDate(date));
        } else if (value.getValue() instanceof Collection) {
            restrictionValue.setValue(value.getValue());
        } else if (value.getValue() != null) {
            restrictionValue.setValue(Collections.singletonList(value.getValue()));
        }
    }

    public static Collection<SearchCriterion> toQueryFromRestrictionGroups(Collection<RestrictionGroup> restrictionGroups, Class<?> type, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) {
        return RestrictionsUtil.toQueryFromRestrictionGroups(restrictionGroups, type, handlers, RestrictionResourcesRegistry.get());
    }

    public static Collection<SearchCriterion> toQueryFromRestrictionGroups(Collection<RestrictionGroup> restrictionGroups, Class<?> type, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) {
        return restrictionGroups.stream().map(item -> RestrictionsUtil.toQueryFromRestrictionGroup(item, type, handlers, registry)).filter(item -> item != null).collect(Collectors.toList());
    }

    public static SearchCriterion toQueryFromRestrictionGroup(RestrictionGroup restrictionGroup, Class<?> type, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) {
        return RestrictionsUtil.toQueryFromRestrictionGroup(restrictionGroup, type, handlers, RestrictionResourcesRegistry.get());
    }

    public static SearchCriterion toQueryFromRestrictionGroup(RestrictionGroup restrictionGroup, Class<?> type, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) {
        if (restrictionGroup.getType() == RestrictionGroupType.SIMPLE) {
            return RestrictionsUtil.handleSimpleRestrictionGroup(restrictionGroup, type, handlers, registry);
        }
        if (restrictionGroup.getType() == RestrictionGroupType.NOT) {
            List<SearchCriterion> criterions = ((List)restrictionGroup.getValue()).stream().map(item -> RestrictionsUtil.toQueryFromRestrictionGroup(item, type, handlers, registry)).filter(item -> item != null).map(item -> SearchCriterion.not(item)).collect(Collectors.toList());
            return criterions.size() > 0 ? SearchCriterion.and(criterions.toArray(new SearchCriterion[criterions.size()])) : null;
        }
        if (restrictionGroup.getType() == RestrictionGroupType.AND) {
            List<SearchCriterion> criterions = ((List)restrictionGroup.getValue()).stream().map(item -> RestrictionsUtil.toQueryFromRestrictionGroup(item, type, handlers, registry)).filter(item -> item != null).collect(Collectors.toList());
            return criterions.size() > 0 ? SearchCriterion.and(criterions.toArray(new SearchCriterion[criterions.size()])) : null;
        }
        if (restrictionGroup.getType() == RestrictionGroupType.OR) {
            List<SearchCriterion> criterions = ((List)restrictionGroup.getValue()).stream().map(item -> RestrictionsUtil.toQueryFromRestrictionGroup(item, type, handlers, registry)).filter(item -> item != null).collect(Collectors.toList());
            return criterions.size() > 0 ? SearchCriterion.or(criterions.toArray(new SearchCriterion[criterions.size()])) : null;
        }
        throw new RuntimeException(String.format("unsupported restriction group %s", restrictionGroup));
    }

    private static SearchCriterion handleSimpleRestrictionGroup(RestrictionGroup restrictionGroup, Class<?> type, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) {
        RestrictionValue restrictionValue = (RestrictionValue)restrictionGroup.getValue();
        RestrictionResourceProperty property = registry.getProperty(restrictionValue.getPropertyId());
        if (property == null) {
            log.warn(String.format("unsupported property %s", restrictionValue.getPropertyId()));
            return null;
        }
        RestrictionResourcePropertyCondition condition = registry.getCondition(restrictionValue.getConditionId());
        if (condition == null) {
            log.warn(String.format("unsupported condition %s", restrictionValue.getConditionId()));
            return null;
        }
        String handlerId = registry.getPropertyConditionValueHandler(restrictionValue.getPropertyId(), restrictionValue.getConditionId());
        RestrictionResourcePropertyValueHandler handler = registry.getValueHandler(handlerId);
        if (handler == null) {
            log.warn(String.format("unsupported handler %s", handlerId));
            return null;
        }
        if (!(property instanceof RestrictionQueryable)) {
            log.warn(String.format("property %s is not queryable", restrictionValue.getPropertyId()));
            return null;
        }
        String propertyId = ((RestrictionQueryable)((Object)property)).getColumn();
        if (propertyId.equals("ownership")) {
            log.warn(String.format("unsupported property %s", propertyId));
            return null;
        }
        if (restrictionValue.getConditionId().startsWith("MY_")) {
            log.warn(String.format("unsupported condition %s", restrictionValue.getConditionId()));
            return null;
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.NOW.getId())) {
            DynamicFieldValue dynamicFieldValue = new DynamicFieldValue();
            dynamicFieldValue.setId(StandardRestrictionResourcePropertyConditions.NOW.getId());
            dynamicFieldValue.setCorrection(null);
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), dynamicFieldValue);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.TODAY.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.TODAY);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.YESTERDAY.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.YESTERDAY);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.CURRENT_WEEK_BSP.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.CURRENT_WEEK_BSP);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.PREVIOUS_WEEK_BSP.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.LAST_WEEK_BSP);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.CURRENT_DECADE.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.CURRENT_DECADE);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.PREVIOUS_DECADE.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.LAST_DECADE);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.CURRENT_MONTH.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.CURRENT_MONTH);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.PREVIOUS_MONTH.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.LAST_MONTH);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.LAST_7_DAYS.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.LAST_7_DAYS);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.LAST_30_DAYS.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.LAST_30_DAYS);
        }
        if (restrictionValue.getConditionId().equals(StandardRestrictionResourcePropertyConditions.LAST_6_MONTHS.getId())) {
            return RestrictionsUtil.createCriterion(propertyId, StandardRestrictionResourcePropertyConditions.EQUALS.getId(), (Object)PredefinedKeyWords.LAST_HALF_YEAR);
        }
        Object value = restrictionValue.getValue();
        if (value instanceof RestrictionValue.DynamicValue) {
            RestrictionValue.DynamicValue dynamicValue = (RestrictionValue.DynamicValue)value;
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.NOW.getId())) {
                DynamicFieldValue dynamicFieldValue = new DynamicFieldValue();
                dynamicFieldValue.setId(StandardRestrictionResourcePropertyDynamicValueHandlers.NOW.getId());
                if (dynamicValue.getParameters() != null) {
                    DynamicFieldDateCorrection correction = new DynamicFieldDateCorrection();
                    correction.setValue(((DateCorrection)dynamicValue.getParameters()).getValue());
                    if (((DateCorrection)dynamicValue.getParameters()).getUnit() == DateCorrectionUnit.HOUR) {
                        correction.setUnit(DynamicFieldDateCorrection.DateCorrectionUnit.HOUR);
                    } else if (((DateCorrection)dynamicValue.getParameters()).getUnit() == DateCorrectionUnit.DAY) {
                        correction.setUnit(DynamicFieldDateCorrection.DateCorrectionUnit.DAY);
                    }
                    dynamicFieldValue.setCorrection(correction);
                }
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), dynamicFieldValue);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.TODAY.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.TODAY);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.YESTERDAY.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.YESTERDAY);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.CURRENT_WEEK_BSP.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.CURRENT_WEEK_BSP);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.PREVIOUS_WEEK_BSP.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.LAST_WEEK_BSP);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.CURRENT_DECADE.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.CURRENT_DECADE);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.PREVIOUS_DECADE.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.LAST_DECADE);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.CURRENT_MONTH.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.CURRENT_MONTH);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.PREVIOUS_MONTH.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.LAST_MONTH);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.LAST_7_DAYS.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.LAST_7_DAYS);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.LAST_30_DAYS.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.LAST_30_DAYS);
            }
            if (dynamicValue.getHandlerId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.LAST_6_MONTHS.getId())) {
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), (Object)PredefinedKeyWords.LAST_HALF_YEAR);
            }
            if (handlers.stream().anyMatch(item -> item.getId().equals(dynamicValue.getHandlerId()))) {
                DynamicFieldValue dynamicFieldValue = new DynamicFieldValue();
                dynamicFieldValue.setId(dynamicValue.getHandlerId());
                return RestrictionsUtil.createCriterion(propertyId, restrictionValue.getConditionId(), dynamicFieldValue);
            }
            return null;
        }
        return handler.getQuery(property, condition, restrictionValue.getValue(), null);
    }

    private static SearchCriterion createCriterion(String propertyId, String conditionId, Object value) {
        if (conditionId.equals(StandardRestrictionResourcePropertyConditions.EQUALS.getId())) {
            return SearchCriterion.eq(propertyId, value);
        }
        if (conditionId.equals(StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId())) {
            return SearchCriterion.ne(propertyId, value);
        }
        if (conditionId.equals(StandardRestrictionResourcePropertyConditions.GREATER.getId())) {
            return SearchCriterion.gt(propertyId, value);
        }
        if (conditionId.equals(StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId())) {
            return SearchCriterion.ge(propertyId, value);
        }
        if (conditionId.equals(StandardRestrictionResourcePropertyConditions.LOWER.getId())) {
            return SearchCriterion.lt(propertyId, value);
        }
        if (conditionId.equals(StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId())) {
            return SearchCriterion.le(propertyId, value);
        }
        return null;
    }

    public static Collection<RestrictionGroup> toRestrictionGroupsFromQuery(Collection<SearchCriterion> criterions, Class<?> type, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) {
        return RestrictionsUtil.toRestrictionGroupsFromQuery(criterions, type, handlers, RestrictionResourcesRegistry.get());
    }

    public static Collection<RestrictionGroup> toRestrictionGroupsFromQuery(Collection<SearchCriterion> criterions, Class<?> type, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) {
        return criterions.stream().map(item -> RestrictionsUtil.toRestrictionGroupFromQuery(item, type, handlers, registry)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static RestrictionGroup toRestrictionGroupFromQuery(SearchCriterion criterion, Class<?> type, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) {
        return RestrictionsUtil.toRestrictionGroupFromQuery(criterion, type, handlers, RestrictionResourcesRegistry.get());
    }

    public static RestrictionGroup toRestrictionGroupFromQuery(SearchCriterion criterion, Class<?> type, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) {
        if (criterion instanceof SearchCriterion.SimpleCriterion) {
            return RestrictionsUtil.handleSimpleCriterion((SearchCriterion.SimpleCriterion)criterion, type, handlers, registry);
        }
        if (criterion instanceof SearchCriterion.BetweenCriterion && !(criterion instanceof SearchCriterion.NotBetweenCriterion)) {
            return RestrictionsUtil.handleBetweenCriterion((SearchCriterion.BetweenCriterion)criterion, type, registry);
        }
        if (criterion instanceof SearchCriterion.NotBetweenCriterion) {
            return RestrictionsUtil.handleNotBetweenCriterion((SearchCriterion.NotBetweenCriterion)criterion, type, registry);
        }
        if (criterion instanceof SearchCriterion.CheckCriterion) {
            return RestrictionsUtil.handleCheckCriterion((SearchCriterion.CheckCriterion)criterion, type, registry);
        }
        if (criterion instanceof SearchCriterion.InCriterion) {
            return RestrictionsUtil.handleInCriterion((SearchCriterion.InCriterion)criterion, type, registry);
        }
        if (criterion instanceof SearchCriterion.NotCriterion) {
            SearchCriterion.NotCriterion notCriterion = (SearchCriterion.NotCriterion)criterion;
            RestrictionGroup restrictionGroup = new RestrictionGroup();
            restrictionGroup.setType(RestrictionGroupType.NOT);
            restrictionGroup.setValue(Collections.singletonList(RestrictionsUtil.toRestrictionGroupFromQuery(notCriterion.getCriterion(), type, handlers, registry)));
            return restrictionGroup;
        }
        if (criterion instanceof SearchCriterion.JunctionCriterion) {
            SearchCriterion.JunctionCriterion junctionCriterion = (SearchCriterion.JunctionCriterion)criterion;
            RestrictionGroup restrictionGroup = new RestrictionGroup();
            if (junctionCriterion.isDisjunction()) {
                restrictionGroup.setType(RestrictionGroupType.OR);
            } else {
                restrictionGroup.setType(RestrictionGroupType.AND);
            }
            restrictionGroup.setValue(junctionCriterion.getCriterions().stream().map(item -> RestrictionsUtil.toRestrictionGroupFromQuery(item, type, handlers, registry)).filter(Objects::nonNull).collect(Collectors.toList()));
            return restrictionGroup;
        }
        throw new RuntimeException(String.format("unsupported criterion %s", criterion));
    }

    private static RestrictionGroup handleSimpleCriterion(SearchCriterion.SimpleCriterion criterion, Class<?> type, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) {
        String propertyId = String.format("%s.%s", type.getName(), criterion.getProperty());
        RestrictionResourceProperty property = registry.getProperty(propertyId);
        if (property == null) {
            log.warn(String.format("unsupported property %s", propertyId));
            return null;
        }
        RestrictionValue restrictionValue = new RestrictionValue();
        restrictionValue.setPropertyId(propertyId);
        Object value = criterion.getValue();
        if (value instanceof DynamicFieldValue) {
            RestrictionsUtil.handleDynamicSimpleCriterion(restrictionValue, (DynamicFieldValue)value, criterion.getOperation(), handlers, registry);
        } else if (value instanceof PredefinedKeyWords) {
            RestrictionsUtil.handleKeywordSimpleCriterion(restrictionValue, (PredefinedKeyWords)((Object)value), criterion.getOperation(), registry);
        } else {
            RestrictionsUtil.handleCommonSimpleCriterion(restrictionValue, criterion.getOperation(), criterion.getValue(), registry);
            RestrictionsUtil.handleCommonSimpleValue(restrictionValue, type.getName(), restrictionValue.getPropertyId(), criterion.getOperation(), criterion.getValue(), registry);
        }
        RestrictionGroup restrictionGroup = new RestrictionGroup();
        restrictionGroup.setType(RestrictionGroupType.SIMPLE);
        restrictionGroup.setValue(restrictionValue);
        return restrictionGroup;
    }

    private static void handleCommonSimpleCriterion(RestrictionValue restrictionValue, SearchCriterion.SimpleCriterion.Operation operation, Object value, RestrictionResourcesRegistry registry) {
        if (operation == SearchCriterion.SimpleCriterion.Operation.EQ) {
            restrictionValue.setConditionId(value != null ? StandardRestrictionResourcePropertyConditions.EQUALS.getId() : StandardRestrictionResourcePropertyConditions.NULL.getId());
        } else if (operation == SearchCriterion.SimpleCriterion.Operation.NE) {
            restrictionValue.setConditionId(value != null ? StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId() : StandardRestrictionResourcePropertyConditions.NOT_NULL.getId());
        } else if (operation == SearchCriterion.SimpleCriterion.Operation.LIKE || operation == SearchCriterion.SimpleCriterion.Operation.ILIKE) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.CONTAINS.getId());
        } else if (operation == SearchCriterion.SimpleCriterion.Operation.GT) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.GREATER.getId());
        } else if (operation == SearchCriterion.SimpleCriterion.Operation.LT) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.LOWER.getId());
        } else if (operation == SearchCriterion.SimpleCriterion.Operation.GE) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId());
        } else if (operation == SearchCriterion.SimpleCriterion.Operation.LE) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId());
        } else if (operation == SearchCriterion.SimpleCriterion.Operation.CONTAINS || operation == SearchCriterion.SimpleCriterion.Operation.ICONTAINS) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.CONTAINS.getId());
        } else if (operation == SearchCriterion.SimpleCriterion.Operation.BEGINS) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.BEGINS.getId());
        } else if (operation == SearchCriterion.SimpleCriterion.Operation.ENDS) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.ENDS.getId());
        } else {
            throw new RuntimeException(String.format("unsupported operation %s", new Object[]{operation}));
        }
    }

    private static void handleCommonSimpleValue(RestrictionValue restrictionValue, String resourceId, String propertyId, SearchCriterion.SimpleCriterion.Operation operation, Object value, RestrictionResourcesRegistry registry) {
        Object actualValue = value;
        if ((operation == SearchCriterion.SimpleCriterion.Operation.ICONTAINS || operation == SearchCriterion.SimpleCriterion.Operation.BEGINS || operation == SearchCriterion.SimpleCriterion.Operation.ENDS) && value instanceof String) {
            RestrictionResourceProperty property = registry.getResourceProperties(resourceId).stream().filter(item -> MiscUtil.equals(item, propertyId)).map(item -> registry.getProperty((String)item)).findFirst().orElse(null);
            if (property != null) {
                if (Enum.class.isAssignableFrom(property.getType())) {
                    actualValue = Enum.valueOf(property.getType(), (String)value);
                } else if (BaseDictionary.class.isAssignableFrom(property.getType())) {
                    String className = property.getType().getName() + "Reference";
                    try {
                        actualValue = XSHelper.getClass(className).getConstructor(String.class).newInstance((String)value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("failed to load class %s", className), e);
                    }
                }
            } else {
                throw new RuntimeException(String.format("failed to find property %s of resource %s", propertyId, resourceId));
            }
        }
        if (actualValue instanceof Boolean || actualValue instanceof Number || actualValue instanceof Date) {
            restrictionValue.setValue(actualValue);
        } else {
            restrictionValue.setValue(actualValue != null ? Collections.singletonList(actualValue) : null);
        }
    }

    private static void handleKeywordSimpleCriterion(RestrictionValue restrictionValue, PredefinedKeyWords keyword, SearchCriterion.SimpleCriterion.Operation operation, RestrictionResourcesRegistry registry) {
        if (operation == SearchCriterion.SimpleCriterion.Operation.EQ) {
            if (keyword == PredefinedKeyWords.TODAY) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.TODAY.getId());
            } else if (keyword == PredefinedKeyWords.YESTERDAY) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.YESTERDAY.getId());
            } else if (keyword == PredefinedKeyWords.CURRENT_WEEK_BSP) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.CURRENT_WEEK_BSP.getId());
            } else if (keyword == PredefinedKeyWords.LAST_WEEK_BSP) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.PREVIOUS_WEEK_BSP.getId());
            } else if (keyword == PredefinedKeyWords.CURRENT_DECADE) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.CURRENT_DECADE.getId());
            } else if (keyword == PredefinedKeyWords.LAST_DECADE) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.PREVIOUS_DECADE.getId());
            } else if (keyword == PredefinedKeyWords.CURRENT_MONTH) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.CURRENT_MONTH.getId());
            } else if (keyword == PredefinedKeyWords.LAST_MONTH) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.PREVIOUS_MONTH.getId());
            } else if (keyword == PredefinedKeyWords.LAST_7_DAYS) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.LAST_7_DAYS.getId());
            } else if (keyword == PredefinedKeyWords.LAST_30_DAYS) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.LAST_30_DAYS.getId());
            } else if (keyword == PredefinedKeyWords.LAST_HALF_YEAR) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.LAST_6_MONTHS.getId());
            } else {
                throw new RuntimeException(String.format("unsupported keyword %s", new Object[]{keyword}));
            }
            restrictionValue.setValue(null);
        } else {
            if (operation == SearchCriterion.SimpleCriterion.Operation.NE) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId());
            } else if (operation == SearchCriterion.SimpleCriterion.Operation.GT) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.GREATER.getId());
            } else if (operation == SearchCriterion.SimpleCriterion.Operation.LT) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.LOWER.getId());
            } else if (operation == SearchCriterion.SimpleCriterion.Operation.GE) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.GREATER_OR_EQUALS.getId());
            } else if (operation == SearchCriterion.SimpleCriterion.Operation.LE) {
                restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.LOWER_OR_EQUALS.getId());
            } else {
                throw new RuntimeException(String.format("unsupported condition %s for keyword %s", new Object[]{operation, keyword}));
            }
            RestrictionValue.DynamicValue dynamicValue = new RestrictionValue.DynamicValue();
            if (keyword == PredefinedKeyWords.TODAY) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.TODAY.getId());
            } else if (keyword == PredefinedKeyWords.YESTERDAY) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.YESTERDAY.getId());
            } else if (keyword == PredefinedKeyWords.CURRENT_WEEK_BSP) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.CURRENT_WEEK_BSP.getId());
            } else if (keyword == PredefinedKeyWords.LAST_WEEK_BSP) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.PREVIOUS_WEEK_BSP.getId());
            } else if (keyword == PredefinedKeyWords.CURRENT_DECADE) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.CURRENT_DECADE.getId());
            } else if (keyword == PredefinedKeyWords.LAST_DECADE) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.PREVIOUS_DECADE.getId());
            } else if (keyword == PredefinedKeyWords.CURRENT_MONTH) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.CURRENT_MONTH.getId());
            } else if (keyword == PredefinedKeyWords.LAST_MONTH) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.PREVIOUS_MONTH.getId());
            } else if (keyword == PredefinedKeyWords.LAST_7_DAYS) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.LAST_7_DAYS.getId());
            } else if (keyword == PredefinedKeyWords.LAST_30_DAYS) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.LAST_30_DAYS.getId());
            } else if (keyword == PredefinedKeyWords.LAST_HALF_YEAR) {
                dynamicValue.setHandlerId(StandardRestrictionResourcePropertyDynamicValueHandlers.LAST_6_MONTHS.getId());
            } else {
                throw new RuntimeException(String.format("unsupported keyword %s", new Object[]{keyword}));
            }
            restrictionValue.setValue(dynamicValue);
        }
    }

    private static void handleDynamicSimpleCriterion(RestrictionValue restrictionValue, DynamicFieldValue value, SearchCriterion.SimpleCriterion.Operation operation, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) {
        RestrictionValue.DynamicValue dynamicValue;
        RestrictionsUtil.handleCommonSimpleCriterion(restrictionValue, operation, value, registry);
        RestrictionResourcePropertyDynamicValueHandler handler = Stream.concat(registry.getDynamicValueHandlers().stream(), handlers.stream()).filter(item -> item.getId().equals(value.getId())).findFirst().orElse(null);
        if (handler != null) {
            dynamicValue = new RestrictionValue.DynamicValue();
            dynamicValue.setHandlerId(handler.getId());
            if (handler.getId().equals(StandardRestrictionResourcePropertyDynamicValueHandlers.NOW.getId()) && value.getCorrection() != null) {
                DateCorrection correction = new DateCorrection();
                correction.setValue(((DynamicFieldDateCorrection)value.getCorrection()).getValue());
                if (((DynamicFieldDateCorrection)value.getCorrection()).getUnit() == DynamicFieldDateCorrection.DateCorrectionUnit.HOUR) {
                    correction.setUnit(DateCorrectionUnit.HOUR);
                } else if (((DynamicFieldDateCorrection)value.getCorrection()).getUnit() == DynamicFieldDateCorrection.DateCorrectionUnit.DAY) {
                    correction.setUnit(DateCorrectionUnit.DAY);
                }
                dynamicValue.setParameters(correction);
            }
        } else {
            throw new RuntimeException(String.format("unsupported dynamic field value %s", value.getId()));
        }
        restrictionValue.setValue(dynamicValue);
    }

    private static RestrictionGroup handleBetweenCriterion(SearchCriterion.BetweenCriterion criterion, Class<?> type, RestrictionResourcesRegistry registry) {
        String propertyId = String.format("%s.%s", type.getName(), criterion.getProperty());
        RestrictionResourceProperty property = registry.getProperty(propertyId);
        if (property == null) {
            log.warn(String.format("unsupported property %s", propertyId));
            return null;
        }
        RestrictionValue restrictionValue = new RestrictionValue();
        restrictionValue.setPropertyId(propertyId);
        restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.WITHIN.getId());
        if (Date.class.isAssignableFrom(property.getType())) {
            restrictionValue.setValue(new DateInterval((Date)criterion.getLo(), (Date)criterion.getHi()));
        } else {
            restrictionValue.setValue(new Pair<Object>(criterion.getLo(), criterion.getHi()));
        }
        RestrictionGroup restrictionGroup = new RestrictionGroup();
        restrictionGroup.setType(RestrictionGroupType.SIMPLE);
        restrictionGroup.setValue(restrictionValue);
        return restrictionGroup;
    }

    private static RestrictionGroup handleNotBetweenCriterion(SearchCriterion.NotBetweenCriterion criterion, Class<?> type, RestrictionResourcesRegistry registry) {
        String propertyId = String.format("%s.%s", type.getName(), criterion.getProperty());
        RestrictionResourceProperty property = registry.getProperty(propertyId);
        if (property == null) {
            log.warn(String.format("unsupported property %s", propertyId));
            return null;
        }
        RestrictionValue restrictionValue = new RestrictionValue();
        restrictionValue.setPropertyId(propertyId);
        restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.BEYOND.getId());
        if (Date.class.isAssignableFrom(property.getType())) {
            restrictionValue.setValue(new DateInterval((Date)criterion.getLo(), (Date)criterion.getHi()));
        } else {
            restrictionValue.setValue(new Pair<Object>(criterion.getLo(), criterion.getHi()));
        }
        RestrictionGroup restrictionGroup = new RestrictionGroup();
        restrictionGroup.setType(RestrictionGroupType.SIMPLE);
        restrictionGroup.setValue(restrictionValue);
        return restrictionGroup;
    }

    private static RestrictionGroup handleCheckCriterion(SearchCriterion.CheckCriterion criterion, Class<?> type, RestrictionResourcesRegistry registry) {
        String propertyId = String.format("%s.%s", type.getName(), criterion.getProperty());
        RestrictionResourceProperty property = registry.getProperty(propertyId);
        if (property == null) {
            log.warn(String.format("unsupported property %s", propertyId));
            return null;
        }
        RestrictionValue restrictionValue = new RestrictionValue();
        restrictionValue.setPropertyId(propertyId);
        if (criterion.getCheck() == SearchCriterion.CheckCriterion.Check.IS_EMPTY) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.EMPTY.getId());
        } else if (criterion.getCheck() == SearchCriterion.CheckCriterion.Check.NOT_EMPTY) {
            restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.NOT_EMPTY.getId());
        }
        restrictionValue.setValue(null);
        RestrictionGroup restrictionGroup = new RestrictionGroup();
        restrictionGroup.setType(RestrictionGroupType.SIMPLE);
        restrictionGroup.setValue(restrictionValue);
        return restrictionGroup;
    }

    private static RestrictionGroup handleInCriterion(SearchCriterion.InCriterion criterion, Class<?> type, RestrictionResourcesRegistry registry) {
        String propertyId = String.format("%s.%s", type.getName(), criterion.getProperty());
        RestrictionResourceProperty property = registry.getProperty(propertyId);
        if (property == null) {
            log.warn(String.format("unsupported property %s", propertyId));
            return null;
        }
        RestrictionValue restrictionValue = new RestrictionValue();
        restrictionValue.setPropertyId(propertyId);
        restrictionValue.setConditionId(StandardRestrictionResourcePropertyConditions.EQUALS.getId());
        restrictionValue.setValue(Arrays.asList(criterion.getValues()));
        RestrictionGroup restrictionGroup = new RestrictionGroup();
        restrictionGroup.setType(RestrictionGroupType.SIMPLE);
        restrictionGroup.setValue(restrictionValue);
        return restrictionGroup;
    }
}

