/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rpc;

import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsIgnorableException;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Date;
import java.util.Optional;

public class ServiceException
extends Exception
implements IncidentsIgnorableException {
    private static final long serialVersionUID = -4089375376786918196L;
    private String details;
    private final Date date = new Date();
    private final boolean ignoreIncidents;
    private final boolean forUser;
    private final boolean forAdmin;

    public ServiceException(String message) {
        super(message);
        this.ignoreIncidents = false;
        this.forUser = false;
        this.forAdmin = false;
    }

    public ServiceException(String message, boolean ignoreIncidents) {
        super(message);
        this.ignoreIncidents = ignoreIncidents;
        this.forUser = false;
        this.forAdmin = false;
    }

    public ServiceException(String message, Throwable cause) {
        super(Optional.ofNullable(IncidentsHelper.findCause(cause, Xeption.class)).filter(xe -> xe.getAdminMessage() != null || xe.getEndUserMessage() != null).map(xe -> xe.getEndUserMessage() != null ? xe.getEndUserMessage().toString() : xe.getAdminMessage().toString()).orElse(message));
        this.forUser = Optional.ofNullable(IncidentsHelper.findCause(cause, Xeption.class)).filter(xe -> xe.getEndUserMessage() != null).map(xe -> Boolean.TRUE).orElse(Boolean.FALSE);
        this.forAdmin = Optional.ofNullable(IncidentsHelper.findCause(cause, Xeption.class)).filter(xe -> xe.getAdminMessage() != null).map(xe -> Boolean.TRUE).orElse(Boolean.FALSE);
        this.details = TextUtil.getExceptionStackTrace(cause);
        this.ignoreIncidents = IncidentsLog.isIgnore(cause);
    }

    public ServiceException(Throwable cause) {
        super((String)Optional.ofNullable(IncidentsHelper.findCause(cause, Xeption.class)).filter(xe -> xe.getAdminMessage() != null || xe.getEndUserMessage() != null).map(xe -> xe.getEndUserMessage() != null ? xe.getEndUserMessage().toString() : xe.getAdminMessage().toString()).orElse(null));
        this.forUser = Optional.ofNullable(IncidentsHelper.findCause(cause, Xeption.class)).filter(xe -> xe.getEndUserMessage() != null).map(xe -> Boolean.TRUE).orElse(Boolean.FALSE);
        this.forAdmin = Optional.ofNullable(IncidentsHelper.findCause(cause, Xeption.class)).filter(xe -> xe.getAdminMessage() != null).map(xe -> Boolean.TRUE).orElse(Boolean.FALSE);
        this.details = TextUtil.getExceptionStackTrace(cause);
        this.ignoreIncidents = IncidentsLog.isIgnore(cause);
    }

    public String getDetails() {
        return this.details;
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public boolean isIgnoreIncidents() {
        return this.ignoreIncidents;
    }

    public boolean isForUser() {
        return this.forUser;
    }

    public boolean isForAdmin() {
        return this.forAdmin;
    }

    public String getUserMessage() {
        return this.forUser ? super.getMessage() : null;
    }

    @Override
    public String getMessage() {
        if (this.details == null) {
            return super.getMessage();
        }
        if (super.getMessage() == null) {
            return TextUtil.concat("message: [null], details: ", this.details);
        }
        return TextUtil.concat("message: ", super.getMessage(), ", details: ", this.details);
    }
}

