/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rules.elements;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DebugInfo
implements Serializable,
XCloneable {
    private static final long serialVersionUID = 4931750995860717515L;
    private DebugItem currentNode;
    private final DebugItem rootNode;
    private static final transient DateTimeFormatter DTF_JODA_DATETIME = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public <E extends Enum<E>> void setParameter(E key, Object value) {
        this.parameters.put(key.name(), value);
    }

    public <T, E extends Enum<E>> T getParameter(E key) {
        return (T)this.parameters.get(key.name());
    }

    public DebugInfo() {
        this.rootNode = this.currentNode = new DebugItem("root", null);
    }

    public void startBlock(String blockId) {
        this.currentNode = new DebugItem(blockId, this.currentNode);
    }

    public void message(String msg) {
        this.currentNode.children.add(new NonNlsMessage("info", msg, null));
    }

    public void message(String messageType, String msg, Throwable e) {
        this.currentNode.children.add(new NonNlsMessage(messageType, msg, e));
    }

    public void warning(String msg) {
        this.warning(msg, null);
    }

    public void warning(String msg, Throwable e) {
        this.currentNode.children.add(new NonNlsMessage("warn", msg, e));
    }

    public void error(String msg) {
        this.currentNode.children.add(new NonNlsMessage("error", msg, null));
    }

    public void error(String msg, Throwable e) {
        this.currentNode.children.add(new NonNlsMessage("error", msg, e));
    }

    public void addBlock(DebugInfo block) {
        this.currentNode.children.add(block.rootNode);
    }

    public void endBlock() {
        if (this.currentNode == null) {
            return;
        }
        this.currentNode.endTime = System.currentTimeMillis();
        this.currentNode = this.currentNode.parentNode;
    }

    private void addElement(Element elm, DebugItem data, Set<DebugItem> traced) {
        if (data == null) {
            return;
        }
        if (traced.contains(data)) {
            this.log.warn(String.format("element %s was already traced", data.nodeId));
            return;
        }
        Element nodeElm = elm;
        if (!traced.isEmpty()) {
            nodeElm = XmlUtil.addElement(elm, "node");
            nodeElm.setAttribute("id", data.nodeId);
        }
        nodeElm.setAttribute("start", DTF_JODA_DATETIME.print(data.startTime));
        if (data.endTime > 0L) {
            nodeElm.setAttribute("duration", String.format("%s ms", Long.toString(data.endTime - data.startTime)));
        }
        traced.add(data);
        for (BaseDebugItem obj : data.children) {
            if (obj instanceof NonNlsMessage) {
                NonNlsMessage message = (NonNlsMessage)obj;
                XHelper.writeString(nodeElm, message.tagId, message.exception == null ? message.message : String.format("%s\ndetails:\n", message.message, TextUtil.getExceptionStackTrace(message.exception)), true);
                continue;
            }
            DebugItem child = (DebugItem)obj;
            this.addElement(nodeElm, child, traced);
        }
    }

    public String buildDebugInfo() {
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("DebugData");
        doc.appendChild(root);
        HashSet<DebugItem> traced = new HashSet<DebugItem>();
        root.setAttribute("prepared", DTF_JODA_DATETIME.print(System.currentTimeMillis()));
        this.addElement(root, this.rootNode, traced);
        StringWriter writer = new StringWriter();
        try {
            XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(writer));
        }
        catch (Exception e) {
            this.log.error("unable to trace debug info", (Throwable)e);
        }
        return writer.toString();
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        DebugInfo clone = new DebugInfo();
        clone.rootNode.copyFrom(this.rootNode);
        clone.parameters.putAll(this.parameters);
        return clone;
    }

    static class NonNlsMessage
    implements Serializable,
    BaseDebugItem {
        private static final long serialVersionUID = 7034270262961291239L;
        final String tagId;
        final String message;
        final Throwable exception;

        NonNlsMessage(String id, String msg, Throwable e) {
            this.tagId = id;
            this.message = msg;
            this.exception = e;
        }

        @Override
        public BaseDebugItem clone(DebugItem parent) {
            return new NonNlsMessage(this.tagId, this.message, this.exception);
        }
    }

    static class DebugItem
    implements Serializable,
    BaseDebugItem {
        private static final long serialVersionUID = 2283991739229471152L;
        String nodeId;
        long startTime;
        long endTime;
        final List<BaseDebugItem> children = new ArrayList<BaseDebugItem>();
        DebugItem parentNode;

        DebugItem(String id, DebugItem parent) {
            this.nodeId = id;
            this.parentNode = parent;
            this.startTime = System.currentTimeMillis();
            if (this.parentNode != null) {
                this.parentNode.children.add(this);
            }
        }

        public String toString() {
            return this.parentNode != null ? String.format("%s/%s", this.parentNode, this.nodeId) : this.nodeId;
        }

        public void copyFrom(DebugItem source) {
            this.startTime = source.startTime;
            this.endTime = source.endTime;
            for (BaseDebugItem child : source.children) {
                this.children.add(child.clone(this));
            }
        }

        @Override
        public DebugItem clone(DebugItem parent) {
            DebugItem clone = new DebugItem(this.nodeId, parent);
            clone.copyFrom(this);
            return clone;
        }
    }

    static interface BaseDebugItem {
        public BaseDebugItem clone(DebugItem var1);
    }
}

