/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search;

import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class SearchCriteria
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = -7658839244842982643L;
    private final ArrayList<SearchCriterion> criterions = new ArrayList();
    private final ArrayList<RestrictionGroup> restrictions = new ArrayList();
    private final LinkedHashMap<String, SortOrder> orders = new LinkedHashMap();
    private final LinkedHashMap<String, String> locales = new LinkedHashMap();
    private String freeTextPattern;

    SearchCriteria() {
    }

    public List<SearchCriterion> getCriterions() {
        return this.criterions;
    }

    public ArrayList<RestrictionGroup> getRestrictions() {
        return this.restrictions;
    }

    public Map<String, SortOrder> getOrders() {
        return this.orders;
    }

    public Map<String, String> getLocales() {
        return this.locales;
    }

    public String getFreeTextPattern() {
        return this.freeTextPattern;
    }

    public void setFreeTextPattern(String value) {
        this.freeTextPattern = value;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        this.criterions.clear();
        for (Element criterionElm : XmlUtil.getElements(elm, "criterions/item")) {
            this.criterions.add(SearchCriterion.readFromXML(criterionElm));
        }
        this.restrictions.clear();
        for (Element restrictionElm : XmlUtil.getElements(elm, "restrictions/item")) {
            this.restrictions.add((RestrictionGroup)XHelper.readObject(restrictionElm, "."));
        }
        this.orders.clear();
        for (Element orderElm : XmlUtil.getElements(elm, "orders/item")) {
            this.orders.put(XmlUtil.getValue(orderElm, "@property"), XHelper.readEnum(orderElm, ".", SortOrder.class));
        }
        this.locales.clear();
        for (Element orderElm : XmlUtil.getElements(elm, "locales/item")) {
            this.locales.put(XmlUtil.getValue(orderElm, "@property"), XHelper.readString(orderElm, "."));
        }
        this.freeTextPattern = XHelper.readString(elm, "freeTextPattern");
    }

    @Override
    public void fromXML(XMLStreamReader reader) throws Exception {
        while (reader.nextTag() != 2) {
            String property;
            String tagName = reader.getName().getLocalPart();
            if ("criterions".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        this.criterions.add(SearchCriterion.readFromXML(reader));
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                continue;
            }
            if ("restrictions".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        this.restrictions.add((RestrictionGroup)XSHelper.readObject(reader));
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                continue;
            }
            if ("orders".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        property = reader.getAttributeValue(null, "property");
                        this.orders.put(property, XSHelper.readEnum(reader, SortOrder.class));
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                continue;
            }
            if ("locales".equals(tagName)) {
                while (reader.nextTag() != 2) {
                    if ("item".equals(reader.getName().getLocalPart())) {
                        property = reader.getAttributeValue(null, "property");
                        this.locales.put(property, XSHelper.readString(reader));
                        continue;
                    }
                    XSHelper.skipElement(reader);
                }
                continue;
            }
            if ("freeTextPattern".equals(tagName)) {
                this.freeTextPattern = XSHelper.readString(reader);
                continue;
            }
            XSHelper.skipElement(reader);
        }
    }

    @Override
    public void toXML(Element elm) throws Exception {
        for (SearchCriterion searchCriterion : this.criterions) {
            searchCriterion.toXML(XmlUtil.addElement(elm, "criterions/item"));
        }
        for (RestrictionGroup restrictionGroup : this.restrictions) {
            restrictionGroup.toXML(XmlUtil.addElement(elm, "restrictions/item"));
        }
        for (Map.Entry entry : this.orders.entrySet()) {
            XHelper.writeEnum(elm, "orders/item", (Enum)entry.getValue()).setAttribute("property", (String)entry.getKey());
        }
        for (Map.Entry entry : this.locales.entrySet()) {
            XHelper.writeString(elm, "locales/item", (String)entry.getValue()).setAttribute("property", (String)entry.getKey());
        }
        XHelper.writeString(elm, "freeTextPattern", this.freeTextPattern, true);
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        if (!this.criterions.isEmpty()) {
            writer.writeStartElement("criterions");
            for (SearchCriterion searchCriterion : this.criterions) {
                writer.writeStartElement("item");
                searchCriterion.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (!this.restrictions.isEmpty()) {
            writer.writeStartElement("restrictions");
            for (RestrictionGroup restrictionGroup : this.restrictions) {
                writer.writeStartElement("item");
                restrictionGroup.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (!this.orders.isEmpty()) {
            writer.writeStartElement("orders");
            for (Map.Entry entry : this.orders.entrySet()) {
                XSHelper.writeEnum(writer, "item", (Enum)entry.getValue(), Collections.singletonMap("property", entry.getKey()));
            }
            writer.writeEndElement();
        }
        if (!this.locales.isEmpty()) {
            writer.writeStartElement("locales");
            for (Map.Entry entry : this.locales.entrySet()) {
                XSHelper.writeString(writer, "item", (String)entry.getValue(), Collections.singletonMap("property", entry.getKey()));
            }
            writer.writeEndElement();
        }
        XSHelper.writeString(writer, "freeTextPattern", this.freeTextPattern, true);
    }

    @Override
    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        SearchCriteria clone = (SearchCriteria)this.getClass().newInstance();
        clone.copyFrom(this, newUids, uids);
        return clone;
    }

    void copyFrom(SearchCriteria source, boolean newUids, Map<String, String> uids) throws Exception {
        this.criterions.clear();
        this.criterions.addAll(XCloneHelper.cloneCollection(source.criterions, newUids, uids));
        this.restrictions.clear();
        this.restrictions.addAll(XCloneHelper.cloneCollection(source.restrictions, newUids, uids));
        this.orders.clear();
        this.orders.putAll(XCloneHelper.cloneMap(source.orders, newUids, uids));
        this.locales.clear();
        this.locales.putAll(XCloneHelper.cloneMap(source.locales, newUids, uids));
        this.freeTextPattern = source.freeTextPattern;
    }

    void toString(StringBuilder buf) {
        int count;
        if (!this.criterions.isEmpty() || this.freeTextPattern != null) {
            buf.append(" WHERE ");
            count = 0;
            for (SearchCriterion searchCriterion : this.criterions) {
                if (count > 0) {
                    buf.append(" AND ");
                }
                searchCriterion.toString(buf);
                ++count;
            }
            if (!TextUtil.isBlank(this.freeTextPattern)) {
                if (count > 0) {
                    buf.append(" AND ");
                }
                buf.append("FREETEXT MATCHES \"").append(this.freeTextPattern).append('\"');
            }
        }
        if (!this.restrictions.isEmpty()) {
            // empty if block
        }
        if (!this.orders.isEmpty()) {
            buf.append(" ORDER BY ");
            count = 0;
            for (Map.Entry entry : this.orders.entrySet()) {
                if (count > 0) {
                    buf.append(", ");
                }
                buf.append((String)entry.getKey()).append(' ').append(((SortOrder)((Object)entry.getValue())).name());
                ++count;
            }
        }
    }
}

