/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.search.utils;

import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.SearchCriteria;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryValidator {
    public static String MODE = System.getProperty(SearchQueryValidator.class.getName() + ".mode");
    private static final Logger log = LoggerFactory.getLogger(SearchQueryValidator.class);
    private static final Map<String, String> TYPE_2_CLASS_NAME = new HashMap<String, String>();
    private static final Set<String> MATH_COMPARABLE_TYPES;
    private static final Set<String> TEXT_TYPES;
    private static final Set<String> SPECIAL_PROPERTIES;

    public static <E extends BaseEntity, I extends EntityIndex<E>> void validate(Class<I> cls, SearchQuery query) {
        block4: {
            if (StringUtils.isBlank((String)MODE)) {
                return;
            }
            try {
                IndexType indexType = MetaRegistryHelper.getIndexType(cls.getName());
                SearchQueryValidator.validateCriteria(indexType, query.getCriteria());
                if (query.getOffset() > 0 && query.getCriteria().getOrders().isEmpty()) {
                    throw Xeption.forDeveloper("pagination is unpredictable without sorting", new Object[0]);
                }
            }
            catch (Throwable t) {
                log.error("query validation failed", t);
                if (!"strict".equals(MODE)) break block4;
                throw t;
            }
        }
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> void validate(Class<I> cls, ProjectionQuery query) {
        block5: {
            if (StringUtils.isBlank((String)MODE)) {
                return;
            }
            try {
                IndexType indexType = MetaRegistryHelper.getIndexType(cls.getName());
                SearchQueryValidator.validateCriteria(indexType, query.getCriteria());
                if (query.getProjections().isEmpty()) {
                    throw Xeption.forDeveloper("projection query with no projections", new Object[0]);
                }
                for (Projection projection : query.getProjections()) {
                    SearchQueryValidator.validateProjection(indexType, projection);
                }
            }
            catch (Throwable t) {
                log.error("query validation failed", t);
                if (!"strict".equals(MODE)) break block5;
                throw t;
            }
        }
    }

    private static void validateCriteria(IndexType indexType, SearchCriteria criteria) {
        for (SearchCriterion criterion : criteria.getCriterions()) {
            SearchQueryValidator.validateCriterion(criterion, indexType);
        }
        for (String orderProp : criteria.getOrders().keySet()) {
            if (indexType.getProperties().containsKey(orderProp)) continue;
            throw Xeption.forDeveloper("order property {0} doesn't exist in index {1}", orderProp, indexType.getId());
        }
    }

    private static void validateProjection(IndexType indexType, Projection projection) {
        block6: {
            block7: {
                if (projection instanceof Projection.RowCountProjection) break block6;
                if (!(projection instanceof Projection.SimpleProjection)) break block7;
                Projection.SimpleProjection sp = (Projection.SimpleProjection)projection;
                IndexProperty indexProperty = indexType.getProperties().get(sp.getProperty());
                switch (sp.getOperation()) {
                    case COUNT: 
                    case GROUP: 
                    case PROPERTY: {
                        break;
                    }
                    case AVG: 
                    case MAX: 
                    case MIN: 
                    case SUM: {
                        if (indexProperty == null) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: property {1} doesn't exist in index {2}", sp.getOperation().name(), sp.getProperty(), indexType.getId());
                        }
                        if (!SearchQueryValidator.isMathComparable(indexProperty.getType())) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: property {1} of index {2} has type {3} which is not supported", sp.getOperation().name(), indexProperty.getId(), indexType.getId(), indexProperty.getType());
                        }
                        break block6;
                    }
                    default: {
                        throw Xeption.forDeveloper("SimpleProjection: unexpected operation {0}", sp.getOperation().name());
                    }
                }
                break block6;
            }
            throw Xeption.forDeveloper("unexpected projection class {0}", projection.getClass().getName());
        }
    }

    private static boolean typeMatches(String propertyType, String valueClassName) {
        return SearchQueryValidator.typeMatches(propertyType, valueClassName, false);
    }

    private static boolean typeMatches(String propertyType, String valueClassName, boolean enumAsString) {
        if (MetaRegistryHelper.getEntityType(propertyType) != null) {
            return EntityReference.class.getName().equals(valueClassName);
        }
        if (MetaRegistryHelper.getDictionaryType(propertyType) != null) {
            return DictionaryReference.class.getName().equals(valueClassName) || String.format("%sReference", propertyType).equals(valueClassName);
        }
        if (enumAsString && MetaRegistryHelper.getEnumType(propertyType) != null) {
            return String.class.getName().equals(valueClassName);
        }
        String className = TYPE_2_CLASS_NAME.get(propertyType);
        if (className != null) {
            return className.equals(valueClassName);
        }
        return propertyType.equals(valueClassName);
    }

    private static boolean isMathComparable(String propertyType) {
        String className = TYPE_2_CLASS_NAME.get(propertyType);
        if (className != null) {
            return MATH_COMPARABLE_TYPES.contains(className);
        }
        return MATH_COMPARABLE_TYPES.contains(propertyType);
    }

    private static boolean isTextType(String propertyType) {
        String className = TYPE_2_CLASS_NAME.get(propertyType);
        if (className != null) {
            return TEXT_TYPES.contains(className);
        }
        return TEXT_TYPES.contains(propertyType);
    }

    private static void validateCriterion(SearchCriterion criterion, IndexType indexType) {
        block34: {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block33: {
                                    if (!(criterion instanceof SearchCriterion.BetweenCriterion)) break block33;
                                    SearchCriterion.BetweenCriterion bc = (SearchCriterion.BetweenCriterion)criterion;
                                    IndexProperty indexProperty = indexType.getProperties().get(bc.getProperty());
                                    if (indexProperty == null) {
                                        throw Xeption.forDeveloper("BetweenCriterion: property {0} doesn't exist in index {1}", bc.getProperty(), indexType.getId());
                                    }
                                    if (!SearchQueryValidator.isMathComparable(indexProperty.getType())) {
                                        throw Xeption.forDeveloper("BetweenCriterion: property {0} of index {1} has type {2} which is not supported", indexProperty.getId(), indexType.getId(), indexProperty.getType());
                                    }
                                    if (!SearchQueryValidator.typeMatches(indexProperty.getType(), bc.getLo().getClass().getName())) {
                                        throw Xeption.forDeveloper("BetweenCriterion: lo value type {0} conflicts with type {1} of property {2} of index {3}", bc.getLo().getClass().getName(), indexProperty.getType(), indexProperty.getId(), indexType.getId());
                                    }
                                    if (!SearchQueryValidator.typeMatches(indexProperty.getType(), bc.getHi().getClass().getName())) {
                                        throw Xeption.forDeveloper("BetweenCriterion: hi value type {0} conflicts with type {1} of property {2} of index {3}", bc.getHi().getClass().getName(), indexProperty.getType(), indexProperty.getId(), indexType.getId());
                                    }
                                    break block34;
                                }
                                if (!(criterion instanceof SearchCriterion.CheckCriterion)) break block35;
                                SearchCriterion.CheckCriterion cc = (SearchCriterion.CheckCriterion)criterion;
                                IndexCollection indexCollection = indexType.getCollections().get(cc.getProperty());
                                if (indexCollection == null) {
                                    throw Xeption.forDeveloper("CheckCriterion: collection {0} doesn't exist in index {1}", cc.getProperty(), indexType.getId());
                                }
                                break block34;
                            }
                            if (!(criterion instanceof SearchCriterion.InCriterion)) break block36;
                            SearchCriterion.InCriterion ic = (SearchCriterion.InCriterion)criterion;
                            IndexProperty indexProperty = indexType.getProperties().get(ic.getProperty());
                            if (indexProperty == null) {
                                throw Xeption.forDeveloper("InCriterion: property {0} doesn't exist in index {1}", ic.getProperty(), indexType.getId());
                            }
                            if (ic.getValues().length == 0) {
                                throw Xeption.forDeveloper("InCriterion: empty values", new Object[0]);
                            }
                            for (int i = 0; i < ic.getValues().length; ++i) {
                                if (SearchQueryValidator.typeMatches(indexProperty.getType(), ic.getValues()[i].getClass().getName())) continue;
                                throw Xeption.forDeveloper("InCriterion: values[{0}] type {1} conflicts with type {2} of property {3} of index {4}", i, ic.getValues()[i].getClass().getName(), indexProperty.getType(), indexProperty.getId(), indexType.getId());
                            }
                            break block34;
                        }
                        if (!(criterion instanceof SearchCriterion.JunctionCriterion)) break block37;
                        SearchCriterion.JunctionCriterion jc = (SearchCriterion.JunctionCriterion)criterion;
                        for (SearchCriterion sc : jc.getCriterions()) {
                            SearchQueryValidator.validateCriterion(sc, indexType);
                        }
                        break block34;
                    }
                    if (!(criterion instanceof SearchCriterion.NotCriterion)) break block38;
                    SearchCriterion.NotCriterion nc = (SearchCriterion.NotCriterion)criterion;
                    SearchQueryValidator.validateCriterion(nc.getCriterion(), indexType);
                    break block34;
                }
                if (!(criterion instanceof SearchCriterion.SimpleCriterion)) break block39;
                SearchCriterion.SimpleCriterion sc = (SearchCriterion.SimpleCriterion)criterion;
                IndexProperty indexProperty = indexType.getProperties().get(sc.getProperty());
                IndexCollection indexCollection = indexType.getCollections().get(sc.getProperty());
                switch (sc.getOperation()) {
                    case GE: 
                    case GT: 
                    case LE: 
                    case LT: {
                        if (indexProperty == null) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: property {1} doesn't exist in index {2}", sc.getOperation().name(), sc.getProperty(), indexType.getId());
                        }
                        if (!SearchQueryValidator.isMathComparable(indexProperty.getType())) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: property {1} of index {2} has type {3} which is not supported", sc.getOperation().name(), indexProperty.getId(), indexType.getId(), indexProperty.getType());
                        }
                        if (!SearchQueryValidator.typeMatches(indexProperty.getType(), sc.getValue().getClass().getName())) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: value type {1} conflicts with type {2} of property {3} of index {4}", sc.getOperation().name(), sc.getValue().getClass().getName(), indexProperty.getType(), indexProperty.getId(), indexType.getId());
                        }
                        break block34;
                    }
                    case BEGINS: 
                    case ENDS: 
                    case ICONTAINS: {
                        if (indexCollection == null) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: collection {1} doesn't exist in index {2}", sc.getOperation().name(), sc.getProperty(), indexType.getId());
                        }
                        if (!SearchQueryValidator.isTextType(indexCollection.getElementType())) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: collection {1} of index {2} has element type {3} which is not supported", sc.getOperation().name(), indexCollection.getId(), indexType.getId(), indexCollection.getElementType());
                        }
                        if (!SearchQueryValidator.typeMatches(indexCollection.getElementType(), sc.getValue().getClass().getName())) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: value type {1} conflicts with element type {2} of collection {3} of index {4}", sc.getOperation().name(), sc.getValue().getClass().getName(), indexCollection.getElementType(), indexCollection.getId(), indexType.getId());
                        }
                        break block34;
                    }
                    case CONTAINS: 
                    case CONTAINS_ONLY: {
                        if (indexCollection == null) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: collection {1} doesn't exist in index {2}", sc.getOperation().name(), sc.getProperty(), indexType.getId());
                        }
                        if (!SearchQueryValidator.isTextType(indexCollection.getElementType()) && MetaRegistryHelper.getEnumType(indexCollection.getElementType()) == null) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: collection {1} of index {2} has element type {3} which is not supported", sc.getOperation().name(), indexCollection.getId(), indexType.getId(), indexCollection.getElementType());
                        }
                        if (!SearchQueryValidator.typeMatches(indexCollection.getElementType(), sc.getValue().getClass().getName(), true)) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: value type {1} conflicts with element type {2} of collection {3} of index {4}", sc.getOperation().name(), sc.getValue().getClass().getName(), indexCollection.getElementType(), indexCollection.getId(), indexType.getId());
                        }
                        break block34;
                    }
                    case LIKE: 
                    case ILIKE: {
                        if (indexProperty == null && indexCollection == null) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: neither property nor collection {1} doesn't exist in index {2}", sc.getOperation().name(), sc.getProperty(), indexType.getId());
                        }
                        if (indexProperty != null) {
                            if (!SearchQueryValidator.isTextType(indexProperty.getType())) {
                                throw Xeption.forDeveloper("SimpleCriterion / {0}: property {1} of index {2} has type {3} which is not supported", sc.getOperation().name(), indexProperty.getId(), indexType.getId(), indexProperty.getType());
                            }
                            if (!SearchQueryValidator.typeMatches(indexProperty.getType(), sc.getValue().getClass().getName())) {
                                throw Xeption.forDeveloper("SimpleCriterion / {0}: value type {1} conflicts with type {2} of property {3} of index {4}", sc.getOperation().name(), sc.getValue().getClass().getName(), indexProperty.getType(), indexProperty.getId(), indexType.getId());
                            }
                        } else {
                            if (!SearchQueryValidator.isTextType(indexCollection.getElementType())) {
                                throw Xeption.forDeveloper("SimpleCriterion / {0}: collection {1} of index {2} has element type {3} which is not supported", sc.getOperation().name(), indexCollection.getId(), indexType.getId(), indexCollection.getElementType());
                            }
                            if (!SearchQueryValidator.typeMatches(indexCollection.getElementType(), sc.getValue().getClass().getName(), true)) {
                                throw Xeption.forDeveloper("SimpleCriterion / {0}: value type {1} conflicts with element type {2} of collection {3} of index {4}", sc.getOperation().name(), sc.getValue().getClass().getName(), indexCollection.getElementType(), indexCollection.getId(), indexType.getId());
                            }
                        }
                        break block34;
                    }
                    case EQ: 
                    case NE: {
                        if (indexProperty == null && !SPECIAL_PROPERTIES.contains(sc.getProperty())) {
                            throw Xeption.forDeveloper("SimpleCriterion / {0}: property {1} doesn't exist in index {2}", sc.getOperation().name(), sc.getProperty(), indexType.getId());
                        }
                        break block34;
                    }
                    default: {
                        throw Xeption.forDeveloper("SimpleCriterion: unexpected operation {0}", sc.getOperation().name());
                    }
                }
            }
            throw Xeption.forDeveloper("unexpected criterion class {0}", criterion.getClass().getName());
        }
    }

    static {
        TYPE_2_CLASS_NAME.put(MiscUtil.getSimpleClassName(Byte.class), Byte.class.getName());
        TYPE_2_CLASS_NAME.put(MiscUtil.getSimpleClassName(Short.class), Short.class.getName());
        TYPE_2_CLASS_NAME.put(MiscUtil.getSimpleClassName(Integer.class), Integer.class.getName());
        TYPE_2_CLASS_NAME.put(MiscUtil.getSimpleClassName(Long.class), Long.class.getName());
        TYPE_2_CLASS_NAME.put(MiscUtil.getSimpleClassName(String.class), String.class.getName());
        MATH_COMPARABLE_TYPES = new HashSet<String>();
        MATH_COMPARABLE_TYPES.add(Byte.class.getName());
        MATH_COMPARABLE_TYPES.add(Byte.TYPE.getName());
        MATH_COMPARABLE_TYPES.add(Short.class.getName());
        MATH_COMPARABLE_TYPES.add(Short.TYPE.getName());
        MATH_COMPARABLE_TYPES.add(Integer.class.getName());
        MATH_COMPARABLE_TYPES.add(Integer.TYPE.getName());
        MATH_COMPARABLE_TYPES.add(Long.class.getName());
        MATH_COMPARABLE_TYPES.add(Long.TYPE.getName());
        MATH_COMPARABLE_TYPES.add(BigInteger.class.getName());
        MATH_COMPARABLE_TYPES.add(BigDecimal.class.getName());
        MATH_COMPARABLE_TYPES.add(Date.class.getName());
        MATH_COMPARABLE_TYPES.add(LocalDate.class.getName());
        MATH_COMPARABLE_TYPES.add(LocalTime.class.getName());
        MATH_COMPARABLE_TYPES.add(LocalDateTime.class.getName());
        MATH_COMPARABLE_TYPES.add(DateTime.class.getName());
        TEXT_TYPES = new HashSet<String>();
        TEXT_TYPES.add(String.class.getName());
        SPECIAL_PROPERTIES = new HashSet<String>();
        SPECIAL_PROPERTIES.add("containerUid");
        SPECIAL_PROPERTIES.add("navigationKey");
    }
}

