/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.security.acl.entry;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class AclEntry
extends BaseAsset {
    private static final long serialVersionUID = -2276384584940932245L;
    private String principalId;
    private String resourceId;
    private final List<AclRule> rules = new ArrayList<AclRule>();

    public AclEntry() {
    }

    public AclEntry(String uid) {
        super(uid);
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public List<AclRule> getRules() {
        return this.rules;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.principalId = XHelper.readString(elm, "principalId");
        this.resourceId = XHelper.readString(elm, "resourceId");
        this.rules.clear();
        for (Element element : XmlUtil.getElements(elm, "rules/item")) {
            AclRule restriction = (AclRule)XHelper.readObject(element, ".");
            if (restriction == null) continue;
            this.rules.add(restriction);
        }
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("principalId".equals(tagName)) {
            this.principalId = XSHelper.readString(reader);
            return true;
        }
        if ("resourceId".equals(tagName)) {
            this.resourceId = XSHelper.readString(reader);
            return true;
        }
        if ("rules".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    AclRule restriction = (AclRule)XSHelper.readObject(reader);
                    if (restriction == null) continue;
                    this.rules.add(restriction);
                    continue;
                }
                XSHelper.skipElement(reader);
            }
            return true;
        }
        return false;
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeString(elm, "principalId", this.principalId);
        XHelper.writeString(elm, "resourceId", this.resourceId);
        for (AclRule rule : this.rules) {
            XHelper.writeObject(elm, "rules/item", rule);
        }
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "principalId", this.principalId);
        XSHelper.writeString(writer, "resourceId", this.resourceId);
        if (!this.rules.isEmpty()) {
            writer.writeStartElement("rules");
            for (AclRule rule : this.rules) {
                XSHelper.writeObject(writer, "item", rule);
            }
            writer.writeEndElement();
        }
    }

    @Override
    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        AclEntry source = (AclEntry)sourceAsset;
        this.principalId = source.principalId;
        this.resourceId = source.resourceId;
        this.rules.clear();
        this.rules.addAll(XCloneHelper.cloneCollection(source.rules, newUids, uids));
    }

    @Override
    public String toString() {
        return String.format("%s/%s", this.principalId, this.resourceId);
    }

    public static enum Property {
        principalId,
        resourceId,
        rules;

    }
}

