/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.security.acl.util;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclPrincipal;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.security.acl.resource.AclResource;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceOperation;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AclUtil {
    private static final Comparator<AclPrincipal> _principalComparator = new Comparator<AclPrincipal>(){

        @Override
        public int compare(AclPrincipal o1, AclPrincipal o2) {
            return MiscUtil.compare(o1.getName(), o2.getName());
        }
    };
    private static final Comparator<AclResource> _resourceComparator = new Comparator<AclResource>(){

        @Override
        public int compare(AclResource o1, AclResource o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<AclResourceProperty> _propertiesComparator = new Comparator<AclResourceProperty>(){

        @Override
        public int compare(AclResourceProperty o1, AclResourceProperty o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<AclResourcePropertyCondition> _conditionsComparator = new Comparator<AclResourcePropertyCondition>(){

        @Override
        public int compare(AclResourcePropertyCondition o1, AclResourcePropertyCondition o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<AclResourceOperation> _operationsComparator = new Comparator<AclResourceOperation>(){

        @Override
        public int compare(AclResourceOperation o1, AclResourceOperation o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public static boolean isSpecialRoot(AclGroup group) {
        return group.equals(AclHelper.all);
    }

    public static boolean isSameGroups(AclGroup ancestor, AclGroup descendant) {
        if (ancestor == null || descendant == null) {
            return false;
        }
        return ancestor.equals(descendant);
    }

    public static boolean isAncestorGroup(AclGroup group, AclGroup descendant) {
        return AclUtil.isRelativeGroups(group, descendant);
    }

    public static boolean isDescendantGroup(AclGroup object, AclGroup ancestor) {
        return AclUtil.isRelativeGroups(ancestor, object);
    }

    public static boolean isRelativeGroups(AclGroup ancestor, AclGroup descendant) {
        if (ancestor == null || descendant == null) {
            return false;
        }
        AclGroup parent = descendant;
        while ((parent = AclHelper.getGroup(parent.getParentId())) != null) {
            if (!parent.equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    public static String toPrincipalsTreeString() {
        ArrayList<AclGroup> rootGroups = new ArrayList<AclGroup>(AclHelper.getRootGroups());
        ArrayList<AclUser> rootUsers = new ArrayList<AclUser>(AclHelper.getRootUsers());
        StringBuilder stringBuilder = new StringBuilder();
        AclUtil.toPrincipalsTreeString(stringBuilder, rootGroups, rootUsers, _principalComparator, _principalComparator, "", true);
        return stringBuilder.toString();
    }

    private static void toPrincipalsTreeString(StringBuilder stringBuilder, List<AclGroup> groups, List<AclUser> users, Comparator<AclPrincipal> groupComparator, Comparator<AclPrincipal> userComparator, String prefix, boolean root) {
        int count = 0;
        int amount = groups.size() + users.size();
        if (groupComparator != null) {
            Collections.sort(groups, groupComparator);
        }
        if (userComparator != null) {
            Collections.sort(users, userComparator);
        }
        for (AclGroup group : groups) {
            stringBuilder.append(AclUtil.getPrefix(prefix, count, amount, root, false) + group + "\n");
            ArrayList<AclGroup> groupChildren = new ArrayList<AclGroup>(AclHelper.getGroupChildren(group.getId()));
            ArrayList<AclUser> groupUsers = new ArrayList<AclUser>(AclHelper.getGroupUsers(group.getId()));
            AclUtil.toPrincipalsTreeString(stringBuilder, groupChildren, groupUsers, groupComparator, userComparator, AclUtil.getPrefix(prefix, count, amount, root, true), false);
            ++count;
        }
        for (AclUser user : users) {
            stringBuilder.append(AclUtil.getPrefix(prefix, count, amount, root, false) + "*" + user + "\n");
            ++count;
        }
    }

    private static String getPrefix(String prefix, int count, int amount, boolean root, boolean transit) {
        return root ? prefix : prefix + (count < amount - 1 ? (transit ? " \u2502  " : " \u251c\u2500\u2500") : (transit ? "    " : " \u2514\u2500\u2500"));
    }

    public static String toResourcesTreeString(boolean detailed) {
        AclResourcesEnvironment environment = Environment.getPublished(AclResourcesEnvironment.class);
        StringBuilder tree = new StringBuilder();
        AclUtil.toResourcesTreeString(environment, new ArrayList<AclResource>(environment.getRootResources()), tree, "", detailed);
        return tree.toString();
    }

    private static void toResourcesTreeString(AclResourcesEnvironment environment, List<AclResource> resources, StringBuilder tree, String offset, boolean detailed) {
        if (resources.isEmpty()) {
            return;
        }
        Collections.sort(resources, _resourceComparator);
        for (AclResource resource : resources) {
            tree.append(offset);
            tree.append(resource.getId());
            if (detailed) {
                ArrayList<AclResourceProperty> properties = new ArrayList<AclResourceProperty>();
                for (String string : environment.getResourceProperties(resource.getId())) {
                    AclResourceProperty property = environment.getProperty(string);
                    if (property == null) continue;
                    properties.add(property);
                }
                tree.append(AclUtil.toStringProperties(environment, properties));
                ArrayList<AclResourceOperation> operations = new ArrayList<AclResourceOperation>();
                for (String operationId : environment.getResourceOperations(resource.getId())) {
                    AclResourceOperation operation = environment.getOperation(operationId);
                    if (operation == null) continue;
                    operations.add(operation);
                }
                tree.append(AclUtil.toStringOperations(environment, operations));
            }
            tree.append("\n");
            ArrayList<AclResource> children = new ArrayList<AclResource>();
            for (String string : environment.getResourceChildren(resource.getId())) {
                AclResource child = environment.getResource(string);
                if (child == null) continue;
                children.add(child);
            }
            AclUtil.toResourcesTreeString(environment, children, tree, offset + "    ", detailed);
        }
    }

    private static String toStringProperties(AclResourcesEnvironment environment, List<AclResourceProperty> properties) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[properties=");
        Collections.sort(properties, _propertiesComparator);
        boolean first = true;
        for (AclResourceProperty property : properties) {
            if (!first) {
                stringBuilder.append(",");
            }
            stringBuilder.append(property.getId());
            ArrayList<AclResourcePropertyCondition> conditions = new ArrayList<AclResourcePropertyCondition>();
            for (String conditionId : environment.getPropertyConditions(property.getId())) {
                AclResourcePropertyCondition condition = environment.getCondition(conditionId);
                if (condition == null) continue;
                conditions.add(condition);
            }
            stringBuilder.append(AclUtil.toStringConditions(environment, conditions));
            first = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String toStringConditions(AclResourcesEnvironment environment, List<AclResourcePropertyCondition> conditions) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[conditions=");
        Collections.sort(conditions, _conditionsComparator);
        boolean first = true;
        for (AclResourcePropertyCondition condition : conditions) {
            if (!first) {
                stringBuilder.append(",");
            }
            stringBuilder.append(condition.getId());
            first = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String toStringOperations(AclResourcesEnvironment environment, List<AclResourceOperation> operations) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[operations=");
        Collections.sort(operations, _operationsComparator);
        boolean first = true;
        for (AclResourceOperation operation : operations) {
            if (!first) {
                stringBuilder.append(",");
            }
            stringBuilder.append(operation.getId());
            first = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

