/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.service.impl;

import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.TextUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceFacadeImpl
implements ExecutorServiceFacade {
    protected static final Logger log = LoggerFactory.getLogger(ExecutorServiceFacadeImpl.class);
    private final ThreadPoolExecutorEx service;
    private static final Field threadLocalsField;

    public ExecutorServiceFacadeImpl() {
        this.service = this.createNewCachedThreadPool("common");
    }

    public ExecutorServiceFacadeImpl(ThreadPoolExecutorEx service) {
        this.service = service;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.service.submit(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.service.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.service.invokeAll(tasks);
    }

    @Override
    public void execute(Runnable command) {
        this.service.execute(command);
    }

    @Override
    public ExecutorServiceFacade newCachedThreadPool(String owner) {
        return new ExecutorServiceFacadeImpl(this.createNewCachedThreadPool(owner));
    }

    @Override
    public ExecutorServiceFacade newCachedThreadPool(String owner, int nThreads) {
        return new ExecutorServiceFacadeImpl(this.createNewCachedThreadPool(owner, nThreads));
    }

    @Override
    public ExecutorServiceFacade newFixedThreadPool(String owner, int nThreads) {
        return new ExecutorServiceFacadeImpl(this.createNewFixedThreadPool(owner, nThreads));
    }

    @Override
    public ExecutorServiceFacade newFixedThreadPool(String owner, int minThreads, int maxThreads) {
        return new ExecutorServiceFacadeImpl(this.createNewFixedThreadPool(owner, minThreads, maxThreads));
    }

    @Override
    public ExecutorServiceFacade newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new ExecutorServiceFacadeImpl(this.createNewFixedThreadPool(nThreads, threadFactory));
    }

    @Override
    public void initiateShutdown() {
        this.service.shutdownNow();
    }

    @Override
    public boolean canShutdown() {
        return this.service.getActiveCount() == 0;
    }

    @Override
    public void dispose() {
        if (this.service.isTerminated()) {
            return;
        }
        if (!this.service.isTerminating()) {
            this.service.shutdownNow();
        }
        try {
            if (!this.service.awaitTermination(5000L, TimeUnit.SECONDS)) {
                log.error("pool did not terminate");
            }
        }
        catch (InterruptedException ie) {
            log.warn("executor service dispose interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    protected ThreadPoolExecutorEx createNewCachedThreadPool(String owner) {
        return new ThreadPoolExecutorEx(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ExecutorServiceFacadeImpl.defaultThreadFactory(owner));
    }

    protected ThreadPoolExecutorEx createNewCachedThreadPool(String owner, int nThreads) {
        return new ThreadPoolExecutorEx(0, nThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ExecutorServiceFacadeImpl.defaultThreadFactory(owner));
    }

    protected ThreadPoolExecutorEx createNewFixedThreadPool(String owner, int nThreads) {
        return new ThreadPoolExecutorEx(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ExecutorServiceFacadeImpl.defaultThreadFactory(owner));
    }

    protected ThreadPoolExecutorEx createNewFixedThreadPool(String owner, int minThreads, int maxThreads) {
        return new ThreadPoolExecutorEx(minThreads, maxThreads, 60L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ExecutorServiceFacadeImpl.defaultThreadFactory(owner));
    }

    protected ThreadPoolExecutorEx createNewFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new ThreadPoolExecutorEx(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    protected static ThreadFactory defaultThreadFactory(String owner) {
        return new DefaultThreadFactory(owner);
    }

    public static void clearThreadLocals(Thread thread) throws Exception {
        threadLocalsField.set(thread, null);
    }

    static {
        try {
            threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
        }
        catch (Exception e) {
            log.error("error while acquire thread locals field", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public DefaultThreadFactory(String owner) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + (TextUtil.nonBlank(owner) ? owner : "(unknown)") + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    protected static class ThreadPoolExecutorEx
    extends ThreadPoolExecutor {
        public ThreadPoolExecutorEx(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            try {
                ExecutorServiceFacadeImpl.clearThreadLocals(Thread.currentThread());
            }
            catch (Exception e) {
                log.error("error while clear thread locals", (Throwable)e);
            }
        }
    }
}

