/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.update;

import com.gridnine.xtrip.common.update.UpdateEntry;
import com.gridnine.xtrip.common.update.UpdateItem;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.w3c.dom.Element;

public final class UpdateFile
implements UpdateItem,
XSerializable,
Serializable {
    private static final long serialVersionUID = 6311329825121922432L;
    private String name;
    private String checkSum;
    private long size;
    private Date modified;
    private final Collection<UpdateEntry> entries = new ArrayList<UpdateEntry>();

    public UpdateFile(File file) throws Exception {
        this.name = file.getName();
        this.size = file.length();
        this.checkSum = MiscUtil.getCheckSum(IoUtil.file2url(file), true);
        this.modified = new Date(file.lastModified());
    }

    public UpdateFile() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCheckSum() {
        return this.checkSum;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void setSize(long value) {
        this.size = value;
    }

    @Override
    public Date getModified() {
        return this.modified;
    }

    public Collection<UpdateEntry> getEntries() {
        return this.entries;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdateFile)) {
            return false;
        }
        UpdateFile other = (UpdateFile)obj;
        return TextUtil.isSame(this.checkSum, other.getCheckSum());
    }

    public int hashCode() {
        int result = Long.valueOf(this.size).hashCode();
        if (this.checkSum != null) {
            result ^= this.checkSum.hashCode();
        }
        return result;
    }

    @Override
    public void fromXML(Element elm) {
        this.checkSum = XHelper.readString(elm, "@checkSum");
        this.name = XHelper.readString(elm, "@name");
        this.size = XHelper.readLong(elm, "@size", 0L);
        Long modifiedValue = XHelper.readLong(elm, "@modified");
        this.modified = modifiedValue == null ? null : new Date(modifiedValue);
        this.entries.clear();
        for (Element itemElm : XmlUtil.getElements(elm, "entry")) {
            UpdateEntry entry = new UpdateEntry(this);
            entry.fromXML(itemElm);
            this.entries.add(entry);
        }
    }

    @Override
    public void toXML(Element elm) {
        elm.setAttribute("name", this.name);
        elm.setAttribute("checkSum", this.checkSum);
        elm.setAttribute("size", Long.toString(this.size));
        if (this.modified != null) {
            elm.setAttribute("modified", Long.toString(this.modified.getTime()));
        } else {
            elm.removeAttribute("modified");
        }
        for (UpdateEntry item : this.entries) {
            item.toXML(XmlUtil.addElement(elm, "entry"));
        }
    }
}

