/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.update.UpdateFile;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateIndexFile
implements XSerializable,
Serializable {
    private static final long serialVersionUID = 1399234924662188561L;
    private UpdateFile setupFile;
    private final List<UpdateFile> commonPlugins = new ArrayList<UpdateFile>();
    private final List<UpdateFile> serverPlugins = new ArrayList<UpdateFile>();
    private final List<UpdateFile> clientPlugins = new ArrayList<UpdateFile>();
    private final List<UpdateFile> clientJRE = new ArrayList<UpdateFile>();
    private String checkSumCommonPlugins;
    private String checkSumServerPlugins;
    private String checkSumClientPlugins;
    private String comment;
    private String checkSum;

    public static UpdateIndexFile get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(UpdateIndexFile.class);
    }

    private static String calculateCheckSum(UpdateFile ... files) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (UpdateFile file : files) {
            baos.write(Base64.decode(file.getCheckSum()));
        }
        return MiscUtil.getCheckSum(baos.toByteArray());
    }

    private static List<UpdateFile> collectFiles(Element[] elements) {
        ArrayList<UpdateFile> result = new ArrayList<UpdateFile>();
        for (Element elm : elements) {
            UpdateFile updateFile = new UpdateFile();
            updateFile.fromXML(elm);
            result.add(updateFile);
        }
        return result;
    }

    public UpdateFile getSetupFile() {
        return this.setupFile;
    }

    public void setSetupFile(UpdateFile value) {
        this.setupFile = value;
    }

    public List<UpdateFile> getClientJRE() {
        return this.clientJRE;
    }

    public List<UpdateFile> getCommonPlugins() {
        return this.commonPlugins;
    }

    public List<UpdateFile> getServerPlugins() {
        return this.serverPlugins;
    }

    public List<UpdateFile> getClientPlugins() {
        return this.clientPlugins;
    }

    public void updateCheckSums() throws Exception {
        this.checkSumCommonPlugins = UpdateIndexFile.calculateCheckSum(this.commonPlugins.toArray(new UpdateFile[this.commonPlugins.size()]));
        this.checkSumServerPlugins = UpdateIndexFile.calculateCheckSum(this.serverPlugins.toArray(new UpdateFile[this.serverPlugins.size()]));
        this.checkSumClientPlugins = UpdateIndexFile.calculateCheckSum(this.clientPlugins.toArray(new UpdateFile[this.clientPlugins.size()]));
        ArrayList<UpdateFile> allFiles = new ArrayList<UpdateFile>();
        allFiles.addAll(this.commonPlugins);
        allFiles.addAll(this.serverPlugins);
        allFiles.addAll(this.clientPlugins);
        allFiles.addAll(this.clientJRE);
        if (this.setupFile != null) {
            allFiles.add(this.setupFile);
        }
        this.checkSum = UpdateIndexFile.calculateCheckSum(allFiles.toArray(new UpdateFile[allFiles.size()]));
    }

    public String getCheckSumCommonPlugins() {
        return this.checkSumCommonPlugins;
    }

    public String getCheckSumServerPlugins() {
        return this.checkSumServerPlugins;
    }

    public String getCheckSumClientPlugins() {
        return this.checkSumClientPlugins;
    }

    public String getCheckSum() {
        return this.checkSum;
    }

    @Override
    public void fromXML(Element elm) {
        Element setupElm = XmlUtil.getElement(elm, "setup/file");
        if (setupElm != null) {
            this.setupFile = new UpdateFile();
            this.setupFile.fromXML(setupElm);
        } else {
            this.setupFile = null;
        }
        this.clientJRE.clear();
        this.clientJRE.addAll(UpdateIndexFile.collectFiles(XmlUtil.getElements(elm, "jre/client/file")));
        this.commonPlugins.clear();
        this.commonPlugins.addAll(UpdateIndexFile.collectFiles(XmlUtil.getElements(elm, "plugins/common/file")));
        this.serverPlugins.clear();
        this.serverPlugins.addAll(UpdateIndexFile.collectFiles(XmlUtil.getElements(elm, "plugins/server/file")));
        this.clientPlugins.clear();
        this.clientPlugins.addAll(UpdateIndexFile.collectFiles(XmlUtil.getElements(elm, "plugins/client/file")));
        this.checkSumCommonPlugins = XHelper.readString(elm, "plugins/common@checkSum");
        this.checkSumServerPlugins = XHelper.readString(elm, "plugins/server@checkSum");
        this.checkSumClientPlugins = XHelper.readString(elm, "plugins/client@checkSum");
        this.checkSum = XHelper.readString(elm, "checkSum");
        this.comment = XHelper.readString(elm, "comment");
    }

    @Override
    public void toXML(Element elm) {
        if (this.setupFile != null) {
            this.setupFile.toXML(XmlUtil.addElement(elm, "setup/file"));
        }
        for (UpdateFile file : this.clientJRE) {
            file.toXML(XmlUtil.addElement(elm, "jre/client/file"));
        }
        if (!TextUtil.isBlank(this.checkSumCommonPlugins)) {
            XmlUtil.addElement(elm, "plugins/common").setAttribute("checkSum", this.checkSumCommonPlugins);
        }
        for (UpdateFile file : this.commonPlugins) {
            file.toXML(XmlUtil.addElement(elm, "plugins/common/file"));
        }
        if (!TextUtil.isBlank(this.checkSumServerPlugins)) {
            XmlUtil.addElement(elm, "plugins/server").setAttribute("checkSum", this.checkSumServerPlugins);
        }
        for (UpdateFile file : this.serverPlugins) {
            file.toXML(XmlUtil.addElement(elm, "plugins/server/file"));
        }
        if (!TextUtil.isBlank(this.checkSumClientPlugins)) {
            XmlUtil.addElement(elm, "plugins/client").setAttribute("checkSum", this.checkSumClientPlugins);
        }
        for (UpdateFile file : this.clientPlugins) {
            file.toXML(XmlUtil.addElement(elm, "plugins/client/file"));
        }
        XHelper.writeString(elm, "checkSum", this.checkSum);
        XHelper.writeDate(elm, "timeStamp", new Date());
        XHelper.writeString(elm, "comment", this.comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToXml(File file) throws Exception {
        Document document = DocumentBuilderHelper.newDocument();
        document.appendChild(document.createElement("application"));
        this.toXML(document.getDocumentElement());
        try (FileOutputStream os = new FileOutputStream(file);){
            XUtil.newTransformer().transform(new DOMSource(document), new StreamResult(os));
        }
    }

    public boolean readFromXml(URL url) throws Exception {
        this.clear();
        if (url == null || !IoUtil.isResourceExists(url)) {
            return false;
        }
        try (InputStream strm = IoUtil.getResourceInputStream(url);){
            this.fromXML(DocumentBuilderHelper.parse(strm).getDocumentElement());
        }
        return true;
    }

    private void clear() {
        this.setupFile = null;
        this.clientJRE.clear();
        this.commonPlugins.clear();
        this.clientPlugins.clear();
        this.serverPlugins.clear();
        this.checkSumCommonPlugins = null;
        this.checkSumServerPlugins = null;
        this.checkSumClientPlugins = null;
        this.checkSum = null;
    }

    public void readFromStream(InputStream strm) throws Exception {
        this.clear();
        this.fromXML(DocumentBuilderHelper.parse(strm).getDocumentElement());
    }

    public Date getModified() {
        Date modified = null;
        for (UpdateFile file : this.clientJRE) {
            if (modified != null && modified.compareTo(file.getModified()) >= 0) continue;
            modified = file.getModified();
        }
        for (UpdateFile file : this.commonPlugins) {
            if (modified != null && modified.compareTo(file.getModified()) >= 0) continue;
            modified = file.getModified();
        }
        for (UpdateFile file : this.serverPlugins) {
            if (modified != null && modified.compareTo(file.getModified()) >= 0) continue;
            modified = file.getModified();
        }
        for (UpdateFile file : this.clientPlugins) {
            if (modified != null && modified.compareTo(file.getModified()) >= 0) continue;
            modified = file.getModified();
        }
        return modified;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    private static class Holder {
        public static final UpdateIndexFile INSTANCE = Environment.getPublished(UpdateIndexFile.class);

        private Holder() {
        }
    }
}

