/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthUtil {
    private static final char[] SKEY = "KFtBZ)ZeDxa7xRt]95GVKtf3mO7M(0".toCharArray();
    private static final Logger log = LoggerFactory.getLogger(AuthUtil.class);

    public static String[] decryptToken(Serializable tokenObj) {
        String[] arr;
        if (Objects.isNull(tokenObj)) {
            return null;
        }
        String token = (String)((Object)tokenObj);
        if (TextUtil.isBlank(token)) {
            if (log.isErrorEnabled()) {
                log.error("auth token is blank");
            }
            return null;
        }
        try {
            String decrypted = DesUtil.decrypt(SKEY, token);
            arr = decrypted.split("\\|");
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("token decrypting failed, token=" + token, (Throwable)e);
            }
            return null;
        }
        if (arr == null || arr.length != 2 || TextUtil.isBlank(arr[0]) || TextUtil.isBlank(arr[1])) {
            if (log.isErrorEnabled()) {
                log.error("auth token has invalid format, token=" + token);
            }
            return null;
        }
        return arr;
    }

    public static String buildAuthToken(String userName, char[] password) throws Exception {
        return DesUtil.encrypt(SKEY, userName + '|' + String.valueOf(password));
    }
}

