/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.EqualsObjectFilter;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectFilter;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CollectionUtil {
    private static final Equator<?, ?> BY_EQUALS_EQUATOR = new Equator(){

        public boolean equal(Object o1, Object o2) {
            return MiscUtil.equals(o1, o2);
        }
    };

    public static <I extends Identity> I find(Iterable<I> coll, String uid) {
        if (uid == null) {
            return null;
        }
        for (Identity item : coll) {
            if (!uid.equals(item.getUid())) continue;
            return (I)item;
        }
        return null;
    }

    public static <I extends Identity> List<String> getUids(Collection<I> coll) {
        if (CollectionUtil.isEmpty(coll)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Identity item : coll) {
            result.add(item.getUid());
        }
        return result;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CollectionUtil.isEmpty(coll);
    }

    public static String[] getEnumNames(Class<? extends Enum<?>> cls) {
        Enum<?>[] enumConstants = cls.getEnumConstants();
        String[] result = new String[enumConstants.length];
        for (int i = 0; i < enumConstants.length; ++i) {
            result[i] = enumConstants[i].name();
        }
        return result;
    }

    public static <T extends Enum<T>> T findEnumConstant(Class<T> cls, String name) {
        if (name == null) {
            return null;
        }
        for (Enum enumConstant : (Enum[])cls.getEnumConstants()) {
            if (!enumConstant.name().equals(name)) continue;
            return (T)enumConstant;
        }
        return null;
    }

    public static String collectionToString(Iterable<?> coll, String delim, boolean unique) {
        StringBuilder result = new StringBuilder();
        HashSet<String> set = unique ? new HashSet<String>() : null;
        for (Object obj : coll) {
            String str;
            if (obj == null || TextUtil.isBlank(str = obj.toString()) || set != null && set.contains(str)) continue;
            if (result.length() > 0) {
                result.append(delim);
            }
            result.append(str);
            if (set == null) continue;
            set.add(str);
        }
        return result.toString();
    }

    public static <T> boolean equals(Collection<T> coll1, Collection<T> coll2, boolean ignoreOrder) {
        if (coll1 == null && coll2 == null) {
            return true;
        }
        if (coll1 == null || coll2 == null) {
            return false;
        }
        if (coll1.size() != coll2.size()) {
            return false;
        }
        if (!ignoreOrder) {
            Iterator<T> it1 = coll1.iterator();
            Iterator<T> it2 = coll2.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (MiscUtil.equals(it1.next(), it2.next())) continue;
                return false;
            }
            if (it1.hasNext() || it2.hasNext()) {
                return false;
            }
        } else {
            for (T item : coll1) {
                if (coll2.contains(item)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T, V> boolean equals(Map<T, V> map1, Map<T, V> map2, boolean ignoreOrder) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        if (!ignoreOrder) {
            Iterator<Map.Entry<T, V>> it1 = map1.entrySet().iterator();
            Iterator<Map.Entry<T, V>> it2 = map2.entrySet().iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Map.Entry<T, V> entry1 = it1.next();
                Map.Entry<T, V> entry2 = it2.next();
                if (MiscUtil.equals(entry1.getKey(), entry2.getKey()) && MiscUtil.equals(entry1.getValue(), entry2.getValue())) continue;
                return false;
            }
            if (it1.hasNext() || it2.hasNext()) {
                return false;
            }
        } else {
            for (Map.Entry<T, V> entry : map1.entrySet()) {
                if (!map2.containsKey(entry.getKey())) {
                    return false;
                }
                if (MiscUtil.equals(entry.getValue(), map2.get(entry.getKey()))) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> void compact(Collection<T> coll) {
        if (coll == null || coll.size() < 2) {
            return;
        }
        ArrayList<T> temp = new ArrayList<T>(coll.size());
        Iterator<T> it = coll.iterator();
        while (it.hasNext()) {
            T elm = it.next();
            if (temp.contains(elm)) {
                it.remove();
                continue;
            }
            temp.add(elm);
        }
    }

    public static <T> List<List<T>> groupBy(Iterable<T> objects, Equator<T, T> eq) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        block0: for (T obj : objects) {
            for (List list : result) {
                T head = CollectionUtil.head(list);
                if (head == null || !eq.equal(obj, head)) continue;
                list.add(obj);
                continue block0;
            }
            ArrayList<T> slice = new ArrayList<T>();
            slice.add(obj);
            result.add(slice);
        }
        return result;
    }

    public static final <T> Equator<T, T> byEqualsEquator() {
        return BY_EQUALS_EQUATOR;
    }

    public static <T, C1 extends Collection<T>, C2 extends Collection<T>> List<T> removeAll(C1 from, C2 what, Equator<T, T> eq) {
        ArrayList<T> result = new ArrayList<T>();
        for (T obj : from) {
            if (CollectionUtil.contains(what, obj, eq)) continue;
            result.add(obj);
        }
        return result;
    }

    public static <T, P, TC extends Collection<T>, PC extends Collection<P>> List<T> retainAll(TC collection, PC items, Equator<T, P> equator) {
        ArrayList<T> result = new ArrayList<T>();
        ArrayList list = new ArrayList(collection);
        for (P item : items) {
            T searchItem = CollectionUtil.find(list, item, equator);
            if (searchItem == null) continue;
            list.remove(searchItem);
            result.add(searchItem);
        }
        return result;
    }

    public static <T> List<List<T>> cartesianProduct(List<List<T>> data) {
        return CollectionUtil.cartesianProduct(data, 0);
    }

    private static <T> List<List<T>> cartesianProduct(List<List<T>> data, int idx) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (idx == data.size()) {
            result.add(new ArrayList());
            return result;
        }
        for (T obj : data.get(idx)) {
            for (List<T> entry : CollectionUtil.cartesianProduct(data, idx + 1)) {
                entry.add(0, obj);
                result.add(entry);
            }
        }
        return result;
    }

    public static <T, C1 extends Collection<T>, C2 extends Collection<T>> boolean sameCollections(C1 c1, C2 c2, Equator<T, T> eq) {
        return CollectionUtil.removeAll(c1, c2, eq).isEmpty() && CollectionUtil.removeAll(c2, c1, eq).isEmpty();
    }

    public static <T, P, TC extends Collection<? extends P>> P find(TC coll, T what, Equator<P, T> eq) {
        for (P obj : coll) {
            if (!eq.equal(obj, what)) continue;
            return obj;
        }
        return null;
    }

    public static <T, P, TC extends List<P>> int indexOf(TC coll, T what, Equator<P, T> eq) {
        for (int i = 0; i < coll.size(); ++i) {
            P obj = coll.get(i);
            if (!eq.equal(obj, what)) continue;
            return i;
        }
        return -1;
    }

    public static <T, P, TC extends Collection<T>> boolean contains(TC collection, P item, Equator<T, P> equator) {
        return CollectionUtil.find(collection, item, equator) != null;
    }

    public static <T, P, TC extends Collection<T>, TP extends Collection<P>> boolean containsAll(TC collection, TP items, Equator<T, P> equator) {
        ArrayList list = new ArrayList(collection);
        for (P item : items) {
            T findItem = CollectionUtil.find(list, item, equator);
            if (findItem != null) {
                list.remove(findItem);
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean containsOnlyNulls(Collection<?> col) {
        for (Object name : col) {
            if (name == null) continue;
            return false;
        }
        return true;
    }

    public static <T> List<List<T>> splitEvenly(List<T> col, int sliceCount) {
        int n = col.size();
        int minItemsPerSlice = n / sliceCount;
        int maxItemsPerSlice = minItemsPerSlice + 1;
        int slicesWithMaxItems = n - sliceCount * minItemsPerSlice;
        int start = 0;
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int i = 0; i < sliceCount; ++i) {
            int itemsCount = i < slicesWithMaxItems ? maxItemsPerSlice : minItemsPerSlice;
            int end = start + itemsCount;
            result.add(col.subList(start, end));
            start = end;
        }
        return result;
    }

    public static <T> List<List<T>> split(Collection<T> col, int sliceSize) {
        ArrayList<List<T>> splitted = new ArrayList<List<T>>();
        ArrayList<T> subset = null;
        int remains = col.size();
        for (T t : col) {
            if (subset == null || subset.size() == sliceSize) {
                subset = new ArrayList<T>(Math.min(remains, sliceSize));
                splitted.add(subset);
            }
            subset.add(t);
            --remains;
        }
        return splitted;
    }

    public static <T> int count(Collection<T> coll, ObjectFilter<T> filter) {
        if (filter == null) {
            return coll.size();
        }
        int result = 0;
        for (T t : coll) {
            if (!filter.accept(t)) continue;
            ++result;
        }
        return result;
    }

    public static <T> int count(Collection<T> coll, T object) {
        return CollectionUtil.count(coll, new EqualsObjectFilter<T>(object));
    }

    public static <K, V> Map<K, V> mapFromValues(Collection<V> values, F1<K, V> keyExtractor) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (V value : values) {
            result.put(keyExtractor.apply(value), value);
        }
        return result;
    }

    public static <K, V> Map<K, V> mapFromKeys(Collection<K> keys, F1<V, K> valueExtractor) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (K key : keys) {
            result.put(key, valueExtractor.apply(key));
        }
        return result;
    }

    public static <K, V> K getKeyByValue(Map<K, V> map, V value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <K, V> Collection<V> getOrAddList(Map<K, Collection<V>> map, K key) {
        Collection<V> result = map.get(key);
        if (result == null) {
            result = new ArrayList<V>();
            map.put(key, result);
        }
        return result;
    }

    public static <K, C extends Collection> C getFromMap(Map<K, C> map, K key, Supplier<C> newCollection) {
        Collection result = (Collection)map.get(key);
        if (result == null) {
            result = (Collection)newCollection.get();
            map.put(key, result);
        }
        return (C)result;
    }

    public static <TResultEl, TParamEl> List<TResultEl> flatMap(List<TParamEl> list, F1<List<TResultEl>, TParamEl> mapper) {
        ArrayList result = new ArrayList();
        for (TParamEl p : list) {
            result.addAll(MiscUtil.guarded((Collection)mapper.apply(p)));
        }
        return result;
    }

    public static <TResultEl, TParamEl> List<TResultEl> map(List<TParamEl> list, F1<TResultEl, TParamEl> mapper) {
        ArrayList<TResultEl> result = new ArrayList<TResultEl>();
        for (TParamEl p : list) {
            TResultEl res = mapper.apply(p);
            if (res == null) continue;
            result.add(res);
        }
        return result;
    }

    public static <T> boolean containAtLeastOneCommonElement(Collection<T> col1, Collection<T> col2) {
        for (T t : col1) {
            if (!col2.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean sameElements(Collection<T> col1, Collection<T> col2) {
        if (col1 == null) {
            return col2 == null || col2.isEmpty();
        }
        if (col2 == null) {
            return col1.isEmpty();
        }
        return col1.containsAll(col2) && col2.containsAll(col1);
    }

    public static <I, T> Collection<T> transform(ItemTransformer<I, T> transformer, I ... items) {
        return CollectionUtil.transform(transformer, Arrays.asList(items));
    }

    public static <I, T> List<T> transform(ItemTransformer<I, T> transformer, Collection<? extends I> items) {
        return CollectionUtil.transform(transformer, items, false);
    }

    public static <I, T> List<T> transform(ItemTransformer<I, T> transformer, Collection<? extends I> items, boolean excludeNulls) {
        if (items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> transformedItems = new ArrayList<T>();
        for (I item : items) {
            T transformed = transformer.transform(item);
            if (excludeNulls && transformed == null) continue;
            transformedItems.add(transformed);
        }
        return transformedItems;
    }

    public static <T> void filter(Collection<T> col, ObjectFilter<T> filter) {
        if (filter == null) {
            return;
        }
        Iterator<T> iter = col.iterator();
        while (iter.hasNext()) {
            if (filter.accept(iter.next())) continue;
            iter.remove();
        }
    }

    public static <T> T head(Iterable<T> iterable) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        Iterator<T> it = iterable.iterator();
        return it.hasNext() ? (T)it.next() : null;
    }

    public static <T> T firstNonNull(Iterable<T> is) {
        if (is == null) {
            return null;
        }
        for (T elem : is) {
            if (elem == null) continue;
            return elem;
        }
        return null;
    }

    public static <T> List<T> list(Iterable<T> i) {
        ArrayList<T> result;
        if (i == null) {
            return null;
        }
        if (i instanceof List) {
            result = (ArrayList<T>)i;
        } else if (i instanceof Collection) {
            result = new ArrayList((Collection)i);
        } else {
            result = new ArrayList<T>();
            for (T t : i) {
                result.add(t);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> Set<T> set(Iterable<T> i) {
        HashSet<T> result;
        if (i == null) {
            return null;
        }
        if (i instanceof Set) {
            result = (HashSet<T>)i;
        } else if (i instanceof Collection) {
            result = new HashSet((Collection)i);
        } else {
            result = new HashSet<T>();
            for (T t : i) {
                result.add(t);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static <T> List<T> safeSubList(List<T> list, int start, int count) {
        if (list == null) {
            return null;
        }
        if (start >= list.size() || count <= 0 || start + count <= 0) {
            return Collections.emptyList();
        }
        int actualFrom = Math.max(0, start);
        int actualTo = Math.min(list.size(), start + count);
        return list.subList(actualFrom, actualTo);
    }

    public static <T> List<T> safeSubList(List<T> list, int start) {
        if (list == null) {
            return null;
        }
        return CollectionUtil.safeSubList(list, start, list.size() - start);
    }

    public static <T> Iterable<T> tail(final Iterable<T> it) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new TailIterator(it.iterator());
            }
        };
    }

    public static <T> List<Set<T>> combinations(Set<T> elements) {
        return CollectionUtil.combinations(new ArrayList<T>(elements));
    }

    private static <T> List<Set<T>> combinations(List<T> elements) {
        ArrayList<Set<T>> combinations = new ArrayList<Set<T>>();
        combinations.add(Collections.emptySet());
        for (int i = 0; i < elements.size(); ++i) {
            T element = elements.get(i);
            List<Set<T>> subListCombinations = CollectionUtil.combinations(elements.subList(i + 1, elements.size()));
            for (Set<T> subListCombination : subListCombinations) {
                HashSet<T> combination = new HashSet<T>();
                combination.add(element);
                combination.addAll(subListCombination);
                combinations.add(combination);
            }
        }
        return combinations;
    }

    public static <T1, T2> Collection<T1> subtract(Collection<T1> col1, Collection<T2> col2, Equator<T1, T2> equator, boolean strict) {
        ArrayList<T1> subtract = new ArrayList<T1>(col1);
        block0: for (T2 elm2 : col2) {
            Iterator iterator = subtract.iterator();
            while (iterator.hasNext()) {
                if (!equator.equal(iterator.next(), elm2)) continue;
                iterator.remove();
                if (!strict) continue;
                continue block0;
            }
        }
        return subtract;
    }

    public static <T1, T2> boolean equals(Collection<T1> col1, Collection<T2> col2, Equator<T1, T2> equator, boolean strict) {
        if (col1 == null && col2 == null) {
            return true;
        }
        if (col1 == null || col2 == null) {
            return false;
        }
        if (col1.size() != col2.size()) {
            return false;
        }
        if (strict) {
            Iterator<T1> col1Iterator = col1.iterator();
            Iterator<T2> col2Iterator = col2.iterator();
            while (col1Iterator.hasNext()) {
                if (equator.equal(col1Iterator.next(), col2Iterator.next())) continue;
                return false;
            }
            return true;
        }
        return CollectionUtil.subtract(col1, col2, equator, true).size() == 0;
    }

    public static <T1, T2> Collection<T1> intersect(Collection<T1> col1, Collection<T2> col2, Equator<T1, T2> equator, boolean strict) {
        return CollectionUtil.subtract(col1, CollectionUtil.subtract(col1, col2, equator, strict), CollectionUtil.byEqualsEquator(), strict);
    }

    public static <E extends Enum<E>> List<E> convertEnumList(Class<E> clazz, List<E> list) {
        ArrayList<E> result = new ArrayList<E>(Arrays.asList(clazz.getEnumConstants()));
        result.removeAll(list);
        return result;
    }

    public static boolean isEmptyMap(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmptyMap(Map<?, ?> map) {
        return !CollectionUtil.isEmptyMap(map);
    }

    private CollectionUtil() {
    }

    public static <T> boolean addIfNotNull(Collection<T> coll, T obj) {
        if (coll == null || obj == null) {
            return false;
        }
        return coll.add(obj);
    }

    public static <T> boolean addAllIfNotNull(Collection<T> c1, Collection<T> c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.addAll(c2);
    }

    public static boolean isSameContent(Collection<?> collection1, Collection<?> collection2) {
        ArrayList temp = new ArrayList(collection1);
        for (Object item : collection2) {
            if (temp.remove(item)) continue;
            return false;
        }
        return temp.isEmpty();
    }

    public static <T> T getLastElement(List<T> list) {
        int size = list.size();
        return list.get(size - 1);
    }

    public static <E> Collection<E> union(Collection<E> c1, Collection<E> c2) {
        ArrayList res = new ArrayList();
        CollectionUtil.addAllIfNotNull(res, c1);
        CollectionUtil.addAllIfNotNull(res, c2);
        return res;
    }

    public static <E> void merge(Collection<E> copyTo, Collection<E> copyFrom, Equator<E, E> eq) {
        for (E elem : copyFrom) {
            if (CollectionUtil.contains(copyTo, elem, eq)) continue;
            copyTo.add(elem);
        }
    }

    public static <TOld, TNew> Changes<TOld, TNew> findChanges(Collection<TOld> oldObjects, Collection<TNew> newObjects, Equator<TOld, TNew> eqById, Equator<TOld, TNew> eqByFields) {
        Changes result = new Changes();
        for (TNew newObj : newObjects) {
            TOld oldObj = CollectionUtil.find(oldObjects, newObj, eqById);
            if (oldObj == null) {
                result.added.add(newObj);
                continue;
            }
            if (eqByFields.equal(oldObj, newObj)) continue;
            result.changed.add(MiscUtil.Pair.of(oldObj, newObj));
        }
        for (Object oldObj : oldObjects) {
            TNew newObj = CollectionUtil.find(newObjects, oldObj, eqById.reversed());
            if (newObj != null) continue;
            result.removed.add(oldObj);
        }
        return result;
    }

    public static <E> Collection<E> flatTree(Collection<E> items, Function<E, Collection<E>> subItemsSupplier) {
        return CollectionUtil.flatTreeStream(items, subItemsSupplier).collect(Collectors.toList());
    }

    public static <E> Stream<E> flatTreeStream(Collection<E> items, Function<E, Collection<E>> subItemsSupplier) {
        return items.stream().flatMap(parent -> CollectionUtil.flatTreeStreamInternal(parent, subItemsSupplier));
    }

    private static <E> Stream<E> flatTreeStreamInternal(E parent, Function<E, Collection<E>> subItemsSupplier) {
        return Stream.concat(Stream.of(parent), subItemsSupplier.apply(parent).stream().flatMap(child -> CollectionUtil.flatTreeStreamInternal(child, subItemsSupplier)));
    }

    public static <E> List<E> sort(List<E> list, Comparator<E> comparator) {
        list.sort(comparator);
        return list;
    }

    public static <T> boolean putIfAbsent(Collection<T> coll, T obj) {
        if (coll == null || obj == null) {
            return false;
        }
        if (!coll.contains(obj)) {
            coll.add(obj);
            return true;
        }
        return false;
    }

    public static <T> T computeIfAbsent(Collection<T> collection, Predicate<T> predicate, Supplier<T> supplier) {
        Objects.requireNonNull(collection);
        Objects.requireNonNull(supplier);
        Object item = collection.stream().filter(predicate).findFirst().orElse(null);
        if (item == null && (item = (Object)supplier.get()) != null) {
            collection.add(item);
        }
        return (T)item;
    }

    public static <T> List<T> toList(T obj) {
        return obj != null ? Collections.singletonList(obj) : Collections.emptyList();
    }

    public static <E> Predicate<Collection<? super E>> isIntersect(Collection<? extends E> collection) {
        return otherCollection -> {
            if (CollectionUtil.isEmpty(collection) || CollectionUtil.isEmpty(otherCollection)) {
                return false;
            }
            Optional<Object> contains = otherCollection.stream().filter(collection::contains).findAny();
            return contains.isPresent();
        };
    }

    public static <T extends Collection> T requireNonEmpty(T collection) {
        Objects.requireNonNull(collection);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return collection;
    }

    public static <T extends Collection> T requireNonEmpty(T collection, String message) {
        Objects.requireNonNull(collection, message);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        return collection;
    }

    public static <T extends Collection> T requireNonEmpty(T collection, Supplier<String> messageSupplier) {
        Objects.requireNonNull(collection, messageSupplier);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
        return collection;
    }

    public static <T extends Map> T requireNonEmpty(T map) {
        Objects.requireNonNull(map);
        if (map.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return map;
    }

    public static <T extends Map> T requireNonEmpty(T map, String message) {
        Objects.requireNonNull(map, message);
        if (map.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        return map;
    }

    public static <T extends Map> T requireNonEmpty(T map, Supplier<String> messageSupplier) {
        Objects.requireNonNull(map, messageSupplier);
        if (map.isEmpty()) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
        return map;
    }

    public static <T> T single(Collection<T> values) {
        return CollectionUtil.single(values.iterator());
    }

    static <T> T single(Iterator<T> iter) {
        return CollectionUtil.singleOrNull(iter, false);
    }

    public static <T> T singleOrNull(Collection<T> values) {
        return CollectionUtil.singleOrNull(values.iterator(), true);
    }

    static <T> T singleOrNull(Iterator<T> iter) {
        return CollectionUtil.singleOrNull(iter, true);
    }

    private static <T> T singleOrNull(Iterator<T> iter, boolean isNullPossible) {
        if (!iter.hasNext()) {
            if (isNullPossible) {
                return null;
            }
            throw new NoSuchElementException("No value present");
        }
        T value = iter.next();
        if (iter.hasNext()) {
            throw new IllegalArgumentException("Multiple values present");
        }
        return value;
    }

    public static <T> T mapGetCaseInsensitive(Map<String, T> map, String key) {
        if (key == null) {
            return map.get(null);
        }
        Map.Entry entry = Streams.singleOrNull(map.entrySet().stream().filter(e -> key.equalsIgnoreCase((String)e.getKey())));
        return entry != null ? (T)entry.getValue() : null;
    }

    public static class Changes<TOld, TNew> {
        public final List<TNew> added = new ArrayList<TNew>();
        public final List<TOld> removed = new ArrayList<TOld>();
        public final List<MiscUtil.Pair<TOld, TNew>> changed = new ArrayList<MiscUtil.Pair<TOld, TNew>>();

        public boolean areTrivial() {
            return this.added.isEmpty() && this.removed.isEmpty() && this.changed.isEmpty();
        }
    }

    public static class CartesianProductIterator<T>
    implements Iterator<List<T>> {
        private final List<List<T>> data;
        private final int[] indexes;
        private boolean empty = false;
        private int index = -1;

        public static <T> CartesianProductIterator<T> create(List<List<T>> data) {
            return new CartesianProductIterator<T>(data);
        }

        private CartesianProductIterator(List<List<T>> data) {
            this.data = data;
            if (data.isEmpty()) {
                throw new IllegalArgumentException();
            }
            for (List<T> list : data) {
                if (!list.isEmpty()) continue;
                this.empty = true;
                break;
            }
            this.indexes = new int[data.size()];
        }

        @Override
        public boolean hasNext() {
            if (this.index == -1) {
                return true;
            }
            if (!this.empty) {
                for (int i = 0; i < this.indexes.length; ++i) {
                    if (this.indexes[i] >= this.data.get(i).size() - 1) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public List<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            if (this.empty) {
                return Collections.emptyList();
            }
            if (this.index > 0) {
                for (int i = this.indexes.length - 1; i >= 0; --i) {
                    if (this.indexes[i] != this.data.get(i).size() - 1) {
                        this.indexes[i] = this.indexes[i] + 1;
                        break;
                    }
                    this.indexes[i] = 0;
                }
            }
            ArrayList<T> next = new ArrayList<T>();
            for (int i = 0; i < this.indexes.length; ++i) {
                next.add(this.data.get(i).get(this.indexes[i]));
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int getIndex() {
            return this.index;
        }

        public int size() {
            if (this.empty) {
                return 1;
            }
            int size = 1;
            for (int i = 0; i < this.indexes.length; ++i) {
                size *= this.data.get(i).size();
            }
            return size;
        }
    }

    private static class TailIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;

        TailIterator(Iterator<T> it) {
            this.it = it;
            if (it.hasNext()) {
                it.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    public static interface ItemTransformer<I, T> {
        public T transform(I var1);
    }

    public static interface F1<TR, TP> {
        public TR apply(TP var1);
    }

    public static interface Equator<T1, T2> {
        public boolean equal(T1 var1, T2 var2);

        default public Equator<T2, T1> reversed() {
            final Equator _this = this;
            return new Equator<T2, T1>(){

                @Override
                public boolean equal(T2 o2, T1 o1) {
                    return _this.equal(o1, o2);
                }
            };
        }
    }

    public static class SimpleToStringComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 5863548989033141416L;

        @Override
        public int compare(T o1, T o2) {
            return TextUtil.compare(o1 == null ? null : o1.toString(), o2 == null ? null : o2.toString(), false, false);
        }
    }
}

