/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateTimeConverter {
    private DateTimeConverter() {
    }

    public static DateTime convertDateTime(Date sourceTime, DateTimeZone sourceTimeZone, DateTimeZone targetTimeZone) {
        if (sourceTime == null) {
            return null;
        }
        return new DateTime((Object)DateTimeConverter.convertTime(sourceTime, sourceTimeZone, targetTimeZone));
    }

    public static Date convertTime(Date sourceTime, DateTimeZone sourceTimeZone, DateTimeZone targetTimeZone) {
        Date convertedTime;
        if (sourceTime == null) {
            return null;
        }
        if (sourceTimeZone != null && targetTimeZone != null && sourceTimeZone.getStandardOffset(sourceTime.getTime()) != targetTimeZone.getStandardOffset(sourceTime.getTime())) {
            DateTime timeInSourceTimeZone = new DateTime((Object)sourceTime, sourceTimeZone);
            int offset = targetTimeZone.getStandardOffset(sourceTime.getTime()) - sourceTimeZone.getStandardOffset(sourceTime.getTime());
            convertedTime = timeInSourceTimeZone.plusMillis(offset).toDate();
        } else {
            convertedTime = sourceTime;
        }
        return convertedTime;
    }

    public static Date convert(Date from, ZoneId fromZoneId, ZoneId toZoneId) {
        if (from == null) {
            return null;
        }
        if (fromZoneId.equals(toZoneId)) {
            return from;
        }
        long fromOffset = (long)fromZoneId.getRules().getOffset(from.toInstant()).getTotalSeconds() * 1000L;
        long toOffset = (long)toZoneId.getRules().getOffset(from.toInstant()).getTotalSeconds() * 1000L;
        long delta = toOffset - fromOffset;
        return new Date(from.getTime() + delta);
    }

    public static Date convert(Date timelimit, TimeZone fromZone, TimeZone toZone) {
        return DateTimeConverter.convert(timelimit, fromZone.toZoneId(), toZone.toZoneId());
    }
}

