/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.MiscUtil;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugUtil {
    private static final Logger log = LoggerFactory.getLogger(DebugUtil.class);
    public static final String prefix = "    ";
    private static final ThreadLocal<Boolean> THREAD_DEBUG_ENABLED = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<Stack<String>> THREAD_NAME_STACK = ThreadLocal.withInitial(() -> new Stack());

    public static boolean isThreadDebugEnabled() {
        return THREAD_DEBUG_ENABLED.get();
    }

    public static void enableThreadDebug() {
        THREAD_DEBUG_ENABLED.set(Boolean.TRUE);
    }

    public static void disableThreadDebug() {
        THREAD_DEBUG_ENABLED.set(Boolean.FALSE);
    }

    public static String getStackTrace() {
        return DebugUtil.getStackTrace(Thread.currentThread());
    }

    public static String getStackTrace(Thread thread) {
        StackTraceElement[] trace = thread.getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement traceElement : trace) {
            String entry = "\tat " + traceElement + "\n";
            if (entry.contains("java.lang.Thread") || entry.contains(".DebugUtil.")) continue;
            sb.append(entry);
        }
        return sb.toString();
    }

    public static void logStackTrace(String message) {
        log.debug(message + "\n" + DebugUtil.getStackTrace());
    }

    public static void logStackTrace() {
        DebugUtil.logStackTrace("");
    }

    public static boolean isStackTraceIncludes(String className, String methodName) {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (!MiscUtil.equals(ste.getClassName(), className) || !MiscUtil.equals(ste.getMethodName(), methodName)) continue;
            return true;
        }
        return false;
    }

    public static Logger getLog() {
        return log;
    }

    public static void setThreadName(String name) {
        THREAD_NAME_STACK.get().push(Thread.currentThread().getName());
        Thread.currentThread().setName(name + "-" + ThreadLocalRandom.current().nextInt(1000));
    }

    public static void restoreThreadName() {
        Thread.currentThread().setName(THREAD_NAME_STACK.get().pop());
    }

    public static String toString(Date date) {
        return date != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(date) : null;
    }

    public static String decorate(String text, String prefix, String title, boolean wrap) {
        return DebugUtil.decorate(Collections.singleton(text), prefix, title, wrap);
    }

    public static String decorate(Iterable<String> texts, String prefix, String title, boolean wrap) {
        StringBuilder stringBuilder = new StringBuilder();
        int max = 0;
        for (String string : texts) {
            String[] entries;
            for (String entry : entries = string != null ? string.split("\\R") : new String[]{}) {
                max = Math.max(max, entry.length());
            }
        }
        if (wrap) {
            StringBuilder titleBuilder;
            if (title != null) {
                titleBuilder = new StringBuilder();
                titleBuilder.append("\u250c\u2500");
                titleBuilder.append(title);
                if (max - title.length() >= 1) {
                    titleBuilder.append(StringUtils.repeat((String)"\u2500", (int)(max - title.length())));
                }
                if (max - title.length() >= 0) {
                    titleBuilder.append("\u2500\u2510");
                }
                stringBuilder.append(prefix != null ? prefix : "");
                stringBuilder.append(titleBuilder.toString());
                stringBuilder.append("\n");
            } else {
                titleBuilder = new StringBuilder();
                titleBuilder.append("\u250c\u2500");
                titleBuilder.append(StringUtils.repeat((String)"\u2500", (int)max));
                titleBuilder.append("\u2500\u2510");
                stringBuilder.append(prefix != null ? prefix : "");
                stringBuilder.append(titleBuilder.toString());
                stringBuilder.append("\n");
            }
        }
        int count = 0;
        for (String text : texts) {
            String[] entries;
            if (count > 0 && wrap) {
                StringBuilder separatorBuilder = new StringBuilder();
                separatorBuilder.append("\u251c\u2500");
                separatorBuilder.append(StringUtils.repeat((String)"\u2500", (int)max));
                separatorBuilder.append("\u2500\u2524");
                stringBuilder.append(prefix != null ? prefix : "");
                stringBuilder.append(separatorBuilder.toString());
                stringBuilder.append("\n");
            }
            for (String entry : entries = text != null ? text.split("\\R") : new String[]{}) {
                StringBuilder bodyBuilder = new StringBuilder();
                if (wrap) {
                    bodyBuilder.append("\u2502 ");
                }
                bodyBuilder.append(entry);
                if (wrap) {
                    bodyBuilder.append(StringUtils.repeat((String)" ", (int)(max - entry.length())));
                    bodyBuilder.append(" \u2502");
                }
                stringBuilder.append(prefix != null ? prefix : "");
                stringBuilder.append(bodyBuilder.toString());
                stringBuilder.append("\n");
            }
            ++count;
        }
        if (wrap) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("\u2514\u2500");
            stringBuilder2.append(StringUtils.repeat((String)"\u2500", (int)max));
            stringBuilder2.append("\u2500\u2518");
            stringBuilder.append(prefix != null ? prefix : "");
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static <O> String table(List<O> objects, List<Column<O>> columns, String prefix, Border border, boolean header) {
        Map<Column, Integer> widths = columns.stream().collect(Collectors.toMap(item -> item, item -> Math.min(Math.max(Stream.concat(Stream.of(header ? item.getName() : null), objects.stream().map(object -> item.getExtractor().apply(object))).mapToInt(value -> value != null ? value.length() : 0).max().orElse(0), item.getMinWidth()), item.getMaxWidth() == 0 ? Integer.MAX_VALUE : item.getMaxWidth())));
        StringBuilder tableBuilder = new StringBuilder();
        if (border == Border.ALL || border == Border.OUTER) {
            StringBuilder borderBuilder = new StringBuilder();
            for (Column<O> column : columns) {
                int width = widths.get(column);
                if (borderBuilder.length() > 0) {
                    if (border == Border.ALL) {
                        borderBuilder.append("\u2500\u252c\u2500");
                    } else if (border == Border.OUTER) {
                        borderBuilder.append("\u2500");
                    }
                }
                borderBuilder.append(StringUtils.repeat((String)"\u2500", (int)width));
            }
            if (prefix != null) {
                tableBuilder.append(prefix);
            }
            tableBuilder.append("\u250c\u2500");
            tableBuilder.append(borderBuilder.toString());
            tableBuilder.append("\u2500\u2510");
            tableBuilder.append("\n");
        }
        if (header) {
            StringBuilder headerBuilder = new StringBuilder();
            for (Column<O> column : columns) {
                String name = column.getName();
                int width = widths.get(column);
                if (name != null && name.length() > width) {
                    name = name.substring(0, width);
                }
                if (headerBuilder.length() > 0) {
                    if (border == Border.ALL || border == Border.INNER) {
                        headerBuilder.append(" \u2502 ");
                    } else {
                        headerBuilder.append(" ");
                    }
                }
                if (name != null) {
                    headerBuilder.append(StringUtils.repeat((String)" ", (int)((width - name.length()) / 2)));
                    headerBuilder.append(name);
                    headerBuilder.append(StringUtils.repeat((String)" ", (int)((width + 1 - name.length()) / 2)));
                    continue;
                }
                headerBuilder.append(StringUtils.repeat((String)" ", (int)width));
            }
            if (prefix != null) {
                tableBuilder.append(prefix);
            }
            if (border == Border.ALL || border == Border.OUTER) {
                tableBuilder.append("\u2502 ");
            }
            tableBuilder.append(headerBuilder.toString());
            if (border == Border.ALL || border == Border.OUTER) {
                tableBuilder.append(" \u2502");
            }
            tableBuilder.append("\n");
        }
        boolean separator = header;
        for (Column<O> object : objects) {
            if (separator && (border == Border.ALL || border == Border.INNER)) {
                StringBuilder borderBuilder = new StringBuilder();
                for (Column<O> column : columns) {
                    int width = widths.get(column);
                    if (borderBuilder.length() > 0) {
                        borderBuilder.append("\u2500\u253c\u2500");
                    }
                    borderBuilder.append(StringUtils.repeat((String)"\u2500", (int)width));
                }
                if (prefix != null) {
                    tableBuilder.append(prefix);
                }
                if (border == Border.ALL) {
                    tableBuilder.append("\u251c\u2500");
                }
                tableBuilder.append(borderBuilder.toString());
                if (border == Border.ALL) {
                    tableBuilder.append("\u2500\u2524");
                }
                tableBuilder.append("\n");
            }
            if (border == Border.ALL) {
                separator = true;
            } else if (border == Border.INNER) {
                separator = false;
            }
            StringBuilder rowBuilder = new StringBuilder();
            for (Column<O> column : columns) {
                String value = column.getExtractor().apply(object);
                Align align = column.getAlign();
                int width = widths.get(column);
                if (value != null && value.length() > width) {
                    value = value.substring(0, width);
                }
                if (rowBuilder.length() > 0) {
                    if (border == Border.ALL || border == Border.INNER) {
                        rowBuilder.append(" \u2502 ");
                    } else {
                        rowBuilder.append(" ");
                    }
                }
                if (value != null) {
                    if (align == Align.RIGHT) {
                        rowBuilder.append(StringUtils.repeat((String)" ", (int)(width - value.length())));
                        rowBuilder.append(value);
                        continue;
                    }
                    if (align == Align.CENTER) {
                        rowBuilder.append(StringUtils.repeat((String)" ", (int)((width - value.length()) / 2)));
                        rowBuilder.append(value);
                        rowBuilder.append(StringUtils.repeat((String)" ", (int)((width + 1 - value.length()) / 2)));
                        continue;
                    }
                    rowBuilder.append(value);
                    rowBuilder.append(StringUtils.repeat((String)" ", (int)(width - value.length())));
                    continue;
                }
                rowBuilder.append(StringUtils.repeat((String)" ", (int)width));
            }
            if (prefix != null) {
                tableBuilder.append(prefix);
            }
            if (border == Border.ALL || border == Border.OUTER) {
                tableBuilder.append("\u2502 ");
            }
            tableBuilder.append(rowBuilder.toString());
            if (border == Border.ALL || border == Border.OUTER) {
                tableBuilder.append(" \u2502");
            }
            tableBuilder.append("\n");
        }
        if (border == Border.ALL || border == Border.OUTER) {
            StringBuilder borderBuilder = new StringBuilder();
            for (Column<O> column : columns) {
                int width = widths.get(column);
                if (borderBuilder.length() > 0) {
                    if (border == Border.ALL) {
                        borderBuilder.append("\u2500\u2534\u2500");
                    } else if (border == Border.OUTER) {
                        borderBuilder.append("\u2500");
                    }
                }
                borderBuilder.append(StringUtils.repeat((String)"\u2500", (int)width));
            }
            if (prefix != null) {
                tableBuilder.append(prefix);
            }
            tableBuilder.append("\u2514\u2500");
            tableBuilder.append(borderBuilder.toString());
            tableBuilder.append("\u2500\u2518");
        }
        return tableBuilder.toString();
    }

    public static enum Border {
        ALL,
        OUTER,
        INNER,
        NONE;

    }

    public static enum Align {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static class ColumnBuilder<O> {
        private String name;
        private Align align;
        private int minWidth;
        private int maxWidth;
        private Function<O, String> extractor;

        public static <O> ColumnBuilder<O> get() {
            return new ColumnBuilder<O>();
        }

        private ColumnBuilder() {
        }

        public ColumnBuilder<O> name(String name) {
            this.name = name;
            return this;
        }

        public ColumnBuilder<O> align(Align align) {
            this.align = align;
            return this;
        }

        public ColumnBuilder<O> minWidth(int minWidth) {
            this.minWidth = minWidth;
            return this;
        }

        public ColumnBuilder<O> maxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public ColumnBuilder<O> extractor(Function<O, String> extractor) {
            this.extractor = extractor;
            return this;
        }

        public Column<O> build() {
            return new Column(this.name, this.align, this.minWidth, this.maxWidth, this.extractor);
        }
    }

    public static class Column<O> {
        private final String name;
        private final Align align;
        private final int minWidth;
        private final int maxWidth;
        private final Function<O, String> extractor;

        private Column(String name, Align align, int minWidth, int maxWidth, Function<O, String> extractor) {
            this.name = name;
            this.align = align;
            this.minWidth = Math.max(minWidth, 0);
            this.maxWidth = Math.max(maxWidth, 0);
            this.extractor = extractor;
        }

        public String getName() {
            return this.name;
        }

        public Align getAlign() {
            return this.align;
        }

        public int getMinWidth() {
            return this.minWidth;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public Function<O, String> getExtractor() {
            return this.extractor;
        }
    }
}

