/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.regex.Pattern;

public class LanguageUtil {
    private static final Pattern LATIN_PATTERN = Pattern.compile("^[a-zA-Z\\s.,\\[\\];-]+$");
    private static final Pattern CYRILLIC_PATTERN = Pattern.compile("^[\u0430-\u044f\u0410-\u042f\\s.,\\[\\];-]+$");
    private static final String[][] EN_RU = new String[][]{{"q", "\u0439"}, {"w", "\u0446"}, {"e", "\u0443"}, {"r", "\u043a"}, {"t", "\u0435"}, {"y", "\u043d"}, {"u", "\u0433"}, {"i", "\u0448"}, {"o", "\u0449"}, {"p", "\u0437"}, {"[", "\u0445"}, {"]", "\u044a"}, {"a", "\u0444"}, {"s", "\u044b"}, {"d", "\u0432"}, {"f", "\u0430"}, {"g", "\u043f"}, {"h", "\u0440"}, {"j", "\u043e"}, {"k", "\u043b"}, {"l", "\u0434"}, {";", "\u0436"}, {"'", "\u044d"}, {"z", "\u044f"}, {"x", "\u0447"}, {"c", "\u0441"}, {"v", "\u043c"}, {"b", "\u0438"}, {"n", "\u0442"}, {"m", "\u044c"}, {",", "\u0431"}, {".", "\u044e"}};
    private static final String[][] RU_EN = new String[][]{{"\u0439", "q"}, {"\u0446", "w"}, {"\u0443", "e"}, {"\u043a", "r"}, {"\u0435", "t"}, {"\u043d", "y"}, {"\u0433", "u"}, {"\u0448", "i"}, {"\u0449", "o"}, {"\u0437", "p"}, {"\u0445", "["}, {"\u044a", "]"}, {"\u0444", "a"}, {"\u044b", "s"}, {"\u0432", "d"}, {"\u0430", "f"}, {"\u043f", "g"}, {"\u0440", "h"}, {"\u043e", "j"}, {"\u043b", "k"}, {"\u0434", "l"}, {"\u0436", ";"}, {"\u044d", "'"}, {"\u044f", "z"}, {"\u0447", "x"}, {"\u0441", "c"}, {"\u043c", "v"}, {"\u0438", "b"}, {"\u0442", "n"}, {"\u044c", "m"}, {"\u0431", ","}, {"\u044e", "."}};
    private static final String[][] RU_EN_tr = new String[][]{{"\u0410", "A"}, {"\u0412", "B"}, {"\u0421", "C"}, {"\u0415", "E"}, {"\u041d", "H"}, {"\u041a", "K"}, {"\u041c", "M"}, {"\u041e", "O"}, {"\u0420", "P"}, {"\u0422", "T"}, {"\u0425", "X"}};

    public static String switchLang(String text) {
        if (TextUtil.isBlank(text)) {
            return text;
        }
        String result = text.trim().toLowerCase();
        for (String[] element : !LATIN_PATTERN.matcher(text).matches() ? RU_EN : EN_RU) {
            result = result.replace(element[0], element[1]);
        }
        return result;
    }

    public static String translitToEnglish(String text) {
        if (TextUtil.isBlank(text)) {
            return text;
        }
        String result = text.trim().toUpperCase();
        for (String[] element : RU_EN_tr) {
            result = result.replace(element[0], element[1]);
        }
        return result;
    }

    public static String getLanguageTag(String text) {
        if (CYRILLIC_PATTERN.matcher(text).matches()) {
            return "RU";
        }
        return "EN";
    }

    private LanguageUtil() {
    }
}

