/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.regex.Pattern;

public final class MailSecurityHelper {
    private static final String MARKER = "zEOpF8eJQa";
    private static final Pattern ALPHABET_AND_NUMBER_PATTERN = Pattern.compile("[A-Z0-9]+");

    public static boolean isPasswordEncrypted(String pass) {
        return !TextUtil.isBlank(pass) && pass.startsWith(MARKER);
    }

    public static String encode(String str) throws InvalidPasswordFormatExeption, GeneralSecurityException, IOException {
        if (!TextUtil.isBlank(str)) {
            if (!MailSecurityHelper.isPasswordEncrypted(str)) {
                return MARKER + DesUtil.encode(str);
            }
            MailSecurityHelper.validatePassword(str);
        }
        return str;
    }

    public static String decode(String str) throws GeneralSecurityException, IOException {
        if (!TextUtil.isBlank(str) && MailSecurityHelper.isPasswordEncrypted(str)) {
            return DesUtil.decode(MailSecurityHelper.removeMarker(str));
        }
        return str;
    }

    private static String removeMarker(String str) {
        return str.substring(MARKER.length());
    }

    public static boolean isEncryptedPasswordValid(String str) {
        if (TextUtil.isBlank(str) && str.length() <= MARKER.length()) {
            return false;
        }
        String clearPassword = MailSecurityHelper.removeMarker(str);
        return clearPassword.length() % 16 == 0 && ALPHABET_AND_NUMBER_PATTERN.matcher(clearPassword).matches();
    }

    private static void validatePassword(String str) throws InvalidPasswordFormatExeption {
        if (!MailSecurityHelper.isEncryptedPasswordValid(str)) {
            throw new InvalidPasswordFormatExeption();
        }
    }

    public static class InvalidPasswordFormatExeption
    extends Exception {
    }
}

