/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.google.common.collect.ImmutableList;
import com.gridnine.xtrip.common.util.Mergeables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class MergeablesTest {
    @Test
    public void testMerge() {
        ArrayList<Object> in = new ArrayList<Object>();
        in.add("foo");
        in.add(new TestMergeable<String>(1, Collections.singleton("good")));
        in.add(new TestMergeable<String>(1, Collections.singleton("we")));
        in.add("foo");
        in.add(new TestMergeable<String>(2, Arrays.asList("for", "ill", "is")));
        in.add(new TestMergeable<String>(1, Arrays.asList("must", "love")));
        in.add("bar");
        in.add(new TestMergeable<String>(2, Arrays.asList("ill", "and", "good")));
        in.add("foo");
        in.add(new TestMergeable<String>(1, Arrays.asList("and", "must")));
        in.add(new TestMergeable<String>(1, Arrays.asList("hate", "ill")));
        in.add("bar");
        in.add("foo");
        in.add(new TestMergeable<String>(2, Arrays.asList("good", "still")));
        List<?> out = Mergeables.mergeWhatIsPossible(in);
        Assert.assertEquals((long)8L, (long)out.size());
        Assert.assertEquals((Object)"good we must love and must hate ill", (Object)StringUtils.join(((TestMergeable)out.get(1)).getVals(), (String)" "));
        Assert.assertEquals((Object)"for ill is ill and good good still", (Object)StringUtils.join(((TestMergeable)out.get(3)).getVals(), (String)" "));
    }

    @Test
    public void testArrayListMerge() {
        Mergeables.CollectionMergeable<String> m1 = new Mergeables.CollectionMergeable<String>(Arrays.asList("a", "b"));
        Mergeables.CollectionMergeable m2 = new Mergeables.CollectionMergeable();
        Mergeables.CollectionMergeable<String> m3 = new Mergeables.CollectionMergeable<String>(Arrays.asList("c"));
        Mergeables.CollectionMergeable<String> m4 = new Mergeables.CollectionMergeable<String>(Arrays.asList("d", "e"));
        List<Mergeables.CollectionMergeable> merged = Mergeables.merge(Arrays.asList(m1, m2, m3, m4));
        Assert.assertEquals((long)1L, (long)merged.size());
        Assert.assertEquals(Arrays.asList("a", "b", "c", "d", "e"), merged.get(0).getCollection());
    }

    private static class TestMergeable<T>
    implements Mergeables.IMergeable<TestMergeable<T>> {
        private final List<T> vals = new ArrayList<T>();
        private final int i;

        public TestMergeable(int i, Collection<T> in) {
            this.i = i;
            this.vals.addAll(in);
        }

        public List<T> getVals() {
            return this.vals;
        }

        @Override
        public boolean canBeMerged(Mergeables.IMergeable<?> mergeable) {
            if (mergeable instanceof TestMergeable) {
                return this.i == ((TestMergeable)mergeable).i;
            }
            return false;
        }

        @Override
        public TestMergeable<T> merge(TestMergeable<T> mergeable) {
            return new TestMergeable<T>(this.i, ImmutableList.builder().addAll(this.vals).addAll(mergeable.vals).build());
        }
    }
}

