/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.BinHex;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.zone.ZoneRulesProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.ArrayUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MiscUtil {
    public static final Logger TIMING_LOG = LoggerFactory.getLogger((String)"com.gridnine.xtrip.TIMING");
    private static volatile String timezoneVersion;
    public static final int CURRENT_DECADE = 1;
    public static final int LAST_DECADE = 2;
    public static final int CURRENT_WEEK_BSP = 3;
    public static final int LAST_WEEK_BSP = 4;
    public static final int CURRENT_MONTH = 5;
    public static final int LAST_MONTH = 6;
    private static final byte[][] XML_HEADERS;
    private static final AtomicLong LAST_TIME_MS;

    public static int compare(int i1, int i2) {
        return i1 > i2 ? 1 : (i1 < i2 ? -1 : 0);
    }

    public static <T> Integer compareIfNulls(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return null;
    }

    public static <T extends Comparable<T>> int compare(T o1, T o2) {
        return MiscUtil.compare(o1, o2, true);
    }

    public static <T extends Comparable<T>> int compare(T o1, T o2, boolean nullIsLess) {
        if (o1 == null) {
            return o2 == null ? 0 : (nullIsLess ? -1 : 1);
        }
        if (o2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return o1.compareTo(o2);
    }

    public static int compare(Date date1, Date date2) {
        return MiscUtil.compare(date1, date2, true);
    }

    public static int compare(Date date1, Date date2, boolean nullIsLess) {
        long time2;
        if (date1 == null) {
            return date2 == null ? 0 : (nullIsLess ? -1 : 1);
        }
        if (date2 == null) {
            return nullIsLess ? 1 : -1;
        }
        long time1 = date1.getTime();
        return time1 < (time2 = date2.getTime()) ? -1 : (time1 == time2 ? 0 : 1);
    }

    public static Date getGmtDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(14, calendar.getTimeZone().getOffset(calendar.getTimeInMillis()));
        return calendar.getTime();
    }

    public static long getDuration(Date startDate, Date endDate) {
        Calendar startDateCalendar = Calendar.getInstance();
        Calendar endDateCalendar = Calendar.getInstance();
        startDateCalendar.setTime(startDate);
        endDateCalendar.setTime(endDate);
        long duration = endDateCalendar.getTimeInMillis() - startDateCalendar.getTimeInMillis();
        return duration;
    }

    public static long getDuration(Date startDate, Date endDate, int type) {
        long duration = MiscUtil.getDuration(startDate, endDate);
        switch (type) {
            case 13: {
                duration /= 1000L;
                break;
            }
            case 12: {
                duration /= 60000L;
                break;
            }
            case 10: {
                duration /= 3600000L;
                break;
            }
            case 5: {
                duration /= 86400000L;
                break;
            }
        }
        return duration;
    }

    public static Date cloneDate(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public static java.sql.Date toSqlDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.sql.Date(date.getTime());
    }

    public static Date getDate(Date date, Date time) {
        Calendar dateCalendar = Calendar.getInstance();
        Calendar timeCalendar = Calendar.getInstance();
        dateCalendar.setTime(date);
        timeCalendar.setTime(time);
        dateCalendar.set(11, timeCalendar.get(11));
        dateCalendar.set(12, timeCalendar.get(12));
        dateCalendar.set(13, timeCalendar.get(13));
        dateCalendar.set(14, timeCalendar.get(14));
        return dateCalendar.getTime();
    }

    public static int getTime(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return (calendar.get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13)) * 1000 + calendar.get(14);
    }

    public static int getMinutes(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return MiscUtil.getMinutes(calendar.get(11), calendar.get(12));
    }

    public static int getMinutes(int hour, int minute) {
        return hour * 60 + minute;
    }

    public static Date setMinutes(Date date, int minutes) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hh = minutes / 60;
        calendar.set(11, hh);
        calendar.set(12, minutes - hh * 60);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date clearTime(Date value) {
        return MiscUtil.clearTime(value, true, true, true, true);
    }

    public static Date clearTime(Date value, String timeZoneId) {
        TimeZone timeZone = timeZoneId != null ? TimeZone.getTimeZone(timeZoneId) : null;
        return MiscUtil.clearTime(value, timeZone, true, true, true, true);
    }

    public static Date clearTime(Date value, boolean hours, boolean minutes, boolean seconds, boolean milliseconds) {
        return MiscUtil.clearTime(value, null, hours, minutes, seconds, milliseconds);
    }

    public static Date clearTime(Date value, TimeZone timeZone, boolean hours, boolean minutes, boolean seconds, boolean milliseconds) {
        if (value == null) {
            return value;
        }
        Calendar calendar = timeZone != null ? Calendar.getInstance(timeZone) : Calendar.getInstance();
        calendar.setTime(value);
        if (hours) {
            calendar.set(11, 0);
        }
        if (minutes) {
            calendar.set(12, 0);
        }
        if (seconds) {
            calendar.set(13, 0);
        }
        if (milliseconds) {
            calendar.set(14, 0);
        }
        return calendar.getTime();
    }

    public static Date setDayEndTime(Date value) {
        return MiscUtil.setDayEndTime(value, true, true, true, true);
    }

    public static Date setDayEndTime(Date value, boolean hours, boolean minutes, boolean seconds, boolean milliseconds) {
        if (value == null) {
            return value;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        if (hours) {
            calendar.set(11, 23);
        }
        if (minutes) {
            calendar.set(12, 59);
        }
        if (seconds) {
            calendar.set(13, 59);
        }
        if (milliseconds) {
            calendar.set(14, 999);
        }
        return calendar.getTime();
    }

    public static Date setTime(Date value, int hours, int minutes, int seconds, int milliseconds) {
        if (value == null) {
            return value;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, milliseconds);
        return calendar.getTime();
    }

    public static Date getBeforeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeInMillis(calendar.getTimeInMillis() - 1L);
        return calendar.getTime();
    }

    public static Date setAfterTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeInMillis(calendar.getTimeInMillis() + 1L);
        return calendar.getTime();
    }

    public static boolean isBetween(Date date1, Date date2, Date date) {
        if (date == null) {
            return false;
        }
        if (date1 != null && date1.after(date)) {
            return false;
        }
        return date2 == null || !date2.before(date);
    }

    public static boolean isBetween(LocalDate date1, LocalDate date2, LocalDate date) {
        if (date == null) {
            return false;
        }
        if (date1 != null && date1.isAfter(date)) {
            return false;
        }
        return date2 == null || !date2.isBefore(date);
    }

    public static boolean isBefore(Date date1, Date date2, Date date) {
        if (date == null) {
            return false;
        }
        return date1 != null && date1.after(date);
    }

    public static boolean isAfter(Date date1, Date date2, Date date) {
        if (date == null) {
            return false;
        }
        return date2 != null && date2.before(date);
    }

    public static boolean isSameDaySafe(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return date1 == null && date2 == null;
        }
        return MiscUtil.isSameDay(date1, date2);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        return cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2);
    }

    public static long getDaysBetween(Date date1, Date date2) {
        long diff = MiscUtil.clearTime(date1).getTime() - MiscUtil.clearTime(date2).getTime();
        return Math.abs(TimeUnit.MILLISECONDS.toDays(diff));
    }

    public static Date addYearsToDate(Date date, int years) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        return cal.getTime();
    }

    public static Date addMonthsToDate(Date date, int months) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, months);
        return cal.getTime();
    }

    public static Date addDaysToDate(Date date, int days) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date addHoursToDate(Date date, int hours) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, hours);
        return cal.getTime();
    }

    public static Date addMinutesToDate(Date date, int minutes) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, minutes);
        return cal.getTime();
    }

    public static Date addSecondsToDate(Date date, int seconds) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, seconds);
        return cal.getTime();
    }

    public static Date addToDate(Date date, int value, int field) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, value);
        return calendar.getTime();
    }

    public static Date setToDate(Date date, int value, int field) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(field, value);
        return calendar.getTime();
    }

    public static int getFromDate(Date date, int field) {
        if (date == null) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(field);
    }

    public static void logTiming(long start, String msg) {
        if (!TIMING_LOG.isDebugEnabled()) {
            return;
        }
        MiscUtil.logTimingInternal(start, msg);
    }

    public static void logTiming(long start, Supplier<String> msgSupplier) {
        if (!TIMING_LOG.isDebugEnabled()) {
            return;
        }
        MiscUtil.logTimingInternal(start, msgSupplier.get());
    }

    private static void logTimingInternal(long start, String msg) {
        long timing = System.currentTimeMillis() - start;
        TIMING_LOG.debug(msg + ", timing=" + timing + " msec");
    }

    public static long getTimestamp() {
        long lastTime;
        long now = System.currentTimeMillis();
        do {
            if ((lastTime = LAST_TIME_MS.get()) < now) continue;
            now = lastTime + 1L;
        } while (!LAST_TIME_MS.compareAndSet(lastTime, now));
        return now;
    }

    public static int find(byte[] arr, byte[] subArr, int start) {
        if (arr.length == 0 || subArr.length == 0 || start > arr.length || arr.length < subArr.length || start < 0) {
            return -1;
        }
        for (int i = start; i < arr.length - subArr.length; ++i) {
            for (int j = 0; j < subArr.length && arr[i + j] == subArr[j]; ++j) {
                if (j != subArr.length - 1) continue;
                return i;
            }
        }
        return -1;
    }

    public static String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static String toString(Object obj, SimpleDateFormat dateFormat) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Date) {
            return dateFormat.format((Date)obj);
        }
        return obj.toString();
    }

    public static void unpack(URL zipFile, File folder) throws IOException {
        MiscUtil.unpack(zipFile, folder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(URL zipFile, File folder, FilenameFilter filter) throws IOException {
        try (ZipInputStream zipStrm = new ZipInputStream(IoUtil.getResourceInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zipStrm.getNextEntry()) != null) {
                if (filter != null && !filter.accept(folder, entry.getName())) continue;
                MiscUtil.unpackEntry(zipStrm, entry, folder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpackEntry(ZipInputStream zipStrm, ZipEntry entry, File baseFolder) throws IOException {
        String name = entry.getName();
        if (name.endsWith("/")) {
            File folder = new File(baseFolder.getCanonicalPath() + '/' + name);
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("can't create folder " + folder);
            }
            folder.setLastModified(entry.getTime());
            return;
        }
        File file = new File(baseFolder.getCanonicalPath() + '/' + name);
        File folder = file.getParentFile();
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException("can't create folder " + folder);
        }
        try (BufferedOutputStream strm = new BufferedOutputStream(new FileOutputStream(file, false));){
            IoUtil.copyStream(zipStrm, strm, 1024);
        }
        file.setLastModified(entry.getTime());
    }

    public static String getCheckSum(InputStream strm) throws Exception {
        if (strm == null) {
            return null;
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        MiscUtil.updateCheckSum(md, strm);
        return Base64.encode(md.digest());
    }

    public static String getMd5Hash(byte[] content) throws NoSuchAlgorithmException, IOException {
        if (content == null) {
            return null;
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(content);
        return BinHex.encode(md.digest());
    }

    public static String getCheckSum(byte[] content) throws NoSuchAlgorithmException {
        if (content == null) {
            return null;
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(content);
        return Base64.encode(md.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCheckSum(URL url, boolean unpackZip) throws Exception {
        if (url == null) {
            return null;
        }
        if (!unpackZip || !url.getFile().toLowerCase().endsWith(".zip") && !url.getFile().toLowerCase().endsWith(".jar")) {
            try (InputStream is = IoUtil.getResourceInputStream(url);){
                String string = MiscUtil.getCheckSum(is);
                return string;
            }
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (ZipInputStream zipStrm = new ZipInputStream(IoUtil.getResourceInputStream(url));){
            MiscUtil.calculateCheckSum(md, zipStrm);
        }
        return Base64.encode(md.digest());
    }

    public static String getCheckSum(String entryName, InputStream strm) throws Exception {
        if (strm == null) {
            return null;
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        String name = entryName.toLowerCase();
        if (name.endsWith(".zip") || name.endsWith(".jar")) {
            MiscUtil.calculateCheckSum(md, new ZipInputStream(strm));
        } else {
            MiscUtil.updateCheckSum(md, strm);
        }
        return Base64.encode(md.digest());
    }

    public static <T> boolean equals(T o1, T o2) {
        return MiscUtil.equals(o1, o2, true);
    }

    public static <T> boolean equals(T o1, T o2, boolean nullIsEquals) {
        if (o1 == null && o2 == null) {
            return nullIsEquals;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        if (o1 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof BigDecimal && o2 instanceof BigDecimal) {
            return ((BigDecimal)o1).compareTo((BigDecimal)o2) == 0;
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            return ((Date)o1).getTime() == ((Date)o2).getTime();
        }
        return o1.equals(o2);
    }

    private static void updateCheckSum(MessageDigest md, InputStream strm) throws IOException {
        int len;
        byte[] buf = new byte[256];
        while ((len = strm.read(buf)) != -1) {
            md.update(buf, 0, len);
        }
    }

    public static String md5(String value) {
        return MiscUtil.md5(value, "UTF-8");
    }

    public static String md5(String value, String charset) {
        try {
            char[] str = value.toCharArray();
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(Charset.forName(charset).encode(CharBuffer.wrap(str)));
            return BinHex.encode(md5.digest()).toLowerCase();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static Date getMonthBegin(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return MiscUtil.clearTime(calendar.getTime());
    }

    public static Date getMonthEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return MiscUtil.setDayEndTime(calendar.getTime());
    }

    public static Date getYearBegin(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.getActualMinimum(2));
        return MiscUtil.getMonthBegin(calendar.getTime());
    }

    public static Date getYearEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.getActualMaximum(2));
        return MiscUtil.getMonthEnd(calendar.getTime());
    }

    public static Date getStartDecade(int periodType) {
        GregorianCalendar calendar = new GregorianCalendar();
        int currentDate = calendar.get(5);
        if (periodType == 1) {
            if (currentDate >= 1 && currentDate <= 10) {
                calendar.set(5, 1);
                return MiscUtil.clearTime(calendar.getTime());
            }
            if (currentDate >= 11 && currentDate <= 20) {
                calendar.set(5, 11);
                return MiscUtil.clearTime(calendar.getTime());
            }
            calendar.set(5, 21);
            return MiscUtil.clearTime(calendar.getTime());
        }
        if (periodType == 2) {
            if (currentDate >= 1 && currentDate <= 10) {
                calendar.add(2, -1);
                calendar.set(5, 21);
                return MiscUtil.clearTime(calendar.getTime());
            }
            if (currentDate >= 11 && currentDate <= 20) {
                calendar.set(5, 1);
                return MiscUtil.clearTime(calendar.getTime());
            }
            calendar.set(5, 11);
            return MiscUtil.clearTime(calendar.getTime());
        }
        if (periodType == 3) {
            if (currentDate >= 1 && currentDate <= 7) {
                calendar.set(5, 1);
                return MiscUtil.clearTime(calendar.getTime());
            }
            if (currentDate >= 8 && currentDate <= 15) {
                calendar.set(5, 8);
                return MiscUtil.clearTime(calendar.getTime());
            }
            if (currentDate >= 16 && currentDate <= 23) {
                calendar.set(5, 16);
                return MiscUtil.clearTime(calendar.getTime());
            }
            calendar.set(5, 24);
            return MiscUtil.clearTime(calendar.getTime());
        }
        if (periodType == 4) {
            if (currentDate >= 1 && currentDate <= 7) {
                calendar.add(2, -1);
                calendar.set(5, 24);
                return MiscUtil.clearTime(calendar.getTime());
            }
            if (currentDate >= 8 && currentDate <= 15) {
                calendar.set(5, 1);
                return MiscUtil.clearTime(calendar.getTime());
            }
            if (currentDate >= 16 && currentDate <= 23) {
                calendar.set(5, 8);
                return MiscUtil.clearTime(calendar.getTime());
            }
            calendar.set(5, 16);
            return MiscUtil.clearTime(calendar.getTime());
        }
        if (periodType == 5) {
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return MiscUtil.clearTime(calendar.getTime());
        }
        if (periodType == 6) {
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(2, -1);
            return MiscUtil.clearTime(calendar.getTime());
        }
        return null;
    }

    public static Date getEndDecade(int periodType) {
        GregorianCalendar calendar = new GregorianCalendar();
        int currentDate = calendar.get(5);
        if (periodType == 1) {
            if (currentDate >= 1 && currentDate <= 10) {
                calendar.set(5, 10);
                return MiscUtil.setDayEndTime(calendar.getTime());
            }
            if (currentDate >= 11 && currentDate <= 20) {
                calendar.set(5, 20);
                return MiscUtil.setDayEndTime(calendar.getTime());
            }
            calendar.set(5, calendar.getActualMaximum(5));
            return MiscUtil.setDayEndTime(calendar.getTime());
        }
        if (periodType == 2) {
            if (currentDate >= 1 && currentDate <= 10) {
                calendar.set(5, 0);
                return MiscUtil.setDayEndTime(calendar.getTime());
            }
            if (currentDate >= 11 && currentDate <= 20) {
                calendar.set(5, 10);
                return MiscUtil.setDayEndTime(calendar.getTime());
            }
            calendar.set(5, 20);
            return MiscUtil.setDayEndTime(calendar.getTime());
        }
        if (periodType == 3) {
            if (currentDate >= 1 && currentDate <= 7) {
                calendar.set(5, 7);
                return MiscUtil.setDayEndTime(calendar.getTime());
            }
            if (currentDate >= 8 && currentDate <= 15) {
                calendar.set(5, 15);
                return MiscUtil.setDayEndTime(calendar.getTime());
            }
            if (currentDate >= 16 && currentDate <= 23) {
                calendar.set(5, 23);
                return MiscUtil.setDayEndTime(calendar.getTime());
            }
            calendar.set(5, calendar.getActualMaximum(5));
            return MiscUtil.setDayEndTime(calendar.getTime());
        }
        if (periodType == 4) {
            if (currentDate >= 1 && currentDate <= 7) {
                calendar.set(5, 0);
                return MiscUtil.setDayEndTime(calendar.getTime());
            }
            if (currentDate >= 8 && currentDate <= 15) {
                calendar.set(5, 7);
                return MiscUtil.setDayEndTime(calendar.getTime());
            }
            if (currentDate >= 16 && currentDate <= 23) {
                calendar.set(5, 15);
                return MiscUtil.setDayEndTime(calendar.getTime());
            }
            calendar.set(5, 23);
            return MiscUtil.setDayEndTime(calendar.getTime());
        }
        if (periodType == 5) {
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(2, 1);
            calendar.add(14, -1);
            return MiscUtil.setDayEndTime(calendar.getTime());
        }
        if (periodType == 6) {
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(2, -1);
            calendar.add(2, 1);
            calendar.add(14, -1);
            return MiscUtil.setDayEndTime(calendar.getTime());
        }
        return null;
    }

    public static DateInterval getCurrentMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date start = cal.getTime();
        cal.add(2, 1);
        cal.add(14, -1);
        Date end = cal.getTime();
        return new DateInterval(start, end);
    }

    public static DateInterval getPreviousMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(2, -1);
        Date start = cal.getTime();
        cal.add(2, 1);
        cal.add(14, -1);
        Date end = cal.getTime();
        return new DateInterval(start, end);
    }

    public static DateInterval getLastDays(int days) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, -days);
        Date start = cal.getTime();
        cal.add(5, days);
        cal.add(14, -1);
        Date end = cal.getTime();
        return new DateInterval(start, end);
    }

    public static DateInterval getLastHalfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(2, -6);
        Date start = cal.getTime();
        cal.add(2, 6);
        cal.add(14, -1);
        Date end = cal.getTime();
        return new DateInterval(start, end);
    }

    public static <T> T findByLocale(Map<Locale, T> map, Locale locale) {
        if (locale == null || map == null) {
            return null;
        }
        T result = map.get(locale);
        if (result != null) {
            return result;
        }
        for (Map.Entry<Locale, T> entry : map.entrySet()) {
            if (entry.getKey() == null || !TextUtil.isSame(locale.getLanguage(), entry.getKey().getLanguage())) continue;
            return entry.getValue();
        }
        return map.get(Locale.ROOT);
    }

    public static <T> T findByLocale(Map<Locale, T> map, Locale locale, Locale defaultLocale) {
        if (locale == null || map == null) {
            return null;
        }
        T result = map.get(locale);
        if (result != null) {
            return result;
        }
        for (Map.Entry<Locale, T> entry : map.entrySet()) {
            if (entry.getKey() == null || !TextUtil.isSame(locale.getLanguage(), entry.getKey().getLanguage())) continue;
            return entry.getValue();
        }
        for (Map.Entry<Locale, T> entry : map.entrySet()) {
            if (entry.getKey() == null || !TextUtil.isSame(defaultLocale.getLanguage(), entry.getKey().getLanguage())) continue;
            return entry.getValue();
        }
        return map.get(Locale.ROOT);
    }

    public static <T> T guarded(T obj, T def) {
        if (obj != null) {
            return obj;
        }
        return def;
    }

    public static <T> T guarded(T obj, T def, T ... rest) {
        if (obj != null) {
            return obj;
        }
        if (def != null) {
            return def;
        }
        for (T o : rest) {
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public static <T> T guarded(T obj, Supplier<T> def) {
        return obj != null ? obj : def.get();
    }

    public static <T> Collection<T> guarded(Collection<T> c) {
        return MiscUtil.guarded(c, Collections.emptyList());
    }

    public static String guarded(String s) {
        return MiscUtil.guarded(s, "");
    }

    public static Integer guarded(Integer i) {
        return MiscUtil.guarded(i, 0);
    }

    public static BigInteger guarded(BigInteger bi) {
        return MiscUtil.guarded(bi, BigInteger.ZERO);
    }

    public static BigDecimal guarded(BigDecimal bd) {
        return MiscUtil.guarded(bd, BigDecimal.ZERO);
    }

    public static boolean isZero(BigDecimal value, boolean nullAsZero) {
        if (value == null) {
            return nullAsZero;
        }
        return BigDecimal.ZERO.compareTo(value) == 0;
    }

    public static Double guarded(Double d) {
        return MiscUtil.guarded(d, 0.0);
    }

    public static int hash(Object ... objects) {
        return Arrays.deepHashCode(objects);
    }

    public static boolean isTrue(String expr) {
        return Boolean.parseBoolean(expr);
    }

    private MiscUtil() {
    }

    public static String translateTerminal(String terminalName, Locale locale) {
        if (terminalName == null || locale == null) {
            return terminalName;
        }
        String result = terminalName;
        if ("ru".equalsIgnoreCase(locale.getLanguage())) {
            result = result.replace("TERMINAL", "\u0422\u0415\u0420\u041c\u0418\u041d\u0410\u041b");
            result = result.replace("TERM", "\u0422\u0415\u0420\u041c\u0418\u041d\u0410\u041b");
            result = result.replace("INTERNATIONAL", "\u041c\u0415\u0416\u0414\u0423\u041d\u0410\u0420\u041e\u0414\u041d\u042b\u0419");
            result = result.replace("INTL", "\u041c\u0415\u0416\u0414\u0423\u041d\u0410\u0420\u041e\u0414\u041d\u042b\u0419");
            result = result.replace("DOMESTIC", "\u0412\u041d\u0423\u0422\u0420\u0415\u041d\u041d\u0418\u0419");
            result = result.replace("DOM", "\u0412\u041d\u0423\u0422\u0420\u0415\u041d\u041d\u0418\u0419");
            result = result.replace("SOUTH", "\u042e\u0416\u041d\u042b\u0419");
            result = result.replace("NORTH", "\u0421\u0415\u0412\u0415\u0420\u041d\u042b\u0419");
            result = result.replace("WEST", "\u0417\u0410\u041f\u0410\u0414\u041d\u042b\u0419");
            result = result.replace("EAST", "\u0412\u041e\u0421\u0422\u041e\u0427\u041d\u042b\u0419");
            result = result.replace("AND", "\u0418");
            result = result.replace("MAIN", "\u041e\u0421\u041d\u041e\u0412\u041d\u041e\u0419");
        }
        return result;
    }

    public static BigDecimal round(BigDecimal number, BigDecimal sampler) {
        return MiscUtil.round(number, RoundingMode.HALF_UP, sampler);
    }

    public static BigDecimal floor(BigDecimal number, BigDecimal sampler) {
        return MiscUtil.round(number, RoundingMode.FLOOR, sampler);
    }

    public static BigDecimal ceil(BigDecimal number, BigDecimal sampler) {
        return MiscUtil.round(number, RoundingMode.CEILING, sampler);
    }

    public static BigDecimal up(BigDecimal number, BigDecimal sampler) {
        return MiscUtil.round(number, RoundingMode.UP, sampler);
    }

    public static BigDecimal round(BigDecimal number, RoundingMode roundingMode, BigDecimal sampler) {
        return number.divide(sampler, 0, roundingMode).multiply(sampler);
    }

    public static BigDecimal minimum(BigDecimal ... numbers) {
        BigDecimal minimum = null;
        for (BigDecimal number : numbers) {
            if (number == null) continue;
            minimum = minimum == null ? number : minimum.min(number);
        }
        return minimum;
    }

    public static BigDecimal maximum(BigDecimal ... numbers) {
        BigDecimal maximum = null;
        for (BigDecimal number : numbers) {
            if (number == null) continue;
            maximum = maximum == null ? number : maximum.max(number);
        }
        return maximum;
    }

    public static Date minimum(Date ... dates) {
        Date minimum = null;
        for (Date date : dates) {
            if (date == null) continue;
            minimum = minimum == null ? date : (date.after(minimum) ? minimum : date);
        }
        return minimum;
    }

    public static Date maximum(Date ... dates) {
        Date maximum = null;
        for (Date date : dates) {
            if (date == null) continue;
            maximum = maximum == null ? date : (date.before(maximum) ? maximum : date);
        }
        return maximum;
    }

    public static Double minimum(Double ... numbers) {
        Double minimum = null;
        for (Double number : numbers) {
            if (number == null) continue;
            minimum = minimum == null ? number : Double.valueOf(Math.min(minimum, number));
        }
        return minimum;
    }

    public static BigDecimal average(int scale, BigDecimal ... numbers) {
        BigDecimal average = null;
        int count = 0;
        for (BigDecimal number : numbers) {
            if (number == null) continue;
            average = average != null ? average.add(number) : number;
            ++count;
        }
        return average != null ? average.divide(BigDecimal.valueOf(count), scale, RoundingMode.HALF_UP) : null;
    }

    public static boolean isSame(BigDecimal ... numbers) {
        BigDecimal gauge = null;
        boolean initialize = false;
        for (BigDecimal number : numbers) {
            if (!initialize) {
                gauge = number;
                initialize = true;
            }
            if (!(number != null && gauge == null || number == null && gauge != null) && (number == null || gauge == null || number.compareTo(gauge) == 0)) continue;
            return false;
        }
        return true;
    }

    public static BigDecimal sum(BigDecimal ... numbers) {
        BigDecimal sum = null;
        for (BigDecimal number : numbers) {
            if (number == null) continue;
            sum = sum != null ? sum.add(number) : number;
        }
        return sum;
    }

    public static BigDecimal sub(BigDecimal main, BigDecimal ... subs) {
        if (main == null || ArrayUtils.isEmpty((Object[])subs)) {
            return main;
        }
        BigDecimal res = main;
        for (BigDecimal sub : subs) {
            res = sub == null ? res : res.subtract(sub);
        }
        return res;
    }

    public static BigDecimal negate(BigDecimal number) {
        return number != null ? number.negate() : null;
    }

    public static BigDecimal abs(BigDecimal number) {
        return number != null ? number.abs() : null;
    }

    public static BigDecimal nonNull(BigDecimal number) {
        return number != null ? number : BigDecimal.ZERO;
    }

    public static BigDecimal scale(BigDecimal number, int scale, RoundingMode roundingMode) {
        return number != null ? number.setScale(scale, roundingMode) : null;
    }

    public static boolean isNegative(BigDecimal number) {
        return number != null && number.compareTo(BigDecimal.ZERO) < 0;
    }

    @Deprecated
    public static String join(Collection<?> col, String separator) {
        StringBuilder res = new StringBuilder();
        Iterator<?> i = col.iterator();
        while (i.hasNext()) {
            res.append(i.next());
            if (!i.hasNext()) continue;
            res.append(separator);
        }
        return res.toString();
    }

    public static Date toDateSafe(XMLGregorianCalendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.toGregorianCalendar().getTime();
    }

    public static Date toDateWithoutTimeZone(XMLGregorianCalendar cal) {
        if (cal == null) {
            return null;
        }
        XMLGregorianCalendar clone = (XMLGregorianCalendar)cal.clone();
        clone.setTimezone(Integer.MIN_VALUE);
        return clone.toGregorianCalendar().getTime();
    }

    public static Date toDateWithoutTimeZone(DateTime datetime) {
        if (datetime == null) {
            return null;
        }
        return datetime.toLocalDateTime().toDate();
    }

    public static DateTime toDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime((Object)date);
    }

    public static DateTime toZoneDateTime(Date date, ZoneId zoneId) {
        if (date == null) {
            return null;
        }
        if (zoneId == null) {
            return MiscUtil.toDateTime(date);
        }
        return new LocalDateTime((Object)date).toDateTime(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(zoneId)));
    }

    public static XMLGregorianCalendar toXmlDateTimeSafe(Date date) {
        if (date == null) {
            return null;
        }
        try {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(date);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static XMLGregorianCalendar toXmlDateSafe(Date date) {
        if (date == null) {
            return null;
        }
        try {
            LocalDate localDate = MiscUtil.toLocalDate(date);
            int year = localDate.getYear();
            int month = localDate.getMonthValue();
            int day = localDate.getDayOfMonth();
            return DatatypeFactory.newInstance().newXMLGregorianCalendarDate(year, month, day, Integer.MIN_VALUE);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] nioByteBufferToByteArray(ByteBuffer buffer) {
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    public static Double negateDouble(Double number) {
        return number != null ? Double.valueOf(-1.0 * number) : null;
    }

    public static Period age(Date birthday, Date date) {
        if (birthday == null || date == null) {
            return null;
        }
        Calendar birthdayCalendar = Calendar.getInstance();
        Calendar dateCalendar = Calendar.getInstance();
        birthdayCalendar.setTime(birthday);
        dateCalendar.setTime(date);
        if (!birthdayCalendar.after(dateCalendar)) {
            int birthdayYear = birthdayCalendar.get(1);
            int dateYear = dateCalendar.get(1);
            int yearAge = dateYear - birthdayYear;
            int travellerBirthdayMonth = birthdayCalendar.get(2);
            int issueDateMonth = dateCalendar.get(2);
            int monthAge = issueDateMonth - travellerBirthdayMonth;
            if (monthAge < 0) {
                monthAge = 12 + monthAge;
                --yearAge;
            }
            int birthdayDay = birthdayCalendar.get(5);
            int dateDay = dateCalendar.get(5);
            int dayAge = dateDay - birthdayDay;
            if (dayAge < 0) {
                dayAge = 30 + dayAge;
                if (--monthAge < 0) {
                    monthAge = 12 + monthAge;
                    --yearAge;
                }
            }
            return new Period(yearAge, monthAge, dayAge, 0, 0, 0, 0, 0);
        }
        return new Period(0, 0, 0, 0, 0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deepCloneSerialization(T object) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
            Object object2;
            ObjectInputStream ois = new ObjectInputStream(bais);
            try {
                object2 = ois.readObject();
            }
            catch (Throwable throwable) {
                ois.close();
                throw throwable;
            }
            ois.close();
            return (T)object2;
        }
    }

    public static String getTimezoneDataVersion() {
        if (timezoneVersion == null) {
            timezoneVersion = ZoneRulesProvider.getVersions("UTC").lastEntry().getKey();
        }
        return timezoneVersion;
    }

    public static Integer getYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static long getDurationWithTimezones(Date dt1, TimeZone tz1, Date dt2, TimeZone tz2) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(dt1);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(dt2);
        return endCal.getTimeInMillis() - (long)tz2.getRawOffset() - (startCal.getTimeInMillis() - (long)tz1.getRawOffset());
    }

    public static String formatTime(Number time) {
        if (time == null) {
            return null;
        }
        int h = time.intValue() / 60;
        int m = time.intValue() % 60;
        DecimalFormat fmt = new DecimalFormat("00");
        return fmt.format(h) + ':' + fmt.format(m);
    }

    public static Date roundMinutes(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int minutes = cal.get(12);
        int diff = minutes % 60;
        if (diff < 30) {
            cal.add(12, -diff);
        } else {
            cal.add(12, 60 - diff);
        }
        return cal.getTime();
    }

    private static void calculateCheckSum(MessageDigest md, ZipInputStream strm) throws IOException {
        ZipEntry entry;
        while ((entry = strm.getNextEntry()) != null) {
            String entryName = entry.getName();
            md.update(entryName.getBytes(StandardCharsets.UTF_8));
            if (entryName.endsWith("/")) continue;
            if ((entryName = entryName.toLowerCase()).endsWith(".zip") || entryName.endsWith(".jar")) {
                MiscUtil.calculateCheckSum(md, new ZipInputStream(strm));
                continue;
            }
            MiscUtil.updateCheckSum(md, strm);
        }
    }

    public static void writeBytesWithoutXmlHeader(OutputStream os, byte[] data) throws Exception {
        if (data == null) {
            return;
        }
        for (byte[] XML_HEADER : XML_HEADERS) {
            if (data.length < XML_HEADER.length) continue;
            byte[] firstBytes = new byte[XML_HEADER.length];
            System.arraycopy(data, 0, firstBytes, 0, firstBytes.length);
            if (!Arrays.equals(firstBytes, XML_HEADER)) continue;
            os.write(data, XML_HEADER.length, data.length - XML_HEADER.length);
            return;
        }
        os.write(data);
    }

    public static BigDecimal mul(BigDecimal multiplier, BigDecimal multiplicand) {
        if (multiplier == null || multiplicand == null) {
            return null;
        }
        return multiplier.multiply(multiplicand);
    }

    public static byte[] serialize(Serializable obj) throws IOException {
        if (obj == null) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(obj);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static <T extends Serializable> T deserialize(byte[] data) throws IOException, ClassNotFoundException {
        if (data == null || data.length == 0) {
            return null;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));){
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
    }

    public static String getSimpleClassName(Class<?> cls) {
        String name = cls.getName();
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx + 1 == name.length()) {
            return "";
        }
        return name.substring(idx + 1);
    }

    public static String getClassName(Class<?> cls) {
        return cls == null ? null : cls.getName();
    }

    public static <TSrc, TRes> TRes extract(TSrc src, Function<TSrc, TRes> f) {
        return src == null ? null : (TRes)f.apply(src);
    }

    public static <T> T uncheckCall(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            return MiscUtil.throwException(e);
        }
    }

    public static <T> T throwException(Throwable e) {
        return MiscUtil.throwExceptionInternal(e);
    }

    private static <E extends Throwable, T> T throwExceptionInternal(Throwable e) throws E {
        throw e;
    }

    public static boolean isBetween(Number number1, Number number2, Number number) {
        if (number == null) {
            return false;
        }
        if (number1 != null && ((Comparable)((Object)number1)).compareTo(number) > 0) {
            return false;
        }
        return number2 == null || ((Comparable)((Object)number2)).compareTo(number) >= 0;
    }

    public static Date toDate(LocalDate date) {
        return date != null ? Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static Date toDate(java.time.LocalDateTime dateTime) {
        return dateTime != null ? Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static Date toDate(java.time.LocalTime localTime) {
        if (localTime != null) {
            LocalDate date = LocalDate.now();
            return Date.from(java.time.LocalDateTime.of(date.getYear(), date.getMonth(), date.getDayOfMonth(), localTime.getHour(), localTime.getMinute(), localTime.getSecond()).atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    public static LocalDate toLocalDate(Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate() : null;
    }

    public static LocalDate toLocalDate(Date date, String zoneId) {
        if (zoneId == null) {
            return MiscUtil.toLocalDate(date);
        }
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.of(zoneId)).toLocalDate() : null;
    }

    public static java.time.LocalDateTime toLocalDateTime(Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime() : null;
    }

    public static java.time.LocalDateTime toLocalDateTime(Date date, String zoneId) {
        if (zoneId == null) {
            return MiscUtil.toLocalDateTime(date);
        }
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.of(zoneId)).toLocalDateTime() : null;
    }

    public static java.time.LocalTime toLocalTime(Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalTime() : null;
    }

    public static <T> T orElse(T t, T def) {
        return t != null ? t : def;
    }

    public static <T> T orElseGet(T t, Supplier<? extends T> other) {
        return t != null ? t : other.get();
    }

    public static LocalDate convertLocalDateFromJoda(org.joda.time.LocalDate joda) {
        return LocalDate.of(joda.getYear(), joda.getMonthOfYear(), joda.getDayOfMonth());
    }

    public static Date convertDateFromJoda(org.joda.time.LocalDate jodaDate) {
        if (jodaDate == null) {
            return null;
        }
        return jodaDate.toDate();
    }

    public static org.joda.time.LocalDate convertToJodaLocalDate(Date dt) {
        if (dt == null) {
            return null;
        }
        return new org.joda.time.LocalDate((Object)dt);
    }

    public static DateTime changeTimeZone(DateTime dt, Integer offsetHours) {
        if (offsetHours == null) {
            return dt;
        }
        return dt.withZone(DateTimeZone.forOffsetHours((int)offsetHours));
    }

    public static TimeZone convertToTimeZone(String timeZoneId) {
        return timeZoneId == null ? null : TimeZone.getTimeZone(timeZoneId);
    }

    public static String getTimeZoneId(TimeZone timeZone) {
        return timeZone == null ? null : timeZone.getID();
    }

    public static String getValue(StringTokenizer tokenizer) {
        String value;
        if (tokenizer.hasMoreTokens() && !"null".equals(value = tokenizer.nextToken())) {
            return value;
        }
        return null;
    }

    public static String getValue(String[] arr, int i) {
        String value;
        if (arr != null && i >= 0 && i < arr.length && !"null".equals(value = arr[i])) {
            return value;
        }
        return null;
    }

    public static <S, V> V safeGet(S object, Function<S, V> mapper) {
        return object != null && mapper != null ? (V)mapper.apply(object) : null;
    }

    public static Class fromName(String cls) throws ClassNotFoundException {
        return TextUtil.isBlank(cls) ? null : Class.forName(cls);
    }

    public static Date createDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }

    public static long startOfDay(Date date, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static <T, V extends Comparable<V>> Comparator<T> comparator(Function<T, V> extractor) {
        return MiscUtil.comparator(extractor, MiscUtil::compare);
    }

    public static <T, V> Comparator<T> comparator(final Function<T, V> extractor, final Comparator<V> comparator) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return o1 == null ? 0 : 1;
                }
                return comparator.compare(extractor.apply(o1), extractor.apply(o2));
            }
        };
    }

    public static <T> Comparator<T> comparator(final Comparator<T> ... comparators) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return o1 == null ? 0 : 1;
                }
                for (Comparator comparator : comparators) {
                    int result = comparator.compare(o1, o2);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        };
    }

    public static <T> Comparator<T> comparator(final List<Comparator<T>> comparators) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return o1 == null ? 0 : 1;
                }
                for (Comparator comparator : comparators) {
                    int result = comparator.compare(o1, o2);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        };
    }

    public static <T> T getValue(Map<String, Object> data, String key) {
        return (T)data.get(key);
    }

    public static <T> T getValue(Map<String, Object> data, Enum<?> key) {
        return MiscUtil.getValue(data, EnumUtil.nameOf(key));
    }

    public static String getCurrencySymbol(String currencyCode) {
        return Currency.getInstance(currencyCode).getSymbol();
    }

    public static String getCurrencySymbol(String currencyCode, Locale locale) {
        return Currency.getInstance(currencyCode).getSymbol(locale);
    }

    public static java.time.LocalDateTime convertLocalDateTimeFromJoda(org.joda.time.LocalDate date, LocalTime time) {
        return java.time.LocalDateTime.of(LocalDate.of(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth()), java.time.LocalTime.of(time.getHourOfDay(), time.getMinuteOfHour()));
    }

    public static <T> T nvl(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static <O, T> T computeIfNull(O object, Function<O, T> getter, BiConsumer<O, T> setter, Supplier<T> supplier) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        Objects.requireNonNull(supplier);
        T item = getter.apply(object);
        if (item == null) {
            item = supplier.get();
            setter.accept(object, item);
        }
        return item;
    }

    public static <E, D, C extends Collection<D>> Collector<E, C, C> getListCollector(Function<E, D> function) {
        return MiscUtil.getCollectionCollector(() -> new ArrayList(), (o1, o2) -> o1.add(function.apply(o2)));
    }

    public static <E, D, C extends Collection<D>> Collector<E, C, C> getListCollector(BiConsumer<C, E> accumulator) {
        return MiscUtil.getCollectionCollector(() -> new ArrayList(), accumulator);
    }

    public static <E, D, C extends Collection<D>> Collector<E, C, C> getSetCollector(Function<E, D> function) {
        return MiscUtil.getCollectionCollector(() -> new HashSet(), (o1, o2) -> o1.add(function.apply(o2)));
    }

    public static <E, D, C extends Collection<D>> Collector<E, C, C> getSetCollector(BiConsumer<C, E> accumulator) {
        return MiscUtil.getCollectionCollector(() -> new HashSet(), accumulator);
    }

    public static <E, D, C extends Collection<D>> Collector<E, C, C> getCollectionCollector(Supplier<C> supplier, BiConsumer<C, E> accumulator) {
        return Collector.of(supplier, (o1, o2) -> accumulator.accept(o1, o2), (o1, o2) -> {
            o1.addAll(o2);
            return o1;
        }, new Collector.Characteristics[0]);
    }

    public static Date startOf(Date date, PeriodType periodType) {
        return MiscUtil.startOf(date, periodType, DayOfWeek.MONDAY);
    }

    public static Date startOf(Date date, PeriodType periodType, DayOfWeek startDayOfWeek) {
        if (PeriodType.EVERY_N_DAYS_OF_MONTH == periodType) {
            throw new IllegalArgumentException("unexpected periodType " + (Object)((Object)periodType));
        }
        return MiscUtil.startOf(date, periodType, startDayOfWeek, null);
    }

    public static Date startOf(Date date, PeriodType periodType, DayOfWeek startDayOfWeek, Integer interval) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfMonth = calendar.get(5);
        if (periodType == PeriodType.MONTH) {
            calendar.set(5, 1);
        } else if (periodType == PeriodType.MONTH_HALF) {
            if (dayOfMonth > 15) {
                calendar.set(5, 16);
            } else {
                calendar.set(5, 1);
            }
        } else if (periodType == PeriodType.DECADE) {
            if (dayOfMonth > 20) {
                calendar.set(5, 21);
            } else if (dayOfMonth > 10) {
                calendar.set(5, 11);
            } else {
                calendar.set(5, 1);
            }
        } else if (periodType == PeriodType.WEEK) {
            int currentDayOfWeekNumber = calendar.get(7);
            int startDayOfWeekNumber = startDayOfWeek != null ? startDayOfWeek.getValue() + 1 : 2;
            int offset = currentDayOfWeekNumber >= startDayOfWeekNumber ? startDayOfWeekNumber - currentDayOfWeekNumber : startDayOfWeekNumber - currentDayOfWeekNumber - 7;
            calendar.add(5, offset);
        } else if (periodType == PeriodType.BSP_PERIOD) {
            if (dayOfMonth > 23) {
                calendar.set(5, 24);
            } else if (dayOfMonth > 15) {
                calendar.set(5, 16);
            } else if (dayOfMonth > 7) {
                calendar.set(5, 8);
            } else {
                calendar.set(5, 1);
            }
        } else if (periodType == PeriodType.EVERY_N_DAYS_OF_MONTH) {
            Pair<Date, Date> intervalPeriod = MiscUtil.getIntervalPeriod(date, interval);
            if (intervalPeriod == null) {
                return null;
            }
            calendar.setTime(intervalPeriod.getFirst());
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date endOf(Date date, PeriodType periodType) {
        return MiscUtil.endOf(date, periodType, DayOfWeek.MONDAY);
    }

    public static Date endOf(Date date, PeriodType periodType, DayOfWeek startDayOfWeek) {
        if (PeriodType.EVERY_N_DAYS_OF_MONTH == periodType) {
            throw new IllegalArgumentException("unexpected periodType " + (Object)((Object)periodType));
        }
        return MiscUtil.endOf(date, periodType, startDayOfWeek, null);
    }

    public static Date endOf(Date date, PeriodType periodType, DayOfWeek startDayOfWeek, Integer interval) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfMonth = calendar.get(5);
        if (periodType == PeriodType.MONTH) {
            calendar.add(2, 1);
            calendar.set(5, 0);
        } else if (periodType == PeriodType.MONTH_HALF) {
            if (dayOfMonth > 15) {
                calendar.add(2, 1);
                calendar.set(5, 0);
            } else {
                calendar.set(5, 15);
            }
        } else if (periodType == PeriodType.DECADE) {
            if (dayOfMonth > 20) {
                calendar.add(2, 1);
                calendar.set(5, 0);
            } else if (dayOfMonth > 10) {
                calendar.set(5, 20);
            } else {
                calendar.set(5, 10);
            }
        } else if (periodType == PeriodType.WEEK) {
            int currentDayOfWeekNumber = calendar.get(7);
            int startDayOfWeekNumber = startDayOfWeek != null ? startDayOfWeek.getValue() + 1 : 2;
            int offset = currentDayOfWeekNumber >= startDayOfWeekNumber ? startDayOfWeekNumber - currentDayOfWeekNumber + 7 : startDayOfWeekNumber - currentDayOfWeekNumber;
            calendar.add(5, offset - 1);
        } else if (periodType == PeriodType.BSP_PERIOD) {
            if (dayOfMonth > 23) {
                calendar.add(2, 1);
                calendar.set(5, 0);
            } else if (dayOfMonth > 15) {
                calendar.set(5, 23);
            } else if (dayOfMonth > 7) {
                calendar.set(5, 15);
            } else {
                calendar.set(5, 7);
            }
        } else if (periodType == PeriodType.EVERY_N_DAYS_OF_MONTH) {
            Pair<Date, Date> intervalPeriod = MiscUtil.getIntervalPeriod(date, interval);
            if (intervalPeriod == null) {
                return null;
            }
            calendar.setTime(intervalPeriod.getSecond());
        }
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Pair<Date, Date> getIntervalPeriod(Date date, Integer interval) {
        Pair<Date, Date> period;
        if (date == null || interval == null || interval <= 0) {
            return null;
        }
        ArrayList<Pair<Date, Date>> periods = new ArrayList<Pair<Date, Date>>();
        Date monthBegin = MiscUtil.getMonthBegin(date);
        LocalDate monthBeginLocal = monthBegin.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Date monthEnd = MiscUtil.getMonthEnd(date);
        LocalDate monthEndLocal = monthEnd.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int days = (int)Duration.between(monthBeginLocal.atStartOfDay(), monthEndLocal.atStartOfDay()).toDays() + 1;
        int count = days / interval;
        for (int i = 0; i < count; ++i) {
            period = new Pair<Date, Date>(MiscUtil.addDaysToDate(monthBegin, i * interval), MiscUtil.setTime(MiscUtil.addDaysToDate(monthBegin, i * interval + interval - 1), 23, 59, 59, 999));
            periods.add(period);
        }
        int remain = days - count * interval;
        if (remain != 0) {
            period = new Pair<Date, Date>(MiscUtil.clearTime(MiscUtil.addDaysToDate(monthEnd, -remain + 1)), monthEnd);
            periods.add(period);
        }
        return periods.stream().filter(item -> MiscUtil.isBetween((Date)item.getFirst(), (Date)item.getSecond(), date)).findFirst().orElse(null);
    }

    static {
        XML_HEADERS = new byte[][]{"<?xml version=\"1.0\"?>".getBytes(), "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes(), "<?xml version='1.0' encoding='UTF-8'?>".getBytes(), "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>".getBytes(), "<?xml version=\"1.0\" encoding=\"utf-8\"?>".getBytes(), "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>".getBytes(), "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>".getBytes()};
        LAST_TIME_MS = new AtomicLong();
    }

    public static enum PeriodType {
        MONTH,
        MONTH_HALF,
        DECADE,
        WEEK,
        DAY,
        BSP_PERIOD,
        EVERY_N_DAYS_OF_MONTH;

    }

    public static class Proxy<E> {
        private E value;

        public Proxy(E value) {
            this.value = value;
        }

        public Proxy() {
        }

        public E getValue() {
            return this.value;
        }

        public void setValue(E value) {
            this.value = value;
        }
    }

    public static final class Pair<T1, T2>
    implements Serializable,
    XCloneable {
        private static final long serialVersionUID = 7991391961265143025L;
        private T1 first;
        private T2 second;

        public Pair() {
        }

        public Pair(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }

        public boolean isEmpty() {
            return this.first == null && this.second == null;
        }

        public T1 getFirst() {
            return this.first;
        }

        public void setFirst(T1 first) {
            this.first = first;
        }

        public T2 getSecond() {
            return this.second;
        }

        public void setSecond(T2 second) {
            this.second = second;
        }

        public int hashCode() {
            return MiscUtil.hash(this.getFirst(), this.getSecond());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Pair)) {
                return false;
            }
            Pair that = (Pair)obj;
            return MiscUtil.equals(this.getFirst(), that.getFirst()) && MiscUtil.equals(this.getSecond(), that.getSecond());
        }

        public static <T1, T2> Pair<T1, T2> of(T1 o1, T2 o2) {
            return new Pair<T1, T2>(o1, o2);
        }

        public String toString() {
            return String.format("(%s, %s)", this.first, this.second);
        }

        @Override
        public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
            Pair<T1, T2> clone = new Pair<T1, T2>();
            clone.first = XCloneHelper.cloneObject(this.first, newUids, uids);
            clone.second = XCloneHelper.cloneObject(this.second, newUids, uids);
            return clone;
        }
    }

    public static class Value<T> {
        private T t;

        public Value(T t) {
            this.t = t;
        }

        public Value() {
        }

        public T getValue() {
            return this.t;
        }

        public void setValue(T t) {
            this.t = t;
        }
    }
}

