/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.l10n.EnglishNumber2WordsConverter;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MoneyUtil {
    private static Map<Locale, Map<String, MoneyUtil>> localeMap = new HashMap<Locale, Map<String, MoneyUtil>>();
    private static final EnglishNumber2WordsConverter EN_CONVERTER;
    private final String name;
    private final String rubOneUnit;
    private final String rubTwoUnit;
    private final String rubFiveUnit;
    private final String rubSex;
    private final String kopOneUnit;
    private final String kopTwoUnit;
    private final String kopFiveUnit;
    private final String kopSex;

    public static String money2str(Locale locale, String currency, double value) {
        return MoneyUtil.money2str(locale, currency, value, false, true);
    }

    public static String money2str(Locale locale, String currency, double value, boolean printCents) {
        return MoneyUtil.money2str(locale, currency, value, false, printCents);
    }

    public static String money2str(Locale locale, String currency, double value, boolean useDigitCents, boolean printCents) {
        Map<String, MoneyUtil> currMap = MiscUtil.findByLocale(localeMap, locale);
        if (currMap == null) {
            throw new IllegalArgumentException("unsupported locale " + locale);
        }
        MoneyUtil moneyUtil = currMap.get(currency);
        if (moneyUtil == null) {
            throw new IllegalArgumentException("unsupported currency " + currency + " for locale " + locale);
        }
        return moneyUtil.money2str(value, useDigitCents, printCents);
    }

    public static String intToString(int number, Locale loc, String sex) {
        if (loc == null) {
            throw new NullPointerException("locale");
        }
        switch (loc.getLanguage()) {
            case "ru": {
                if (sex == null || !sex.equals("M") && !sex.equals("F")) {
                    return MoneyUtil.triad2Word(number, 0, "M");
                }
                return MoneyUtil.triad2Word(number, 0, sex);
            }
            case "en": {
                return EN_CONVERTER.toNumberWords(BigDecimal.valueOf(number));
            }
        }
        throw new IllegalArgumentException("unsupported locale " + loc);
    }

    public static String getCurrencyName(Locale locale, String currency) {
        Map<String, MoneyUtil> currMap = MiscUtil.findByLocale(localeMap, locale);
        if (currMap == null) {
            throw new IllegalArgumentException("unsupported locale " + locale);
        }
        MoneyUtil moneyUtil = currMap.get(currency);
        if (moneyUtil == null) {
            throw new IllegalArgumentException("unsupported currency " + currency + " for locale " + locale);
        }
        return moneyUtil.name;
    }

    public static boolean isLocaleSupported(Locale locale) {
        return MiscUtil.findByLocale(localeMap, locale) != null;
    }

    public static boolean isCurrencySupported(Locale locale, String currency) {
        Map<String, MoneyUtil> currMap = MiscUtil.findByLocale(localeMap, locale);
        return currMap != null && currMap.containsKey(currency);
    }

    private MoneyUtil(Element el) {
        this.name = el.getAttribute("Name");
        this.rubOneUnit = el.getAttribute("RubOneUnit");
        this.rubTwoUnit = el.getAttribute("RubTwoUnit");
        this.rubFiveUnit = el.getAttribute("RubFiveUnit");
        this.kopOneUnit = el.getAttribute("KopOneUnit");
        this.kopTwoUnit = el.getAttribute("KopTwoUnit");
        this.kopFiveUnit = el.getAttribute("KopFiveUnit");
        this.rubSex = el.getAttribute("RubSex");
        this.kopSex = el.getAttribute("KopSex");
    }

    private String money2str(double value, boolean useDigitCents, boolean printCents) {
        StringBuilder result = new StringBuilder();
        int triadNum = 0;
        int intPart = (int)value;
        int fractPart = (int)Math.round((value - (double)intPart) * 100.0);
        if (intPart == 0) {
            result.append("\u043d\u043e\u043b\u044c ");
        }
        do {
            int theTriad = intPart % 1000;
            result.insert(0, MoneyUtil.triad2Word(theTriad, triadNum, this.rubSex));
            if (triadNum == 0) {
                int range10 = theTriad % 100 / 10;
                int range = theTriad % 10;
                if (range10 == 1) {
                    result.append(this.rubFiveUnit);
                } else {
                    switch (range) {
                        case 1: {
                            result.append(this.rubOneUnit);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            result.append(this.rubTwoUnit);
                            break;
                        }
                        default: {
                            result.append(this.rubFiveUnit);
                        }
                    }
                }
            }
            ++triadNum;
        } while ((intPart /= 1000) > 0);
        if (printCents) {
            result.append(" ");
            if (useDigitCents) {
                result.append(new DecimalFormat("00").format(fractPart)).append(' ');
            } else if (fractPart == 0) {
                result.append("\u043d\u043e\u043b\u044c ");
            } else {
                result.append(MoneyUtil.triad2Word(fractPart, 0, this.kopSex));
            }
            result.append(TextUtil.declension(fractPart, this.kopOneUnit, this.kopTwoUnit, this.kopFiveUnit));
        }
        return result.toString();
    }

    private static String triad2Word(int triad, int triadNum, String sex) {
        StringBuilder result = new StringBuilder(28);
        if (triad == 0) {
            return result.toString();
        }
        int range = triad / 100;
        switch (range) {
            default: {
                break;
            }
            case 1: {
                result = result.append("\u0441\u0442\u043e ");
                break;
            }
            case 2: {
                result = result.append("\u0434\u0432\u0435\u0441\u0442\u0438 ");
                break;
            }
            case 3: {
                result = result.append("\u0442\u0440\u0438\u0441\u0442\u0430 ");
                break;
            }
            case 4: {
                result = result.append("\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430 ");
                break;
            }
            case 5: {
                result = result.append("\u043f\u044f\u0442\u044c\u0441\u043e\u0442 ");
                break;
            }
            case 6: {
                result = result.append("\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442 ");
                break;
            }
            case 7: {
                result = result.append("\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ");
                break;
            }
            case 8: {
                result = result.append("\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442 ");
                break;
            }
            case 9: {
                result = result.append("\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442 ");
            }
        }
        range = triad % 100 / 10;
        switch (range) {
            default: {
                break;
            }
            case 2: {
                result = result.append("\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c ");
                break;
            }
            case 3: {
                result = result.append("\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c ");
                break;
            }
            case 4: {
                result = result.append("\u0441\u043e\u0440\u043e\u043a ");
                break;
            }
            case 5: {
                result = result.append("\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ");
                break;
            }
            case 6: {
                result = result.append("\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442 ");
                break;
            }
            case 7: {
                result = result.append("\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ");
                break;
            }
            case 8: {
                result = result.append("\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442 ");
                break;
            }
            case 9: {
                result = result.append("\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e ");
            }
        }
        int range10 = range;
        range = triad % 10;
        if (range10 == 1) {
            switch (range) {
                case 0: {
                    result = result.append("\u0434\u0435\u0441\u044f\u0442\u044c ");
                    break;
                }
                case 1: {
                    result = result.append("\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 2: {
                    result = result.append("\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 3: {
                    result = result.append("\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 4: {
                    result = result.append("\u0447\u0435\u0442\u044b\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 5: {
                    result = result.append("\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 6: {
                    result = result.append("\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 7: {
                    result = result.append("\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 8: {
                    result = result.append("\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                    break;
                }
                case 9: {
                    result = result.append("\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c ");
                }
            }
        } else {
            switch (range) {
                default: {
                    break;
                }
                case 1: {
                    if (triadNum == 1) {
                        result = result.append("\u043e\u0434\u043d\u0430 ");
                        break;
                    }
                    if (sex.equals("M")) {
                        result = result.append("\u043e\u0434\u0438\u043d ");
                        break;
                    }
                    if (!sex.equals("F")) break;
                    result = result.append("\u043e\u0434\u043d\u0430 ");
                    break;
                }
                case 2: {
                    if (triadNum == 1) {
                        result = result.append("\u0434\u0432\u0435 ");
                        break;
                    }
                    if (sex.equals("M")) {
                        result = result.append("\u0434\u0432\u0430 ");
                        break;
                    }
                    if (!sex.equals("F")) break;
                    result = result.append("\u0434\u0432\u0435 ");
                    break;
                }
                case 3: {
                    result = result.append("\u0442\u0440\u0438 ");
                    break;
                }
                case 4: {
                    result = result.append("\u0447\u0435\u0442\u044b\u0440\u0435 ");
                    break;
                }
                case 5: {
                    result = result.append("\u043f\u044f\u0442\u044c ");
                    break;
                }
                case 6: {
                    result = result.append("\u0448\u0435\u0441\u0442\u044c ");
                    break;
                }
                case 7: {
                    result = result.append("\u0441\u0435\u043c\u044c ");
                    break;
                }
                case 8: {
                    result = result.append("\u0432\u043e\u0441\u0435\u043c\u044c ");
                    break;
                }
                case 9: {
                    result = result.append("\u0434\u0435\u0432\u044f\u0442\u044c ");
                }
            }
        }
        block44 : switch (triadNum) {
            default: {
                break;
            }
            case 1: {
                if (range10 == 1) {
                    result = result.append("\u0442\u044b\u0441\u044f\u0447 ");
                    break;
                }
                switch (range) {
                    default: {
                        result = result.append("\u0442\u044b\u0441\u044f\u0447 ");
                        break block44;
                    }
                    case 1: {
                        result = result.append("\u0442\u044b\u0441\u044f\u0447\u0430 ");
                        break block44;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                }
                result = result.append("\u0442\u044b\u0441\u044f\u0447\u0438 ");
                break;
            }
            case 2: {
                if (range10 == 1) {
                    result = result.append("\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432 ");
                    break;
                }
                switch (range) {
                    default: {
                        result = result.append("\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432 ");
                        break block44;
                    }
                    case 1: {
                        result = result.append("\u043c\u0438\u043b\u043b\u0438\u043e\u043d ");
                        break block44;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                }
                result = result.append("\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u0430 ");
                break;
            }
            case 3: {
                if (range10 == 1) {
                    result = result.append("\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u043e\u0432 ");
                    break;
                }
                switch (range) {
                    default: {
                        result = result.append("\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u043e\u0432 ");
                        break block44;
                    }
                    case 1: {
                        result = result.append("\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434 ");
                        break block44;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                }
                result = result.append("\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u0430 ");
                break;
            }
            case 4: {
                if (range10 == 1) {
                    result = result.append("\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432 ");
                    break;
                }
                switch (range) {
                    default: {
                        result = result.append("\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432 ");
                        break block44;
                    }
                    case 1: {
                        result = result.append("\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d ");
                        break block44;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                }
                result = result.append("\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u0430 ");
            }
        }
        return result.toString();
    }

    static {
        Logger log = LoggerFactory.getLogger(MoneyUtil.class);
        try {
            Document xmlDoc;
            try (InputStream strm = MoneyUtil.class.getResourceAsStream("MoneyUtil.xml");){
                xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(strm);
            }
            NodeList els = xmlDoc.getDocumentElement().getElementsByTagName("Currencies");
            for (int i = 0; i < els.getLength(); ++i) {
                Element el = (Element)XmlUtil.safeGetNode(els, i);
                Locale locale = TextUtil.str2locale(el.getAttribute("Locale"));
                HashMap<String, MoneyUtil> map = new HashMap<String, MoneyUtil>();
                NodeList els2 = el.getElementsByTagName("Currency");
                for (int j = 0; j < els2.getLength(); ++j) {
                    Element el2 = (Element)XmlUtil.safeGetNode(els2, j);
                    String curr = el2.getAttribute("Code");
                    map.put(curr, new MoneyUtil(el2));
                    log.debug("populated currency " + curr + " for locale " + locale);
                }
                localeMap.put(locale, map);
                log.debug("populated locale " + locale);
            }
        }
        catch (Exception e) {
            log.error("failed initializing class " + MoneyUtil.class.getName(), (Throwable)e);
        }
        EN_CONVERTER = new EnglishNumber2WordsConverter();
    }
}

