/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

public class MultiString {
    private String delimeter;
    private String[] parts;
    private Integer hash;
    private Integer length;

    public MultiString(String ... parts) {
        this(false, null, parts);
    }

    public MultiString(boolean withDelimeter, String delimeter, String ... parts) {
        this.delimeter = delimeter;
        this.parts = parts;
    }

    public int hashCode() {
        int h;
        if (this.hash == null) {
            h = 0;
            for (int i = 0; i < this.parts.length; ++i) {
                int j;
                if (this.delimeter != null && i > 0) {
                    for (j = 0; j < this.delimeter.length(); ++j) {
                        h = 31 * h + this.delimeter.charAt(j);
                    }
                }
                for (j = 0; j < this.parts[i].length(); ++j) {
                    h = 31 * h + this.parts[i].charAt(j);
                }
            }
            this.hash = h;
        } else {
            h = this.hash;
        }
        return h;
    }

    public int length() {
        int l;
        if (this.length == null) {
            l = 0;
            for (int i = 0; i < this.parts.length; ++i) {
                l += this.parts[i].length();
            }
            if (this.delimeter != null && this.parts.length > 1) {
                l += (this.parts.length - 1) * this.delimeter.length();
            }
            this.length = l;
        } else {
            l = this.length;
        }
        return l;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof MultiString) {
            MultiString ms = (MultiString)anObject;
            int n = this.length();
            if (n == ms.length()) {
                int p1;
                int i1 = 0;
                int p2 = 0;
                int i2 = 0;
                for (p1 = 0; p1 < this.parts.length && this.parts[p1].length() == 0; ++p1) {
                }
                while (p2 < ms.parts.length && ms.parts[p2].length() == 0) {
                    ++p2;
                }
                boolean d1 = false;
                boolean d2 = false;
                while (n-- != 0) {
                    char c2;
                    char c1 = d1 ? this.delimeter.charAt(i1) : this.parts[p1].charAt(i1);
                    char c = c2 = d2 ? ms.delimeter.charAt(i2) : ms.parts[p2].charAt(i2);
                    if (c1 != c2) {
                        return false;
                    }
                    if (d1) {
                        if (i1 + 1 == this.delimeter.length()) {
                            d1 = false;
                            i1 = 0;
                            while (++p1 < this.parts.length && this.parts[p1].length() == 0) {
                            }
                        } else {
                            ++i1;
                        }
                    } else if (i1 + 1 == this.parts[p1].length()) {
                        i1 = 0;
                        if (this.delimeter == null || this.delimeter.length() == 0) {
                            while (++p1 < this.parts.length && this.parts[p1].length() == 0) {
                            }
                        } else {
                            d1 = true;
                        }
                    } else {
                        ++i1;
                    }
                    if (d2) {
                        if (i2 + 1 == ms.delimeter.length()) {
                            d2 = false;
                            i2 = 0;
                            while (++p2 < ms.parts.length && ms.parts[p2].length() == 0) {
                            }
                            continue;
                        }
                        ++i2;
                        continue;
                    }
                    if (i2 + 1 == ms.parts[p2].length()) {
                        i2 = 0;
                        if (ms.delimeter == null || ms.delimeter.length() == 0) {
                            while (++p2 < ms.parts.length && ms.parts[p2].length() == 0) {
                            }
                            continue;
                        }
                        d2 = true;
                        continue;
                    }
                    ++i2;
                }
                return true;
            }
        }
        return false;
    }

    public String join() {
        int i;
        Object result;
        if (this.delimeter == null || this.delimeter.length() == 0) {
            result = null;
            boolean needJoin = false;
            for (i = 0; i < this.parts.length; ++i) {
                if (this.parts[i].length() <= 0) continue;
                if (result == null) {
                    result = this.parts[i];
                    continue;
                }
                needJoin = true;
                break;
            }
            if (!needJoin) {
                return (char[])(result != null ? result : (char[])"");
            }
        }
        result = new char[this.length()];
        int c = 0;
        for (int p = 0; p < this.parts.length; ++p) {
            if (p > 0 && this.delimeter != null) {
                for (i = 0; i < this.delimeter.length(); ++i) {
                    result[c++] = this.delimeter.charAt(i);
                }
            }
            for (i = 0; i < this.parts[p].length(); ++i) {
                result[c++] = this.parts[p].charAt(i);
            }
        }
        return new String((char[])result);
    }
}

