/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;

public class ObjectHolder<T>
implements Identity {
    private T value;

    public ObjectHolder() {
    }

    public ObjectHolder(T value) {
        this();
        this.value = value;
    }

    @Override
    public String getUid() {
        return this.value == null ? null : String.valueOf(this.value.hashCode());
    }

    @Override
    public void setUid(String uid) {
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ObjectHolder)) {
            return false;
        }
        ObjectHolder oh = (ObjectHolder)obj;
        return MiscUtil.equals(this.value, oh.getValue());
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public static <T> List<ObjectHolder<T>> toHolders(List<T> values) {
        ArrayList<ObjectHolder<T>> result = new ArrayList<ObjectHolder<T>>();
        for (T value : values) {
            result.add(new ObjectHolder<T>(value));
        }
        return result;
    }

    public static <T> List<T> fromHolders(List<ObjectHolder<T>> values) {
        ArrayList<T> result = new ArrayList<T>();
        for (ObjectHolder<T> value : values) {
            result.add(value.getValue());
        }
        return result;
    }

    public static <T> ObjectHolder<T> of(T value) {
        return new ObjectHolder<T>(value);
    }
}

