/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class Predicates {
    public static <T> Predicate<T> metodRef(Predicate<T> metodRef) {
        return metodRef;
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return o -> !predicate.test(o);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... predicates) {
        return o -> Arrays.stream(predicates).allMatch(p -> p.test(o));
    }

    public static <I, O extends I> InstanceOfPredicate<I, O> instanceOf(Class<O> cls) {
        return new InstanceOfPredicate(cls);
    }

    public static <T> Predicate<? super T> simplePredicate(boolean value) {
        return t -> value;
    }

    public static <T, U> BiPredicate<? super T, ? super U> simpleBiPredicate(boolean value) {
        return (t, v) -> value;
    }

    public static class InstanceOfPredicate<I, O extends I>
    implements NarrowingPredicate<I, O> {
        private final Class<O> cls;

        public InstanceOfPredicate(Class<O> cls) {
            this.cls = cls;
        }

        @Override
        public boolean test(I o) {
            return o != null && this.cls.isAssignableFrom(o.getClass());
        }
    }

    public static interface NarrowingPredicate<I, O extends I>
    extends Predicate<I> {
    }
}

