/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.util.TestObj;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionUtilTest {
    @Test
    public void testEmptyConstructorFound() {
        Collection<Constructor<HasOneEmptyConstructor>> cs = ReflectionUtil.findPublicConstructors(HasOneEmptyConstructor.class, new Object[0]);
        Assert.assertEquals((long)1L, (long)cs.size());
        cs = ReflectionUtil.findPublicConstructors(HasOneEmptyConstructor.class, new Object[0]);
        Assert.assertEquals((long)1L, (long)cs.size());
        cs = ReflectionUtil.findPublicConstructors(HasOneEmptyConstructor.class, null);
        Assert.assertEquals((long)1L, (long)cs.size());
    }

    @Test
    public void testSubclass() {
        ReflectionUtil.findSinglePublicConstructor(AClass.class, Integer.MIN_VALUE);
    }

    @Test
    public void testParameterizedPrimitiveConstructorFound() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Collection<Constructor<HasOneEmptyOneParameterizedConstructor>> cs = ReflectionUtil.findPublicConstructors(HasOneEmptyOneParameterizedConstructor.class, 1);
        Assert.assertEquals((long)1L, (long)cs.size());
        Constructor<HasOneEmptyOneParameterizedConstructor> c = cs.iterator().next();
        Assert.assertEquals((long)1L, (long)c.getParameterTypes().length);
        Assert.assertEquals(Integer.TYPE, c.getParameterTypes()[0]);
        cs = ReflectionUtil.findPublicConstructors(HasOneEmptyOneParameterizedConstructor.class, 1);
        Assert.assertEquals((long)1L, (long)cs.size());
        c = cs.iterator().next();
        Assert.assertEquals((long)1L, (long)c.getParameterTypes().length);
        Assert.assertEquals(Integer.TYPE, c.getParameterTypes()[0]);
        HasOneEmptyOneParameterizedConstructor instance = c.newInstance(31415);
        Assert.assertEquals((long)31415L, (long)instance.i);
        cs = ReflectionUtil.findPublicConstructors(HasOneEmptyOneParameterizedConstructor.class, new Object[]{null});
        Assert.assertEquals((long)0L, (long)cs.size());
    }

    @Test
    public void testMethodHandle() {
        MethodHandle statusMH = ReflectionUtil.getMethodHandleForField(TestObj.class, "status");
        int status = (Integer)ReflectionUtil.getField(statusMH, new TestObj());
        Assert.assertEquals((long)100L, (long)status);
    }

    private static class AClass {
        public AClass(Object o) {
        }
    }

    private static class HasOneEmptyOneParameterizedConstructor {
        public final int i;

        public HasOneEmptyOneParameterizedConstructor() {
            this(0);
        }

        public HasOneEmptyOneParameterizedConstructor(int i) {
            this.i = i;
        }
    }

    private static class HasOneEmptyConstructor {
    }
}

