/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;

public class RsaUtil {
    public static int SIZE_2048 = 2048;
    public static int SIZE_1024 = 1024;

    public static byte[] encrypt(byte[] data, byte[] publicKey, int keySize) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Cipher cf = Cipher.getInstance("RSA/ECB/NoPadding");
        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKey));
        cf.init(1, pubKey);
        return cf.doFinal(data);
    }

    public static byte[] decrypt(byte[] data, byte[] privateKey, int keySize) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Cipher cf = Cipher.getInstance("RSA/ECB/NoPadding");
        PrivateKey priKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKey));
        cf.init(2, priKey);
        return cf.doFinal(data);
    }

    public static class RsaKeyPair {
        private final byte[] privateKey;
        private final byte[] publicKey;
        private final int keySize;

        public RsaKeyPair(int keySize) throws Exception {
            KeyPairGenerator kg = KeyPairGenerator.getInstance("RSA");
            this.keySize = keySize;
            kg.initialize(keySize);
            KeyPair pair = kg.generateKeyPair();
            PrivateKey priKey = pair.getPrivate();
            byte[] key = priKey.getEncoded();
            this.privateKey = Arrays.copyOf(key, key.length);
            PublicKey pubKey = pair.getPublic();
            key = pubKey.getEncoded();
            this.publicKey = Arrays.copyOf(key, key.length);
        }

        public byte[] getPrivateKey() {
            return this.privateKey;
        }

        public byte[] getPublicKey() {
            return this.publicKey;
        }

        public int getKeySize() {
            return this.keySize;
        }
    }
}

