/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.PersonalNameImpl;
import com.gridnine.xtrip.common.util.ReplacementUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class TextUtil {
    public static final String RIGHT_ARROW = "\u2192";
    private static final String[][] RU_EN = new String[][]{{"\u0410", "A"}, {"\u0411", "B"}, {"\u0412", "V"}, {"\u0413", "G"}, {"\u0414", "D"}, {"\u0415", "E"}, {"\u0401", "Yo"}, {"\u0416", "Zh"}, {"\u0417", "Z"}, {"\u0418", "I"}, {"\u0419", "Y"}, {"\u041a", "K"}, {"\u041b", "L"}, {"\u041c", "M"}, {"\u041d", "N"}, {"\u041e", "O"}, {"\u041f", "P"}, {"\u0420", "R"}, {"\u0421", "S"}, {"\u0422", "T"}, {"\u0423", "U"}, {"\u0424", "F"}, {"\u0425", "Kh"}, {"\u0426", "Ts"}, {"\u0427", "Ch"}, {"\u0428", "Sh"}, {"\u0429", "Sh"}, {"\u042b", "Y"}, {"\u042d", "E"}, {"\u042e", "Yu"}, {"\u042f", "Ya"}, {"\u042a", ""}, {"\u042c", ""}};
    private static final String[][] ru_en = new String[][]{{"\u0430", "a"}, {"\u0431", "b"}, {"\u0432", "v"}, {"\u0433", "g"}, {"\u0434", "d"}, {"\u0435", "e"}, {"\u0451", "yo"}, {"\u0436", "zh"}, {"\u0437", "z"}, {"\u0438", "i"}, {"\u0439", "y"}, {"\u043a", "k"}, {"\u043b", "l"}, {"\u043c", "m"}, {"\u043d", "n"}, {"\u043e", "o"}, {"\u043f", "p"}, {"\u0440", "r"}, {"\u0441", "s"}, {"\u0442", "t"}, {"\u0443", "u"}, {"\u0444", "f"}, {"\u0445", "kh"}, {"\u0446", "ts"}, {"\u0447", "ch"}, {"\u0448", "sh"}, {"\u0449", "sh"}, {"\u044b", "y"}, {"\u044d", "e"}, {"\u044e", "yu"}, {"\u044f", "ya"}, {"\u044a", ""}, {"\u044c", ""}};
    private static final String[][] EN_RU = new String[][]{{"ZH", "\u0416"}, {"KH", "\u0425"}, {"TS", "\u0426"}, {"CH", "\u0427"}, {"SH", "\u0428"}, {"SH", "\u0429"}, {"YU", "\u042e"}, {"YA", "\u042f"}, {"YO", "\u0401"}, {"EE", "\u0418"}, {"CK", "\u041a"}, {"TH", "\u0422"}, {"\u041e\u041e", "\u0423"}, {"A", "\u0410"}, {"B", "\u0411"}, {"C", "\u041a"}, {"D", "\u0414"}, {"E", "\u0415"}, {"F", "\u0424"}, {"G", "\u0413"}, {"H", "\u0425"}, {"I", "\u0418"}, {"J", "\u0414\u0416"}, {"K", "\u041a"}, {"L", "\u041b"}, {"M", "\u041c"}, {"N", "\u041d"}, {"O", "\u041e"}, {"P", "\u041f"}, {"Q", "\u041a"}, {"R", "\u0420"}, {"S", "\u0421"}, {"T", "\u0422"}, {"U", "\u0423"}, {"V", "\u0412"}, {"W", "\u0412"}, {"Y", "\u0419"}, {"X", "\u041a\u0421"}, {"Y", "\u042b"}, {"Z", "\u0417"}};
    private static final String[][] en_ru = new String[][]{{"zh", "\u0436"}, {"kh", "\u0445"}, {"ts", "\u0446"}, {"ch", "\u0447"}, {"sh", "\u0448"}, {"sh", "\u0449"}, {"yu", "\u044e"}, {"ya", "\u044f"}, {"yo", "\u0451"}, {"ee", "\u0438"}, {"ck", "\u043a"}, {"th", "\u0442"}, {"\u043e\u043e", "\u0443"}, {"a", "\u0430"}, {"b", "\u0431"}, {"c", "\u043a"}, {"d", "\u0434"}, {"e", "\u0435"}, {"f", "\u0444"}, {"g", "\u0433"}, {"h", "\u0445"}, {"i", "\u0438"}, {"j", "\u0434\u0436"}, {"k", "\u043a"}, {"l", "\u043b"}, {"m", "\u043c"}, {"n", "\u043d"}, {"o", "\u043e"}, {"p", "\u043f"}, {"q", "\u043a"}, {"r", "\u0440"}, {"s", "\u0441"}, {"t", "\u0442"}, {"u", "\u0443"}, {"v", "\u0432"}, {"w", "\u0432"}, {"y", "\u0439"}, {"x", "\u043a\u0441"}, {"y", "\u044b"}, {"z", "\u0437"}};
    private static final String[][] En_ru = new String[][]{{"Zh", "\u0416"}, {"Kh", "\u0425"}, {"Ts", "\u0426"}, {"Ch", "\u0427"}, {"Sh", "\u0428"}, {"Sh", "\u0429"}, {"Yu", "\u042e"}, {"Ya", "\u042f"}, {"Yo", "\u0401"}, {"Ee", "\u0418"}, {"Ck", "\u041a"}, {"Th", "\u0422"}, {"\u041eo", "\u0423"}};
    private static final String INVALID_FILENAME_CHARACTERS = "/\\?%*:|\"<>";
    private static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("([0-9A-Za-z-_]+\\.)*[0-9A-Za-z-_]+@((([0-9A-Za-z-_]+\\.)+[A-Za-z]+)|(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}))");
    private static final Pattern WINDOWS_LINEBREAK = Pattern.compile("\r\n");
    private static final Pattern NAMED_PARAMETER_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    private static final String[] RESERVED_WINDOWS_FILE_NAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    public static boolean isBlank(String str) {
        return TextUtil.isBlank(str, true);
    }

    public static boolean nonBlank(String str) {
        return !TextUtil.isBlank(str, true);
    }

    public static boolean isBlank(String str, boolean trim) {
        return str == null || (trim ? StringUtils.isBlank((String)str) : str.length() == 0);
    }

    public static boolean isSame(String o1, String o2) {
        return TextUtil.isSame(o1, o2, false, true);
    }

    public static boolean isSame(String o1, String o2, boolean ignoreCase) {
        return TextUtil.isSame(o1, o2, ignoreCase, true);
    }

    public static boolean isSame(String o1, String o2, boolean ignoreCase, boolean trim) {
        if (TextUtil.isBlank(o1, trim) && TextUtil.isBlank(o2, trim)) {
            return true;
        }
        if (TextUtil.isBlank(o1, trim) || TextUtil.isBlank(o2, trim)) {
            return false;
        }
        return ignoreCase ? (trim ? o1.trim().equalsIgnoreCase(o2.trim()) : o1.equalsIgnoreCase(o2)) : (trim ? o1.trim().equals(o2.trim()) : o1.equals(o2));
    }

    public static boolean isLike(String o1, String o2) {
        return TextUtil.isLike(o1, o2, false, true);
    }

    public static boolean isLike(String o1, String o2, boolean ignoreCase) {
        return TextUtil.isLike(o1, o2, ignoreCase, true);
    }

    public static boolean isLike(String o1, String o2, boolean ignoreCase, boolean trim) {
        if (TextUtil.isBlank(o1, trim) && TextUtil.isBlank(o2, trim)) {
            return true;
        }
        if (TextUtil.isBlank(o1, trim) || o2 == null) {
            return false;
        }
        return ignoreCase ? (trim ? o1.trim().toLowerCase().indexOf(o2.trim().toLowerCase()) >= 0 : o1.toLowerCase().indexOf(o2.toLowerCase()) >= 0) : (trim ? o1.trim().indexOf(o2.trim()) >= 0 : o1.indexOf(o2) >= 0);
    }

    public static String nonNullStr(String s) {
        return s != null ? s : "";
    }

    public static String nonEmptyStr(String s) {
        return TextUtil.isBlank(s) ? " " : s.trim();
    }

    public static String nonBlankStr(String s) {
        return TextUtil.isBlank(s) ? "" : s;
    }

    public static String nullOrNonBlankString(String s) {
        return TextUtil.isBlank(s) ? null : s;
    }

    public static String objToNotNullString(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    public static String replaceAll(String str, String from, String to) {
        if (str == null) {
            return null;
        }
        if (TextUtil.isBlank(from, false)) {
            return str;
        }
        String toStr = to != null ? to : "";
        StringBuilder builder = new StringBuilder(str);
        int p = 0;
        while ((p = builder.indexOf(from, p)) != -1) {
            builder.replace(p, p + from.length(), toStr);
            p += toStr.length();
        }
        return builder.toString();
    }

    public static Locale str2locale(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (str.indexOf(95) == -1) {
            return new Locale(str.trim().toLowerCase(Locale.ENGLISH));
        }
        String[] parts = str.trim().split("_");
        if (parts.length == 1) {
            return new Locale(parts[0].toLowerCase(Locale.ENGLISH));
        }
        if (parts.length == 2) {
            return new Locale(parts[0].toLowerCase(Locale.ENGLISH), parts[1].toUpperCase(Locale.ENGLISH));
        }
        if (parts.length == 3) {
            return new Locale(parts[0].toLowerCase(Locale.ENGLISH), parts[1].toUpperCase(Locale.ENGLISH), parts[2]);
        }
        throw new IllegalArgumentException("invalid locale string - " + str);
    }

    public static String first(String str, int count) {
        if (str == null || count <= 0) {
            return "";
        }
        if (str.length() <= count + 3) {
            return str;
        }
        StringBuilder res = new StringBuilder(str);
        return res.delete(count, res.length()).append("...").toString();
    }

    public static String capitalize(String str) {
        if (TextUtil.isBlank(str)) {
            return "";
        }
        return StringUtils.capitalize((String)str);
    }

    public static String decapitalize(String str) {
        if (TextUtil.isBlank(str)) {
            return "";
        }
        StringBuilder res = new StringBuilder(str);
        res.setCharAt(0, Character.toLowerCase(res.charAt(0)));
        return res.toString();
    }

    public static String camel(String str) {
        if (TextUtil.isBlank(str)) {
            return "";
        }
        boolean f = true;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLetter(c)) {
                if (f) {
                    sb.append(Character.toUpperCase(c));
                    f = false;
                    continue;
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (!f && !Character.isDigit(c)) {
                f = true;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String format(Format format, Object obj) {
        return TextUtil.format(format, obj, "");
    }

    public static String format(Format format, Object obj, String stub) {
        return obj == null ? stub : format.format(obj);
    }

    public static final String formatNamed(String str, Map<String, String> params) {
        if (str == null) {
            return null;
        }
        return ReplacementUtils.replace(NAMED_PARAMETER_PATTERN, str, s -> (String)params.get(s.substring(2, s.length() - 1)));
    }

    public static String fillLeft(String str, int len) {
        return TextUtil.fillLeft(str, ' ', len);
    }

    public static String fillLeft(String str, char ch, int len) {
        String s;
        if (len <= 0) {
            throw new IllegalArgumentException("invalid fill left length parameter " + len);
        }
        String string = s = str == null ? "" : str;
        if (s.length() >= len) {
            return s;
        }
        StringBuilder result = new StringBuilder(len);
        int count = len - s.length();
        for (int i = 0; i < count; ++i) {
            result.append(ch);
        }
        return result.append(s).toString();
    }

    public static String fillRight(String str, int len) {
        return TextUtil.fillRight(str, ' ', len);
    }

    public static String fillRight(String str, char ch, int len) {
        String s;
        if (len <= 0) {
            throw new IllegalArgumentException("invalid fill right length parameter " + len);
        }
        String string = s = str == null ? "" : str;
        if (s.length() >= len) {
            return s;
        }
        StringBuilder result = new StringBuilder(len);
        result.append(s);
        int count = len - s.length();
        for (int i = 0; i < count; ++i) {
            result.append(ch);
        }
        return result.toString();
    }

    public static String buildFullName(PersonalName personalName) {
        return TextUtil.buildFullName(personalName, false);
    }

    public static PersonalName createName(String first, String middle, String last) {
        return new PersonalNameImpl(first, middle, last);
    }

    public static PersonalName createName(String first, String second, String middle, String last) {
        return new PersonalNameImpl(first, second, middle, last);
    }

    public static String buildFullName(PersonalName personalName, boolean useInitials) {
        if (personalName == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (!TextUtil.isBlank(personalName.getLastName())) {
            result.append(personalName.getLastName().trim());
        }
        if (!TextUtil.isBlank(personalName.getFirstName())) {
            if (result.length() > 0) {
                result.append(' ');
            }
            String firstName = personalName.getFirstName().trim();
            result.append(useInitials ? firstName.charAt(0) + "." : firstName);
        }
        if (!TextUtil.isBlank(personalName.getSecondName())) {
            if (result.length() > 0) {
                result.append(' ');
            }
            String secondName = personalName.getSecondName().trim();
            result.append(useInitials ? secondName.charAt(0) + "." : secondName);
        }
        if (!TextUtil.isBlank(personalName.getMiddleName())) {
            if (result.length() > 0) {
                result.append(' ');
            }
            String middleName = personalName.getMiddleName().trim();
            result.append(useInitials ? middleName.charAt(0) + "." : middleName);
        }
        return result.toString();
    }

    public static void splitFullName(String fullName, PersonalName personalName) {
        personalName.setLastName("");
        personalName.setFirstName("");
        personalName.setMiddleName("");
        if (TextUtil.isBlank(fullName)) {
            return;
        }
        String[] arr = fullName.split("\\s+");
        if (arr.length == 0) {
            personalName.setLastName(fullName.trim());
        } else if (arr.length == 1) {
            personalName.setLastName(arr[0].trim());
        } else if (arr.length == 2) {
            personalName.setLastName(arr[0].trim());
            personalName.setFirstName(arr[1].trim());
        } else if (arr.length == 3) {
            personalName.setLastName(arr[0].trim());
            personalName.setFirstName(arr[1].trim());
            personalName.setMiddleName(arr[2].trim());
        } else if (arr.length == 4) {
            personalName.setLastName(arr[0].trim());
            personalName.setFirstName(arr[1].trim());
            personalName.setSecondName(arr[2].trim());
            personalName.setMiddleName(arr[3].trim());
        } else {
            personalName.setLastName(arr[0].trim());
            personalName.setFirstName(arr[1].trim());
            for (int i = 2; i < arr.length; ++i) {
                if (!TextUtil.isBlank(personalName.getMiddleName())) {
                    personalName.setMiddleName(personalName.getMiddleName() + ' ' + arr[i].trim());
                    continue;
                }
                personalName.setMiddleName(arr[i].trim());
            }
        }
    }

    public static boolean isSame(PersonalName name1, PersonalName name2) {
        return CollectionUtil.equals(TextUtil.name2set(name1), TextUtil.name2set(name2), true);
    }

    private static Set<String> name2set(PersonalName name) {
        HashSet<String> result = new HashSet<String>();
        TextUtil.name2set(result, name.getLastName());
        TextUtil.name2set(result, name.getFirstName());
        TextUtil.name2set(result, name.getMiddleName());
        TextUtil.name2set(result, name.getSecondName());
        return result;
    }

    private static void name2set(Set<String> set, String name) {
        if (TextUtil.isBlank(name)) {
            return;
        }
        for (String str : name.split("\\s+")) {
            if (TextUtil.isBlank(str)) continue;
            set.add(str.trim().toLowerCase());
        }
    }

    public static String buildFullNumber(CompositeNumber number) {
        if (number == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (!TextUtil.isBlank(number.getNumberPrefix())) {
            result.append(number.getNumberPrefix());
        }
        if (!TextUtil.isBlank(number.getNumber())) {
            if (result.length() > 0) {
                result.append('-');
            }
            result.append(number.getNumber());
        }
        if (!TextUtil.isBlank(number.getNumberSuffix())) {
            if (result.length() > 0) {
                result.append('-');
            }
            result.append(number.getNumberSuffix());
        }
        return result.toString();
    }

    public static String buildUrl(String baseUrl, Map<String, String> parameters, String charset) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(baseUrl);
        if (parameters.size() > 0) {
            sb.append('?');
            Iterator<Map.Entry<String, String>> iter = parameters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> parameter = iter.next();
                sb.append(URLEncoder.encode(parameter.getKey(), charset));
                sb.append('=');
                sb.append(URLEncoder.encode(parameter.getValue(), charset));
                if (!iter.hasNext()) continue;
                sb.append('&');
            }
        }
        return sb.toString();
    }

    public static int compare(String o1, String o2, boolean nullIsFirst, boolean ignoreCase) {
        if (TextUtil.isBlank(o1) && TextUtil.isBlank(o2)) {
            return 0;
        }
        if (TextUtil.isBlank(o1) && !TextUtil.isBlank(o2)) {
            return nullIsFirst ? -1 : 1;
        }
        if (!TextUtil.isBlank(o1) && TextUtil.isBlank(o2)) {
            return nullIsFirst ? 1 : -1;
        }
        return ignoreCase ? o1.compareToIgnoreCase(o2) : o1.compareTo(o2);
    }

    public static String combine(char separator, String ... parts) {
        if (parts == null || parts.length == 0) {
            return null;
        }
        return TextUtil.join(Character.toString(separator), Arrays.asList(parts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExceptionStackTraceRegular(Throwable t) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream sps = new PrintStream((OutputStream)baos, false, "UTF8");){
            t.printStackTrace(sps);
            sps.flush();
            String string = baos.toString("UTF8");
            return string;
        }
    }

    public static String getExceptionStackTrace(Throwable e) {
        if (e == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(e.getStackTrace().length * 100);
        TextUtil.printError(e, e.toString(), sb);
        return sb.toString();
    }

    private static void printError(Throwable t, String header, StringBuilder sb) {
        if (t == null) {
            return;
        }
        String nl = System.getProperty("line.separator");
        if (!TextUtil.isBlank(header)) {
            sb.append(nl).append(header).append(nl).append(nl);
        }
        for (StackTraceElement element : t.getStackTrace()) {
            TextUtil.printStackTraceElement(element, sb).append(nl);
        }
        Throwable next = t.getCause();
        TextUtil.printError(next, "Caused by " + next, sb);
        if (t instanceof SQLException) {
            next = ((SQLException)t).getNextException();
            TextUtil.printError(next, "Next exception: " + next, sb);
        } else if (t instanceof InvocationTargetException) {
            next = ((InvocationTargetException)t).getTargetException();
            TextUtil.printError(next, "Target exception: " + next, sb);
        }
    }

    private static StringBuilder printStackTraceElement(StackTraceElement ste, StringBuilder sb) {
        sb.append(ste.getClassName());
        sb.append('.');
        sb.append(ste.getMethodName());
        sb.append('(');
        if (ste.isNativeMethod()) {
            sb.append("Native Method");
        } else if (ste.getFileName() != null) {
            sb.append(ste.getFileName());
            if (ste.getLineNumber() >= 0) {
                sb.append(':');
                sb.append(ste.getLineNumber());
            }
        } else {
            sb.append("Unknown Source");
        }
        sb.append(')');
        return sb;
    }

    public static String join(String separator, Iterable<?> values) {
        return TextUtil.join(separator, values, false);
    }

    public static String join(String separator, Iterable<?> values, boolean ignoreEmptyValues) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : values) {
            String value;
            if (object == null || TextUtil.isBlank(value = MiscUtil.toString(object), ignoreEmptyValues)) continue;
            if (!TextUtil.isBlank(separator, false) && stringBuilder.length() > 0) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(value);
        }
        return stringBuilder.toString();
    }

    public static String convertToUnicode(String source) {
        if (TextUtil.isBlank(source)) {
            return source;
        }
        StringBuilder result = new StringBuilder(source);
        boolean inQuote = false;
        for (int n = 0; n < result.length(); ++n) {
            char ch = result.charAt(n);
            if (ch == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (!inQuote || ch >= ' ' && ch <= '~') continue;
            result.delete(n, n + 1);
            result.insert(--n + 1, "\\u");
            n += 2;
            String hex = Integer.toHexString(ch & 0xFFFF);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                result.insert(n + 1, "0");
                ++n;
            }
            result.insert(n + 1, hex.toLowerCase());
            ++n;
        }
        return result.toString();
    }

    public static String repeat(String str, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count can't be negative");
        }
        if (str == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(str.length() * count);
        for (int i = 0; i < count; ++i) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    public static boolean isContainsDigits(String input) {
        if (TextUtil.isBlank(input)) {
            return false;
        }
        for (int i = 0; i < input.length(); ++i) {
            if (!Character.isDigit(input.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String collection2String(Collection coll) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            sb.append("\"" + iter.next().toString() + "\"");
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public static List<String> string2List(String content, String delimeter) {
        if (TextUtil.isBlank(content)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String token : content.split(delimeter)) {
            result.add(token);
        }
        return result;
    }

    public static String declension(int quantity, String option1, String option2, String option3) {
        int hundredSurplus = quantity % 100;
        if (hundredSurplus >= 11 && hundredSurplus <= 19) {
            return option3;
        }
        int decadeSurplus = quantity % 10;
        switch (decadeSurplus) {
            case 1: {
                return option1;
            }
            case 2: 
            case 3: 
            case 4: {
                return option2;
            }
        }
        return option3;
    }

    public static String translit(String text, boolean toEng) {
        if (TextUtil.isBlank(text)) {
            return text;
        }
        String result = text.trim();
        if (!toEng) {
            for (String[] element : En_ru) {
                result = result.replace(element[0], element[1]);
            }
        }
        for (String[] element : toEng ? RU_EN : EN_RU) {
            result = result.replace(element[0], element[1]);
        }
        for (String[] element : toEng ? ru_en : en_ru) {
            result = result.replace(element[0], element[1]);
        }
        return result;
    }

    public static boolean isCyrillic(String string, boolean checkLettersOnly) {
        if (TextUtil.isBlank(string)) {
            return true;
        }
        if (checkLettersOnly) {
            string = string.replaceAll("[^\\p{L}]", "");
        }
        return string.matches("\\p{InCyrillic}+");
    }

    public static boolean containsCyrillicLetter(String string) {
        if (TextUtil.isBlank(string)) {
            return false;
        }
        return string.matches("^.*\\p{InCyrillic}+.*$");
    }

    public static List<String> split(String content, int treshold, String pattern) {
        if (treshold < 1) {
            throw new IllegalArgumentException("treshold must be greater than zero");
        }
        ArrayList<String> entries = new ArrayList<String>();
        TextUtil.split(content, treshold, Pattern.compile("[" + pattern + "](?=[^" + pattern + "]*$)"), entries);
        return entries;
    }

    private static void split(String content, int treshold, Pattern pattern, List<String> lines) {
        String line = content.trim();
        if (line.length() > treshold) {
            int index = treshold;
            Matcher matcher = pattern.matcher(line.substring(1, index + 1));
            if (matcher.find()) {
                index = 1 + matcher.start();
            }
            lines.add(line.substring(0, index));
            TextUtil.split(line.substring(index), treshold, pattern, lines);
        } else {
            lines.add(line);
        }
    }

    public static List<String> split(String content, String pattern, boolean trim, boolean ignoreEmptyValues) {
        String[] tokens;
        ArrayList<String> entries = new ArrayList<String>();
        for (String token : tokens = content.split(pattern)) {
            if (trim) {
                if (TextUtil.isBlank(token, true)) continue;
                entries.add(token.trim());
                continue;
            }
            if (ignoreEmptyValues) {
                if (TextUtil.isBlank(token, true)) continue;
                entries.add(token);
                continue;
            }
            if (TextUtil.isBlank(token, false)) continue;
            entries.add(token);
        }
        return entries;
    }

    public static String trim(String string) {
        if (TextUtil.isBlank(string)) {
            return string;
        }
        return string.trim();
    }

    public static String trim(String string, String pattern) {
        if (TextUtil.isBlank(string, false) || TextUtil.isBlank(pattern, false)) {
            return string;
        }
        Matcher matcher = Pattern.compile("^[" + pattern + "]*(.*?)[" + pattern + "]*$").matcher(string);
        matcher.matches();
        return matcher.group(1);
    }

    public static String ltrim(String string, String pattern) {
        if (TextUtil.isBlank(string, false) || TextUtil.isBlank(pattern, false)) {
            return string;
        }
        Matcher matcher = Pattern.compile("^[" + pattern + "]*(.*?)$").matcher(string);
        matcher.matches();
        return matcher.group(1);
    }

    public static String rtrim(String string, String pattern) {
        if (TextUtil.isBlank(string, false) || TextUtil.isBlank(pattern, false)) {
            return string;
        }
        Matcher matcher = Pattern.compile("^(.*?)[" + pattern + "]*$").matcher(string);
        matcher.matches();
        return matcher.group(1);
    }

    public static boolean contains(String string, String pattern) {
        if (string == null || pattern == null) {
            return false;
        }
        return string.contains(pattern);
    }

    public static boolean startsWith(String string, String pattern) {
        if (string == null || pattern == null) {
            return false;
        }
        return string.startsWith(pattern);
    }

    public static boolean endsWith(String string, String pattern) {
        if (string == null || pattern == null) {
            return false;
        }
        return string.endsWith(pattern);
    }

    public static String filterInvalidFilenameCharacters(String filename) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (INVALID_FILENAME_CHARACTERS.indexOf(c) >= 0) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String firstLettersUpperCase(String text) {
        if (TextUtil.isBlank(text)) {
            return null;
        }
        String str = text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
        Matcher m = Pattern.compile("[- ].").matcher(str);
        StringBuilder sb = new StringBuilder();
        int last = 0;
        while (m.find()) {
            sb.append(str, last, m.start());
            sb.append(m.group(0).toUpperCase());
            last = m.end();
        }
        sb.append(str.substring(last));
        return sb.toString();
    }

    public static boolean isValidEmailAddress(String str) {
        if (TextUtil.isBlank(str)) {
            return false;
        }
        return EMAIL_ADDRESS_PATTERN.matcher(str).matches();
    }

    public static boolean translationRequired(String text) {
        if (text == null) {
            return false;
        }
        String cleanText = TextUtil.clean(text);
        if (cleanText.length() < 1) {
            return false;
        }
        String[] strings = cleanText.split(" ");
        int i = (int)((double)strings.length / 100.0 * 60.0);
        boolean translationRequired = false;
        for (String string : strings) {
            if (!TextUtil.containsCyrillicLetter(string) && !TextUtil.isBlank(string)) {
                --i;
            }
            if (i >= 0) continue;
            translationRequired = true;
            break;
        }
        return translationRequired;
    }

    protected static String clean(String text) {
        String result = TextUtil.remove(text, "\u21b5");
        result = TextUtil.remove(result, "<\\/b>");
        result = TextUtil.remove(result, "<\\/i>");
        result = TextUtil.remove(result, "<b>");
        result = TextUtil.remove(result, "</b>");
        result = TextUtil.remove(result, "<i>");
        result = TextUtil.remove(result, "</i>");
        result = TextUtil.remove(result, "-");
        result = TextUtil.remove(result, ":");
        result = TextUtil.remove(result, "0");
        result = TextUtil.remove(result, "1");
        result = TextUtil.remove(result, "2");
        result = TextUtil.remove(result, "3");
        result = TextUtil.remove(result, "4");
        result = TextUtil.remove(result, "5");
        result = TextUtil.remove(result, "6");
        result = TextUtil.remove(result, "7");
        result = TextUtil.remove(result, "8");
        result = TextUtil.remove(result, "9");
        result = TextUtil.remove(result, ".");
        result = TextUtil.remove(result, "*");
        result = TextUtil.remove(result, ";");
        result = TextUtil.remove(result, ",");
        result = TextUtil.remove(result, "'");
        result = TextUtil.remove(result, "+");
        result = TextUtil.remove(result, "/");
        result = TextUtil.remove(result, "(");
        result = TextUtil.remove(result, ")");
        return result.trim();
    }

    protected static String remove(String text, String stuffToRemove) {
        return text.replace(stuffToRemove, "");
    }

    public static String toSeparatedString(long value, int groupLenght) {
        String nonSeparatedString = Long.toString(value);
        return TextUtil.toSeparatedString(nonSeparatedString, groupLenght);
    }

    public static String toSeparatedString(BigDecimal value) {
        String nonSeparatedString = value.toPlainString();
        return TextUtil.toSeparatedString(nonSeparatedString, 3);
    }

    public static String toSeparatedString(long value) {
        return TextUtil.toSeparatedString(value, 3);
    }

    private static String toSeparatedString(String nonSeparatedString, int groupLenght) {
        boolean minus;
        boolean bl = minus = nonSeparatedString.charAt(0) == '-';
        if (minus) {
            nonSeparatedString = nonSeparatedString.substring(1);
        }
        String decimalPointString = "";
        if (nonSeparatedString.indexOf(46) != -1) {
            int index = nonSeparatedString.indexOf(46);
            decimalPointString = "," + nonSeparatedString.substring(index + 1, nonSeparatedString.length());
            if (decimalPointString.length() < 3) {
                decimalPointString = decimalPointString + StringUtils.repeat((String)"0", (int)(3 - decimalPointString.length()));
            }
            nonSeparatedString = nonSeparatedString.substring(0, index);
        }
        ArrayList<String> groups = new ArrayList<String>(nonSeparatedString.length() / groupLenght + 1);
        for (int rightIndex = nonSeparatedString.length(); rightIndex > 0; rightIndex -= groupLenght) {
            int leftIndex = Math.max(0, rightIndex - groupLenght);
            groups.add(nonSeparatedString.substring(leftIndex, rightIndex));
        }
        StringBuilder result = new StringBuilder(nonSeparatedString.length() + nonSeparatedString.length() / groupLenght + 1);
        if (minus) {
            result.append('-');
        }
        boolean firstGroup = true;
        for (int i = groups.size() - 1; i >= 0; --i) {
            if (!firstGroup) {
                result.append(' ');
            }
            result.append((String)groups.get(i));
            firstGroup = false;
        }
        result.append(decimalPointString);
        return result.toString();
    }

    public static String firstNonBlank(String ... ss) {
        if (ss == null) {
            return null;
        }
        for (String s : ss) {
            if (TextUtil.isBlank(s)) continue;
            return s;
        }
        return null;
    }

    public static String adjustStringToLimit(String str, String stopPattern, int limit) {
        if (TextUtil.isBlank(str)) {
            return null;
        }
        int stopPos = str.length();
        if (stopPos > limit) {
            if (stopPattern != null) {
                stopPos = str.lastIndexOf(stopPattern, limit);
            }
            if (stopPos == -1 || stopPos > limit) {
                stopPos = limit;
            }
        }
        return str.substring(0, stopPos);
    }

    public static final String toUnixLines(String src) {
        if (src == null) {
            return null;
        }
        return WINDOWS_LINEBREAK.matcher(src).replaceAll("\n");
    }

    public static boolean equals(String s1, String s2, boolean nullEq) {
        return MiscUtil.equals(s1, s2, nullEq);
    }

    public static String concat(String s1, String s2) {
        return String.valueOf(s1).concat(String.valueOf(s2));
    }

    public static Integer toInteger(String str) {
        return StringUtils.isNumeric((String)str) && TextUtil.nonBlank(str) ? Integer.valueOf(str) : null;
    }

    public static Long toLong(String str) {
        return StringUtils.isNumeric((String)str) && TextUtil.nonBlank(str) ? Long.valueOf(str) : null;
    }

    public static String unescape(String pattern) {
        StringBuilder result = new StringBuilder(pattern);
        for (int i = 0; i < result.length(); ++i) {
            if (result.charAt(i) != '\\') continue;
            result.delete(i, i + 1);
        }
        return result.toString();
    }

    public static String getFieldOrTrimToLength(String field, int maxLength) {
        return field == null || field.length() <= maxLength ? field : field.substring(0, maxLength - 3) + "...";
    }

    public static String concat(String ... strings) {
        int len = 0;
        for (String string : strings) {
            len += string.length();
        }
        StringBuilder sb = new StringBuilder(len);
        for (String string : strings) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static String concatWithDelimeter(String delimeter, String ... strings) {
        int len = 0;
        for (String string : strings) {
            len += string.length();
        }
        StringBuilder sb = new StringBuilder(len += delimeter.length() * (strings.length - 1));
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                sb.append(delimeter);
            }
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    public static String truncate(String string, int maxLength) {
        if (string == null) {
            return null;
        }
        return string.length() > maxLength ? string.substring(0, maxLength) : string;
    }

    public static String requireNonBlank(String string) {
        Objects.requireNonNull(string);
        if (TextUtil.isBlank(string)) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public static String requireNonBlank(String string, String message) {
        Objects.requireNonNull(string, message);
        if (TextUtil.isBlank(string)) {
            throw new IllegalArgumentException(message);
        }
        return string;
    }

    public static String requireNonBlank(String string, Supplier<String> messageSupplier) {
        Objects.requireNonNull(string, messageSupplier);
        if (TextUtil.isBlank(string)) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
        return string;
    }

    public static String normalizeFileName(String name) {
        String result = name.replaceAll("[\\\\/:*?\"<>|\t]", "").trim();
        if (result.endsWith(".")) {
            result = result.substring(0, result.length() - 1);
        }
        for (String reservedName : RESERVED_WINDOWS_FILE_NAMES) {
            String str;
            if (result.equalsIgnoreCase(reservedName)) {
                result = "X" + result;
            }
            if (!result.contains(".") || !(str = result.substring(0, result.indexOf("."))).equalsIgnoreCase(reservedName)) continue;
            result = "X" + result;
        }
        return result;
    }
}

