/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.TextUtil;
import org.junit.Assert;
import org.junit.Test;

public final class TextUtilTest {
    @Test
    public void translationRequiredDoesntCrashIfParameterIsNull() {
        Assert.assertFalse((boolean)TextUtil.translationRequired(null));
    }

    @Test
    public void translationRequiredDefaultScenario() {
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0411 \u0411 \u0411 \u0411 \u0411 \u0413 \u0413 \u0413 \u0413"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0411 \u0411 \u0411 \u0411 \u0411 \u0413 \u0413 \u0413 Z"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0411 \u0411 \u0411 \u0411 \u0411 \u0413 \u0413 Z Z"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0411 \u0411 \u0411 \u0411 \u0411 \u0413 Z Z Z"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0411 \u0411 \u0411 \u0411 \u0411 Z Z Z Z"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0411 \u0411 \u0411 \u0411 Z Z Z Z Z"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("\u0411 \u0411 \u0411 Z Z Z Z Z Z"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("\u0411 \u0411 Z Z Z Z Z Z Z"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("\u0411 Z Z Z Z Z Z Z Z"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("Z Z Z Z Z Z Z Z Z"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("a"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("b"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("c"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("d"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("e"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("f"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("g"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("h"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("i"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("j"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("k"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("l"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("m"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("n"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("o"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("p"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("q"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("r"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("s"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("t"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("u"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("v"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("w"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("x"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("y"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("z"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("A"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("B"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("C"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("D"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("E"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("F"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("G"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("H"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("I"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("J"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("K"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("L"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("M"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("N"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("O"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("P"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("Q"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("R"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("S"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("T"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("U"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("V"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("W"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("X"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("Y"));
        Assert.assertTrue((boolean)TextUtil.translationRequired("Z"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0430"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0431"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0432"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0433"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0434"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0435"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0451"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0436"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0437"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0438"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u043a"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u043b"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u043c"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u043d"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u043e"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u043f"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0440"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0441"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0442"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0443"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0444"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0445"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0446"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0447"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0448"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0449"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u044d"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u044e"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u044f"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u044c"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u044a"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0410"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0411"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0412"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0413"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0414"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0415"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0401"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0416"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0417"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0418"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u041a"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u041b"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u041c"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u041d"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u041e"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u041f"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0420"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0421"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0422"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0423"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0424"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0425"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0426"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0427"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0428"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0429"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u042d"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u042e"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u042f"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u042c"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u042a"));
    }

    @Test
    public void translationRequiredReturnsFalseForRussianFareRules() {
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n                 SOJ  DOJ  CT2   RT CT2+  EOE   ST   AO     \n  \u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 *     \u041d    \u041d    \u041e    \u0420    \u041d    \u041e    \u0420    \u0420     \n  \u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a **    -    -    \u0414    \u0414    -    \u0414    \u0414    -     \n  \u0422\u044d\u0440\u0438\u0444/\u0423\u041f\u0422  **    -    -    \u0414    \u0414    -    \u0414    \u0414    -     \n  \u041a\u043e\u0434 \u0442\u0430\u0440\u0438\u0444\u0430 **    -    -    \u0414    \u0414    -    \u0414    \u0414    -     \n    *   \u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435: \u0420,\u0410-\u0440\u0430\u0437\u0440; \u041d,\u0411-\u043d\u0435 \u0440\u0430\u0437\u0440; \u041e,\u0421-\u0440\u0430\u0437\u0440 \u0441 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u043c\u0438; \u0422,\u0414-\n            \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f; \u0428-\u0442\u043e\u043b\u044c\u043a\u043e \u0441 \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438 \u0441 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u043c\u0438\n            \u0431\u0438\u043b\u0435\u0442\u0430\u043c\u0438\n    **  \u0423\u0441\u043b\u043e\u0432\u0438\u044f: \u0414-\u0438\u043c\u0435\u044e\u0442\u0441\u044f;  \u041d-\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 (\u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0435 \u0434\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u044f);\n            '-'-\u043d\u0435 \u0430\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u044e\u0442\u0441\u044f (\u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0435 \u0434\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u044f)\n<b>----- \u0435\u0441\u043b\u0438<\\/b> (\u041a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u043e\u0432) \n  \u041a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044f \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u0441 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u043e\u043c <i>'SU'-\u041f\u0410\u041e \u0410\u042d\u0420\u041e\u0424\u041b\u041e\u0422<\\/i>.\n<b>\u0438<\\/b>          (\u041a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044f \u043a\u043e\u0434\u043e\u0432 \u0431\u0430\u0437\u043e\u0432\u044b\u0445 \u0442\u0430\u0440\u0438\u0444\u043e\u0432/ \u0442\u0438\u043f\u043e\u0432 \u0442\u0430\u0440\u0438\u0444\u043e\u0432) \n  \u041a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 <i>\u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f<\\/i> \u0441 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438 \u0441 \u043a\u043e\u0434\u043e\u043c \u0431\u0430\u0437\u043e\u0432\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 <i>'U-'<\\/i>/<i>'R-'<\\/i>.\n<b>\u0438<\\/b>          (\u041a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u043e\u0432) \n  \u041a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 <i>\u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f<\\/i> \u0441 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438, \u0438\u043c\u0435\u044e\u0449\u0438\u043c\u0438 \u0423\u041f\u0422 \u043d\u043e\u043c\u0435\u0440: <i>PR01<\\/i> \u0438\u0437 \u043b\u044e\u0431\u043e\u0433\u043e\n    \u0442\u044d\u0440\u0438\u0444\u0430. \u041f\u0440\u0438 \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u043d\u0430\u0438\u0431\u043e\u043b\u0435\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0438\u0432\u0430\u044e\u0449\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f.\n  \u041a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 <i>\u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f<\\/i> \u0441 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438, \u0438\u043c\u0435\u044e\u0449\u0438\u043c\u0438 \u0423\u041f\u0422 \u043d\u043e\u043c\u0435\u0440: <i>PRR1<\\/i> \u0438\u0437 \u043b\u044e\u0431\u043e\u0433\u043e\n    \u0442\u044d\u0440\u0438\u0444\u0430. \u041f\u0440\u0438 \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u043d\u0430\u0438\u0431\u043e\u043b\u0435\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0438\u0432\u0430\u044e\u0449\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f.\n  \u041a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 <i>\u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f<\\/i> \u0441 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438, \u0438\u043c\u0435\u044e\u0449\u0438\u043c\u0438 \u0423\u041f\u0422 \u043d\u043e\u043c\u0435\u0440: <i>PRA1<\\/i> \u0438\u0437 \u043b\u044e\u0431\u043e\u0433\u043e\n    \u0442\u044d\u0440\u0438\u0444\u0430. \u041f\u0440\u0438 \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u043d\u0430\u0438\u0431\u043e\u043b\u0435\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0438\u0432\u0430\u044e\u0449\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f.\n<b>\u0442\u043e<\\/b>         (\u0417\u0430\u043c\u043a\u043d\u0443\u0442\u0430\u044f \u043a\u0440\u0443\u0433\u043e\u0432\u0430\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0430 \u0441 2 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u043c\u0438 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u043c\u0438 (RT \u0438 CT2))\n  \u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439 \u043d\u0435\u0442\n<b>\u0438\u043b\u0438<\\/b>        (\u041a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044f End on end) \n\n\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("<b>"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("<\\/b>"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("<\\/i>"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("*"));
        Assert.assertFalse((boolean)TextUtil.translationRequired(";"));
        Assert.assertFalse((boolean)TextUtil.translationRequired(","));
        Assert.assertFalse((boolean)TextUtil.translationRequired("'"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("+"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("/"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("("));
        Assert.assertFalse((boolean)TextUtil.translationRequired(")"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u041d\u0430\u0434\u0431\u0430\u0432\u043a\u0438 (\u0441\u043a\u0438\u0434\u043a\u0438) \u043a \u0442\u0430\u0440\u0438\u0444\u0443"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u0421\u0431\u043e\u0440\u044b \u043f\u0440\u0438 \u0440\u0430\u0441\u0442\u043e\u0440\u0436\u0435\u043d\u0438\u0438 (\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0439) \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n<b>-----<\\/b> \n \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0423\u041f\u0422 - <i>\u041d\u0415\u0412\u041e\u0417\u0412\u0420\u0410\u0422\u041d\u042b\u0415 \u0422\u0410\u0420\u0418\u0424\u042b<\\/i>\n \u0414\u0430\u043d\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u0434\u043b\u044f \u044d\u043a\u043e\u043d\u043e\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043a\u043b\u0430\u0441\u0441\u0430 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f.\n\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n<b>-----<\\/b> \n \u0442\u0430\u0440\u0438\u0444 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u0434\u043b\u044f '<i>\u0410\u0410\u0410<\\/i>'-\u0412\u0417\u0420\u041e\u0421\u041b\u042b\u0419 \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420.\n<b>\u0438\u043b\u0438<\\/b> \n \u0442\u0430\u0440\u0438\u0444 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u0434\u043b\u044f '<i>\u0420\u0411\u0413<\\/i>'-\u0420\u0415\u0411\u0415\u041d\u041e\u041a \u0421\u041e\u041f\u0420\u041e\u0412\u041e\u0416\u0414\u0410\u0415\u041c\u042b\u0419 \u0421 \u041f\u0420\u0415\u0414\u041e\u0421\u0422\u0410\u0412\u041b\u0415\u041d\u0418\u0415\u041c \u041c\u0415\u0421\u0422\u0410 \u043e\u0442\n <i>2<\\/i> \u0434\u043e <i>12<\\/i> \u043b\u0435\u0442.\n<b>\u0438\u043b\u0438<\\/b> \n \u0442\u0430\u0440\u0438\u0444 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u0434\u043b\u044f '<i>\u0420\u0412\u0413<\\/i>'-\u041c\u041b\u0410\u0414\u0415\u041d\u0415\u0426 \u0421 \u041f\u0420\u0415\u0414\u041e\u0421\u0422\u0410\u0412\u041b\u0415\u041d \u041c\u0415\u0421\u0422\u0410 \u041f\u041e \u041f\u0420\u041e\u0421\u042c\u0411\u0415\n \u0420\u041e\u0414\u0418\u0422\u0415\u041b\u0415\u0419 \u0410 \u0422\u0410\u041a\u0416\u0415 2 3 \u0418 \u0422 \u0414 \u041c\u041b\u0410\u0414\u0415\u041d\u0415\u0426 \u043e\u0442 <i>0<\\/i> \u0434\u043e <i>2<\\/i> \u043b\u0435\u0442.\n\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n<b>-----<\\/b> \n \u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f.\n \u041e\u0442\u043a\u0440\u044b\u0442\u0430\u044f \u0434\u0430\u0442\u0430 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430 \u043d\u0438 \u043d\u0430 \u043a\u0430\u043a\u0438\u0445 \u0443\u0447\u0430\u0441\u0442\u043a\u0430\u0445 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 (\u043d\u0438 \u043d\u0430\n \u043a\u0430\u043a\u0438\u0445 \u0443\u0447\u0430\u0441\u0442\u043a\u0430\u0445 \u0446\u0435\u043d\u043e\u0432\u043e\u0439 \u0435\u0434\u0438\u043d\u0438\u0446\u044b).\n \u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0431\u0438\u043b\u0435\u0442\u0430 \u043d\u0430 \u043f\u043e\u0434\u0441\u0430\u0434\u043a\u0443 \u0438 \u043b\u0438\u0441\u0442 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f.\n \u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043d\u0435 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 \u0447\u0435\u043c \u0447\u0435\u0440\u0435\u0437 <i>24<\\/i> \u0447\u0430\u0441 \u043f\u043e\u0441\u043b\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f\n .\n\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n<b>-----<\\/b> \n \u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b.\n \u041d\u0430\u0434\u0431\u0430\u0432\u043a\u04301: \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e.\n\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n<b>-----<\\/b> (\u041d\u0435\u0437\u0430\u043c\u043a\u043d\u0443\u0442\u0430\u044f \u043a\u0440\u0443\u0433\u043e\u0432\u0430\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0430 (OJ)) \n \u041a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430 \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u043d\u0435\u0437\u0430\u043c\u043a\u043d\u0443\u0442\u043e\u0439 \u043a\u0440\u0443\u0433\u043e\u0432\u043e\u0439 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \n<i> \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f<\\/i>.\n \u0420\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0441 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438 \u043f\u0443\u0431\u043b\u0438\u043a\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430.\n \u0422\u0430\u0440\u0438\u0444 \u043c\u043e\u0436\u0435\u0442 \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u043d\u0435\u0437\u0430\u043c\u043a\u043d\u0443\u0442\u043e\u0439 \u043a\u0440\u0443\u0433\u043e\u0432\u043e\u0439 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \u0441\n \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u043c \u0438\u043b\u0438 \u0441 \u043d\u0430\u0437\u0435\u043c\u043d\u044b\u043c \u0443\u0447\u0430\u0441\u0442\u043a\u043e\u043c (SOJ) \u0438\u043b\u0438 \u0441 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u043c \u0438 \u0441 \u043d\u0430\u0437\u0435\u043c\u043d\u044b\u043c \u0443\u0447\u0430\u0441\u0442\u043a\u043e\u043c\n (DOJ).\n \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e.\n \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043e\u043a \u0432 \u043f\u0443\u043d\u043a\u0442\u0430\u0445 \u043f\u0435\u0440\u0435\u0441\u0430\u0434\u043a\u0438 \u043c\u0435\u0436\u0434\u0443 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u043c\u0438 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u043c\u0438 \u043d\u0435\n \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e.\n\n<b>-----<\\/b> (\u0417\u0430\u043c\u043a\u043d\u0443\u0442\u0430\u044f \u043a\u0440\u0443\u0433\u043e\u0432\u0430\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0430 \u0441 2 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u043c\u0438 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u043c\u0438 (RT \u0438 CT2))\n \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430 \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u0437\u0430\u043c\u043a\u043d\u0443\u0442\u043e\u0439 \u043a\u0440\u0443\u0433\u043e\u0432\u043e\u0439 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \u0441 \u0434\u0432\u0443\u043c\u044f\n \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u043c\u0438 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u043c\u0438 <i>\u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f<\\/i>.\n \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0441 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438 \u043f\u0443\u0431\u043b\u0438\u043a\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430.\n \u0422\u0430\u0440\u0438\u0444 \u043c\u043e\u0436\u0435\u0442 \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \u0442\u0443\u0434\u0430-\u043e\u0431\u0440\u0430\u0442\u043d\u043e (RT) \u0438\u043b\u0438\n \u0437\u0430\u043c\u043a\u043d\u0443\u0442\u043e\u0439 \u043a\u0440\u0443\u0433\u043e\u0432\u043e\u0439 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \u0441 2 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u043c\u0438 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u043c\u0438 (CT2).\n\n<b>-----<\\/b> (\u0417\u0430\u043c\u043a\u043d\u0443\u0442\u0430\u044f \u043a\u0440\u0443\u0433\u043e\u0432\u0430\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0430 \u0441 \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c 2 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u043c\u0438 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u043c\u0438\n (CT2+)) \n \u041a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430 \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u0437\u0430\u043c\u043a\u043d\u0443\u0442\u043e\u0439 \u043a\u0440\u0443\u0433\u043e\u0432\u043e\u0439 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \u0441 \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c\n \u0434\u0432\u0443\u043c\u044f \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u043c\u0438 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u043c\u0438 <i>\u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f<\\/i>.\n \u0420\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0441 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438 \u043f\u0443\u0431\u043b\u0438\u043a\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430.\n \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e.\n \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e.\n \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043e\u043a \u0432 \u043f\u0443\u043d\u043a\u0442\u0430\u0445 \u043f\u0435\u0440\u0435\u0441\u0430\u0434\u043a\u0438 \u043c\u0435\u0436\u0434\u0443 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u043c\u0438 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u043c\u0438 \u043d\u0435\n \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e.\n\n<b>-----<\\/b> (\u041a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044f End on end) \n \u041a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044f end-on-end <i>\u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f<\\/i>.\n \u0420\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044f end-on-end \u0442\u043e\u043b\u044c\u043a\u043e \u0441 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438 \u043f\u0443\u0431\u043b\u0438\u043a\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430.\n\n<b>-----<\\/b> (\u0421\u0442\u044b\u043a\u043e\u0432\u043e\u0447\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b) \n \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 \u0441\u043a\u0432\u043e\u0437\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 \u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u0441\u0442\u044b\u043a\u043e\u0432\u043e\u0447\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 <i>\u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f<\\/i>.\n \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 \u0441\u043a\u0432\u043e\u0437\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u043e \u0441\u0442\u044b\u043a\u043e\u0432\u043e\u0447\u043d\u044b\u043c \u0442\u0430\u0440\u0438\u0444\u043e\u043c\n \u043f\u0443\u0431\u043b\u0438\u043a\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430.\n \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 \u0441\u043a\u0432\u043e\u0437\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u0441\u043e \u0441\u0442\u044b\u043a\u043e\u0432\u043e\u0447\u043d\u044b\u043c \u0442\u0430\u0440\u0438\u0444\u043e\u043c <i>OW<\\/i> \u0438\u043b\u0438 <i>RT<\\/i>.\n\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n<b>-----<\\/b> (\u0421\u0431\u043e\u0440\u044b \u043f\u0440\u0438 \u0434\u043e\u0431\u0440\u043e\u0432\u043e\u043b\u044c\u043d\u043e\u043c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438) \n <i>\u0434\u043e\u0431\u0440\u043e\u0432\u043e\u043b\u044c\u043d\u043e\u0435<\\/i> \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \u0437\u0430\u043f\u0440\u0435\u0449\u0430\u0435\u0442\u0441\u044f \u0432 \u0441\u043b\u0443\u0447\u0430\u0435\n \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430/\u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u0440\u0430\u043d\u043d\u044e\u044e(\u0435\u0435)\n \u0434\u0430\u0442\u0443(\u0432\u0440\u0435\u043c\u044f)/\u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u043f\u043e\u0437\u0434\u043d\u044e\u044e(\u0435\u0435) \u0434\u0430\u0442\u0443(\u0432\u0440\u0435\u043c\u044f).\n<b>\u0438\u043b\u0438<\\/b> (\u0421\u0431\u043e\u0440\u044b \u043f\u0440\u0438 \u0434\u043e\u0431\u0440\u043e\u0432\u043e\u043b\u044c\u043d\u043e\u043c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438) \n <i>\u0414\u041e\u0411\u0420\u041e\u0412\u041e\u041b\u042c\u041d\u041e\u0415<\\/i> \u0418\u0417\u041c\u0415\u041d\u0415\u041d\u0418\u0415 \u0423\u0421\u041b\u041e\u0412\u0418\u0419 \u0414\u041e\u0413\u041e\u0412\u041e\u0420\u0410 \u041f\u0415\u0420\u0415\u0412\u041e\u0417\u041a\u0418 \u0420\u0410\u0417\u0420\u0415\u0428\u0410\u0415\u0422\u0421\u042f \u0412 \u0421\u041b\u0423\u0427\u0410\u0415\n \u0418\u0417\u041c\u0415\u041d\u0415\u041d\u0418\u042f \u0424\u0418\u041e \u0414\u041e \u041e\u0422\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u0418\u042f \u0412\u041e\u0417\u0414\u0423\u0428\u041d\u041e\u0413\u041e \u0421\u0423\u0414\u041d\u0410.\n \u0412\u0417\u0418\u041c\u0410\u0415\u0422\u0421\u042f \u0421\u0411\u041e\u0420 \u0412 \u0420\u0410\u0417\u041c\u0415\u0420\u0415 <i>4000.00 \u0420\u0423\u0411<\\/i>.\n \u041f\u0420\u0418\u041c\u0415\u0427\u0410\u041d\u0418\u0415:\n<i> \u0412\u0417\u0418\u041c\u0410\u0415\u0422\u0421\u042f \u0421\u0411\u041e\u0420 SA \u0412 \u0420\u0410\u0417\u041c\u0415\u0420\u0415 4000.00 \u0420\u0423\u0411. \u0414\u0410\u041d\u041d\u042b\u0419\n \u0421\u0411\u041e\u0420 \u0412\u0417\u0418\u041c\u0410\u0415\u0422\u0421\u042f \u0417\u0410 \u041e\u041f\u0415\u0420\u0410\u0426\u0418\u042e \u0411\u041b \u0418 \u041f\u0420\u0418\u041c\u0415\u041d\u042f\u0415\u0422\u0421\u042f \u0412\u0421\u0415\u041c\n \u041a\u0410\u0422\u0415\u0413\u041e\u0420\u0418\u042f\u041c \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u041e\u0412<\\/i>\n<b>\u0438\u043b\u0438<\\/b> (\u0421\u0431\u043e\u0440\u044b \u043f\u0440\u0438 \u0432\u044b\u043d\u0443\u0436\u0434\u0435\u043d\u043d\u043e\u043c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438) \n <i>\u0432\u044b\u043d\u0443\u0436\u0434\u0435\u043d\u043d\u043e\u0435<\\/i> \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f.\n <i>\u0441\u0431\u043e\u0440 \u043d\u0435 \u0432\u0437\u0438\u043c\u0430\u0435\u0442\u0441\u044f<\\/i>.\n<b>\u0438\u043b\u0438<\\/b> (\u0421\u0431\u043e\u0440\u044b \u043f\u0440\u0438 \u0434\u043e\u0431\u0440\u043e\u0432\u043e\u043b\u044c\u043d\u043e\u043c \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0435) \n <i>\u0434\u043e\u0431\u0440\u043e\u0432\u043e\u043b\u044c\u043d\u044b\u0439<\\/i> \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0437\u0430\u043f\u0440\u0435\u0449\u0430\u0435\u0442\u0441\u044f.\n<b>\u0438\u043b\u0438<\\/b> (\u0421\u0431\u043e\u0440\u044b \u043f\u0440\u0438 \u0432\u044b\u043d\u0443\u0436\u0434\u0435\u043d\u043d\u043e\u043c \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0435) \n <i>\u0432\u044b\u043d\u0443\u0436\u0434\u0435\u043d\u043d\u044b\u0439<\\/i> \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f.\n <i>\u0441\u0431\u043e\u0440 \u043d\u0435 \u0432\u0437\u0438\u043c\u0430\u0435\u0442\u0441\u044f<\\/i>.\n\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n<b>-----<\\/b> \n \u043f\u0435\u0440\u0432\u043e\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0439 \u0438 \u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442<i> \"\u0412\u041e\u0417\u0412\u0420\u0410\u0422 \u0418\n \u0418\u0417\u041c\u0415\u041d\u0415\u041d\u0418\u042f \u0414\u0410\u0422\u042b \u0418 \u041c\u0410\u0420\u0428\u0420\u0423\u0422\u0410 \u0417\u0410\u041f\u0420\u0415\u0429\u0415\u041d\u042b, \u0411\u0410\u0413\u0410\u0416 \u0412 \u0421\u0410\u041b\u041e\u041d \u041f\u041b\u0410\u0422\u041d\u041e,\u041a\u0420\u041e\u041c\u0415 \u0416\u0415\u041d.\u0421\u0423\u041c\u041a\u0418,\n \u041f\u041e\u0420\u0422\u0424\u0415\u041b\u042f,\u0412\u0415\u0420\u0425.\u041e\u0414\u0415\u0416\u0414\"<\\/i> \u0432 \u0433\u0440\u0430\u0444\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f/\u0437\u0430\u043f\u0440\u0435\u0449\u0430\u0435\u0442\u0441\u044f.\n\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n<b>-----<\\/b> \n \u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u043a\u0438\u0434\u043a\u0438 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430 '<i>\u0420\u041c\u0413<\\/i>'-'\u041c\u041b\u0410\u0414\u0415\u041d\u0415\u0426 \u0411\u0415\u0417\n \u041f\u0420\u0415\u0414\u041e\u0421\u0422\u0410\u0412\u041b\u0415\u041d\u0418\u042f \u041c\u0415\u0421\u0422\u0410' \u043e\u0442 <i>0<\\/i> \u0434\u043e <i>2<\\/i> \u043b\u0435\u0442.\n \u0421\u043a\u0438\u0434\u043a\u0430 <i>100.00<\\/i> \u043f\u0440\u043e\u0446\u0435\u043d\u0442\u043e\u0432 \u043e\u0442 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430.\n<b>\u0438\u043b\u0438<\\/b> \n \u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u043a\u0438\u0434\u043a\u0438 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430 '<i>\u0420\u0411\u0413<\\/i>'-'\u0420\u0415\u0411\u0415\u041d\u041e\u041a \u0421\u041e\u041f\u0420\u041e\u0412\u041e\u0416\u0414\u0410\u0415\u041c\u042b\u0419 \u0421\n \u041f\u0420\u0415\u0414\u041e\u0421\u0422\u0410\u0412\u041b\u0415\u041d\u0418\u0415\u041c \u041c\u0415\u0421\u0422\u0410' \u043e\u0442 <i>2<\\/i> \u0434\u043e <i>12<\\/i> \u043b\u0435\u0442.\n \u0421\u043a\u0438\u0434\u043a\u0430 <i>0.00<\\/i> \u043f\u0440\u043e\u0446\u0435\u043d\u0442\u043e\u0432 \u043e\u0442 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430.\n<b>\u0438\u043b\u0438<\\/b> \n \u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u043a\u0438\u0434\u043a\u0438 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430 '<i>\u0420\u0412\u0413<\\/i>'-'\u041c\u041b\u0410\u0414\u0415\u041d\u0415\u0426 \u0421 \u041f\u0420\u0415\u0414\u041e\u0421\u0422\u0410\u0412\u041b\u0415\u041d\n \u041c\u0415\u0421\u0422\u0410 \u041f\u041e \u041f\u0420\u041e\u0421\u042c\u0411\u0415 \u0420\u041e\u0414\u0418\u0422\u0415\u041b\u0415\u0419 \u0410 \u0422\u0410\u041a\u0416\u0415 2 3 \u0418 \u0422 \u0414 \u041c\u041b\u0410\u0414\u0415\u041d\u0415\u0426' \u043e\u0442 <i>0<\\/i> \u0434\u043e <i>2<\\/i> \u043b\u0435\u0442.\n \u0421\u043a\u0438\u0434\u043a\u0430 <i>0.00<\\/i> \u043f\u0440\u043e\u0446\u0435\u043d\u0442\u043e\u0432 \u043e\u0442 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430.\n\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\n<b>-----<\\/b> \n \u041f\u0420\u0418\u041c\u0415\u0427\u0410\u041d\u0418\u0415:\n<i> \u041d\u0415 \u0420\u0410\u0417\u0420\u0415\u0428\u0410\u0415\u0422\u0421\u042f.<\\/i>\n\n"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u21b5<b>-----</b>      \u21b5  \u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b.\u21b5  \u041d\u0430\u0434\u0431\u0430\u0432\u043a\u04301: \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e.\u21b5\u21b5"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u21b5<b>-----</b>      \u21b5  \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0423\u041f\u0422 - <i>SU CARRIER PROMO-ECONOMY FARES</i>\u21b5  \u0414\u0430\u043d\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f <i>\u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445</i> <i>\u0420\u041e\u0421\u0421\u0418\u042f (\u0412 \u0415\u0412\u0420\u041e\u041f\u0415)</i>.\u21b5  \u0414\u0430\u043d\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u0434\u043b\u044f \u044d\u043a\u043e\u043d\u043e\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043a\u043b\u0430\u0441\u0441\u0430 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f.\u21b5  \u0414\u0430\u043d\u043d\u043e\u0435 \u0423\u041f\u0422 \u0440\u0435\u0433\u0443\u043b\u0438\u0440\u0443\u0435\u0442 \u0442\u0430\u0440\u0438\u0444\u044b <i>RT</i>.\u21b5  \u0422\u0430\u0440\u0438\u0444\u044b \u0440\u0435\u0433\u0443\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u043c \u0423\u041f\u0422 \u043c\u043e\u0433\u0443\u0442 \u043a\u043e\u043c\u0431\u0438\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u0442\u0438\u043f\u043e\u0432\u21b5  \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \u0432 \u043e\u0434\u043d\u0443 \u0441\u0442\u043e\u0440\u043e\u043d\u0443 (OW).\u21b5  \u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043c\u0435\u0436\u0434\u0443\u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438: \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0438\u0432\u0430\u0435\u0442 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e\u21b5  \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043d\u0430 \u0432\u0441\u0435\u0445 \u0440\u0435\u0439\u0441\u0430\u0445 \u0434\u043b\u044f \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u043c\u044b \u0442\u0430\u0440\u0438\u0444\u044b \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0423\u041f\u0422. \u041a\u0440\u043e\u043c\u0435\u21b5  \u0442\u043e\u0433\u043e, \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043d\u0435\u043f\u0440\u0438\u043c\u0435\u043d\u0438\u043c\u044b \u043d\u0430 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0440\u0435\u0439\u0441\u0430\u0445.\u21b5\u21b5"));
        Assert.assertFalse((boolean)TextUtil.translationRequired(""));
        Assert.assertFalse((boolean)TextUtil.translationRequired(" "));
        Assert.assertFalse((boolean)TextUtil.translationRequired(":"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("0"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("1"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("2"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("3"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("4"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("5"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("6"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("7"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("8"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("9"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("."));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u21b5"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("<b>"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("<b>-----</b>"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u21b5<b>-----</b>      \u21b5  "));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u21b5<b>-----</b>      \u21b5  \u041f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0430 \u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u043c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0435 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c\u0441\u044f \u043d\u0430 <i>SU</i> \u0441 <i>3000</i> \u043f\u043e <i>4999</i>.\u21b5<b>\u0438</b>          \u21b5  \u041f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0430 \u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u043c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c\u0441\u044f \u043d\u0430 \u043b\u044e\u0431\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430 <i>SU</i>.\u21b5\u21b5"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u21b5<b>-----</b>      \u21b5  <i>\u041e\u0422\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u0418\u0415 \u0418\u0417 \u041f\u0423\u041d\u041a\u0422\u0410 \u041f\u041e\u0421\u041b\u0415\u0414\u041d\u0415\u0419 \u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041a\u0418</i> \u041c\u041e\u0416\u0415\u0422 \u0411\u042b\u0422\u042c <i>\u041d\u0415 \u041f\u041e\u0417\u0414\u041d\u0415\u0415</i>, \u0427\u0415\u041c \u0427\u0415\u0420\u0415\u0417 <i>30\u21b5    \u0421\u0423\u0422</i> \u041f\u041e\u0421\u041b\u0415 <i>\u041e\u0422\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u0418\u042f \u0418\u0417 \u041f\u0423\u041d\u041a\u0422\u0410 \u041d\u0410\u0427\u0410\u041b\u0410 \u041f\u0415\u0420\u0415\u0412\u041e\u0417\u041a\u0418</i>.\u21b5\u21b5"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u21b5<b>-----</b>      \u21b5  \u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b.\u21b5  \u041d\u0430\u0434\u0431\u0430\u0432\u043a\u04301: \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e.\u21b5\u21b5"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u21b5<b>-----</b>      \u21b5  \u041c\u0410\u041a\u0421\u0418\u041c\u0423\u041c <i>2</i> \u0422\u0420\u0410\u041d\u0421\u0424\u0415\u0420(\u041e\u0412) \u0420\u0410\u0417\u0420\u0415\u0428\u0410\u042e\u0422\u0421\u042f - \u041f\u041e <i>1</i> \u0412 \u041a\u0410\u0416\u0414\u041e\u041c \u041d\u0410\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u0418\u0418.\u21b5  \u041d\u0410\u0417\u0415\u041c\u041d\u042b\u0415 \u0423\u0427\u0410\u0421\u0422\u041a\u0418, \u0421\u041c\u0415\u0416\u041d\u042b\u0415 \u0421 \u041f\u0423\u041d\u041a\u0422\u041e\u041c \u041f\u041e\u0421\u0422\u0420\u041e\u0415\u041d\u0418\u042f \u0422\u0410\u0420\u0418\u0424\u0410, \u041d\u0415 \u0420\u0410\u0417\u0420\u0415\u0428\u0410\u042e\u0422\u0421\u042f.\u21b5    \u041d\u0410\u0417\u0415\u041c\u041d\u042b\u0415 \u0423\u0427\u0410\u0421\u0422\u041a\u0418 \u0412\u041d\u0423\u0422\u0420\u0418 \u0422\u0410\u0420\u0418\u0424\u041d\u041e\u0413\u041e \u041a\u041e\u041c\u041f\u041e\u041d\u0415\u041d\u0422\u0410 \u041d\u0415 \u0420\u0410\u0417\u0420\u0415\u0428\u0410\u042e\u0422\u0421\u042f.\u21b5  \u041f\u0420\u0418\u041c\u0415\u0427\u0410\u041d\u0418\u0415:\u21b5<i>\u041f\u0415\u0420\u0415\u0421\u0410\u0414\u041a\u0410 \u0420\u0410\u0417\u0420\u0415\u0428\u0410\u0415\u0422\u0421\u042f \u0422\u041e\u041b\u042c\u041a\u041e \u0412 \u041f\u0420\u0415\u0414\u0415\u041b\u0410\u0425 \u041c\u0410\u0420\u0428\u0420\u0423\u0422\u0410, \u0421\u0412\u042f\u0417\u0410\u041d\u041d\u041e\u0413\u041e \u0421 \u042d\u0422\u0418\u041c \u0422\u0410\u0420\u0418\u0424\u041e\u041c</i>\u21b5\u21b5"));
        Assert.assertFalse((boolean)TextUtil.translationRequired("\u21b5<b>-----</b>      \u21b5<i>\u0418\u041d\u0424\u041e\u0420\u041c\u0410\u0426\u0418\u041e\u041d\u041d\u0410\u042f \u041a\u0410\u0422\u0415\u0413\u041e\u0420\u0418\u042f. \u041d\u0415 \u041e\u041a\u0410\u0417\u042b\u0412\u0410\u0415\u0422 \u0412\u041b\u0418\u042f\u041d\u0418\u042f \u041d\u0410 \u0410\u0412\u0422\u041e\u041c\u0410\u0422\u0418\u0427\u0415\u0421\u041a\u0423\u042e \u041e\u0426\u0415\u041d\u041a\u0423</i>\u21b5  \u041f\u0420\u0418\u041c\u0415\u0427\u0410\u041d\u0418\u0415:\u21b5<i>\u0414\u0415\u0419\u0421\u0422\u0412\u0418\u0422\u0415\u041b\u042c\u041d\u041e \u0421 01 \u0418\u042e\u041d\u042f 2008 \u0413\u041e\u0414\u0410. \u0415\u0421\u041b\u0418 \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420 \u0414\u041e\u0411\u0420\u041e\u0412\u041e\u041b\u042c\u041d\u041e \u041f\u0420\u041e\u0421\u0418\u0422 \u041f\u041e\u041c\u0415\u041d\u042f\u0422\u042c\u21b5\u042d\u041b\u0415\u041a\u0422\u0420\u041e\u041d\u041d\u042b\u0419 \u0411\u0418\u041b\u0415\u0422 \u041d\u0410 \u0411\u0423\u041c\u0410\u0416\u041d\u042b\u0419, \u0412\u0417\u0418\u041c\u0410\u0415\u0422\u0421\u042f \u0414\u041e\u041f\u041b\u0410\u0422\u0410 \u0412 \u0420\u0410\u0417\u041c\u0415\u0420\u0415 EUR 10.00 \u0417\u0410 \u0411\u0418\u041b\u0415\u0422.\u21b5\u0414\u041e\u041f\u041b\u0410\u0422\u0410 \u041e\u0424\u041e\u0420\u041c\u041b\u042f\u0415\u0422\u0421\u042f \u041d\u0410 MCO/MPD \u0418 \u0420\u0410\u0421\u0421\u0427\u0418\u0422\u042b\u0412\u0410\u0415\u0422\u0421\u042f \u041f\u041e \u0421\u0422\u0410\u0412\u041a\u0415, \u0414\u0415\u0419\u0421\u0422\u0412\u0423\u042e\u0429\u0418\u0419 \u041d\u0410 \u041c\u041e\u041c\u0415\u041d\u0422\u0417\u0410\u041c\u0415\u041d\u042b \u042d\u041b\u0415\u041a\u0422\u0420\u041e\u041d\u041d\u041e\u0413\u041e \u0411\u0418\u041b\u0415\u0422\u0410 \u041d\u0410 \u0411\u0423\u041c\u0410\u0416\u041d\u042b\u0419. \u0414\u041e\u041f\u041b\u0410\u0422\u0410 \u0417\u0410 \u0411\u0423\u041c\u0410\u0416\u041d\u042b\u0419 \u0411\u0418\u041b\u0415\u0422 \u0412\u041e\u0417\u0412\u0420\u0410\u0422\u0423 \u041d\u0415\u21b5\u041f\u041e\u0414\u041b\u0415\u0416\u0418\u0422.</i>\u21b5\u21b5<b>----- \u0435\u0441\u043b\u0438</b> \u21b5  \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f '<i>\u0420\u041c\u0413</i>'-\u041c\u041b\u0410\u0414\u0415\u041d\u0415\u0426 \u0411\u0415\u0417 \u041f\u0420\u0415\u0414\u041e\u0421\u0422\u0410\u0412\u041b\u0415\u041d\u0418\u042f \u041c\u0415\u0421\u0422\u0410:\u21b5  \u043c\u043b\u0430\u0434\u0448\u0435 <i>2</i> \u043b\u0435\u0442.\u21b5<b>\u0442\u043e</b>         \u21b5    \u0414\u0430\u0442\u044b \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u0441 01.11.2013 00:00:00\u21b5  \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f <i>\u043d\u0430\u0434\u0431\u0430\u0432\u043a\u0430</i> <i>'Q'-\u0420\u0410\u0417\u041d\u041e\u0415 \u0414\u0420\u0423\u0413\u041e\u0415</i> \u0434\u043b\u044f\u21b5    <i>\u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432</i>: \u0431\u0435\u0437 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439;\u21b5    <i>\u0434\u0435\u0442\u0435\u0439</i>: \u0431\u0435\u0437 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439;\u21b5    <i>\u043c\u043b\u0430\u0434\u0435\u043d\u0446\u0435\u0432</i>: \u0431\u0435\u0437 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439;\u21b5  \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435 <i>0.00 \u0415\u0412\u0420</i> <i>\u0437\u0430 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442</i>.\u21b5\u21b5<b>----- \u0435\u0441\u043b\u0438</b> \u21b5  \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f '<i>SKY</i>'-\u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420 \u041d\u0410 \u0420\u0415\u0419\u0421\u0410\u0425 \u041f\u0415\u0420\u0415\u0412\u041e\u0417\u0427\u0418\u041a\u041e\u0412 \u0427\u041b\u0415\u041d\u041e\u0412\u21b5  \u0410\u041b\u042c\u042f\u041d\u0421\u0410 SKY TEAM.\u21b5<b>\u0442\u043e</b>         \u21b5    \u0414\u0430\u0442\u044b \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u0441 01.11.2013 00:00:00\u21b5  \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f <i>\u043d\u0430\u0434\u0431\u0430\u0432\u043a\u0430</i> <i>'Q'-\u0420\u0410\u0417\u041d\u041e\u0415 \u0414\u0420\u0423\u0413\u041e\u0415</i> \u0434\u043b\u044f\u21b5    <i>\u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432</i>: \u0431\u0435\u0437 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439;\u21b5    <i>\u0434\u0435\u0442\u0435\u0439</i>: \u0431\u0435\u0437 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439;\u21b5    <i>\u043c\u043b\u0430\u0434\u0435\u043d\u0446\u0435\u0432</i>: \u0431\u0435\u0437 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439;\u21b5  \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435 <i>0.00 \u0415\u0412\u0420</i> <i>\u0437\u0430 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442</i>.\u21b5\u21b5<b>----- \u0435\u0441\u043b\u0438</b> \u21b5  \u0411\u0438\u043b\u0435\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d \u0441 \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u043c \u043a\u043e\u0434\u043e\u043c \u043f\u0443\u0431\u043b\u0438\u043a\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430.\u21b5<b>\u0442\u043e</b>         \u21b5  \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f <i>\u043d\u0430\u0434\u0431\u0430\u0432\u043a\u0430</i> <i>'Q'-\u0420\u0410\u0417\u041d\u041e\u0415 \u0414\u0420\u0423\u0413\u041e\u0415</i> \u0434\u043b\u044f\u21b5    <i>\u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432</i>: \u0431\u0435\u0437 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439;\u21b5    <i>\u0434\u0435\u0442\u0435\u0439</i>: \u0431\u0435\u0437 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439;\u21b5    <i>\u043c\u043b\u0430\u0434\u0435\u043d\u0446\u0435\u0432</i>: \u0431\u0435\u0437 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439;\u21b5  \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435 <i>0.00 \u0415\u0412\u0420</i> <i>\u0437\u0430 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442</i>.\u21b5\u21b5<b>-----</b>      \u21b5  \u041f\u0420\u0418\u041c\u0415\u041d\u042f\u0415\u0422\u0421\u042f <i>\u041d\u0410\u0414\u0411\u0410\u0412\u041a\u0410</i> <i>'\u0422'-\u0422\u041e\u041f\u041b\u0418\u0412\u041d\u042b\u0419 \u0421\u0411\u041e\u0420</i> \u0414\u041b\u042f\u21b5    <i>\u0412\u0417\u0420\u041e\u0421\u041b\u042b\u0425 \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u041e\u0412</i>: \u0411\u0415\u0417 \u0414\u041e\u041f\u041e\u041b\u041d\u0418\u0422\u0415\u041b\u042c\u041d\u042b\u0425 \u041e\u0413\u0420\u0410\u041d\u0418\u0427\u0415\u041d\u0418\u0419;\u21b5    <i>\u0414\u0415\u0422\u0415\u0419</i>: \u0411\u0415\u0417 \u0414\u041e\u041f\u041e\u041b\u041d\u0418\u0422\u0415\u041b\u042c\u041d\u042b\u0425 \u041e\u0413\u0420\u0410\u041d\u0418\u0427\u0415\u041d\u0418\u0419;\u21b5    <i>\u041c\u041b\u0410\u0414\u0415\u041d\u0426\u0415\u0412</i>: \u0411\u0415\u0417 \u0414\u041e\u041f\u041e\u041b\u041d\u0418\u0422\u0415\u041b\u042c\u041d\u042b\u0425 \u041e\u0413\u0420\u0410\u041d\u0418\u0427\u0415\u041d\u0418\u0419;\u21b5  \u0412 \u0420\u0410\u0417\u041c\u0415\u0420\u0415 <i>1500.00 \u0420\u0423\u0411</i> <i>\u0417\u0410 \u041a\u0410\u0416\u0414\u042b\u0419 \u041a\u0423\u041f\u041e\u041d</i>.\u21b5  \u041d\u0410\u0414\u0411\u0410\u0412\u041a\u0418 (\u0421\u041a\u0418\u0414\u041a\u0418) \u041f\u0420\u0418\u041c\u0415\u041d\u042f\u042e\u0422\u0421\u042f \u0412 \u21b5     <i>'\u0420\u0424'</i> (\u0420\u041e\u0421\u0421\u0418\u0419\u0421\u041a\u0410\u042f \u0424\u0415\u0414\u0415\u0420\u0410\u0426\u0418\u042f)\u21b5    .\u21b5\u21b5"));
    }

    @Test
    public void cleanRemovesIrrelevantCharacters() {
        Assert.assertEquals((Object)"", (Object)TextUtil.clean("\u21b5"));
        Assert.assertEquals((Object)"", (Object)TextUtil.clean("<b>"));
        Assert.assertEquals((Object)"", (Object)TextUtil.clean("</b>"));
        Assert.assertEquals((Object)"", (Object)TextUtil.clean("<i>"));
        Assert.assertEquals((Object)"", (Object)TextUtil.clean("</i>"));
        Assert.assertEquals((Object)"", (Object)TextUtil.clean("-"));
    }
}

