/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.Node;
import com.gridnine.xtrip.common.util.NodesIterator;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class TrieMap<T>
implements Serializable {
    private static final long serialVersionUID = -863326419777326258L;
    private final LinkedList<Node<T>> nodes = new LinkedList();
    private int size;

    public T put(String key, T value) {
        Object result;
        Node node;
        if (TextUtil.isBlank(key)) {
            throw new IllegalArgumentException("key is blank");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is NULL");
        }
        Node newNode = null;
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext() && (newNode = (node = (Node)iterator.next()).put(key)) == null) {
        }
        if (newNode == null) {
            newNode = new Node();
            newNode.string = key;
            if (!this.nodes.isEmpty()) {
                this.nodes.getLast().next = newNode;
                newNode.prev = this.nodes.getLast();
            }
            this.nodes.add(newNode);
        }
        if ((result = newNode.value) == null) {
            ++this.size;
        }
        newNode.value = value;
        return result;
    }

    public T get(String key) {
        for (Node node : this.nodes) {
            Node result = node.get(key);
            if (result == null) continue;
            return result.value;
        }
        return null;
    }

    public T remove(String key) {
        T result = Node.remove(this.nodes, key);
        if (result != null) {
            --this.size;
            return result;
        }
        return null;
    }

    public void clear() {
        for (Node node : this.nodes) {
            node.clear();
        }
        this.nodes.clear();
        this.size = 0;
    }

    public Iterator<Map.Entry<String, T>> search(String pattern) {
        return new NodesIterator<T>(Node.find(this.nodes, pattern));
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

